/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Logging;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.ConnectionReadTimeoutException;
import org.neo4j.driver.exceptions.TransactionTerminatedException;
import org.neo4j.driver.internal.DatabaseBookmark;
import org.neo4j.driver.internal.async.ResultCursorsHolder;
import org.neo4j.driver.internal.async.TerminationAwareStateLockingExecutor;
import org.neo4j.driver.internal.cursor.AsyncResultCursor;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.telemetry.ApiTelemetryWork;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.LockUtil;

public class UnmanagedTransaction
implements TerminationAwareStateLockingExecutor {
    public static final String EXPLICITLY_TERMINATED_MSG = "The transaction has been explicitly terminated by the driver";
    protected static final String CANT_COMMIT_COMMITTED_MSG = "Can't commit, transaction has been committed";
    protected static final String CANT_ROLLBACK_COMMITTED_MSG = "Can't rollback, transaction has been committed";
    protected static final String CANT_COMMIT_ROLLED_BACK_MSG = "Can't commit, transaction has been rolled back";
    protected static final String CANT_ROLLBACK_ROLLED_BACK_MSG = "Can't rollback, transaction has been rolled back";
    protected static final String CANT_COMMIT_ROLLING_BACK_MSG = "Can't commit, transaction has been requested to be rolled back";
    protected static final String CANT_ROLLBACK_COMMITTING_MSG = "Can't rollback, transaction has been requested to be committed";
    private static final EnumSet<State> OPEN_STATES = EnumSet.of(State.ACTIVE, State.TERMINATED);
    private final Connection connection;
    private final BoltProtocol protocol;
    private final Consumer<DatabaseBookmark> bookmarkConsumer;
    private final ResultCursorsHolder resultCursors;
    private final long fetchSize;
    private final Lock lock = new ReentrantLock();
    private State state = State.ACTIVE;
    private CompletableFuture<Void> commitFuture;
    private CompletableFuture<Void> rollbackFuture;
    private Throwable causeOfTermination;
    private CompletionStage<Void> terminationStage;
    private final NotificationConfig notificationConfig;
    private final CompletableFuture<UnmanagedTransaction> beginFuture = new CompletableFuture();
    private final Logging logging;
    private final ApiTelemetryWork apiTelemetryWork;

    public UnmanagedTransaction(Connection connection, Consumer<DatabaseBookmark> bookmarkConsumer, long fetchSize, NotificationConfig notificationConfig, ApiTelemetryWork apiTelemetryWork, Logging logging) {
        this(connection, bookmarkConsumer, fetchSize, new ResultCursorsHolder(), notificationConfig, apiTelemetryWork, logging);
    }

    protected UnmanagedTransaction(Connection connection, Consumer<DatabaseBookmark> bookmarkConsumer, long fetchSize, ResultCursorsHolder resultCursors, NotificationConfig notificationConfig, ApiTelemetryWork apiTelemetryWork, Logging logging) {
        this.connection = connection;
        this.protocol = connection.protocol();
        this.bookmarkConsumer = bookmarkConsumer;
        this.resultCursors = resultCursors;
        this.fetchSize = fetchSize;
        this.notificationConfig = notificationConfig;
        this.logging = logging;
        this.apiTelemetryWork = apiTelemetryWork;
        connection.bindTerminationAwareStateLockingExecutor(this);
    }

    public CompletionStage<UnmanagedTransaction> beginAsync(Set<Bookmark> initialBookmarks, TransactionConfig config, String txType, boolean flush) {
        this.apiTelemetryWork.execute(this.connection, this.protocol).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                this.beginFuture.completeExceptionally((Throwable)throwable);
            }
        });
        this.protocol.beginTransaction(this.connection, initialBookmarks, config, txType, this.notificationConfig, this.logging, flush).handle((ignore, beginError) -> {
            if (beginError != null) {
                if (beginError instanceof AuthorizationExpiredException) {
                    this.connection.terminateAndRelease("Authorization information kept on the server has expired, this connection is no longer valid.");
                } else if (beginError instanceof ConnectionReadTimeoutException) {
                    this.connection.terminateAndRelease(beginError.getMessage());
                } else {
                    this.connection.release();
                }
                throw Futures.asCompletionException(beginError);
            }
            return this;
        }).whenComplete(Futures.futureCompletingConsumer(this.beginFuture));
        return flush ? this.beginFuture : CompletableFuture.completedFuture(this);
    }

    public CompletionStage<Void> closeAsync() {
        return this.closeAsync(false);
    }

    public CompletionStage<Void> closeAsync(boolean commit) {
        return this.closeAsync(commit, true);
    }

    public CompletionStage<Void> commitAsync() {
        return this.closeAsync(true, false);
    }

    public CompletionStage<Void> rollbackAsync() {
        return this.closeAsync(false, false);
    }

    public CompletionStage<ResultCursor> runAsync(Query query) {
        this.ensureCanRunQueries();
        CompletionStage<AsyncResultCursor> cursorStage = this.protocol.runInUnmanagedTransaction(this.connection, query, this, this.fetchSize).asyncResult();
        this.resultCursors.add(cursorStage);
        return this.beginFuture.thenCompose(ignored -> cursorStage.thenCompose(AsyncResultCursor::mapSuccessfulRunCompletionAsync).thenApply(Function.identity()));
    }

    public CompletionStage<RxResultCursor> runRx(Query query) {
        this.ensureCanRunQueries();
        CompletionStage<RxResultCursor> cursorStage = this.protocol.runInUnmanagedTransaction(this.connection, query, this, this.fetchSize).rxResult();
        this.resultCursors.add(cursorStage);
        return cursorStage;
    }

    public boolean isOpen() {
        return OPEN_STATES.contains((Object)LockUtil.executeWithLock(this.lock, () -> this.state));
    }

    public Throwable markTerminated(Throwable cause) {
        return LockUtil.executeWithLock(this.lock, () -> {
            if (this.state == State.TERMINATED) {
                if (cause != null) {
                    this.addSuppressedWhenNotCaptured(this.causeOfTermination, cause);
                }
            } else {
                this.state = State.TERMINATED;
                this.causeOfTermination = cause != null ? cause : new TransactionTerminatedException(EXPLICITLY_TERMINATED_MSG);
            }
            return this.causeOfTermination;
        });
    }

    private void addSuppressedWhenNotCaptured(Throwable currentCause, Throwable newCause) {
        boolean noneMatch;
        if (currentCause != newCause && (noneMatch = Arrays.stream(currentCause.getSuppressed()).noneMatch(suppressed -> suppressed == newCause))) {
            currentCause.addSuppressed(newCause);
        }
    }

    public Connection connection() {
        return this.connection;
    }

    @Override
    public void execute(Consumer<Throwable> causeOfTerminationConsumer) {
        LockUtil.executeWithLock(this.lock, () -> causeOfTerminationConsumer.accept(this.causeOfTermination));
    }

    public CompletionStage<Void> terminateAsync() {
        return LockUtil.executeWithLock(this.lock, () -> {
            if (!this.isOpen() || this.commitFuture != null || this.rollbackFuture != null) {
                return Futures.failedFuture(new ClientException("Can't terminate closed or closing transaction"));
            }
            if (this.state == State.TERMINATED) {
                return this.terminationStage != null ? this.terminationStage : CompletableFuture.completedFuture(null);
            }
            Throwable terminationException = this.markTerminated(null);
            this.terminationStage = this.connection.reset(terminationException);
            return this.terminationStage;
        });
    }

    private void ensureCanRunQueries() {
        LockUtil.executeWithLock(this.lock, () -> {
            if (this.state == State.COMMITTED) {
                throw new ClientException("Cannot run more queries in this transaction, it has been committed");
            }
            if (this.state == State.ROLLED_BACK) {
                throw new ClientException("Cannot run more queries in this transaction, it has been rolled back");
            }
            if (this.state == State.TERMINATED) {
                Throwable patt11090$temp = this.causeOfTermination;
                if (patt11090$temp instanceof TransactionTerminatedException) {
                    TransactionTerminatedException transactionTerminatedException = (TransactionTerminatedException)patt11090$temp;
                    throw transactionTerminatedException;
                }
                throw new TransactionTerminatedException("Cannot run more queries in this transaction, it has either experienced an fatal error or was explicitly terminated", this.causeOfTermination);
            }
            if (this.commitFuture != null) {
                throw new ClientException("Cannot run more queries in this transaction, it is being committed");
            }
            if (this.rollbackFuture != null) {
                throw new ClientException("Cannot run more queries in this transaction, it is being rolled back");
            }
        });
    }

    private CompletionStage<Void> doCommitAsync(Throwable cursorFailure) {
        ClientException exception = LockUtil.executeWithLock(this.lock, () -> this.state == State.TERMINATED ? new TransactionTerminatedException("Transaction can't be committed. It has been rolled back either because of an error or explicit termination", cursorFailure != this.causeOfTermination ? this.causeOfTermination : null) : null);
        return exception != null ? Futures.failedFuture(exception) : this.protocol.commitTransaction(this.connection).thenAccept(this.bookmarkConsumer);
    }

    private CompletionStage<Void> doRollbackAsync() {
        return LockUtil.executeWithLock(this.lock, () -> this.state) == State.TERMINATED ? Futures.completedWithNull() : this.protocol.rollbackTransaction(this.connection);
    }

    private static BiFunction<Void, Throwable, Void> handleCommitOrRollback(Throwable cursorFailure) {
        return (ignore, commitOrRollbackError) -> {
            CompletionException combinedError = Futures.combineErrors(cursorFailure, commitOrRollbackError);
            if (combinedError != null) {
                throw combinedError;
            }
            return null;
        };
    }

    private void handleTransactionCompletion(boolean commitAttempt, Throwable throwable) {
        LockUtil.executeWithLock(this.lock, () -> {
            this.state = commitAttempt && throwable == null ? State.COMMITTED : State.ROLLED_BACK;
        });
        if (throwable instanceof AuthorizationExpiredException) {
            this.connection.terminateAndRelease("Authorization information kept on the server has expired, this connection is no longer valid.");
        } else if (throwable instanceof ConnectionReadTimeoutException) {
            this.connection.terminateAndRelease(throwable.getMessage());
        } else {
            this.connection.release();
        }
    }

    private CompletionStage<Void> closeAsync(boolean commit, boolean completeWithNullIfNotOpen) {
        CompletableFuture<Void> stage = LockUtil.executeWithLock(this.lock, () -> {
            CompletableFuture<Object> resultStage = null;
            if (completeWithNullIfNotOpen && !this.isOpen()) {
                resultStage = Futures.completedWithNull();
            } else if (this.state == State.COMMITTED) {
                resultStage = Futures.failedFuture(new ClientException(commit ? CANT_COMMIT_COMMITTED_MSG : CANT_ROLLBACK_COMMITTED_MSG));
            } else if (this.state == State.ROLLED_BACK) {
                resultStage = Futures.failedFuture(new ClientException(commit ? CANT_COMMIT_ROLLED_BACK_MSG : CANT_ROLLBACK_ROLLED_BACK_MSG));
            } else if (commit) {
                if (this.rollbackFuture != null) {
                    resultStage = Futures.failedFuture(new ClientException(CANT_COMMIT_ROLLING_BACK_MSG));
                } else if (this.commitFuture != null) {
                    resultStage = this.commitFuture;
                } else {
                    this.commitFuture = new CompletableFuture();
                }
            } else if (this.commitFuture != null) {
                resultStage = Futures.failedFuture(new ClientException(CANT_ROLLBACK_COMMITTING_MSG));
            } else if (this.rollbackFuture != null) {
                resultStage = this.rollbackFuture;
            } else {
                this.rollbackFuture = new CompletableFuture();
            }
            return resultStage;
        });
        if (stage == null) {
            Function<Throwable, CompletionStage> targetAction;
            CompletableFuture<Void> targetFuture;
            if (commit) {
                targetFuture = this.commitFuture;
                targetAction = throwable -> this.doCommitAsync((Throwable)throwable).handle(UnmanagedTransaction.handleCommitOrRollback(throwable));
            } else {
                targetFuture = this.rollbackFuture;
                targetAction = throwable -> this.doRollbackAsync().handle(UnmanagedTransaction.handleCommitOrRollback(throwable));
            }
            this.resultCursors.retrieveNotConsumedError().thenCompose(targetAction).whenComplete((ignored, throwable) -> this.handleTransactionCompletion(commit, (Throwable)throwable)).whenComplete(Futures.futureCompletingConsumer(targetFuture));
            stage = targetFuture;
        }
        return stage;
    }

    private static enum State {
        ACTIVE,
        TERMINATED,
        COMMITTED,
        ROLLED_BACK;

    }
}

