/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.scheduler;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.neo4j.driver.internal.shaded.reactor.core.Disposable;
import org.neo4j.driver.internal.shaded.reactor.core.Disposables;
import org.neo4j.driver.internal.shaded.reactor.core.Exceptions;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.scheduler.ReactorThreadFactory;
import org.neo4j.driver.internal.shaded.reactor.core.scheduler.Scheduler;
import org.neo4j.driver.internal.shaded.reactor.core.scheduler.Schedulers;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;

final class BoundedElasticScheduler
implements Scheduler,
Supplier<ScheduledExecutorService>,
Scannable {
    static final AtomicLong COUNTER = new AtomicLong();
    static final ThreadFactory EVICTOR_FACTORY = r -> {
        Thread t = new Thread(r, "elasticBounded-evictor-" + COUNTER.incrementAndGet());
        t.setDaemon(true);
        return t;
    };
    static final CachedService SHUTDOWN = new CachedService(null);
    static final int DEFAULT_TTL_SECONDS = 60;
    final ThreadFactory factory;
    final int ttlSeconds;
    final int threadCap;
    final int deferredTaskCap;
    final Deque<CachedServiceExpiry> idleServicesWithExpiry;
    final Queue<DeferredFacade> deferredFacades;
    final Queue<CachedService> allServices;
    final ScheduledExecutorService evictor;
    volatile boolean shutdown;
    volatile int remainingThreads;
    static final AtomicIntegerFieldUpdater<BoundedElasticScheduler> REMAINING_THREADS = AtomicIntegerFieldUpdater.newUpdater(BoundedElasticScheduler.class, "remainingThreads");
    volatile int remainingDeferredTasks;
    static final AtomicIntegerFieldUpdater<BoundedElasticScheduler> REMAINING_DEFERRED_TASKS = AtomicIntegerFieldUpdater.newUpdater(BoundedElasticScheduler.class, "remainingDeferredTasks");

    BoundedElasticScheduler(int threadCap, int deferredTaskCap, ThreadFactory factory, int ttlSeconds) {
        if (ttlSeconds < 0) {
            throw new IllegalArgumentException("ttlSeconds must be positive, was: " + ttlSeconds);
        }
        this.ttlSeconds = ttlSeconds;
        if (threadCap < 1) {
            throw new IllegalArgumentException("threadCap must be strictly positive, was: " + threadCap);
        }
        if (deferredTaskCap < 1) {
            throw new IllegalArgumentException("deferredTaskCap must be strictly positive, was: " + deferredTaskCap);
        }
        this.threadCap = threadCap;
        this.remainingThreads = threadCap;
        this.deferredTaskCap = deferredTaskCap;
        this.remainingDeferredTasks = deferredTaskCap;
        this.factory = factory;
        this.idleServicesWithExpiry = new ConcurrentLinkedDeque<CachedServiceExpiry>();
        this.deferredFacades = new ConcurrentLinkedQueue<DeferredFacade>();
        this.allServices = new ConcurrentLinkedQueue<CachedService>();
        this.evictor = Executors.newScheduledThreadPool(1, EVICTOR_FACTORY);
        this.evictor.scheduleAtFixedRate(() -> this.eviction(System::currentTimeMillis), ttlSeconds, ttlSeconds, TimeUnit.SECONDS);
    }

    @Override
    public ScheduledExecutorService get() {
        ScheduledThreadPoolExecutor poolExecutor = new ScheduledThreadPoolExecutor(1, this.factory);
        poolExecutor.setMaximumPoolSize(1);
        poolExecutor.setRemoveOnCancelPolicy(true);
        return poolExecutor;
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException("Restarting not supported yet");
    }

    @Override
    public boolean isDisposed() {
        return this.shutdown;
    }

    @Override
    public void dispose() {
        CachedService cached;
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.evictor.shutdownNow();
        this.idleServicesWithExpiry.clear();
        while ((cached = this.allServices.poll()) != null) {
            cached.exec.shutdownNow();
        }
    }

    @Nullable
    CachedService tryPick() {
        if (this.shutdown) {
            return SHUTDOWN;
        }
        CachedServiceExpiry e = this.idleServicesWithExpiry.pollLast();
        if (e != null) {
            return e.cached;
        }
        if (REMAINING_THREADS.decrementAndGet(this) < 0) {
            REMAINING_THREADS.incrementAndGet(this);
            if (this.shutdown) {
                return SHUTDOWN;
            }
            return null;
        }
        CachedService result = new CachedService(this);
        this.allServices.offer(result);
        if (this.shutdown) {
            this.allServices.remove(result);
            return SHUTDOWN;
        }
        return result;
    }

    @Override
    public Scheduler.Worker createWorker() {
        if (this.shutdown) {
            return new ActiveWorker(SHUTDOWN);
        }
        CachedServiceExpiry e = this.idleServicesWithExpiry.pollLast();
        if (e != null) {
            return new ActiveWorker(e.cached);
        }
        if (REMAINING_THREADS.decrementAndGet(this) < 0) {
            REMAINING_THREADS.incrementAndGet(this);
            if (this.shutdown) {
                return new ActiveWorker(SHUTDOWN);
            }
            DeferredWorker deferredWorker = new DeferredWorker(this);
            this.deferredFacades.offer(deferredWorker);
            return deferredWorker;
        }
        CachedService availableService = new CachedService(this);
        this.allServices.offer(availableService);
        if (this.shutdown) {
            this.allServices.remove(availableService);
            return new ActiveWorker(SHUTDOWN);
        }
        return new ActiveWorker(availableService);
    }

    @Override
    public Disposable schedule(Runnable task) {
        int remTasks;
        CachedService cached = this.tryPick();
        if (cached != null) {
            return Schedulers.directSchedule(cached.exec, task, cached, 0L, TimeUnit.MILLISECONDS);
        }
        if (this.deferredTaskCap == Integer.MAX_VALUE) {
            DeferredDirect deferredDirect = new DeferredDirect(task, 0L, 0L, TimeUnit.MILLISECONDS, this);
            this.deferredFacades.offer(deferredDirect);
            return deferredDirect;
        }
        do {
            if ((remTasks = REMAINING_DEFERRED_TASKS.get(this)) > 0) continue;
            throw Exceptions.failWithRejected("hard cap on deferred tasks reached for " + this.toString());
        } while (!REMAINING_DEFERRED_TASKS.compareAndSet(this, remTasks, remTasks - 1));
        DeferredDirect deferredDirect = new DeferredDirect(task, 0L, 0L, TimeUnit.MILLISECONDS, this);
        this.deferredFacades.offer(deferredDirect);
        return deferredDirect;
    }

    @Override
    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        int remTasks;
        CachedService cached = this.tryPick();
        if (cached != null) {
            return Schedulers.directSchedule(cached.exec, task, cached, delay, unit);
        }
        if (this.deferredTaskCap == Integer.MAX_VALUE) {
            DeferredDirect deferredDirect = new DeferredDirect(task, delay, 0L, TimeUnit.MILLISECONDS, this);
            this.deferredFacades.offer(deferredDirect);
            return deferredDirect;
        }
        do {
            if ((remTasks = REMAINING_DEFERRED_TASKS.get(this)) > 0) continue;
            throw Exceptions.failWithRejected("hard cap on deferred tasks reached for " + this.toString());
        } while (!REMAINING_DEFERRED_TASKS.compareAndSet(this, remTasks, remTasks - 1));
        DeferredDirect deferredDirect = new DeferredDirect(task, delay, 0L, TimeUnit.MILLISECONDS, this);
        this.deferredFacades.offer(deferredDirect);
        return deferredDirect;
    }

    @Override
    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        int remTasks;
        CachedService cached = this.tryPick();
        if (cached != null) {
            return Disposables.composite(Schedulers.directSchedulePeriodically(cached.exec, task, initialDelay, period, unit), cached);
        }
        if (this.deferredTaskCap == Integer.MAX_VALUE) {
            DeferredDirect deferredDirect = new DeferredDirect(task, initialDelay, period, TimeUnit.MILLISECONDS, this);
            this.deferredFacades.offer(deferredDirect);
            return deferredDirect;
        }
        do {
            if ((remTasks = REMAINING_DEFERRED_TASKS.get(this)) > 0) continue;
            throw Exceptions.failWithRejected("hard cap on deferred tasks reached for " + this.toString());
        } while (!REMAINING_DEFERRED_TASKS.compareAndSet(this, remTasks, remTasks - 1));
        DeferredDirect deferredDirect = new DeferredDirect(task, initialDelay, period, TimeUnit.MILLISECONDS, this);
        this.deferredFacades.offer(deferredDirect);
        return deferredDirect;
    }

    public String toString() {
        StringBuilder ts = new StringBuilder("boundedElastic").append('(');
        if (this.factory instanceof ReactorThreadFactory) {
            ts.append('\"').append(((ReactorThreadFactory)this.factory).get()).append("\",");
        }
        ts.append("maxThreads=").append(this.threadCap).append(",maxTaskQueued=").append(this.deferredTaskCap == Integer.MAX_VALUE ? "unbounded" : Integer.valueOf(this.deferredTaskCap)).append(",ttl=").append(this.ttlSeconds).append("s)");
        return ts.toString();
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.TERMINATED || key == Scannable.Attr.CANCELLED) {
            return this.isDisposed();
        }
        if (key == Scannable.Attr.CAPACITY) {
            return this.threadCap;
        }
        if (key == Scannable.Attr.BUFFERED) {
            return this.idleServicesWithExpiry.size();
        }
        if (key == Scannable.Attr.NAME) {
            return this.toString();
        }
        return null;
    }

    @Override
    public Stream<? extends Scannable> inners() {
        return this.idleServicesWithExpiry.stream().map(cached -> cached.cached);
    }

    void eviction(LongSupplier nowSupplier) {
        long now = nowSupplier.getAsLong();
        ArrayList<CachedServiceExpiry> list = new ArrayList<CachedServiceExpiry>(this.idleServicesWithExpiry);
        for (CachedServiceExpiry e : list) {
            if (e.expireMillis >= now || !this.idleServicesWithExpiry.remove(e)) continue;
            e.cached.exec.shutdownNow();
            this.allServices.remove(e.cached);
            REMAINING_THREADS.incrementAndGet(this);
        }
    }

    static final class DeferredDirect
    extends AtomicReference<CachedService>
    implements Scannable,
    Disposable,
    DeferredFacade {
        volatile Disposable activeTask;
        static final AtomicReferenceFieldUpdater<DeferredDirect, Disposable> ACTIVE_TASK = AtomicReferenceFieldUpdater.newUpdater(DeferredDirect.class, Disposable.class, "activeTask");
        volatile int disposed;
        static final AtomicIntegerFieldUpdater<DeferredDirect> DISPOSED = AtomicIntegerFieldUpdater.newUpdater(DeferredDirect.class, "disposed");
        final Runnable task;
        final long delay;
        final long period;
        final TimeUnit timeUnit;
        final BoundedElasticScheduler parent;

        DeferredDirect(Runnable task, long delay, long period, TimeUnit unit, BoundedElasticScheduler parent) {
            this.task = task;
            this.delay = delay;
            this.period = period;
            this.timeUnit = unit;
            this.parent = parent;
        }

        @Override
        public void setService(CachedService service) {
            if (DISPOSED.get(this) == 1) {
                service.dispose();
                return;
            }
            if (this.compareAndSet(null, service)) {
                if (this.parent.deferredTaskCap != Integer.MAX_VALUE) {
                    REMAINING_DEFERRED_TASKS.incrementAndGet(this.parent);
                }
                if (this.period == 0L && this.delay == 0L) {
                    ACTIVE_TASK.set(this, Schedulers.directSchedule(service.exec, this.task, this, 0L, TimeUnit.SECONDS));
                } else if (this.period != 0L) {
                    ACTIVE_TASK.set(this, Schedulers.directSchedulePeriodically(service.exec, this.task, this.delay, this.period, this.timeUnit));
                } else {
                    ACTIVE_TASK.set(this, Schedulers.directSchedule(service.exec, this.task, this, this.delay, this.timeUnit));
                }
            } else {
                service.dispose();
            }
        }

        @Override
        public void dispose() {
            if (DISPOSED.compareAndSet(this, 0, 1)) {
                CachedService c;
                Disposable at;
                if (this.parent.deferredFacades.remove(this) && this.parent.deferredTaskCap != Integer.MAX_VALUE) {
                    REMAINING_DEFERRED_TASKS.incrementAndGet(this.parent);
                }
                if ((at = (Disposable)ACTIVE_TASK.getAndSet(this, null)) != null) {
                    at.dispose();
                }
                if ((c = (CachedService)this.getAndSet(null)) != null) {
                    c.dispose();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return DISPOSED.get(this) == 1;
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED || key == Scannable.Attr.CANCELLED) {
                return this.isDisposed();
            }
            if (key == Scannable.Attr.NAME) {
                return this.parent.toString() + ".deferredDirect";
            }
            if (key == Scannable.Attr.CAPACITY) {
                return 1;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            CachedService d = (CachedService)this.get();
            if (key == Scannable.Attr.BUFFERED) {
                return d == null ? 1 : 0;
            }
            return null;
        }
    }

    static final class DeferredWorker
    extends ConcurrentLinkedQueue<DeferredWorkerTask>
    implements Scheduler.Worker,
    Scannable,
    DeferredFacade {
        final BoundedElasticScheduler parent;
        volatile ActiveWorker delegate;
        static final AtomicReferenceFieldUpdater<DeferredWorker, ActiveWorker> DELEGATE = AtomicReferenceFieldUpdater.newUpdater(DeferredWorker.class, ActiveWorker.class, "delegate");
        volatile int disposed;
        static final AtomicIntegerFieldUpdater<DeferredWorker> DISPOSED = AtomicIntegerFieldUpdater.newUpdater(DeferredWorker.class, "disposed");
        final String workerName;

        DeferredWorker(BoundedElasticScheduler parent) {
            this.parent = parent;
            this.workerName = parent.toString() + ".deferredWorker";
        }

        @Override
        public void setService(CachedService service) {
            if (DISPOSED.get(this) == 1) {
                service.dispose();
                return;
            }
            ActiveWorker delegate = new ActiveWorker(service);
            if (DELEGATE.compareAndSet(this, null, delegate)) {
                DeferredWorkerTask pendingTask;
                while ((pendingTask = (DeferredWorkerTask)this.poll()) != null) {
                    pendingTask.activate(delegate);
                }
            } else {
                service.dispose();
            }
        }

        @Override
        public Disposable schedule(Runnable task) {
            if (DISPOSED.get(this) == 1) {
                throw Exceptions.failWithRejected("Worker has been disposed");
            }
            ActiveWorker aw = DELEGATE.get(this);
            if (aw == null) {
                int remTasks;
                if (this.parent.deferredTaskCap == Integer.MAX_VALUE) {
                    DeferredWorkerTask pendingTask = new DeferredWorkerTask(this, task, 0L, 0L, TimeUnit.MILLISECONDS);
                    this.offer(pendingTask);
                    return pendingTask;
                }
                do {
                    if ((remTasks = REMAINING_DEFERRED_TASKS.get(this.parent)) > 0) continue;
                    throw Exceptions.failWithRejected("hard cap on deferred tasks reached for " + this.toString());
                } while (!REMAINING_DEFERRED_TASKS.compareAndSet(this.parent, remTasks, remTasks - 1));
                DeferredWorkerTask pendingTask = new DeferredWorkerTask(this, task, 0L, 0L, TimeUnit.MILLISECONDS);
                this.offer(pendingTask);
                return pendingTask;
            }
            return aw.schedule(task);
        }

        @Override
        public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            if (DISPOSED.get(this) == 1) {
                throw Exceptions.failWithRejected("Worker has been disposed");
            }
            ActiveWorker aw = DELEGATE.get(this);
            if (aw == null) {
                int remTasks;
                if (this.parent.deferredTaskCap == Integer.MAX_VALUE) {
                    DeferredWorkerTask pendingTask = new DeferredWorkerTask(this, task, delay, 0L, unit);
                    this.offer(pendingTask);
                    return pendingTask;
                }
                do {
                    if ((remTasks = REMAINING_DEFERRED_TASKS.get(this.parent)) > 0) continue;
                    throw Exceptions.failWithRejected("hard cap on deferred tasks reached for " + this.toString());
                } while (!REMAINING_DEFERRED_TASKS.compareAndSet(this.parent, remTasks, remTasks - 1));
                DeferredWorkerTask pendingTask = new DeferredWorkerTask(this, task, delay, 0L, unit);
                this.offer(pendingTask);
                return pendingTask;
            }
            return aw.schedule(task, delay, unit);
        }

        @Override
        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            if (DISPOSED.get(this) == 1) {
                throw Exceptions.failWithRejected("Worker has been disposed");
            }
            ActiveWorker aw = DELEGATE.get(this);
            if (aw == null) {
                int remTasks;
                if (this.parent.deferredTaskCap == Integer.MAX_VALUE) {
                    DeferredWorkerTask pendingTask = new DeferredWorkerTask(this, task, initialDelay, period, unit);
                    this.offer(pendingTask);
                    return pendingTask;
                }
                do {
                    if ((remTasks = REMAINING_DEFERRED_TASKS.get(this.parent)) > 0) continue;
                    throw Exceptions.failWithRejected("hard cap on deferred tasks reached for " + this.toString());
                } while (!REMAINING_DEFERRED_TASKS.compareAndSet(this.parent, remTasks, remTasks - 1));
                DeferredWorkerTask pendingTask = new DeferredWorkerTask(this, task, initialDelay, period, unit);
                this.offer(pendingTask);
                return pendingTask;
            }
            return aw.schedulePeriodically(task, initialDelay, period, unit);
        }

        @Override
        public void dispose() {
            if (DISPOSED.compareAndSet(this, 0, 1)) {
                DeferredWorkerTask pendingTask;
                this.parent.deferredFacades.remove(this);
                while ((pendingTask = (DeferredWorkerTask)this.poll()) != null) {
                    pendingTask.disposeInner();
                }
                ActiveWorker aw = DELEGATE.getAndSet(this, null);
                if (aw != null) {
                    aw.dispose();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return DISPOSED.get(this) == 1;
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED || key == Scannable.Attr.CANCELLED) {
                return this.isDisposed();
            }
            if (key == Scannable.Attr.NAME) {
                return this.workerName;
            }
            if (key == Scannable.Attr.CAPACITY) {
                return REMAINING_DEFERRED_TASKS.get(this.parent);
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.size();
            }
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            return null;
        }
    }

    static final class DeferredWorkerTask
    implements Disposable {
        final DeferredWorker parent;
        final Runnable task;
        final long delay;
        final long period;
        final TimeUnit timeUnit;
        volatile Disposable activated;
        static final AtomicReferenceFieldUpdater<DeferredWorkerTask, Disposable> ACTIVATED = AtomicReferenceFieldUpdater.newUpdater(DeferredWorkerTask.class, Disposable.class, "activated");

        DeferredWorkerTask(DeferredWorker parent, Runnable task, long delay, long period, TimeUnit unit) {
            this.parent = parent;
            this.task = task;
            this.delay = delay;
            this.period = period;
            this.timeUnit = unit;
        }

        void activate(ActiveWorker delegate) {
            if (this.parent.parent.deferredTaskCap != Integer.MAX_VALUE) {
                REMAINING_DEFERRED_TASKS.incrementAndGet(this.parent.parent);
            }
            this.activated = this.period == 0L && this.delay == 0L ? delegate.schedule(this.task) : (this.period != 0L ? delegate.schedulePeriodically(this.task, this.delay, this.period, this.timeUnit) : delegate.schedule(this.task, this.delay, this.timeUnit));
        }

        @Override
        public void dispose() {
            this.parent.remove(this);
            this.disposeInner();
        }

        void disposeInner() {
            if (this.parent.parent.deferredTaskCap != Integer.MAX_VALUE) {
                REMAINING_DEFERRED_TASKS.incrementAndGet(this.parent.parent);
            }
            if (this.activated != null) {
                this.activated.dispose();
            }
        }
    }

    @FunctionalInterface
    static interface DeferredFacade {
        public void setService(CachedService var1);
    }

    static final class ActiveWorker
    extends AtomicBoolean
    implements Scheduler.Worker,
    Scannable {
        final CachedService cached;
        final Disposable.Composite tasks;

        ActiveWorker(CachedService cached) {
            this.cached = cached;
            this.tasks = Disposables.composite();
        }

        @Override
        public Disposable schedule(Runnable task) {
            return Schedulers.workerSchedule(this.cached.exec, this.tasks, task, 0L, TimeUnit.MILLISECONDS);
        }

        @Override
        public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            return Schedulers.workerSchedule(this.cached.exec, this.tasks, task, delay, unit);
        }

        @Override
        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            return Schedulers.workerSchedulePeriodically(this.cached.exec, this.tasks, task, initialDelay, period, unit);
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.tasks.dispose();
                this.cached.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.tasks.isDisposed();
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED || key == Scannable.Attr.CANCELLED) {
                return this.isDisposed();
            }
            if (key == Scannable.Attr.NAME) {
                return this.cached.scanUnsafe(key) + ".worker";
            }
            if (key == Scannable.Attr.PARENT) {
                return this.cached.parent;
            }
            return this.cached.scanUnsafe(key);
        }
    }

    static final class CachedServiceExpiry {
        final CachedService cached;
        final long expireMillis;

        CachedServiceExpiry(CachedService cached, long expireMillis) {
            this.cached = cached;
            this.expireMillis = expireMillis;
        }
    }

    static final class CachedService
    implements Disposable,
    Scannable {
        final BoundedElasticScheduler parent;
        final ScheduledExecutorService exec;

        CachedService(@Nullable BoundedElasticScheduler parent) {
            this.parent = parent;
            if (parent != null) {
                this.exec = Schedulers.decorateExecutorService(parent, parent.get());
            } else {
                this.exec = Executors.newSingleThreadScheduledExecutor();
                this.exec.shutdownNow();
            }
        }

        @Override
        public void dispose() {
            if (this.exec != null && this != SHUTDOWN && !this.parent.shutdown) {
                DeferredFacade deferredFacade = this.parent.deferredFacades.poll();
                if (deferredFacade != null) {
                    deferredFacade.setService(this);
                } else {
                    CachedServiceExpiry e = new CachedServiceExpiry(this, System.currentTimeMillis() + (long)this.parent.ttlSeconds * 1000L);
                    this.parent.idleServicesWithExpiry.offerLast(e);
                    if (this.parent.shutdown && this.parent.idleServicesWithExpiry.remove(e)) {
                        this.exec.shutdownNow();
                    }
                }
            }
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            Integer capacity;
            if (key == Scannable.Attr.NAME) {
                return this.parent.scanUnsafe(key);
            }
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            if (key == Scannable.Attr.TERMINATED || key == Scannable.Attr.CANCELLED) {
                return this.isDisposed();
            }
            if (key == Scannable.Attr.CAPACITY && ((capacity = (Integer)Schedulers.scanExecutor(this.exec, key)) == null || capacity == -1)) {
                return 1;
            }
            return Schedulers.scanExecutor(this.exec, key);
        }
    }
}

