/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.Sinh;
import org.nd4j.linalg.util.ComplexUtil;

public class Cosh
extends BaseTransformOp {
    public Cosh() {
    }

    public Cosh(INDArray x, INDArray z) {
        super(x, z);
    }

    public Cosh(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public Cosh(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Cosh(INDArray x) {
        super(x);
    }

    @Override
    public int opNum() {
        return 64;
    }

    @Override
    public String name() {
        return "cosh";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.cos(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)FastMath.cosh((double)origin);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.cosh((double)origin);
    }

    @Override
    public double op(double origin) {
        return FastMath.cosh((double)origin);
    }

    @Override
    public float op(float origin) {
        return (float)FastMath.cosh((double)origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransformOp derivative() {
        return new Sinh(this.x, this.y, this.z, this.n);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Cosh(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Cosh(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Cosh(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Cosh(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

