/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class TensorMmul
extends BaseAccumulation {
    private int[][] axes;

    public TensorMmul(INDArray x, INDArray y, int[][] axes) {
        super(x, y);
        this.axes = axes;
        this.extraArgs = new Object[]{axes};
    }

    public TensorMmul(INDArray x, INDArray y, INDArray z, int[][] axes) {
        super(x, y, z, 0L);
        this.axes = axes;
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }

    @Override
    public void exec() {
        if (this.z != null) {
            this.z.assign(Nd4j.tensorMmul(this.x, this.y, this.z, this.axes));
        } else {
            this.z = Nd4j.tensorMmul(this.x, this.y, this.axes);
        }
    }

    @Override
    public int opNum() {
        return 3;
    }

    @Override
    public long n() {
        return 0L;
    }

    @Override
    public String name() {
        return "tensormmul";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        ++this.numProcessed;
        return origin.mul((Number)other);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        ++this.numProcessed;
        return origin.mul((Number)Float.valueOf(other));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        ++this.numProcessed;
        return origin.mul(other);
    }

    @Override
    public float op(float origin, float other) {
        ++this.numProcessed;
        return origin * other;
    }

    @Override
    public double op(double origin, double other) {
        ++this.numProcessed;
        return origin * other;
    }

    @Override
    public double op(double origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public float op(float origin) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin;
    }

    @Override
    public double update(double accum, double x) {
        return accum + x;
    }

    @Override
    public double update(double accum, double x, double y) {
        return accum + x * y;
    }

    @Override
    public float update(float accum, float x) {
        return accum + x;
    }

    @Override
    public float update(float accum, float x, float y) {
        return accum + x * y;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        return accum.add((Number)x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        return accum.add((Number)(x * y));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        return accum.add(x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        return accum.add(x.mul(y));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        return accum.add(x.mul((Number)y));
    }

    @Override
    public double combineSubResults(double first, double second) {
        return first + second;
    }

    @Override
    public float combineSubResults(float first, float second) {
        return first + second;
    }

    @Override
    public IComplexNumber combineSubResults(IComplexNumber first, IComplexNumber second) {
        return first.add(second);
    }

    public TensorMmul() {
    }
}

