/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.parallel.tasks.cpu.indexaccum;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveAction;
import org.apache.commons.math3.util.Pair;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.parallel.tasks.Task;
import org.nd4j.linalg.api.parallel.tasks.TaskExecutorProvider;
import org.nd4j.linalg.api.parallel.tasks.cpu.indexaccum.CPUIndexAccumulationTask;
import org.nd4j.linalg.api.shape.tensor.TensorCalculator;

public class CPUIndexAccumulations1dAction
extends RecursiveAction
implements Task<Void> {
    private Future future;
    private List<Task<?>> subTasks = null;
    private IndexAccumulation op;
    private int threshold;
    private TensorCalculator tCalcx;
    private TensorCalculator tCalcy;
    private int firstTensor;
    private int lastTensor;
    private INDArray output;

    public CPUIndexAccumulations1dAction(IndexAccumulation op, int threshold, TensorCalculator tCalcx, TensorCalculator tCalcy, int firstTensor, int lastTensor, INDArray output) {
        this.op = op;
        this.threshold = threshold;
        this.tCalcx = tCalcx;
        this.tCalcy = tCalcy;
        this.firstTensor = firstTensor;
        this.lastTensor = lastTensor;
        this.output = output;
    }

    @Override
    protected void compute() {
        int nTensors = this.lastTensor - this.firstTensor + 1;
        int nElements = nTensors * this.tCalcx.getTensorLength();
        if (nTensors > 1 && nElements > this.threshold) {
            int nFirst = nTensors / 2;
            CPUIndexAccumulations1dAction taskLeft = new CPUIndexAccumulations1dAction(this.op, this.threshold, this.tCalcx, this.tCalcy, this.firstTensor, this.firstTensor + nFirst - 1, this.output);
            taskLeft.fork();
            CPUIndexAccumulations1dAction taskRight = new CPUIndexAccumulations1dAction(this.op, this.threshold, this.tCalcx, this.tCalcy, this.firstTensor + nFirst, this.lastTensor, this.output);
            taskRight.fork();
            taskLeft.join();
            taskRight.join();
        } else if (nTensors == 1 && nElements > this.threshold) {
            int offsetX = this.tCalcx.getOffsetForTensor(this.firstTensor);
            int offsetY = this.tCalcy != null ? this.tCalcy.getOffsetForTensor(this.firstTensor) : 0;
            int incrX = this.tCalcx.getElementWiseStrideForTensor();
            int incrY = this.tCalcy != null ? this.tCalcy.getElementWiseStrideForTensor() : 0;
            int n = this.tCalcx.getTensorLength();
            int nFirst = n / 2;
            CPUIndexAccumulationTask first = new CPUIndexAccumulationTask(this.op, this.threshold, nFirst, offsetX, offsetY, incrX, incrY, 0, false);
            first.fork();
            int nSecond = n - nFirst;
            int offsetX2 = offsetX + nFirst * incrX;
            int offsetY2 = offsetY + nFirst * incrY;
            CPUIndexAccumulationTask second = new CPUIndexAccumulationTask(this.op, this.threshold, nSecond, offsetX2, offsetY2, incrX, incrY, nFirst, false);
            second.fork();
            Pair<Double, Integer> pair = this.op.combineSubResults((Pair<Double, Integer>)((Pair)first.join()), (Pair<Double, Integer>)((Pair)second.join()));
            this.output.putScalar(this.firstTensor, (int)((Integer)pair.getSecond()));
        } else {
            this.execute();
        }
    }

    @Override
    public Void call() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private void execute() {
        DataBuffer x = this.op.x().data();
        DataBuffer y = this.op.y() != null ? this.op.y().data() : null;
        int incrX = this.tCalcx.getElementWiseStrideForTensor();
        int n = this.tCalcx.getTensorLength();
        if (y != null) {
            int incrY = this.tCalcy.getElementWiseStrideForTensor();
            for (int tensorNum = this.firstTensor; tensorNum <= this.lastTensor; ++tensorNum) {
                double dy;
                int i;
                int byteOffsetY;
                int offsetX = this.tCalcx.getOffsetForTensor(tensorNum);
                int offsetY = this.tCalcy.getOffsetForTensor(tensorNum);
                if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
                    int i2;
                    if (x.dataType() == DataBuffer.Type.FLOAT) {
                        int i3;
                        float[] xf = (float[])x.array();
                        float[] yf = (float[])y.array();
                        float accum = this.op.zeroFloat();
                        int idxAccum = -1;
                        if (incrX == 1 && incrY == 1) {
                            for (i3 = 0; i3 < n; ++i3) {
                                if ((idxAccum = this.op.update(accum, idxAccum, xf[offsetX + i3], yf[offsetY + i3], i3)) != i3) continue;
                                accum = this.op.op(xf[offsetX + i3], yf[offsetY + i3]);
                            }
                        } else {
                            for (i3 = 0; i3 < n; ++i3) {
                                if ((idxAccum = this.op.update(accum, idxAccum, xf[offsetX + i3 * incrX], yf[offsetY + i3 * incrY], i3)) != i3) continue;
                                accum = this.op.op(xf[offsetX + i3 * incrX], yf[offsetY + i3 * incrY]);
                            }
                        }
                        this.output.putScalar(tensorNum, idxAccum);
                        continue;
                    }
                    double[] xd = (double[])x.array();
                    double[] yd = (double[])y.array();
                    double accum = this.op.zeroDouble();
                    int idxAccum = -1;
                    if (incrX == 1 && incrY == 1) {
                        for (i2 = 0; i2 < n; ++i2) {
                            if ((idxAccum = this.op.update(accum, idxAccum, xd[offsetX + i2], yd[offsetY + i2], i2)) != i2) continue;
                            accum = this.op.op(xd[offsetX + i2], yd[offsetY + i2]);
                        }
                    } else {
                        for (i2 = 0; i2 < n; ++i2) {
                            if ((idxAccum = this.op.update(accum, idxAccum, xd[offsetX + i2 * incrX], yd[offsetY + i2 * incrY], i2)) != i2) continue;
                            accum = this.op.op(xd[offsetX + i2 * incrX], yd[offsetY + i2 * incrY]);
                        }
                    }
                    this.output.putScalar(tensorNum, idxAccum);
                    continue;
                }
                ByteBuf nbbx = x.asNetty();
                ByteBuf nbby = y.asNetty();
                if (x.dataType() == DataBuffer.Type.FLOAT) {
                    int i4;
                    int byteOffsetX = 4 * offsetX;
                    byteOffsetY = 4 * offsetY;
                    float accum = this.op.zeroFloat();
                    int idxAccum = -1;
                    int idx = 0;
                    if (incrX == 1 && incrY == 1) {
                        i4 = 0;
                        while (i4 < 4 * n) {
                            float fy;
                            float fx = nbbx.getFloat(byteOffsetX + i4);
                            if ((idxAccum = this.op.update(accum, idxAccum, fx, fy = nbby.getFloat(byteOffsetY + i4), idx)) == idx) {
                                accum = this.op.op(fx, fy);
                            }
                            i4 += 4;
                            ++idx;
                        }
                    } else {
                        i4 = 0;
                        while (i4 < 4 * n) {
                            float fy;
                            float fx = nbbx.getFloat(byteOffsetX + i4 * incrX);
                            if ((idxAccum = this.op.update(accum, idxAccum, fx, fy = nbby.getFloat(byteOffsetY + i4 * incrY), idx)) == idx) {
                                accum = this.op.op(fx, fy);
                            }
                            i4 += 4;
                            ++idx;
                        }
                    }
                    this.output.putScalar(tensorNum, idxAccum);
                    continue;
                }
                int byteOffsetX = 8 * offsetX;
                byteOffsetY = 8 * offsetY;
                double accum = this.op.zeroDouble();
                int idxAccum = -1;
                int idx = 0;
                if (incrX == 1 && incrY == 1) {
                    i = 0;
                    while (i < 8 * n) {
                        double dx = nbbx.getDouble(byteOffsetX + i);
                        if ((idxAccum = this.op.update(accum, idxAccum, dx, dy = nbby.getDouble(byteOffsetY + i), idx)) == idx) {
                            accum = this.op.op(dx, dy);
                        }
                        i += 8;
                        ++idx;
                    }
                } else {
                    i = 0;
                    while (i < 8 * n) {
                        double dx = nbbx.getDouble(byteOffsetX + i * incrX);
                        if ((idxAccum = this.op.update(accum, idxAccum, dx, dy = nbby.getDouble(byteOffsetY + i * incrY), idx)) == idx) {
                            accum = this.op.op(dx, dy);
                        }
                        i += 8;
                        ++idx;
                    }
                }
                this.output.putScalar(tensorNum, idxAccum);
            }
        } else {
            for (int tensorNum = this.firstTensor; tensorNum <= this.lastTensor; ++tensorNum) {
                double dx;
                int i;
                int idxAccum;
                int offsetX = this.tCalcx.getOffsetForTensor(tensorNum);
                if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
                    int i5;
                    if (x.dataType() == DataBuffer.Type.FLOAT) {
                        int i6;
                        float[] xf = (float[])x.array();
                        float accum = this.op.zeroFloat();
                        int idxAccum2 = -1;
                        if (incrX == 1) {
                            for (i6 = 0; i6 < n; ++i6) {
                                if ((idxAccum2 = this.op.update(accum, idxAccum2, xf[offsetX + i6], i6)) != i6) continue;
                                accum = this.op.op(xf[offsetX + i6]);
                            }
                        } else {
                            for (i6 = 0; i6 < n; ++i6) {
                                if ((idxAccum2 = this.op.update(accum, idxAccum2, xf[offsetX + i6 * incrX], i6)) != i6) continue;
                                accum = this.op.op(xf[offsetX + i6 * incrX]);
                            }
                        }
                        this.output.putScalar(tensorNum, idxAccum2);
                        continue;
                    }
                    double[] xd = (double[])x.array();
                    double accum = this.op.zeroDouble();
                    idxAccum = -1;
                    if (incrX == 1) {
                        for (i5 = 0; i5 < n; ++i5) {
                            if ((idxAccum = this.op.update(accum, idxAccum, xd[offsetX + i5], i5)) != i5) continue;
                            accum = this.op.op(xd[offsetX + i5]);
                        }
                    } else {
                        for (i5 = 0; i5 < n; ++i5) {
                            if ((idxAccum = this.op.update(accum, idxAccum, xd[offsetX + i5 * incrX], i5)) != i5) continue;
                            accum = this.op.op(xd[offsetX + i5 * incrX]);
                        }
                    }
                    this.output.putScalar(tensorNum, idxAccum);
                    continue;
                }
                ByteBuf nbbx = x.asNetty();
                if (x.dataType() == DataBuffer.Type.FLOAT) {
                    int i7;
                    int byteOffsetX = 4 * offsetX;
                    float accum = this.op.zeroFloat();
                    idxAccum = -1;
                    int idx = 0;
                    if (incrX == 1) {
                        i7 = 0;
                        while (i7 < 4 * n) {
                            float fx = nbbx.getFloat(byteOffsetX + i7);
                            if ((idxAccum = this.op.update(accum, idxAccum, fx, idx)) == idx) {
                                accum = this.op.op(fx);
                            }
                            i7 += 4;
                            ++idx;
                        }
                    } else {
                        i7 = 0;
                        while (i7 < 4 * n) {
                            float fx = nbbx.getFloat(byteOffsetX + i7 * incrX);
                            if ((idxAccum = this.op.update(accum, idxAccum, fx, idx)) == idx) {
                                accum = this.op.op(fx);
                            }
                            i7 += 4;
                            ++idx;
                        }
                    }
                    this.output.putScalar(tensorNum, idxAccum);
                    continue;
                }
                int byteOffsetX = 8 * offsetX;
                double accum = this.op.zeroDouble();
                int idxAccum3 = -1;
                int idx = 0;
                if (incrX == 1) {
                    i = 0;
                    while (i < 8 * n) {
                        dx = nbbx.getDouble(byteOffsetX + i);
                        if ((idxAccum3 = this.op.update(accum, idxAccum3, dx, idx)) == idx) {
                            accum = this.op.op(dx);
                        }
                        i += 8;
                        ++idx;
                    }
                } else {
                    i = 0;
                    while (i < 8 * n) {
                        dx = nbbx.getDouble(byteOffsetX + i * incrX);
                        if ((idxAccum3 = this.op.update(accum, idxAccum3, dx, idx)) == idx) {
                            accum = this.op.op(dx);
                        }
                        i += 8;
                        ++idx;
                    }
                }
                this.output.putScalar(tensorNum, idxAccum3);
            }
        }
    }

    @Override
    public Void invokeBlocking() {
        this.invokeAsync();
        return this.blockUntilComplete();
    }

    @Override
    public void invokeAsync() {
        this.future = TaskExecutorProvider.getTaskExecutor().executeAsync(this);
    }

    @Override
    public Void blockUntilComplete() {
        if (this.future == null) {
            this.invokeAsync();
        }
        try {
            this.future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.subTasks != null) {
            for (Task<?> t : this.subTasks) {
                t.blockUntilComplete();
            }
        }
        return null;
    }
}

