/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.accum.Mean;
import org.nd4j.linalg.api.ops.impl.accum.Sum;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public class Bias
extends BaseAccumulation {
    private double mean;

    public Bias() {
    }

    public Bias(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
        this.passThrough = true;
    }

    public Bias(INDArray x, INDArray y, int n) {
        this(x, y, x, n);
        this.passThrough = true;
    }

    public Bias(INDArray x) {
        super(x);
        this.passThrough = true;
    }

    public Bias(INDArray x, INDArray y) {
        super(x, y);
        this.passThrough = true;
    }

    @Override
    public String name() {
        return "bias";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Bias(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Bias(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Bias(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Bias(this.x.tensorAlongDimension(index, dimension));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin.sub(this.mean);
    }

    @Override
    public double op(double origin) {
        return origin - this.mean;
    }

    @Override
    public float op(float origin) {
        return (float)((double)origin - this.mean);
    }

    @Override
    public double update(double accum, double x) {
        return accum + x;
    }

    @Override
    public double update(double accum, double x, double y) {
        return accum + x;
    }

    @Override
    public float update(float accum, float x) {
        return accum + x;
    }

    @Override
    public float update(float accum, float x, float y) {
        return accum + x;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        return accum.add(x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        return accum.add(x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        return accum.add(x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        return accum.add(x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        return accum.add(x);
    }

    @Override
    public IComplexNumber zeroComplex() {
        return Nd4j.createComplexNumber(0.0, 0.0);
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        super.init(x, y, z, n);
    }

    @Override
    public double combineSubResults(double first, double second) {
        return first + second;
    }

    @Override
    public float combineSubResults(float first, float second) {
        return first + second;
    }

    @Override
    public IComplexNumber combineSubResults(IComplexNumber first, IComplexNumber second) {
        return first.add(second);
    }

    @Override
    public void exec() {
        this.mean = Nd4j.getExecutioner().execAndReturn(new Mean(this.x)).getFinalResult().doubleValue();
        INDArray xMinusMean = this.x.sub(this.mean);
        double sum = Nd4j.getExecutioner().execAndReturn(new Sum(xMinusMean)).getFinalResult().doubleValue();
        this.finalResult = sum;
    }

    @Override
    public void exec(int ... dimension) {
        int[] retShape = ArrayUtil.removeIndex(this.x.shape(), dimension);
        int nOps = this.x.tensorssAlongDimension(dimension);
        this.z = Nd4j.create(retShape);
        for (int i = 0; i < nOps; ++i) {
            double d = Nd4j.getExecutioner().execAndReturn((Bias)this.opForDimension(i, dimension)).getFinalResult().doubleValue();
            this.z.putScalar(i, d);
        }
    }
}

