/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

import com.google.common.primitives.Ints;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.nd4j.linalg.api.blas.BlasBufferUtil;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.iter.FirstAxisIterator;
import org.nd4j.linalg.api.iter.NdIndexIterator;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.accum.Max;
import org.nd4j.linalg.api.ops.impl.accum.Mean;
import org.nd4j.linalg.api.ops.impl.accum.Min;
import org.nd4j.linalg.api.ops.impl.accum.Norm1;
import org.nd4j.linalg.api.ops.impl.accum.Norm2;
import org.nd4j.linalg.api.ops.impl.accum.NormMax;
import org.nd4j.linalg.api.ops.impl.accum.Prod;
import org.nd4j.linalg.api.ops.impl.accum.StandardDeviation;
import org.nd4j.linalg.api.ops.impl.accum.Sum;
import org.nd4j.linalg.api.ops.impl.accum.Variance;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAddOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastCopyOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMulOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRSubOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastSubOp;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarAdd;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMultiplication;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarEquals;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarNotEquals;
import org.nd4j.linalg.api.ops.impl.transforms.Negative;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.AddOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.DivOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.MulOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.SubOp;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.Eps;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.EqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.GreaterThan;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.LessThan;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.NotEqualTo;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.indexing.ShapeOffsetResolution;
import org.nd4j.linalg.indexing.SpecifiedIndex;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.string.NDArrayStrings;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.nd4j.linalg.util.NDArrayMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNDArray
implements INDArray,
Iterable {
    protected static final Logger log = LoggerFactory.getLogger(BaseNDArray.class);
    private static final long serialVersionUID = 3285982317165542614L;
    protected int[] shape;
    protected int[] stride;
    protected int offset = 0;
    protected char ordering;
    protected DataBuffer data;
    protected int rows;
    protected int columns;
    protected int length;
    protected INDArray linearView;
    protected boolean cleanedUp = false;
    protected transient WeakReference<INDArray> ref;
    protected int firstNonOneStride = -1;
    protected int numLeadingOnes = -1;
    protected int numTrailingOnes = -1;
    protected int majorStride = -1;
    protected Boolean isVector = null;
    protected Boolean isScalar = null;
    protected boolean isWrapAround = false;
    protected int linearStride = -1;
    protected int elementWiseStride = -1;
    protected boolean attemptedToFindElementWiseStride = false;

    public BaseNDArray() {
    }

    public BaseNDArray(DataBuffer buffer) {
        this.data = buffer;
        this.init(new int[]{1, buffer.length()});
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, int[] stride, int offset, char ordering) {
        this.data = buffer;
        if (ArrayUtil.prod(shape) > buffer.length()) {
            throw new IllegalArgumentException("Shape must be <= buffer length");
        }
        this.stride = stride;
        this.offset = offset;
        this.ordering = ordering;
        this.init(shape);
    }

    public BaseNDArray(double[][] data) {
        this(data, Nd4j.order().charValue());
    }

    public BaseNDArray(double[][] data, char ordering) {
        this(Nd4j.createBuffer(ArrayUtil.flatten(data)), new int[]{data.length, data[0].length}, Nd4j.getStrides(new int[]{data.length, data[0].length}, ordering), 0, ordering);
        int r;
        for (r = 0; r < this.rows; ++r) {
            assert (data[r].length == this.columns);
        }
        this.data = Nd4j.createBuffer(this.length);
        for (r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                this.putScalar(new int[]{r, c}, data[r][c]);
            }
        }
    }

    public BaseNDArray(int[] shape, DataBuffer buffer) {
        this.data = buffer;
        this.init(shape);
    }

    public BaseNDArray(float[] data, int[] shape, char ordering) {
        this(data, shape, 0, ordering);
    }

    public BaseNDArray(float[] data, int[] shape, int offset, char ordering) {
        this(data, shape, ordering == 'c' ? ArrayUtil.calcStrides(shape) : ArrayUtil.calcStridesFortran(shape), offset);
    }

    public BaseNDArray(int[] shape, int[] stride, int offset, char ordering) {
        this(Nd4j.createBuffer(ArrayUtil.prod(shape)), shape, stride, offset, ordering);
    }

    public BaseNDArray(int[] shape, int[] stride, char ordering) {
        this(shape, stride, 0, ordering);
    }

    public BaseNDArray(int[] shape, int offset, char ordering) {
        this(shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    public BaseNDArray(int[] shape) {
        this(shape, 0, Nd4j.order().charValue());
    }

    public BaseNDArray(int newRows, int newColumns, char ordering) {
        this.ordering = ordering;
        this.data = Nd4j.createBuffer(newRows * newColumns);
        this.init(new int[]{newRows, newColumns});
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, char ordering) {
        this(slices, shape, Nd4j.getStrides(shape, ordering), ordering);
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, int[] stride, char ordering) {
        int[] thisShape = Ints.concat((int[][])new int[][]{{slices.size()}, slices.get(0).shape()});
        DataBuffer ret = slices.get(0).data().dataType() == DataBuffer.Type.FLOAT ? Nd4j.createBuffer(new float[ArrayUtil.prod(thisShape)]) : Nd4j.createBuffer(new double[ArrayUtil.prod(thisShape)]);
        this.stride = stride;
        this.ordering = ordering;
        this.data = ret;
        this.init(thisShape);
        for (int i = 0; i < this.slices(); ++i) {
            this.putSlice(i, slices.get(i));
        }
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, char ordering) {
        this(data, shape, stride, 0, ordering);
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        this.offset = offset;
        this.stride = ArrayUtil.copy(stride);
        this.ordering = ordering;
        if (data != null && data.length > 0) {
            this.data = Nd4j.createBuffer(data);
            if (offset >= data.length) {
                throw new IllegalArgumentException("invalid offset: must be < data.length");
            }
        }
        this.init(shape);
    }

    public BaseNDArray(DataBuffer data, int[] shape, int[] stride, int offset) {
        this.data = data;
        this.stride = stride;
        this.offset = offset;
        this.ordering = Nd4j.order().charValue();
        this.init(shape);
    }

    public BaseNDArray(int[] data, int[] shape, int[] strides) {
        this(Nd4j.createBuffer(data), shape, strides);
    }

    public BaseNDArray(DataBuffer data, int[] shape) {
        this(data, shape, Nd4j.getStrides(shape, Nd4j.order().charValue()), 0, Nd4j.order().charValue());
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, int offset) {
        this(buffer, shape, Nd4j.getStrides(shape), offset, Nd4j.order().charValue());
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, char ordering) {
        this(buffer, shape, Nd4j.getStrides(shape, ordering), 0, ordering);
    }

    public BaseNDArray(double[] data, int[] shape, char ordering) {
        this(Nd4j.createBuffer(data), shape, ordering);
    }

    public BaseNDArray(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        this(Nd4j.createBuffer(data), shape, stride, offset, ordering);
    }

    public BaseNDArray(float[] data, char order) {
        this(Nd4j.createBuffer(data), order);
    }

    public BaseNDArray(DataBuffer floatBuffer, char order) {
        this(floatBuffer, new int[]{floatBuffer.length()}, Nd4j.getStrides(new int[]{floatBuffer.length()}, order), 0, order);
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, int[] strides) {
        this(buffer, shape, strides, 0, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape) {
        this(data, shape, 0);
    }

    public BaseNDArray(float[] data, int[] shape, int offset) {
        this(data, shape, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(int[] shape, int[] stride, int offset) {
        this(new float[ArrayUtil.prod(shape)], shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(int[] shape, int[] stride) {
        this(shape, stride, 0);
    }

    public BaseNDArray(int[] shape, int offset) {
        this(shape, ArrayUtil.calcStrides(shape), offset);
    }

    public BaseNDArray(int[] shape, char ordering) {
        this(shape, 0, ordering);
    }

    public BaseNDArray(int newRows, int newColumns) {
        this(newRows, newColumns, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, int[] shape) {
        this(slices, shape, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, int[] stride) {
        this(slices, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride) {
        this(data, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, int offset) {
        this(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data) {
        this(Nd4j.createBuffer(data));
    }

    public BaseNDArray(float[][] data) {
        this(data, Nd4j.order().charValue());
    }

    public BaseNDArray(float[][] data, char ordering) {
        this(Nd4j.createBuffer(ArrayUtil.flatten(data)), new int[]{data.length, data[0].length}, Nd4j.getStrides(new int[]{data.length, data[0].length}, ordering), 0, ordering);
        int r;
        for (r = 0; r < this.rows; ++r) {
            assert (data[r].length == this.columns);
        }
        this.data = Nd4j.createBuffer(this.length);
        for (r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                this.putScalar(new int[]{r, c}, data[r][c]);
            }
        }
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, int offset, char ordering) {
        this(buffer, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    @Override
    public void setWrapAround(boolean wrapAround) {
        this.isWrapAround = wrapAround;
    }

    @Override
    public boolean isWrapAround() {
        return this.isWrapAround;
    }

    public boolean isValid() {
        try {
            this.linearIndex(this.length() - 1);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public INDArray linearViewColumnOrder() {
        return this.create(this.data, new int[]{this.length, 1}, this.offset());
    }

    protected INDArray create(DataBuffer data, int[] shape, int offset) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(data, shape, offset);
        }
        return Nd4j.create(data, shape, offset);
    }

    @Override
    public INDArray linearView() {
        return this;
    }

    @Override
    public void resetLinearView() {
    }

    @Override
    public int elementWiseStride() {
        if (this.elementWiseStride < 0 && !this.attemptedToFindElementWiseStride) {
            INDArray reshapeAttempt = Shape.newShapeNoCopy(this, new int[]{1, this.length()}, this.ordering() == 'f');
            if (reshapeAttempt != null) {
                this.elementWiseStride = reshapeAttempt.stride(-1);
            }
            this.attemptedToFindElementWiseStride = true;
        }
        return this.elementWiseStride;
    }

    @Override
    public int elementStride() {
        return 1;
    }

    @Override
    public int majorStride() {
        this.setLinearStride();
        return this.stride(-1);
    }

    @Override
    public int secondaryStride() {
        if (this.stride.length == 0) {
            return 1;
        }
        if (this.stride.length >= 2) {
            if (this.ordering == 'c') {
                if (this.isColumnVector()) {
                    return this.majorStride();
                }
                return this.stride[1];
            }
            return this.majorStride();
        }
        return this.majorStride();
    }

    @Override
    public int tensorssAlongDimension(int ... dimension) {
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + this.rank();
        }
        if (dimension == null || dimension.length == 0) {
            throw new IllegalArgumentException("Invalid input: dimensions not specified (null or length 0)");
        }
        int[] tensorShape = ArrayUtil.keep(this.shape(), dimension);
        return this.length / ArrayUtil.prod(tensorShape);
    }

    @Override
    public INDArray tensorAlongDimension(int index, int ... dimension) {
        if (dimension == null || dimension.length == 0) {
            throw new IllegalArgumentException("Invalid input: dimensions not specified (null or length 0)");
        }
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + this.rank();
        }
        if (dimension.length == 1 && this.isColumnVector() && dimension[0] == 0 || this.isRowVector() && this.isRowVector() && dimension[0] == 1) {
            return this;
        }
        int[] tensorShape = ArrayUtil.keep(this.shape(), dimension);
        int[] reverseDimensions = ArrayUtil.reverseCopy(dimension);
        int[] remove = ArrayUtil.removeIndex(ArrayUtil.range(0, this.rank()), dimension);
        int[] newPermuteDims = Ints.concat((int[][])new int[][]{remove, reverseDimensions});
        INDArray permuted = this.permute(newPermuteDims);
        int sliceIdx = NDArrayMath.sliceOffsetForTensor(index, permuted, tensorShape);
        INDArray ret2 = permuted.slice(sliceIdx);
        if (dimension.length == tensorShape.length && ArrayUtil.prod(tensorShape) == ret2.length()) {
            return ret2;
        }
        int length = ArrayUtil.prod(tensorShape);
        int tensorLength = ArrayUtil.prod(tensorShape);
        int offset = index * tensorLength / NDArrayMath.lengthPerSlice(ret2);
        if (sliceIdx == 0 && length == NDArrayMath.lengthPerSlice(ret2)) {
            return ret2.slice(offset);
        }
        if (length == NDArrayMath.lengthPerSlice(ret2)) {
            offset -= ret2.slices() * (offset / ret2.slices());
            ret2 = ret2.slice(offset);
            return ret2;
        }
        while (ret2.length() > length) {
            sliceIdx = NDArrayMath.sliceOffsetForTensor(index, ret2, tensorShape);
            sliceIdx -= ret2.slices() * (sliceIdx / ret2.slices());
            ret2 = ret2.slice(sliceIdx);
        }
        return ret2;
    }

    @Override
    public int vectorsAlongDimension(int dimension) {
        if (dimension == 0 && this.isVector() || this.isRowVector()) {
            return 1;
        }
        if (this.size(dimension) == 1 && !this.isVector()) {
            for (int i = dimension; i < this.rank(); ++i) {
                if (this.size(i) == 1) continue;
                return this.vectorsAlongDimension(i);
            }
            return this.length();
        }
        if (this.size(0) == 1 && !this.isVector()) {
            int realDimension = this.rank() - this.getLeadingOnes();
            return this.length / this.size(realDimension);
        }
        if (dimension >= this.shape.length) {
            return this.length / this.size(this.shape.length - 1);
        }
        return this.length / this.size(dimension);
    }

    @Override
    public INDArray vectorAlongDimension(int index, int dimension) {
        if (dimension < 0) {
            dimension = this.stride.length + dimension;
        }
        if (dimension == this.shape.length - 1 && this.size(dimension) == 1 && this.rank() > 2 || this.rank() > 2 && dimension == 0 && this.size(dimension) == 1) {
            return this.linearView();
        }
        INDArray ret = this.tensorAlongDimension(index, dimension);
        if (this.isMatrix() && ret.isVector() && dimension == 1 && !ret.isRowVector()) {
            return ret.reshape(ArrayUtil.reverseCopy(ret.shape()));
        }
        if (this.isMatrix() && ret.isVector() && dimension == 0 && !ret.isColumnVector()) {
            return ret.reshape(ArrayUtil.reverseCopy(ret.shape()));
        }
        return ret;
    }

    @Override
    public void setOrder(char order) {
        this.ordering = order;
    }

    @Override
    public void setShape(int ... shape) {
        this.shape = shape;
    }

    private int getFirstNonOneStride() {
        if (this.firstNonOneStride >= 0) {
            return this.firstNonOneStride;
        }
        for (int j = 0; j < this.stride().length; ++j) {
            if (this.stride()[j] == 1) continue;
            if (this.firstNonOneStride < 0) {
                this.firstNonOneStride = this.stride[j];
            }
            return this.stride[j];
        }
        if (this.firstNonOneStride < 0) {
            this.firstNonOneStride = this.elementStride();
        }
        return this.elementStride();
    }

    @Override
    public INDArray cumsumi(int dimension) {
        if (this.isVector()) {
            double s = 0.0;
            for (int i = 0; i < this.length; ++i) {
                this.putScalar(i, s += this.getDouble(i));
            }
        } else {
            if (dimension == Integer.MAX_VALUE) {
                INDArray flattened = this.ravel();
                double prevVal = flattened.getDouble(0);
                for (int i = 1; i < flattened.length(); ++i) {
                    double d = prevVal + flattened.getDouble(i);
                    flattened.putScalar(i, d);
                    prevVal = d;
                }
                return flattened;
            }
            for (int i = 0; i < this.vectorsAlongDimension(dimension); ++i) {
                INDArray vec = this.vectorAlongDimension(i, dimension);
                vec.cumsumi(0);
            }
        }
        return this;
    }

    @Override
    public Number normmaxNumber() {
        return this.normmax(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber normmaxComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number norm2Number() {
        return this.norm2(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber norm2Complex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number norm1Number() {
        return this.norm1(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber norm1Complex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number stdNumber() {
        return this.std(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber stdComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number prodNumber() {
        return this.prod(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber prodComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number meanNumber() {
        return this.mean(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber meanComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number varNumber() {
        return this.var(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber varComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number maxNumber() {
        return this.max(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber maxComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number minNumber() {
        return this.min(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber minComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number sumNumber() {
        return this.sum(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber sumComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray cumsum(int dimension) {
        return this.dup().cumsumi(dimension);
    }

    @Override
    public INDArray assign(INDArray arr) {
        if (arr.elementWiseStride() > 0 && this.elementWiseStride() > 0 && this.ordering() == arr.ordering()) {
            this.data().copyAtStride(arr.data(), arr.length(), this.elementWiseStride(), arr.elementWiseStride(), this.offset(), arr.offset());
        } else {
            NdIndexIterator iterator = new NdIndexIterator(this.shape());
            NdIndexIterator otherIter = new NdIndexIterator(arr.shape());
            for (int i = 0; i < this.length(); ++i) {
                this.putScalar(iterator.next(), arr.getDouble(otherIter.next()));
            }
        }
        return this;
    }

    @Override
    public INDArray putScalar(int i, double value) {
        if (this.isScalar()) {
            this.data.put(this.offset + i, value);
            return this;
        }
        if (this.isRowVector()) {
            return this.putScalar(new int[]{0, i}, value);
        }
        if (this.isColumnVector()) {
            return this.putScalar(new int[]{i, 0}, value);
        }
        int[] indexes = this.ordering() == 'c' ? Shape.ind2subC(this, i) : Shape.ind2sub(this, i);
        return this.putScalar(indexes, value);
    }

    @Override
    public INDArray putScalar(int i, float value) {
        return this.putScalar(i, (double)value);
    }

    @Override
    public INDArray putScalar(int i, int value) {
        return this.putScalar(i, (double)value);
    }

    @Override
    public INDArray putScalar(int[] indexes, double value) {
        int offset = Shape.getOffset(this.offset(), this.shape(), this.stride(), indexes);
        if (offset >= this.data().length()) {
            throw new IllegalArgumentException("Illegal index " + Arrays.toString(indexes));
        }
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(int[] indexes, float value) {
        return this.putScalar(indexes, (double)value);
    }

    @Override
    public INDArray putScalar(int[] indexes, int value) {
        return this.putScalar(indexes, (double)value);
    }

    @Override
    public INDArray eps(Number other) {
        return this.dup().epsi(other);
    }

    @Override
    public INDArray epsi(Number other) {
        return Nd4j.getExecutioner().execAndReturn(new Eps(this));
    }

    @Override
    public INDArray eps(INDArray other) {
        return this.dup().epsi(other);
    }

    @Override
    public INDArray epsi(INDArray other) {
        Nd4j.getExecutioner().exec(new Eps(this.linearView(), other.linearView(), this, this.length()));
        return this;
    }

    @Override
    public INDArray lt(Number other) {
        return this.dup().lti(other);
    }

    @Override
    public INDArray lti(Number other) {
        Nd4j.getExecutioner().exec(new ScalarLessThan(this.linearView(), other));
        return this;
    }

    @Override
    public INDArray eq(Number other) {
        return this.dup().eqi(other);
    }

    @Override
    public INDArray eqi(Number other) {
        Nd4j.getExecutioner().exec(new ScalarEquals(this.linearView(), other));
        return this;
    }

    @Override
    public INDArray gt(Number other) {
        return this.dup().gti(other);
    }

    @Override
    public INDArray gti(Number other) {
        Nd4j.getExecutioner().exec(new ScalarGreaterThan(this.linearView(), other));
        return this;
    }

    @Override
    public INDArray lt(INDArray other) {
        return this.dup().lti(other);
    }

    @Override
    public INDArray lti(INDArray other) {
        Nd4j.getExecutioner().exec(new LessThan(this.linearView(), other, this.linearView(), this.length()));
        return this;
    }

    @Override
    public INDArray neq(Number other) {
        return this.dup().neqi(other);
    }

    @Override
    public INDArray neqi(Number other) {
        Nd4j.getExecutioner().exec(new ScalarNotEquals(this.linearView(), other));
        return this;
    }

    @Override
    public INDArray neq(INDArray other) {
        return this.dup().neqi(other);
    }

    @Override
    public INDArray neqi(INDArray other) {
        Nd4j.getExecutioner().exec(new NotEqualTo(this.linearView(), other.linearView(), this.linearView(), this.length()));
        return this;
    }

    @Override
    public INDArray eq(INDArray other) {
        return this.dup().eqi(other);
    }

    @Override
    public INDArray eqi(INDArray other) {
        Nd4j.getExecutioner().exec(new EqualTo(this.linearView(), other.linearView(), this.linearView(), this.length()));
        return this;
    }

    @Override
    public INDArray gt(INDArray other) {
        return this.dup().gti(other);
    }

    @Override
    public INDArray gti(INDArray other) {
        Nd4j.getExecutioner().exec(new GreaterThan(this.linearView(), other.linearView(), this.linearView(), this.length()));
        return this;
    }

    @Override
    public INDArray neg() {
        return this.dup().negi();
    }

    @Override
    public INDArray negi() {
        Nd4j.getExecutioner().exec(new Negative(this.linearView()));
        return this;
    }

    @Override
    public INDArray rdiv(Number n, INDArray result) {
        return this.dup().rdivi(n, result);
    }

    @Override
    public INDArray rdivi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarReverseDivision(this.linearView(), null, result.linearView(), result.length(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray rsub(Number n, INDArray result) {
        return this.dup().rsubi(n, result);
    }

    @Override
    public INDArray rsubi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarReverseSubtraction(this.linearView(), null, result.linearView(), result.length(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray div(Number n, INDArray result) {
        return this.dup().divi(n, result);
    }

    @Override
    public INDArray divi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarDivision(this.linearView(), null, result.linearView(), result.length(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray mul(Number n, INDArray result) {
        return this.dup().muli(n, result);
    }

    @Override
    public INDArray muli(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarMultiplication((INDArray)this, null, result, result.length(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray sub(Number n, INDArray result) {
        return this.dup().subi(n, result);
    }

    @Override
    public INDArray subi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarSubtraction(this.linearView(), null, result.linearView(), result.length(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray add(Number n, INDArray result) {
        return this.dup().addi(n, result);
    }

    @Override
    public INDArray addi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarAdd((INDArray)this, null, result, result.length(), n));
        return this;
    }

    @Override
    public INDArray getScalar(int row, int column) {
        return this.getScalar(new int[]{row, column});
    }

    @Override
    public INDArray dup() {
        INDArray ret = Shape.toOffsetZeroCopy(this);
        return ret;
    }

    @Override
    public INDArray dup(char order) {
        return Shape.toOffsetZeroCopy(this, order);
    }

    @Override
    public int getInt(int ... indices) {
        return (int)this.getDouble(indices);
    }

    @Override
    public double getDouble(int ... indices) {
        if (indices.length == 1) {
            if (this.isRowVector()) {
                return Shape.getDouble(this, 0, indices[0]);
            }
            if (this.isColumnVector()) {
                return Shape.getDouble(this, indices[0], 0);
            }
            if (this.isScalar() && indices[0] == 0) {
                return this.data().getDouble(this.offset());
            }
            throw new IllegalStateException("Indexes length must be > 1 for non vectors and scalars");
        }
        return Shape.getDouble(this, indices);
    }

    @Override
    public float getFloat(int ... indices) {
        return (float)this.getDouble(indices);
    }

    @Override
    public boolean isScalar() {
        if (this.isScalar != null) {
            return this.isScalar;
        }
        if (this.shape.length == 0) {
            this.isScalar = true;
            return true;
        }
        if (this.shape.length == 2 && this.length() == 1) {
            return true;
        }
        this.isScalar = false;
        this.isScalar = this.length == 1 && this.shape.length <= 2;
        return this.isScalar;
    }

    @Override
    public INDArray put(int[] indices, INDArray element) {
        if (!element.isScalar()) {
            throw new IllegalArgumentException("Unable to insert anything but a scalar");
        }
        if (this.isRowVector() && indices[0] == 0 && indices.length == 2) {
            int ix = this.offset;
            for (int i = 1; i < indices.length; ++i) {
                ix += indices[i] * this.stride[i];
            }
            if (ix >= this.data.length()) {
                throw new IllegalArgumentException("Illegal indices " + Arrays.toString(indices));
            }
            this.data.put(ix, element.getDouble(0));
        } else {
            int ix = this.offset;
            for (int i = 0; i < indices.length; ++i) {
                if (this.size(i) == 1) continue;
                ix += indices[i] * this.stride[i];
            }
            if (ix >= this.data.length()) {
                throw new IllegalArgumentException("Illegal indices " + Arrays.toString(indices));
            }
            this.data.put(ix, element.getDouble(0));
        }
        return this;
    }

    @Override
    public INDArray put(int i, int j, INDArray element) {
        return this.put(new int[]{i, j}, element);
    }

    @Override
    public INDArray put(int i, int j, Number element) {
        return this.putScalar(new int[]{i, j}, element.doubleValue());
    }

    @Override
    public INDArray putSlice(int slice, INDArray put) {
        if (this.isScalar()) {
            assert (put.isScalar()) : "Invalid dimension. Can only insert a scalar in to another scalar";
            this.put(0, put.getScalar(0));
            return this;
        }
        if (this.isVector()) {
            assert (put.isScalar() || put.isVector() && put.length() == this.length()) : "Invalid dimension on insertion. Can only insert scalars input vectors";
            if (put.isScalar()) {
                this.putScalar(slice, put.getDouble(0));
            } else {
                for (int i = 0; i < this.length(); ++i) {
                    this.putScalar(i, put.getDouble(i));
                }
            }
            return this;
        }
        this.assertSlice(put, slice);
        INDArray view = this.slice(slice);
        if (put.length() == 1) {
            this.putScalar(slice, put.getDouble(0));
        } else if (put.isVector()) {
            for (int i = 0; i < put.length(); ++i) {
                view.putScalar(i, put.getDouble(i));
            }
        } else {
            assert (Shape.shapeEquals(view.shape(), put.shape()));
            INDArray linear = view.linearView();
            INDArray putLinearView = put.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, putLinearView.getDouble(i));
            }
        }
        return this;
    }

    protected void assertSlice(INDArray put, int slice) {
        assert (slice <= this.slices()) : "Invalid slice specified " + slice;
        int[] sliceShape = put.shape();
        if (Shape.isRowVectorShape(sliceShape)) {
            return;
        }
        int[] requiredShape = ArrayUtil.removeIndex(this.shape(), 0);
        if (put.isScalar()) {
            return;
        }
        if (this.isVector() && put.isVector() && put.length() < this.length()) {
            return;
        }
        if (Shape.isColumnVectorShape(sliceShape)) {
            return;
        }
        if (!(Shape.shapeEquals(sliceShape, requiredShape) || Shape.isRowVectorShape(requiredShape) || Shape.isRowVectorShape(sliceShape))) {
            throw new IllegalStateException(String.format("Invalid shape size of %s . Should have been %s ", Arrays.toString(sliceShape), Arrays.toString(requiredShape)));
        }
    }

    @Override
    public boolean isMatrix() {
        return this.shape().length == 2 && this.shape[0] != 1 && this.shape[1] != 1;
    }

    @Override
    public int index(int row, int column) {
        if (!this.isMatrix()) {
            if (this.isColumnVector()) {
                int idx = this.linearIndex(row);
                return idx;
            }
            if (this.isRowVector()) {
                int idx = this.linearIndex(column);
                return idx;
            }
            throw new IllegalStateException("Unable to get row/column from a non matrix");
        }
        return this.offset + (row * this.stride[0] + column * this.stride[1]);
    }

    protected INDArray newShape(int[] newShape, char ordering) {
        return this.create(this.data(), newShape, this.stride(), this.offset);
    }

    protected INDArray create(DataBuffer data, int[] newShape, int[] newStrides, int offset, char ordering) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(data, newShape, newStrides, offset, ordering);
        }
        return Nd4j.create(data, newShape, newStrides, offset, ordering);
    }

    protected INDArray create(DataBuffer data, int[] newShape, int[] newStrides, int offset) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(data, newShape, newStrides, offset);
        }
        return Nd4j.create(data, newShape, newStrides, offset);
    }

    protected INDArray create(int[] shape) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(shape, this.getStrides(shape, Nd4j.order().charValue()), 0);
        }
        return Nd4j.create(shape, this.getStrides(shape, Nd4j.order().charValue()), 0);
    }

    protected INDArray create(int[] shape, int[] strides, int offset) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(shape, strides, offset);
        }
        return Nd4j.create(shape, strides, offset);
    }

    protected int[] getStrides(int[] shape, char ordering) {
        return Nd4j.getStrides(shape, ordering);
    }

    @Override
    public double squaredDistance(INDArray other) {
        double sd = 0.0;
        for (int i = 0; i < this.length; ++i) {
            double d = this.getDouble(i) - other.getDouble(i);
            sd += d * d;
        }
        return sd;
    }

    @Override
    public double distance2(INDArray other) {
        return Math.sqrt(this.squaredDistance(other));
    }

    @Override
    public double distance1(INDArray other) {
        return other.sub(this).sum(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public INDArray put(INDArrayIndex[] indices, INDArray element) {
        return this.get(indices).assign(element);
    }

    @Override
    public INDArray put(INDArrayIndex[] indices, Number element) {
        INDArray get = this.get(indices);
        for (int i = 0; i < get.length(); ++i) {
            get.putScalar(i, element.doubleValue());
        }
        return this;
    }

    @Override
    public INDArray swapAxes(int dimension, int with) {
        int[] shape = ArrayUtil.range(0, this.shape().length);
        shape[dimension] = with;
        shape[with] = dimension;
        return this.permute(shape);
    }

    @Override
    public boolean isView() {
        return this.offset > 0 || this.length() < this.data().length();
    }

    @Override
    public DataBuffer data() {
        return this.data;
    }

    @Override
    public void setData(DataBuffer data) {
        this.data = data;
    }

    @Override
    public int slices() {
        if (this.shape.length < 1) {
            return 0;
        }
        if (this.isRowVector()) {
            return this.length();
        }
        return this.shape[0];
    }

    @Override
    public INDArray subArray(ShapeOffsetResolution resolution) {
        int[] offsets = resolution.getOffsets();
        int[] shape = resolution.getShapes();
        int[] stride = resolution.getStrides();
        int offset = this.offset + resolution.getOffset();
        int n = shape.length;
        if (shape.length < 1) {
            return this.create(Nd4j.createBuffer(shape));
        }
        if (offsets.length != n) {
            throw new IllegalArgumentException("Invalid offset " + Arrays.toString(offsets));
        }
        if (stride.length != n) {
            throw new IllegalArgumentException("Invalid stride " + Arrays.toString(stride));
        }
        if (Arrays.equals(shape, this.shape)) {
            if (ArrayUtil.isZero(offsets)) {
                return this;
            }
            throw new IllegalArgumentException("Invalid subArray offsets");
        }
        if (offset >= this.data().length()) {
            offset = ArrayUtil.sum(offsets);
        }
        return this.create(this.data, Arrays.copyOf(shape, shape.length), stride, offset, this.ordering);
    }

    @Override
    public INDArray subArray(int[] offsets, int[] shape, int[] stride) {
        int n = shape.length;
        if (shape.length < 1) {
            return this.create(Nd4j.createBuffer(shape));
        }
        if (offsets.length != n) {
            throw new IllegalArgumentException("Invalid offset " + Arrays.toString(offsets));
        }
        if (stride.length != n) {
            throw new IllegalArgumentException("Invalid stride " + Arrays.toString(stride));
        }
        if (Arrays.equals(shape, this.shape)) {
            if (ArrayUtil.isZero(offsets)) {
                return this;
            }
            throw new IllegalArgumentException("Invalid subArray offsets");
        }
        int[] dotProductStride = stride;
        int[] dotProductOffsets = offsets;
        int offset = this.offset + NDArrayIndex.offset(dotProductStride, dotProductOffsets);
        if (offset >= this.data().length()) {
            offset = ArrayUtil.sum(offsets);
        }
        return this.create(this.data, Arrays.copyOf(shape, shape.length), stride, offset, this.ordering);
    }

    protected INDArray create(DataBuffer buffer) {
        return Nd4j.create(buffer);
    }

    @Override
    public INDArray cond(Condition condition) {
        return this.dup().condi(condition);
    }

    @Override
    public INDArray condi(Condition condition) {
        INDArray linear = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            boolean met = condition.apply(linear.getDouble(i));
            linear.putScalar(i, met ? 1 : 0);
        }
        return this;
    }

    @Override
    public void setStride(int[] stride) {
        this.stride = stride;
    }

    protected void init(int[] shape) {
        this.shape = shape;
        if (this.shape.length == 1) {
            this.rows = 1;
            this.columns = this.shape[0];
        } else if (this.shape().length == 2) {
            this.rows = shape[0];
            this.columns = shape[1];
        }
        if (this.shape.length == 1) {
            this.init(new int[]{1, this.shape[0]});
        }
        if (this.ordering == '\u0000') {
            this.ordering = Nd4j.order().charValue();
        }
        this.length = ArrayUtil.prod(this.shape);
        if (this.stride == null) {
            this.stride = this.getStrides(shape, this.ordering());
        }
        if (this.stride.length != this.shape.length) {
            this.stride = this.getStrides(shape, this.ordering());
        }
    }

    @Override
    public INDArray getScalar(int i) {
        return Nd4j.scalar(this.getDouble(i));
    }

    protected void assertColumnVector(INDArray column) {
        assert (column.isColumnVector() || column.columns() == this.columns() && column.rows() == 1) : "Must only add a column vector";
        assert (column.length() == this.rows() || column.columns() == this.columns() && column.rows() == 1) : "Illegal column vector must have the same length as the number of rows in this ndarray";
    }

    protected INDArray doColumnWise(INDArray columnVector, char operation) {
        if (this.isVector()) {
            switch (operation) {
                case 'a': {
                    this.addi(columnVector);
                    break;
                }
                case 's': {
                    this.subi(columnVector);
                    break;
                }
                case 'm': {
                    this.muli(columnVector);
                    break;
                }
                case 'd': {
                    this.divi(columnVector);
                    break;
                }
                case 'h': {
                    this.rsubi(columnVector);
                    break;
                }
                case 't': {
                    this.rdivi(columnVector);
                }
            }
            return this;
        }
        if (this.rows() == 1 && columnVector.isScalar()) {
            this.applyScalarOp(columnVector, operation);
        } else {
            this.assertColumnVector(columnVector);
            this.applyBroadcastOp(columnVector, operation);
        }
        return this;
    }

    @Override
    public boolean isCleanedUp() {
        return this.cleanedUp;
    }

    @Override
    public void cleanup() {
        if (Nd4j.shouldInstrument) {
            Nd4j.getInstrumentation().log(this, "destroyed");
        }
        this.cleanedUp = true;
    }

    protected void assertRowVector(INDArray rowVector) {
        assert (rowVector.isRowVector() || rowVector.rows() == this.rows() && rowVector.columns() == 1) : "Must only add a row vector";
        assert (rowVector.length() == this.columns() || rowVector.rows() == this.rows() && rowVector.columns() == 1) : "Illegal row vector must have the same length as the number of rows in this ndarray";
    }

    protected INDArray doRowWise(INDArray rowVector, char operation) {
        if (this.isVector()) {
            switch (operation) {
                case 'a': {
                    this.addi(rowVector);
                    break;
                }
                case 's': {
                    this.subi(rowVector);
                    break;
                }
                case 'm': {
                    this.muli(rowVector);
                    break;
                }
                case 'd': {
                    this.divi(rowVector);
                    break;
                }
                case 'h': {
                    this.rsubi(rowVector);
                    break;
                }
                case 't': {
                    this.rdivi(rowVector);
                }
            }
            return this;
        }
        if (this.columns() == 1 && rowVector.isScalar()) {
            if (this instanceof IComplexNDArray) {
                this.applyScalarOp(rowVector, operation);
            }
        } else {
            this.assertRowVector(rowVector);
            this.applyBroadcastOp(rowVector, operation);
        }
        return this;
    }

    private void applyBroadcastOp(INDArray vector, char operation) {
        int alongDimension;
        int n = alongDimension = Shape.isRowVectorShape(vector.shape()) ? 1 : 0;
        if (this.data() == vector.data()) {
            vector = vector.dup();
        }
        switch (operation) {
            case 'a': {
                Nd4j.getExecutioner().exec(new BroadcastAddOp((INDArray)this, vector, (INDArray)this, alongDimension));
                return;
            }
            case 's': {
                Nd4j.getExecutioner().exec(new BroadcastSubOp((INDArray)this, vector, (INDArray)this, alongDimension));
                return;
            }
            case 'm': {
                Nd4j.getExecutioner().exec(new BroadcastMulOp((INDArray)this, vector, (INDArray)this, alongDimension));
                return;
            }
            case 'd': {
                Nd4j.getExecutioner().exec(new BroadcastDivOp((INDArray)this, vector, (INDArray)this, alongDimension));
                return;
            }
            case 'h': {
                Nd4j.getExecutioner().exec(new BroadcastRSubOp((INDArray)this, vector, (INDArray)this, alongDimension));
                return;
            }
            case 't': {
                Nd4j.getExecutioner().exec(new BroadcastRDivOp((INDArray)this, vector, (INDArray)this, alongDimension));
                return;
            }
            case 'p': {
                Nd4j.getExecutioner().exec(new BroadcastCopyOp((INDArray)this, vector, (INDArray)this, alongDimension));
                return;
            }
        }
        throw new UnsupportedOperationException("Unknown operation: " + operation);
    }

    private void applyScalarOp(INDArray vector, char operation) {
        if (this instanceof IComplexNDArray) {
            IComplexNDArray row = (IComplexNDArray)vector;
            switch (operation) {
                case 'a': {
                    this.addi(row.getComplex(0));
                    break;
                }
                case 's': {
                    this.subi(row.getComplex(0));
                    break;
                }
                case 'm': {
                    this.muli(row.getComplex(0));
                    break;
                }
                case 'd': {
                    this.divi(row.getComplex(0));
                    break;
                }
                case 'h': {
                    this.rsubi(row.getComplex(0));
                    break;
                }
                case 't': {
                    this.rdivi(row.getComplex(0));
                }
            }
        } else {
            switch (operation) {
                case 'a': {
                    this.addi(vector.getDouble(0));
                    break;
                }
                case 's': {
                    this.subi(vector.getDouble(0));
                    break;
                }
                case 'm': {
                    this.muli(vector.getDouble(0));
                    break;
                }
                case 'd': {
                    this.divi(vector.getDouble(0));
                    break;
                }
                case 'h': {
                    this.rsubi(vector.getDouble(0));
                    break;
                }
                case 't': {
                    this.rdivi(vector.getDouble(0));
                }
            }
        }
    }

    @Override
    public int stride(int dimension) {
        if (this.stride == null) {
            throw new IllegalStateException("Array created with no stride");
        }
        if (dimension < 0) {
            return this.stride[this.stride.length + dimension];
        }
        return this.stride[dimension];
    }

    @Override
    public INDArray rdiviColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 't');
    }

    @Override
    public INDArray rdivColumnVector(INDArray columnVector) {
        return this.dup().rdiviColumnVector(columnVector);
    }

    @Override
    public INDArray rdiviRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 't');
    }

    @Override
    public INDArray rdivRowVector(INDArray rowVector) {
        return this.dup().rdiviRowVector(rowVector);
    }

    @Override
    public INDArray rsubiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'h');
    }

    @Override
    public INDArray rsubColumnVector(INDArray columnVector) {
        return this.dup().rsubiColumnVector(columnVector);
    }

    @Override
    public INDArray rsubiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'h');
    }

    @Override
    public INDArray rsubRowVector(INDArray rowVector) {
        return this.dup().rsubiRowVector(rowVector);
    }

    @Override
    public INDArray put(int i, INDArray element) {
        if (!element.isScalar()) {
            throw new IllegalArgumentException("Element must be a scalar");
        }
        return this.putScalar(i, element.getDouble(0));
    }

    @Override
    public INDArray diviColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'd');
    }

    @Override
    public INDArray divColumnVector(INDArray columnVector) {
        return this.dup().diviColumnVector(columnVector);
    }

    @Override
    public INDArray diviRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'd');
    }

    @Override
    public INDArray divRowVector(INDArray rowVector) {
        return this.dup().diviRowVector(rowVector);
    }

    @Override
    public INDArray muliColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'm');
    }

    @Override
    public INDArray mulColumnVector(INDArray columnVector) {
        return this.dup().muliColumnVector(columnVector);
    }

    @Override
    public INDArray muliRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'm');
    }

    @Override
    public INDArray mulRowVector(INDArray rowVector) {
        return this.dup().muliRowVector(rowVector);
    }

    @Override
    public INDArray subiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 's');
    }

    @Override
    public INDArray subColumnVector(INDArray columnVector) {
        return this.dup().subiColumnVector(columnVector);
    }

    @Override
    public INDArray subiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 's');
    }

    @Override
    public INDArray subRowVector(INDArray rowVector) {
        return this.dup().subiRowVector(rowVector);
    }

    @Override
    public INDArray addiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'a');
    }

    @Override
    public INDArray addColumnVector(INDArray columnVector) {
        return this.dup().addiColumnVector(columnVector);
    }

    @Override
    public INDArray addiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'a');
    }

    @Override
    public INDArray addRowVector(INDArray rowVector) {
        return this.dup().addiRowVector(rowVector);
    }

    @Override
    public INDArray mmul(INDArray other) {
        int[] shape = new int[]{this.rows(), other.columns()};
        INDArray result = this.create(shape, 'f');
        if (result.isScalar()) {
            return Nd4j.scalar(Nd4j.getBlasWrapper().dot(this, other));
        }
        return this.mmuli(other, result);
    }

    protected INDArray create(int[] shape, char ordering) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(shape, ordering);
        }
        return Nd4j.create(shape, ordering);
    }

    @Override
    public INDArray mmul(INDArray other, INDArray result) {
        return this.dup().mmuli(other, result);
    }

    @Override
    public INDArray div(INDArray other) {
        return this.dup().divi(other);
    }

    @Override
    public INDArray div(INDArray other, INDArray result) {
        return this.dup().divi(other, result);
    }

    @Override
    public INDArray mul(INDArray other) {
        return this.dup().muli(other);
    }

    @Override
    public INDArray mul(INDArray other, INDArray result) {
        return this.dup().muli(other, result);
    }

    @Override
    public INDArray sub(INDArray other) {
        return this.dup().subi(other);
    }

    @Override
    public INDArray sub(INDArray other, INDArray result) {
        return this.dup().subi(other, result);
    }

    @Override
    public INDArray add(INDArray other) {
        return this.dup().addi(other);
    }

    @Override
    public INDArray add(INDArray other, INDArray result) {
        return this.dup().addi(other, result);
    }

    @Override
    public INDArray mmuli(INDArray other) {
        return this.dup().mmuli(other, this);
    }

    @Override
    public INDArray mmuli(INDArray other, INDArray result) {
        INDArray otherArray = other;
        INDArray resultArray = result;
        LinAlgExceptions.assertMultiplies(this, other);
        if (other.isScalar()) {
            return this.muli(otherArray.getDouble(0), resultArray);
        }
        if (this.isScalar()) {
            return otherArray.muli(this.getDouble(0), resultArray);
        }
        if (result == this || result == other) {
            INDArray temp = this.create(resultArray.shape(), this.getStrides(this.shape, 'f'));
            if (otherArray.columns() == 1) {
                Nd4j.getBlasWrapper().level2().gemv(BlasBufferUtil.getCharForTranspose(result), BlasBufferUtil.getCharForTranspose(this), 1.0, this, otherArray, 0.0, temp);
            } else {
                Nd4j.getBlasWrapper().level3().gemm(BlasBufferUtil.getCharForTranspose(result), BlasBufferUtil.getCharForTranspose(this), BlasBufferUtil.getCharForTranspose(temp), 1.0, this, other, 0.0, resultArray);
            }
            Nd4j.getBlasWrapper().copy(temp, resultArray);
        } else if (other.columns() == 1) {
            Nd4j.getBlasWrapper().level2().gemv(BlasBufferUtil.getCharForTranspose(this), BlasBufferUtil.getCharForTranspose(other), 1.0, this, other, 0.0, resultArray);
        } else {
            Nd4j.getBlasWrapper().level3().gemm(BlasBufferUtil.getCharForTranspose(this), BlasBufferUtil.getCharForTranspose(other), BlasBufferUtil.getCharForTranspose(resultArray), 1.0, this, other, 0.0, resultArray);
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(resultArray);
        }
        return resultArray;
    }

    private INDArray create(int[] shape, int[] stride) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(shape, stride);
        }
        return Nd4j.create(shape, stride);
    }

    @Override
    public INDArray divi(INDArray other) {
        return this.divi(other, (INDArray)this);
    }

    @Override
    public INDArray divi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.divi(other.getDouble(0), result);
        }
        if (this.isScalar()) {
            return other.divi(this.getDouble(0), result);
        }
        Nd4j.getExecutioner().exec(new DivOp(this, other, result, this.length()));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray muli(INDArray other) {
        return this.muli(other, (INDArray)this);
    }

    @Override
    public INDArray muli(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.muli(other.getDouble(0), result);
        }
        if (this.isScalar()) {
            return other.muli(this.getDouble(0), result);
        }
        Nd4j.getExecutioner().exec(new MulOp(this, other, result, this.length()));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray subi(INDArray other) {
        return this.subi(other, (INDArray)this);
    }

    @Override
    public INDArray subi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.subi(other.getDouble(0), result);
        }
        if (this.isScalar()) {
            return other.subi(this.getDouble(0), result);
        }
        Nd4j.getExecutioner().exec(new SubOp(this, other, result, this.length()));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray addi(INDArray other) {
        return this.addi(other, (INDArray)this);
    }

    @Override
    public INDArray addi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return result.addi(other.getDouble(0), result);
        }
        if (this.isScalar()) {
            return other.addi(this.getDouble(0), result);
        }
        Nd4j.getExecutioner().exec(new AddOp((INDArray)this, other, result));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray normmax(int ... dimension) {
        return Nd4j.getExecutioner().exec(new NormMax(this), dimension);
    }

    @Override
    public INDArray rdiv(INDArray other) {
        return this.dup().rdivi(other);
    }

    @Override
    public INDArray rdivi(INDArray other) {
        return this.rdivi(other, (INDArray)this);
    }

    @Override
    public INDArray rdiv(INDArray other, INDArray result) {
        return this.dup().rdivi(other, result);
    }

    @Override
    public INDArray rdivi(INDArray other, INDArray result) {
        return other.divi(this, result);
    }

    @Override
    public INDArray rsub(INDArray other, INDArray result) {
        return this.dup().rsubi(other, result);
    }

    @Override
    public INDArray rsub(INDArray other) {
        return this.dup().rsubi(other);
    }

    @Override
    public INDArray rsubi(INDArray other) {
        return this.rsubi(other, (INDArray)this);
    }

    @Override
    public INDArray rsubi(INDArray other, INDArray result) {
        return other.subi(this, result);
    }

    @Override
    public INDArray assign(Number value) {
        this.data().assign(value, this.offset());
        return this;
    }

    @Override
    public int linearIndex(int i) {
        this.setLinearStride();
        int idx = i;
        for (int j = 0; j < this.stride.length - 1; ++j) {
            if (this.size(i) == 1) continue;
            idx += i * this.stride(j);
        }
        return this.offset + idx;
    }

    private void setLinearStride() {
        if (this.linearStride >= 0) {
            return;
        }
        this.linearStride = ArrayUtil.prod(this.reshape(1, this.length()).stride());
    }

    @Override
    public INDArray slice(int slice) {
        if (slice >= this.slices()) {
            throw new IllegalArgumentException("Illegal slice " + slice);
        }
        if (this.shape.length == 0) {
            if (slice == 0) {
                return this.createScalarForIndex(slice, true);
            }
            throw new IllegalArgumentException("Can't slice a 0-d NDArray");
        }
        if (slice < 0) {
            slice += this.shape.length;
        }
        INDArrayIndex[] indexes = new INDArrayIndex[this.rank()];
        indexes[0] = NDArrayIndex.point(slice);
        for (int i = 1; i < this.rank(); ++i) {
            indexes[i] = NDArrayIndex.all();
        }
        return this.get(indexes);
    }

    protected INDArray createScalarForIndex(int i, boolean applyOffset) {
        return this.create(this.data(), new int[]{1, 1}, new int[]{1, 1}, applyOffset ? this.offset + i : i);
    }

    protected INDArray createScalar(double d) {
        return Nd4j.scalar(d);
    }

    @Override
    public int getTrailingOnes() {
        if (this.numTrailingOnes >= 0) {
            return this.numTrailingOnes;
        }
        int numLeadingOnes = 0;
        for (int i = this.rank() - 1; i > 0; --i) {
            if (this.size(i) != 1) continue;
            ++numLeadingOnes;
        }
        this.numTrailingOnes = numLeadingOnes;
        return numLeadingOnes;
    }

    @Override
    public int getLeadingOnes() {
        if (this.numLeadingOnes >= 0) {
            return this.numLeadingOnes;
        }
        int numLeadingOnes = 0;
        for (int i = 0; i < this.rank(); ++i) {
            if (this.size(i) != 1) continue;
            ++numLeadingOnes;
        }
        this.numLeadingOnes = numLeadingOnes;
        return numLeadingOnes;
    }

    @Override
    public INDArray slice(int slice, int dimension) {
        if (dimension < 0) {
            dimension += this.rank();
        }
        if (this.isMatrix()) {
            return this.vectorAlongDimension(slice, dimension);
        }
        return this.tensorAlongDimension(slice, dimension);
    }

    @Override
    public INDArray getScalar(int ... indexes) {
        return Nd4j.scalar(this.getDouble(indexes));
    }

    @Override
    public INDArray rdiv(Number n) {
        return this.dup().rdivi(n);
    }

    @Override
    public INDArray rdivi(Number n) {
        return this.rdivi(n, (INDArray)this);
    }

    @Override
    public INDArray rsub(Number n) {
        return this.dup().rsubi(n);
    }

    @Override
    public INDArray rsubi(Number n) {
        return this.rsubi(n, (INDArray)this);
    }

    @Override
    public INDArray div(Number n) {
        return this.dup().divi(n);
    }

    @Override
    public INDArray divi(Number n) {
        return this.divi(n, (INDArray)this);
    }

    @Override
    public INDArray mul(Number n) {
        return this.dup().muli(n);
    }

    @Override
    public INDArray muli(Number n) {
        return this.muli(n, (INDArray)this);
    }

    @Override
    public INDArray sub(Number n) {
        return this.dup().subi(n);
    }

    @Override
    public INDArray subi(Number n) {
        return this.subi(n, (INDArray)this);
    }

    @Override
    public INDArray add(Number n) {
        return this.dup().addi(n);
    }

    @Override
    public INDArray addi(Number n) {
        return this.addi(n, (INDArray)this);
    }

    @Override
    public INDArray repmat(int[] shape) {
        INDArray ret;
        INDArray linear = ret = this.create(shape);
        BaseNDArray thisLinear = this;
        int bufferIdx = 0;
        for (int i = 0; i < ret.length(); ++i) {
            linear.putScalar(i, thisLinear.getDouble(bufferIdx));
            if (++bufferIdx < this.length()) continue;
            bufferIdx = 0;
        }
        return ret;
    }

    @Override
    public INDArray repeat(int dimension, int ... repeats) {
        if (dimension < 0) {
            dimension += this.rank();
        }
        if (repeats.length < this.rank()) {
            repeats = dimension > 0 ? Ints.concat((int[][])new int[][]{ArrayUtil.nTimes(this.rank() - repeats.length, 1), repeats}) : Ints.concat((int[][])new int[][]{repeats, ArrayUtil.nTimes(this.rank() - repeats.length, 1)});
        }
        int[] newShape = new int[this.rank()];
        for (int i = 0; i < newShape.length; ++i) {
            newShape[i] = this.size(i) * repeats[i];
        }
        INDArray ret = this.create(newShape);
        int repeatDelta = ArrayUtil.prod(newShape) / this.length();
        for (int i = 0; i < this.tensorssAlongDimension(dimension); ++i) {
            INDArray thisTensor = this.tensorAlongDimension(i, dimension);
            INDArray retTensor = ret.tensorAlongDimension(i, dimension);
            int retIdx = 0;
            for (int k = 0; k < thisTensor.length(); ++k) {
                for (int j = 0; j < repeatDelta; ++j) {
                    retTensor.putScalar(retIdx++, thisTensor.getDouble(k));
                }
            }
        }
        return ret;
    }

    @Override
    public INDArray repeat(int ... repeats) {
        if (repeats.length == 1) {
            INDArray ret = this.create(1, this.length() * repeats[0]);
            int idx = 0;
            for (int i = 0; i < this.length(); ++i) {
                for (int j = 0; j < repeats[0]; ++j) {
                    ret.putScalar(idx++, this.getDouble(i));
                }
            }
            return ret;
        }
        throw new IllegalStateException("Illegal length");
    }

    @Override
    public INDArray putRow(int row, INDArray toPut) {
        if (this.isRowVector() && Shape.shapeEquals(this.shape(), toPut.shape())) {
            return this.assign(toPut);
        }
        return this.put(new INDArrayIndex[]{NDArrayIndex.point(row), NDArrayIndex.all()}, toPut);
    }

    @Override
    public INDArray putColumn(int column, INDArray toPut) {
        if (this.isColumnVector() && Shape.shapeEquals(this.shape(), toPut.shape())) {
            return this.assign(toPut);
        }
        return this.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.point(column)}, toPut);
    }

    @Override
    public double getDouble(int i) {
        if (i >= this.length()) {
            throw new IllegalArgumentException("Unable to get linear index >= " + this.length());
        }
        if (i == 0) {
            return this.data().getDouble(this.offset);
        }
        int[] dimensions = this.ordering == 'c' ? Shape.ind2subC(this, i) : Shape.ind2sub(this, i);
        Shape.assertShapeLessThan(dimensions, this.shape());
        return this.getDouble(dimensions);
    }

    @Override
    public double getDouble(int i, int j) {
        return this.getDouble(new int[]{i, j});
    }

    @Override
    public float getFloat(int i) {
        return (float)this.getDouble(i);
    }

    @Override
    public float getFloat(int i, int j) {
        return (float)this.getDouble(i, j);
    }

    @Override
    public INDArray transpose() {
        return this.transposei();
    }

    @Override
    public INDArray transposei() {
        return this.permute(ArrayUtil.reverseCopy(ArrayUtil.range(0, this.rank())));
    }

    protected INDArray create(DataBuffer data, int[] shape, int[] strides) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(data, shape, strides, this.offset(), this.ordering());
        }
        return Nd4j.create(data, shape, strides, this.offset(), this.ordering());
    }

    @Override
    public INDArray reshape(char order, int ... newShape) {
        INDArray reshapeAttempt;
        int numberNegativesOnes = 0;
        int[] shape = ArrayUtil.copy(newShape);
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] >= 0) continue;
            if (numberNegativesOnes >= 1) {
                throw new IllegalArgumentException("Only one dimension can be negative ones");
            }
            ++numberNegativesOnes;
            int shapeLength = 1;
            for (int j = 0; j < shape.length; ++j) {
                if (shape[j] < 1) continue;
                shapeLength *= shape[j];
            }
            int realShape = Math.abs(this.length() / shapeLength);
            int[] thisNewShape = new int[shape.length];
            for (int j = 0; j < shape.length; ++j) {
                thisNewShape[j] = i != j ? shape[j] : realShape;
            }
            shape = thisNewShape;
            break;
        }
        if ((reshapeAttempt = Shape.newShapeNoCopy(this, ArrayUtil.copy(shape), order == 'f')) != null) {
            reshapeAttempt.setOrder(Shape.getOrder(reshapeAttempt));
            return reshapeAttempt;
        }
        INDArray ret = Nd4j.create(shape, order);
        ret.assign(this);
        return ret;
    }

    @Override
    public double getDoubleUnsafe(int offset) {
        return this.data().getDouble(this.offset + offset);
    }

    @Override
    public INDArray putScalarUnsafe(int offset, double value) {
        this.data().put(this.offset + offset, value);
        return this;
    }

    @Override
    public int innerMostStride() {
        if (this.ordering == 'c') {
            return this.stride(-1);
        }
        return this.stride(0);
    }

    @Override
    public INDArray reshape(char order, int rows, int columns) {
        return this.reshape(order, new int[]{rows, columns});
    }

    @Override
    public INDArray reshape(int ... shape) {
        return this.reshape(this.ordering(), shape);
    }

    @Override
    public void checkDimensions(INDArray other) {
        assert (Arrays.equals(this.shape, other.shape())) : " Other array should have been shape: " + Arrays.toString(this.shape) + " but was " + Arrays.toString(other.shape());
        assert (Arrays.equals(this.stride, other.stride())) : " Other array should have been stride: " + Arrays.toString(this.stride) + " but was " + Arrays.toString(other.stride());
        assert (this.offset == other.offset()) : "Offset of this array is " + this.offset + " but other was " + other.offset();
    }

    @Override
    public INDArray prod(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Prod(this), dimension);
    }

    @Override
    public INDArray mean(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Mean(this), dimension);
    }

    @Override
    public INDArray var(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Variance(this), dimension);
    }

    @Override
    public INDArray max(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Max(this), dimension);
    }

    @Override
    public INDArray min(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Min(this), dimension);
    }

    @Override
    public INDArray sum(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Sum(this), dimension);
    }

    @Override
    public INDArray norm1(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Norm1(this), dimension);
    }

    @Override
    public INDArray std(int ... dimension) {
        return Nd4j.getExecutioner().exec(new StandardDeviation(this), dimension);
    }

    @Override
    public INDArray norm2(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Norm2(this), dimension);
    }

    @Override
    public int columns() {
        if (this.isMatrix()) {
            if (this.shape().length > 2) {
                return Shape.squeeze(this.shape)[1];
            }
            if (this.shape().length == 2) {
                return this.shape[1];
            }
        }
        if (this.isVector()) {
            if (this.isColumnVector()) {
                return 1;
            }
            if (this.isRowVector() && this.shape.length > 1) {
                return this.shape[1];
            }
            return this.shape[0];
        }
        throw new IllegalStateException("Unable to get number of of columns for a non 2d matrix");
    }

    @Override
    public int rows() {
        if (this.isMatrix()) {
            if (this.shape().length > 2) {
                return Shape.squeeze(this.shape)[0];
            }
            if (this.shape().length == 2) {
                return this.shape[0];
            }
        } else if (this.isVector()) {
            if (this.isRowVector()) {
                return 1;
            }
            return this.shape[0];
        }
        throw new IllegalStateException("Unable to get number of of rows for a non 2d matrix");
    }

    @Override
    public INDArray ravel(char ordering) {
        INDArray ret = this.create(new int[]{1, this.length}, ordering);
        NDArrayIndex index = new NDArrayIndex(this.shape());
        int i = 0;
        while (i < this.length()) {
            double val = this.getDouble(index.next());
            ret.putScalar(new int[]{0, i++}, val);
        }
        return ret;
    }

    @Override
    public INDArray ravel() {
        return this.reshape(1, this.length());
    }

    @Override
    public void sliceVectors(List<INDArray> list) {
        if (this.isVector()) {
            list.add(this);
        } else {
            for (int i = 0; i < this.slices(); ++i) {
                this.slice(i).sliceVectors(list);
            }
        }
    }

    @Override
    public INDArray reshape(int newRows, int newColumns) {
        return this.reshape(new int[]{newRows, newColumns});
    }

    @Override
    public INDArray getColumn(int c) {
        if (this.isColumnVector() && c == 0) {
            return this;
        }
        if (this.shape.length == 2) {
            INDArray ret = this.vectorAlongDimension(c, 0);
            return ret.reshape(ret.length(), 1);
        }
        if (this.isRowVector()) {
            return this.createScalarForIndex(c, true);
        }
        if (this.isColumnVector() && c == 0) {
            return this;
        }
        throw new IllegalArgumentException("Unable to getFloat scalar column of non 2d matrix");
    }

    @Override
    public INDArray getRows(int[] rindices) {
        return this.get(new SpecifiedIndex(rindices));
    }

    @Override
    public INDArray get(INDArrayIndex ... indexes) {
        ShapeOffsetResolution resolution = new ShapeOffsetResolution(this);
        resolution.exec(indexes);
        if (indexes.length < 1) {
            throw new IllegalStateException("Invalid index found of zero length");
        }
        int[] shape = resolution.getShapes();
        if (ArrayUtil.prod(shape) > this.length()) {
            INDArray ret = this.create(shape);
            INDArrayIndex slices = indexes[0];
            if (slices.length() == 1) {
                INDArrayIndex subRange = indexes[0];
                int count = 0;
                for (int i = 0; i < slices.length(); ++i) {
                    if (count >= ret.length()) {
                        count = 0;
                    }
                    int get = subRange.next();
                    ret.putScalar(count, this.getDouble(get));
                    ++count;
                }
            } else {
                INDArrayIndex[] subRange = Arrays.copyOfRange(indexes, 1, indexes.length);
                INDArrayIndex[] putRange = NDArrayIndex.rangeOfLength(subRange);
                for (int i = 0; i < slices.length(); ++i) {
                    INDArray sliceI = ret.slice(i);
                    INDArray thisSlice = this.slice(slices.next());
                    sliceI.put(putRange, thisSlice.get(subRange));
                }
            }
            return ret;
        }
        if (indexes[0] instanceof SpecifiedIndex) {
            INDArray ret = this.create(shape);
            int count = 0;
            if (this.isVector()) {
                indexes[0].reset();
                while (indexes[0].hasNext()) {
                    ret.putScalar(count++, this.getDouble(indexes[0].next()));
                }
            } else {
                while (indexes[0].hasNext()) {
                    int nextIdx = indexes[0].next();
                    INDArray next = this.slice(nextIdx);
                    if (indexes.length > 1) {
                        ret.putSlice(count++, next.get(Arrays.copyOfRange(indexes, 1, indexes.length)));
                        continue;
                    }
                    if (next.isVector()) {
                        ret.putSlice(count++, next);
                        continue;
                    }
                    ret.putSlice(count++, next.get(indexes));
                }
            }
            return ret;
        }
        INDArray ret = this.subArray(resolution);
        return ret;
    }

    @Override
    public INDArray getColumns(int ... cindices) {
        return this.get(NDArrayIndex.all(), new SpecifiedIndex(cindices));
    }

    protected INDArray create(int rows, int length) {
        return this.create(new int[]{rows, length});
    }

    @Override
    public INDArray getRow(int r) {
        if (this.isRowVector() && r == 0) {
            return this;
        }
        if (this.shape.length == 2) {
            if (this.isColumnVector()) {
                return this.createScalarForIndex(r, true);
            }
            return this.vectorAlongDimension(r, 1);
        }
        if (this.size(0) == 1 && this.shape.length == 3) {
            return this.slice(0).vectorAlongDimension(r, 1);
        }
        if (this.isRowVector() && r == 0) {
            return this;
        }
        throw new IllegalArgumentException("Unable to getFloat row of non 2d matrix");
    }

    public boolean equals(Object o) {
        INDArray n = null;
        if (!(o instanceof INDArray)) {
            return false;
        }
        if (n == null) {
            n = (INDArray)o;
        }
        if (this.isScalar() && n.isScalar()) {
            double val2;
            if (this.data.dataType() == DataBuffer.Type.FLOAT) {
                double val22;
                double val = this.getDouble(0);
                return Math.abs(val - (val22 = n.getDouble(0))) < Nd4j.EPS_THRESHOLD;
            }
            double val = this.getDouble(0);
            return Math.abs(val - (val2 = n.getDouble(0))) < Nd4j.EPS_THRESHOLD;
        }
        if (this.isVector() && n.isVector()) {
            for (int i = 0; i < this.length; ++i) {
                double comp;
                double curr;
                if (!(this.data.dataType() == DataBuffer.Type.FLOAT ? Math.abs((curr = this.getDouble(i)) - (comp = n.getDouble(i))) > Nd4j.EPS_THRESHOLD : Math.abs((curr = this.getDouble(i)) - (comp = n.getDouble(i))) > Nd4j.EPS_THRESHOLD)) continue;
                return false;
            }
            return true;
        }
        if (!Shape.shapeEquals(this.shape(), n.shape())) {
            return false;
        }
        if (this.slices() != n.slices()) {
            return false;
        }
        for (int i = 0; i < this.slices(); ++i) {
            INDArray nSlice;
            INDArray slice = this.slice(i);
            if (slice.equals(nSlice = n.slice(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] shape() {
        return this.shape;
    }

    @Override
    public int[] stride() {
        return this.stride;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public char ordering() {
        return this.ordering;
    }

    @Override
    public int size(int dimension) {
        if (this.isScalar()) {
            if (dimension == 0 || dimension == 1 || dimension < 0) {
                return this.length;
            }
            throw new IllegalArgumentException("Illegal dimension for scalar " + dimension);
        }
        if (dimension < 0) {
            return this.shape[this.shape.length + dimension];
        }
        return this.shape[dimension];
    }

    @Override
    public int rank() {
        return this.shape().length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public INDArray broadcast(int ... shape) {
        if (Shape.shapeEquals(shape, this.shape())) {
            return this;
        }
        boolean compatible = true;
        int count = shape.length - 1;
        int thisCount = this.shape.length - 1;
        for (int i = shape.length - 1; i > 0 && count >= 0 && thisCount >= 0; --count, --thisCount, --i) {
            if (shape[count] == this.shape()[thisCount] || shape[count] == 1 || this.shape()[thisCount] == 1) continue;
            compatible = false;
            break;
        }
        if (!compatible) {
            throw new IllegalArgumentException("Incompatible broadcast from " + Arrays.toString(this.shape()) + " to " + Arrays.toString(shape));
        }
        int[] retShape = new int[shape.length];
        ArrayList<Integer> broadCastDimensions = new ArrayList<Integer>();
        ArrayList<Integer> nonBroadCastDimensions = new ArrayList<Integer>();
        for (int i = 0; i < retShape.length; ++i) {
            if (this.shape().length == 1) {
                if (i == 0) {
                    if (i < this.shape().length) {
                        retShape[i] = Math.max(1, shape[i]);
                        continue;
                    }
                    retShape[i] = shape[i];
                    continue;
                }
                if (i < this.shape().length) {
                    retShape[i] = Math.max(shape[i], this.size(i));
                    continue;
                }
                retShape[i] = shape[i];
                continue;
            }
            if (i < this.rank() && this.size(i) == 1) {
                broadCastDimensions.add(i);
            } else {
                nonBroadCastDimensions.add(i);
            }
            retShape[i] = i < this.shape().length ? Math.max(shape[i], this.size(i)) : shape[i];
        }
        INDArray ret = this.create(retShape, this.ordering());
        if (this.isRowVector()) {
            for (int i = 0; i < ret.slices(); ++i) {
                ret.putSlice(i, this);
            }
        } else {
            int repeatDelta = ArrayUtil.prod(retShape) / this.length();
            block3: for (int i = 0; i < this.slices(); ++i) {
                INDArray thisTensor = this.slice(i);
                INDArray retTensor = ret.slice(i);
                int retIdx = 0;
                int tensorLen = thisTensor.rank();
                for (int k = 0; k < tensorLen; ++k) {
                    for (int j = 0; j < repeatDelta; ++j) {
                        if (retIdx >= retTensor.length()) continue block3;
                        retTensor.putScalar(retIdx++, thisTensor.getDouble(k));
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public INDArray dimShuffle(Object[] rearrange, int[] newOrder, boolean[] broadCastable) {
        int i;
        if (broadCastable.length != this.shape.length) {
            throw new IllegalArgumentException("The broadcastable dimensions must be the same length as the current shape");
        }
        boolean broadcast = false;
        HashSet<Object> set = new HashSet<Object>();
        for (int i2 = 0; i2 < rearrange.length; ++i2) {
            set.add(rearrange[i2]);
            if (rearrange[i2] instanceof Integer) {
                Integer j = (Integer)rearrange[i2];
                if (j < broadCastable.length) continue;
                throw new IllegalArgumentException("Illegal dimension, dimension must be < broadcastable.length (aka the real dimensions");
            }
            if (rearrange[i2] instanceof Character) {
                Character c = (Character)rearrange[i2];
                if (c.charValue() != 'x') {
                    throw new IllegalArgumentException("Illegal input: Must be x");
                }
                broadcast = true;
                continue;
            }
            throw new IllegalArgumentException("Only characters and integers allowed");
        }
        if (!broadcast) {
            int[] ret = new int[rearrange.length];
            for (int i3 = 0; i3 < ret.length; ++i3) {
                ret[i3] = (Integer)rearrange[i3];
            }
            return this.permute(ret);
        }
        ArrayList<Integer> drop = new ArrayList<Integer>();
        for (int i4 = 0; i4 < broadCastable.length; ++i4) {
            if (set.contains(i4)) continue;
            if (broadCastable[i4]) {
                drop.add(i4);
                continue;
            }
            throw new IllegalArgumentException("We can't drop the given dimension because its not broadcastable");
        }
        int[] shuffle = new int[broadCastable.length];
        int count = 0;
        for (int i5 = 0; i5 < rearrange.length; ++i5) {
            if (!(rearrange[i5] instanceof Integer)) continue;
            shuffle[count++] = (Integer)rearrange[i5];
        }
        ArrayList<Integer> augment = new ArrayList<Integer>();
        for (int i6 = 0; i6 < rearrange.length; ++i6) {
            if (!(rearrange[i6] instanceof Character)) continue;
            augment.add(i6);
        }
        Integer[] augmentDims = augment.toArray(new Integer[1]);
        count = 0;
        int dropIdx = 0;
        int[] newShape = new int[shuffle.length + drop.size()];
        for (int i7 = 0; i7 < newShape.length; ++i7) {
            if (i7 < shuffle.length) {
                newShape[count++] = shuffle[i7];
                continue;
            }
            newShape[count++] = (Integer)drop.get(dropIdx++);
        }
        INDArray ret = this.permute(newShape);
        ArrayList<Integer> newDims = new ArrayList<Integer>();
        int[] shape = Arrays.copyOfRange(ret.shape(), 0, shuffle.length);
        for (i = 0; i < shape.length; ++i) {
            newDims.add(shape[i]);
        }
        for (i = 0; i < augmentDims.length; ++i) {
            newDims.add(augmentDims[i], 1);
        }
        int[] toReshape = ArrayUtil.toArray(newDims);
        ret = ret.reshape(toReshape);
        return ret;
    }

    @Override
    public INDArray permute(int ... rearrange) {
        if (rearrange.length != this.shape.length) {
            return this.dup();
        }
        this.checkArrangeArray(rearrange);
        int[] newShape = this.doPermuteSwap(this.shape, rearrange);
        int[] newStride = this.doPermuteSwap(this.stride, rearrange);
        char newOrder = Shape.getOrder(newShape, newStride, this.elementStride());
        INDArray value = this.create(this.data(), newShape, newStride, this.offset(), newOrder);
        return value;
    }

    protected void copyRealTo(INDArray arr) {
        INDArray flattened = this.linearView();
        INDArray arrLinear = arr.linearView();
        for (int i = 0; i < flattened.length(); ++i) {
            arrLinear.putScalar(i, flattened.getDouble(i));
        }
    }

    protected int[] doPermuteSwap(int[] shape, int[] rearrange) {
        int[] ret = new int[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            ret[i] = shape[rearrange[i]];
        }
        return ret;
    }

    protected void checkArrangeArray(int[] arr) {
        int i;
        assert (arr.length == this.shape.length) : "Invalid rearrangement: number of arrangement != shape";
        for (i = 0; i < arr.length; ++i) {
            if (arr[i] >= arr.length) {
                throw new IllegalArgumentException("The specified dimensions can't be swapped. Given element " + i + " was >= number of dimensions");
            }
            if (arr[i] >= 0) continue;
            throw new IllegalArgumentException("Invalid dimension: " + i + " : negative value");
        }
        for (i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr.length; ++j) {
                if (i == j || arr[i] != arr[j]) continue;
                throw new IllegalArgumentException("Permute array must have unique elements");
            }
        }
    }

    @Override
    public boolean isVector() {
        boolean ret = this.isRowVector() || this.isColumnVector();
        return ret;
    }

    @Override
    public boolean isSquare() {
        return this.isMatrix() && this.rows() == this.columns();
    }

    @Override
    public boolean isRowVector() {
        return this.shape().length == 1 || this.shape().length == 2 && this.shape[0] == 1;
    }

    @Override
    public boolean isColumnVector() {
        if (this.shape().length == 1) {
            return false;
        }
        if (this.shape().length == 2 && this.shape()[1] == 1) {
            return this.shape()[1] == 1;
        }
        return false;
    }

    public String toString() {
        return new NDArrayStrings().format(this);
    }

    @Override
    public Object element() {
        if (!this.isScalar()) {
            throw new IllegalStateException("Unable to retrieve element from non scalar matrix");
        }
        if (this.data.dataType() == DataBuffer.Type.FLOAT) {
            return Float.valueOf(this.data.getFloat(this.offset));
        }
        return this.data.getDouble(this.offset);
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n) {
        return this.dup().rdivi(n);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n) {
        return this.rdivi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n) {
        return this.dup().rsubi(n);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n) {
        return this.rsubi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray div(IComplexNumber n) {
        return this.dup().divi(n);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n) {
        return this.divi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n) {
        return this.dup().muli(n);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n) {
        return this.muli(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n) {
        return this.dup().subi(n);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n) {
        return this.subi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray add(IComplexNumber n) {
        return this.dup().addi(n);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n) {
        return this.addi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n, IComplexNDArray result) {
        return this.dup().rdivi(n, result);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).rdivi(n, result);
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n, IComplexNDArray result) {
        return this.dup().rsubi(n, result);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).rsubi(n, result);
    }

    @Override
    public IComplexNDArray div(IComplexNumber n, IComplexNDArray result) {
        return this.dup().divi(n, result);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).divi(n, result);
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n, IComplexNDArray result) {
        return this.dup().muli(n, result);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).muli(n, result);
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n, IComplexNDArray result) {
        return this.dup().subi(n, result);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).subi(n, result);
    }

    @Override
    public IComplexNDArray add(IComplexNumber n, IComplexNDArray result) {
        return this.dup().addi(n, result);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).addi(n, result);
    }

    protected INDArray create(BaseNDArray baseNDArray) {
        return baseNDArray;
    }

    public Iterator<Object> iterator() {
        return new FirstAxisIterator(this);
    }
}

