/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;

public abstract class BaseDataBuffer
implements DataBuffer {
    protected int length;
    protected int elementSize;
    protected transient ByteBuffer wrappedBuffer;
    protected Collection<String> referencing;
    protected transient WeakReference<DataBuffer> ref;
    protected boolean isPersist;
    protected DataBuffer.AllocationMode allocationMode;
    protected double[] doubleData;
    protected int[] intData;
    protected float[] floatData;
    protected AtomicBoolean dirty;

    protected BaseDataBuffer(ByteBuf buf, int length) {
        this.referencing = Collections.synchronizedSet(new HashSet());
        this.isPersist = false;
        this.dirty = new AtomicBoolean(false);
        this.allocationMode = Nd4j.alloc;
        this.wrappedBuffer = buf.nioBuffer();
        this.length = length;
    }

    public BaseDataBuffer(float[] data, boolean copy) {
        this.referencing = Collections.synchronizedSet(new HashSet());
        this.isPersist = false;
        this.dirty = new AtomicBoolean(false);
        this.allocationMode = Nd4j.alloc;
        if (this.allocationMode == DataBuffer.AllocationMode.HEAP) {
            this.floatData = copy ? ArrayUtil.copy(data) : data;
        } else {
            this.wrappedBuffer = ByteBuffer.allocateDirect(4 * data.length);
            this.wrappedBuffer.order(ByteOrder.nativeOrder());
            FloatBuffer buffer = this.wrappedBuffer.asFloatBuffer();
            for (int i = 0; i < data.length; ++i) {
                buffer.put(i, data[i]);
            }
        }
        this.length = data.length;
    }

    public BaseDataBuffer(double[] data, boolean copy) {
        this.referencing = Collections.synchronizedSet(new HashSet());
        this.isPersist = false;
        this.dirty = new AtomicBoolean(false);
        this.allocationMode = Nd4j.alloc;
        if (this.allocationMode == DataBuffer.AllocationMode.HEAP) {
            this.doubleData = copy ? ArrayUtil.copy(data) : data;
        } else {
            this.wrappedBuffer = ByteBuffer.allocateDirect(8 * data.length);
            this.wrappedBuffer.order(ByteOrder.nativeOrder());
            DoubleBuffer buffer = this.wrappedBuffer.asDoubleBuffer();
            for (int i = 0; i < data.length; ++i) {
                buffer.put(i, data[i]);
            }
        }
        this.length = data.length;
    }

    public BaseDataBuffer(int[] data, boolean copy) {
        this.referencing = Collections.synchronizedSet(new HashSet());
        this.isPersist = false;
        this.dirty = new AtomicBoolean(false);
        this.allocationMode = Nd4j.alloc;
        if (this.allocationMode == DataBuffer.AllocationMode.HEAP) {
            this.intData = copy ? ArrayUtil.copy(data) : data;
        } else {
            this.wrappedBuffer = ByteBuffer.allocateDirect(4 * data.length);
            this.wrappedBuffer.order(ByteOrder.nativeOrder());
            FloatBuffer buffer = this.wrappedBuffer.asFloatBuffer();
            for (int i = 0; i < data.length; ++i) {
                buffer.put(i, data[i]);
            }
        }
        this.length = data.length;
    }

    public BaseDataBuffer(double[] data) {
        this(data, Nd4j.copyOnOps);
    }

    public BaseDataBuffer(int[] data) {
        this(data, Nd4j.copyOnOps);
    }

    public BaseDataBuffer(float[] data) {
        this(data, Nd4j.copyOnOps);
    }

    public BaseDataBuffer(int length, int elementSize) {
        this.referencing = Collections.synchronizedSet(new HashSet());
        this.isPersist = false;
        this.dirty = new AtomicBoolean(false);
        this.allocationMode = Nd4j.alloc;
        this.length = length;
        this.elementSize = elementSize;
        if (this.allocationMode() == DataBuffer.AllocationMode.DIRECT) {
            this.setNioBuffer();
        } else if (this.dataType() == DataBuffer.Type.DOUBLE) {
            this.doubleData = new double[length];
        } else if (this.dataType() == DataBuffer.Type.FLOAT) {
            this.floatData = new float[length];
        }
    }

    public BaseDataBuffer(ByteBuffer buffer, int length) {
        block4: {
            block6: {
                block5: {
                    block3: {
                        this.referencing = Collections.synchronizedSet(new HashSet());
                        this.isPersist = false;
                        this.dirty = new AtomicBoolean(false);
                        this.allocationMode = Nd4j.alloc;
                        this.length = length;
                        buffer.order(ByteOrder.nativeOrder());
                        if (this.allocationMode() != DataBuffer.AllocationMode.DIRECT) break block3;
                        this.wrappedBuffer = buffer;
                        break block4;
                    }
                    if (this.dataType() != DataBuffer.Type.INT) break block5;
                    this.intData = new int[length];
                    IntBuffer intBuffer = buffer.asIntBuffer();
                    for (int i = 0; i < length; ++i) {
                        this.intData[i] = intBuffer.get(i);
                    }
                    break block4;
                }
                if (this.dataType() != DataBuffer.Type.DOUBLE) break block6;
                this.doubleData = new double[length];
                DoubleBuffer doubleBuffer = buffer.asDoubleBuffer();
                for (int i = 0; i < length; ++i) {
                    this.doubleData[i] = doubleBuffer.get(i);
                }
                break block4;
            }
            if (this.dataType() != DataBuffer.Type.FLOAT) break block4;
            this.floatData = new float[length];
            FloatBuffer floatBuffer = buffer.asFloatBuffer();
            for (int i = 0; i < length; ++i) {
                this.floatData[i] = floatBuffer.get(i);
            }
        }
    }

    protected void setNioBuffer() {
        this.wrappedBuffer = ByteBuffer.allocateDirect(this.elementSize * this.length);
        this.wrappedBuffer.order(ByteOrder.nativeOrder());
    }

    public BaseDataBuffer(byte[] data, int length) {
        this(Unpooled.wrappedBuffer((byte[])data), length);
    }

    @Override
    public DataBuffer.AllocationMode allocationMode() {
        return this.allocationMode;
    }

    @Override
    public void persist() {
        this.isPersist = true;
    }

    @Override
    public boolean isPersist() {
        return this.isPersist;
    }

    @Override
    public void unPersist() {
        this.isPersist = false;
    }

    protected BaseDataBuffer(int length) {
        this.referencing = Collections.synchronizedSet(new HashSet());
        this.isPersist = false;
        this.dirty = new AtomicBoolean(false);
        this.length = length;
        this.allocationMode = Nd4j.alloc;
        if (length < 0) {
            throw new IllegalArgumentException("Unable to create a buffer of length <= 0");
        }
        this.ref = new WeakReference<DataBuffer>(this, Nd4j.bufferRefQueue());
        if (this.allocationMode == DataBuffer.AllocationMode.HEAP) {
            if (length >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Length of data buffer can not be > Integer.MAX_VALUE for heap (array based storage) allocation");
            }
            if (this.dataType() == DataBuffer.Type.DOUBLE) {
                this.doubleData = new double[length];
            } else if (this.dataType() == DataBuffer.Type.FLOAT) {
                this.floatData = new float[length];
            }
        } else {
            if (length * this.getElementSize() < 0) {
                throw new IllegalArgumentException("Unable to create buffer of length " + length + " due to negative length specified");
            }
            this.wrappedBuffer = ByteBuffer.allocateDirect(this.getElementSize() * length);
        }
    }

    @Override
    public void copyAtStride(DataBuffer buf, int n, int stride, int yStride, int offset, int yOffset) {
        if (this.dataType() == DataBuffer.Type.FLOAT) {
            for (int i = 0; i < n; ++i) {
                this.put(offset + i * stride, buf.getFloat(yOffset + i * yStride));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.put(offset + i * stride, buf.getDouble(yOffset + i * yStride));
            }
        }
    }

    @Override
    public void removeReferencing(String id) {
        this.referencing.remove(id);
    }

    @Override
    public Collection<String> references() {
        return this.referencing;
    }

    @Override
    public void addReferencing(String id) {
        this.referencing.add(id);
    }

    @Override
    public void assign(int[] indices, float[] data, boolean contiguous, int inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if (indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], data[i]);
        }
    }

    @Override
    public void setData(int[] data) {
        if (this.intData != null) {
            this.intData = data;
        } else {
            for (int i = 0; i < data.length; ++i) {
                this.put(i, data[i]);
            }
        }
    }

    @Override
    public void setData(float[] data) {
        if (this.floatData != null) {
            this.floatData = data;
        } else {
            for (int i = 0; i < data.length; ++i) {
                this.put(i, data[i]);
            }
        }
    }

    @Override
    public void setData(double[] data) {
        if (this.doubleData != null) {
            this.doubleData = data;
        } else {
            for (int i = 0; i < data.length; ++i) {
                this.put(i, data[i]);
            }
        }
    }

    @Override
    public void assign(int[] indices, double[] data, boolean contiguous, int inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if (indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        for (int i = 0; i < indices.length; i += inc) {
            this.put(indices[i], data[i]);
        }
    }

    @Override
    public void assign(DataBuffer data) {
        if (data.length() != this.length()) {
            throw new IllegalArgumentException("Unable to assign buffer of length " + data.length() + " to this buffer of length " + this.length());
        }
        for (int i = 0; i < data.length(); ++i) {
            this.put(i, data.getDouble(i));
        }
    }

    @Override
    public void assign(int[] indices, float[] data, boolean contiguous) {
        this.assign(indices, data, contiguous, 1);
    }

    @Override
    public void assign(int[] indices, double[] data, boolean contiguous) {
        this.assign(indices, data, contiguous, 1);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void assign(Number value) {
        for (int i = 0; i < this.length(); ++i) {
            this.assign(value, i);
        }
    }

    @Override
    public double[] getDoublesAt(int offset, int length) {
        return this.getDoublesAt(offset, 1, length);
    }

    @Override
    public float[] getFloatsAt(int offset, int inc, int length) {
        if (offset + length > this.length()) {
            length -= offset;
        }
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getFloat(i + offset);
        }
        return ret;
    }

    @Override
    public DataBuffer dup() {
        if (this.floatData != null) {
            return this.create(this.floatData);
        }
        if (this.doubleData != null) {
            return this.create(this.doubleData);
        }
        if (this.intData != null) {
            return this.create(this.intData);
        }
        DataBuffer ret = this.create(this.length);
        for (int i = 0; i < ret.length(); ++i) {
            ret.put(i, this.getDouble(i));
        }
        return ret;
    }

    protected abstract DataBuffer create(int var1);

    public abstract DataBuffer create(double[] var1);

    public abstract DataBuffer create(float[] var1);

    public abstract DataBuffer create(int[] var1);

    public abstract DataBuffer create(ByteBuf var1, int var2);

    @Override
    public double[] getDoublesAt(int offset, int inc, int length) {
        if (offset + length > this.length()) {
            length -= offset;
        }
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getDouble(i + offset);
        }
        return ret;
    }

    @Override
    public float[] getFloatsAt(int offset, int length) {
        return this.getFloatsAt(offset, 1, length);
    }

    @Override
    public IComplexFloat getComplexFloat(int i) {
        return Nd4j.createFloat(this.getFloat(i), this.getFloat(i + 1));
    }

    @Override
    public IComplexDouble getComplexDouble(int i) {
        return Nd4j.createDouble(this.getDouble(i), this.getDouble(i + 1));
    }

    @Override
    public IComplexNumber getComplex(int i) {
        return this.dataType() == DataBuffer.Type.FLOAT ? this.getComplexFloat(i) : this.getComplexDouble(i);
    }

    @Override
    public void put(int i, IComplexNumber result) {
        this.put(i, result.realComponent().doubleValue());
        this.put(i + 1, result.imaginaryComponent().doubleValue());
    }

    @Override
    public void assign(int[] offsets, int[] strides, DataBuffer ... buffers) {
        this.assign(offsets, strides, this.length(), buffers);
    }

    @Override
    public byte[] asBytes() {
        if (this.allocationMode == DataBuffer.AllocationMode.HEAP) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(this.getElementSize() * this.length());
            DataOutputStream dos = new DataOutputStream(bos);
            if (this.dataType() == DataBuffer.Type.DOUBLE) {
                if (this.doubleData == null) {
                    throw new IllegalStateException("Double array is null!");
                }
                try {
                    for (int i = 0; i < this.doubleData.length; ++i) {
                        dos.writeDouble(this.doubleData[i]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.floatData == null) {
                throw new IllegalStateException("Double array is null!");
            }
            try {
                for (int i = 0; i < this.floatData.length; ++i) {
                    dos.writeFloat(this.floatData[i]);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return bos.toByteArray();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            for (int i = 0; i < this.length(); ++i) {
                try {
                    dos.writeDouble(this.getDouble(i));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (int i = 0; i < this.length(); ++i) {
                try {
                    dos.writeFloat(this.getFloat(i));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return bos.toByteArray();
    }

    @Override
    public float[] asFloat() {
        if (this.allocationMode == DataBuffer.AllocationMode.HEAP && this.floatData != null) {
            return this.floatData;
        }
        float[] ret = new float[this.length];
        for (int i = 0; i < this.length; ++i) {
            ret[i] = this.getFloat(i);
        }
        return ret;
    }

    @Override
    public double[] asDouble() {
        if (this.allocationMode == DataBuffer.AllocationMode.HEAP && this.doubleData != null) {
            return this.doubleData;
        }
        double[] ret = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            ret[i] = this.getDouble(i);
        }
        return ret;
    }

    @Override
    public int[] asInt() {
        if (this.allocationMode == DataBuffer.AllocationMode.HEAP && this.intData != null) {
            return this.intData;
        }
        return this.wrappedBuffer.asIntBuffer().array();
    }

    @Override
    public double getDouble(int i) {
        if (this.doubleData != null) {
            if (i >= this.doubleData.length) {
                throw new IllegalStateException("Index out of bounds " + i);
            }
            this.dirty.set(false);
            return this.doubleData[i];
        }
        if (this.floatData != null) {
            if (i >= this.floatData.length) {
                throw new IllegalStateException("Index out of bounds " + i);
            }
            this.dirty.set(false);
            return this.floatData[i];
        }
        if (this.intData != null) {
            this.dirty.set(false);
            return this.intData[i];
        }
        if (this.dataType() == DataBuffer.Type.FLOAT) {
            this.dirty.set(false);
            return this.wrappedBuffer.asFloatBuffer().get(i);
        }
        if (this.dataType() == DataBuffer.Type.INT) {
            this.dirty.set(false);
            return this.wrappedBuffer.asIntBuffer().get(i);
        }
        this.dirty.set(false);
        return this.wrappedBuffer.asDoubleBuffer().get(i);
    }

    @Override
    public float getFloat(int i) {
        if (this.doubleData != null) {
            if (i >= this.doubleData.length) {
                throw new IllegalStateException("Index out of bounds " + i);
            }
            this.dirty.set(false);
            return (float)this.doubleData[i];
        }
        if (this.floatData != null) {
            if (i >= this.floatData.length) {
                throw new IllegalStateException("Index out of bounds " + i);
            }
            this.dirty.set(false);
            return this.floatData[i];
        }
        if (this.intData != null) {
            this.dirty.set(false);
            return this.intData[i];
        }
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            this.dirty.set(false);
            return (float)this.wrappedBuffer.asDoubleBuffer().get(i);
        }
        this.dirty.getAndSet(true);
        return this.wrappedBuffer.asFloatBuffer().get(i);
    }

    @Override
    public Number getNumber(int i) {
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            return this.getDouble(i);
        }
        if (this.dataType() == DataBuffer.Type.INT) {
            return this.getInt(i);
        }
        return Float.valueOf(this.getFloat(i));
    }

    @Override
    public void put(int i, float element) {
        this.put(i, (double)element);
    }

    @Override
    public void put(int i, double element) {
        if (i < 0 || i >= this.length()) {
            throw new IllegalArgumentException("Illegal index " + i);
        }
        if (this.doubleData != null) {
            this.doubleData[i] = element;
        } else if (this.floatData != null) {
            this.floatData[i] = (float)element;
        } else if (this.intData != null) {
            this.intData[i] = (int)element;
        } else if (this.dataType() == DataBuffer.Type.DOUBLE) {
            this.wrappedBuffer.asDoubleBuffer().put(i, element);
        } else if (this.dataType() == DataBuffer.Type.INT) {
            this.wrappedBuffer.asIntBuffer().put(i, (int)element);
        } else {
            this.wrappedBuffer.asFloatBuffer().put(i, (float)element);
        }
        this.dirty.set(true);
    }

    @Override
    public boolean dirty() {
        return this.dirty.get();
    }

    @Override
    public DoubleBuffer asNioDouble() {
        return this.wrappedBuffer.asDoubleBuffer();
    }

    @Override
    public FloatBuffer asNioFloat() {
        return this.wrappedBuffer.asFloatBuffer();
    }

    @Override
    public ByteBuffer asNio() {
        return this.wrappedBuffer;
    }

    @Override
    public ByteBuf asNetty() {
        if (this.wrappedBuffer != null) {
            return Unpooled.wrappedBuffer((ByteBuffer)this.wrappedBuffer);
        }
        if (this.floatData != null) {
            return Unpooled.copyFloat((float[])this.floatData);
        }
        if (this.doubleData != null) {
            return Unpooled.copyDouble((double[])this.doubleData);
        }
        throw new IllegalStateException("No data source defined");
    }

    @Override
    public void put(int i, int element) {
        this.put(i, (double)element);
    }

    @Override
    public void assign(Number value, int offset) {
        for (int i = offset; i < this.length(); ++i) {
            this.put(i, value.doubleValue());
        }
    }

    @Override
    public void write(OutputStream dos) {
        if (dos instanceof DataOutputStream) {
            try {
                this.write((DataOutputStream)dos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            DataOutputStream dos2 = new DataOutputStream(dos);
            try {
                this.write(dos2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void read(InputStream is) {
        if (is instanceof DataInputStream) {
            this.read((DataInputStream)is);
        } else {
            DataInputStream dis2 = new DataInputStream(is);
            this.read(dis2);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public int getInt(int ix) {
        return (int)this.getDouble(ix);
    }

    @Override
    public void assign(int[] offsets, int[] strides, long n, DataBuffer ... buffers) {
        if (offsets.length != strides.length || strides.length != buffers.length) {
            throw new IllegalArgumentException("Unable to assign buffers, please specify equal lengths strides, offsets, and buffers");
        }
        int length = 0;
        for (int i = 0; i < buffers.length; ++i) {
            length += buffers[i].length();
        }
        int count = 0;
        for (int i = 0; i < buffers.length; ++i) {
            for (int j = offsets[i]; j < buffers[i].length(); j += strides[i]) {
                this.put(count++, buffers[i].getDouble(j));
            }
        }
        if ((long)count != n) {
            throw new IllegalArgumentException("Strides and offsets didn't match up to length " + n);
        }
    }

    @Override
    public void assign(DataBuffer ... buffers) {
        int[] offsets = new int[buffers.length];
        int[] strides = new int[buffers.length];
        for (int i = 0; i < strides.length; ++i) {
            strides[i] = 1;
        }
        this.assign(offsets, strides, buffers);
    }

    @Override
    public void destroy() {
    }

    public boolean equals(Object o) {
        if (o instanceof DataBuffer) {
            DataBuffer d = (DataBuffer)o;
            if (d.length() != this.length()) {
                return false;
            }
            for (int i = 0; i < this.length(); ++i) {
                double eps = Math.abs(this.getDouble(i) - d.getDouble(i));
                if (!(eps > Nd4j.EPS_THRESHOLD)) continue;
                return false;
            }
        }
        return true;
    }

    private void readObject(ObjectInputStream s) {
        this.doReadObject(s);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.write(out);
    }

    protected void doReadObject(ObjectInputStream s) {
        try {
            s.defaultReadObject();
            this.read(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void read(DataInputStream s) {
        try {
            this.ref = new WeakReference<DataBuffer>(this, Nd4j.bufferRefQueue());
            this.referencing = Collections.synchronizedSet(new HashSet());
            this.dirty = new AtomicBoolean(false);
            this.allocationMode = DataBuffer.AllocationMode.valueOf(s.readUTF());
            this.length = s.readInt();
            DataBuffer.Type t = DataBuffer.Type.valueOf(s.readUTF());
            if (t == DataBuffer.Type.DOUBLE) {
                if (this.allocationMode == DataBuffer.AllocationMode.HEAP) {
                    if (this.dataType() == DataBuffer.Type.FLOAT) {
                        this.floatData = new float[this.length()];
                    } else if (this.dataType() == DataBuffer.Type.DOUBLE) {
                        this.doubleData = new double[this.length()];
                    } else {
                        this.intData = new int[this.length()];
                    }
                    for (int i = 0; i < this.length(); ++i) {
                        this.put(i, s.readDouble());
                    }
                } else {
                    this.wrappedBuffer = ByteBuffer.allocateDirect(this.length() * this.getElementSize());
                    this.wrappedBuffer.order(ByteOrder.nativeOrder());
                    for (int i = 0; i < this.length(); ++i) {
                        this.put(i, s.readDouble());
                    }
                }
            } else if (this.allocationMode == DataBuffer.AllocationMode.HEAP) {
                if (this.dataType() == DataBuffer.Type.FLOAT) {
                    this.floatData = new float[this.length()];
                } else if (this.dataType() == DataBuffer.Type.DOUBLE) {
                    this.doubleData = new double[this.length()];
                } else {
                    this.intData = new int[this.length()];
                }
                for (int i = 0; i < this.length(); ++i) {
                    this.put(i, s.readFloat());
                }
            } else {
                this.wrappedBuffer = ByteBuffer.allocateDirect(this.length() * this.getElementSize());
                this.wrappedBuffer.order(ByteOrder.nativeOrder());
                for (int i = 0; i < this.length(); ++i) {
                    this.put(i, s.readFloat());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.allocationMode.name());
        out.writeInt(this.length());
        out.writeUTF(this.dataType().name());
        if (this.dataType() == DataBuffer.Type.DOUBLE) {
            for (int i = 0; i < this.length(); ++i) {
                out.writeDouble(this.getDouble(i));
            }
        } else {
            for (int i = 0; i < this.length(); ++i) {
                out.writeFloat(this.getFloat(i));
            }
        }
    }

    @Override
    public Object array() {
        if (this.floatData != null) {
            return this.floatData;
        }
        if (this.doubleData != null) {
            return this.doubleData;
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("[");
        for (int i = 0; i < this.length(); ++i) {
            ret.append(this.getNumber(i));
            if (i >= this.length() - 1) continue;
            ret.append(",");
        }
        ret.append("]");
        return ret.toString();
    }

    public int hashCode() {
        int result = this.length;
        result = 31 * result + (this.referencing != null ? this.referencing.hashCode() : 0);
        result = 31 * result + (this.ref != null ? this.ref.hashCode() : 0);
        result = 31 * result + (this.isPersist ? 1 : 0);
        result = 31 * result + (this.allocationMode != null ? this.allocationMode.hashCode() : 0);
        return result;
    }
}

