/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.render;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.mybatis.dynamic.sql.AbstractColumnComparisonCondition;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.AbstractNoValueCondition;
import org.mybatis.dynamic.sql.AbstractSingleValueCondition;
import org.mybatis.dynamic.sql.AbstractSubselectCondition;
import org.mybatis.dynamic.sql.AbstractTwoValueCondition;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.ConditionVisitor;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.select.render.SelectRenderer;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;

public class WhereConditionVisitor<T>
implements ConditionVisitor<T, Optional<FragmentAndParameters>> {
    private RenderingStrategy renderingStrategy;
    private AtomicInteger sequence;
    private BindableColumn<T> column;
    private TableAliasCalculator tableAliasCalculator;
    private String parameterPrefix;

    private WhereConditionVisitor(Builder<T> builder) {
        this.renderingStrategy = Objects.requireNonNull(((Builder)builder).renderingStrategy);
        this.sequence = Objects.requireNonNull(((Builder)builder).sequence);
        this.column = Objects.requireNonNull(((Builder)builder).column);
        this.tableAliasCalculator = Objects.requireNonNull(((Builder)builder).tableAliasCalculator);
        this.parameterPrefix = Objects.requireNonNull(((Builder)builder).parameterPrefix);
    }

    @Override
    public Optional<FragmentAndParameters> visit(AbstractListValueCondition<T> condition) {
        FragmentCollector fc = condition.mapValues(this::toFragmentAndParameters).collect(FragmentCollector.collect());
        if (fc.isEmpty()) {
            return Optional.empty();
        }
        return FragmentAndParameters.withFragment(condition.renderCondition(this.columnName(), fc.fragments())).withParameters(fc.parameters()).buildOptional();
    }

    @Override
    public Optional<FragmentAndParameters> visit(AbstractNoValueCondition<T> condition) {
        return FragmentAndParameters.withFragment(condition.renderCondition(this.columnName())).buildOptional();
    }

    @Override
    public Optional<FragmentAndParameters> visit(AbstractSingleValueCondition<T> condition) {
        String mapKey = this.formatParameterMapKey(this.sequence.getAndIncrement());
        String fragment = condition.renderCondition(this.columnName(), this.getFormattedJdbcPlaceholder(mapKey));
        return FragmentAndParameters.withFragment(fragment).withParameter(mapKey, condition.value()).buildOptional();
    }

    @Override
    public Optional<FragmentAndParameters> visit(AbstractTwoValueCondition<T> condition) {
        String mapKey1 = this.formatParameterMapKey(this.sequence.getAndIncrement());
        String mapKey2 = this.formatParameterMapKey(this.sequence.getAndIncrement());
        String fragment = condition.renderCondition(this.columnName(), this.getFormattedJdbcPlaceholder(mapKey1), this.getFormattedJdbcPlaceholder(mapKey2));
        return FragmentAndParameters.withFragment(fragment).withParameter(mapKey1, condition.value1()).withParameter(mapKey2, condition.value2()).buildOptional();
    }

    @Override
    public Optional<FragmentAndParameters> visit(AbstractSubselectCondition<T> condition) {
        SelectStatementProvider selectStatement = SelectRenderer.withSelectModel(condition.selectModel()).withRenderingStrategy(this.renderingStrategy).withSequence(this.sequence).build().render();
        String fragment = condition.renderCondition(this.columnName(), selectStatement.getSelectStatement());
        return FragmentAndParameters.withFragment(fragment).withParameters(selectStatement.getParameters()).buildOptional();
    }

    @Override
    public Optional<FragmentAndParameters> visit(AbstractColumnComparisonCondition<T> condition) {
        String fragment = condition.renderCondition(this.columnName(), this.tableAliasCalculator);
        return FragmentAndParameters.withFragment(fragment).buildOptional();
    }

    private FragmentAndParameters toFragmentAndParameters(Object value) {
        String mapKey = this.formatParameterMapKey(this.sequence.getAndIncrement());
        return FragmentAndParameters.withFragment(this.getFormattedJdbcPlaceholder(mapKey)).withParameter(mapKey, value).build();
    }

    private String formatParameterMapKey(int number) {
        return "p" + number;
    }

    private String getFormattedJdbcPlaceholder(String mapKey) {
        return this.renderingStrategy.getFormattedJdbcPlaceholder(this.column, this.parameterPrefix, mapKey);
    }

    private String columnName() {
        return this.column.renderWithTableAlias(this.tableAliasCalculator);
    }

    public static <T> Builder<T> withColumn(BindableColumn<T> column) {
        return new Builder<T>().withColumn(column);
    }

    public static class Builder<T> {
        private RenderingStrategy renderingStrategy;
        private AtomicInteger sequence;
        private BindableColumn<T> column;
        private TableAliasCalculator tableAliasCalculator;
        private String parameterPrefix = "parameters";

        public Builder<T> withSequence(AtomicInteger sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder<T> withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder<T> withColumn(BindableColumn<T> column) {
            this.column = column;
            return this;
        }

        public Builder<T> withTableAliasCalculator(TableAliasCalculator tableAliasCalculator) {
            this.tableAliasCalculator = tableAliasCalculator;
            return this;
        }

        public Builder<T> withParameterName(String parameterName) {
            if (parameterName != null) {
                this.parameterPrefix = parameterName + "." + "parameters";
            }
            return this;
        }

        public WhereConditionVisitor<T> build() {
            return new WhereConditionVisitor(this);
        }
    }
}

