/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;

public class RenderedCriterion {
    private Optional<String> connector;
    private Optional<FragmentAndParameters> initialCondition;
    private List<RenderedCriterion> subCriteria;

    private RenderedCriterion(Builder builder) {
        this.connector = Objects.requireNonNull(builder.connector);
        this.initialCondition = Objects.requireNonNull(builder.initialCondition);
        this.subCriteria = Objects.requireNonNull(builder.subCriteria);
    }

    public FragmentAndParameters renderWithInitialConnector() {
        FragmentAndParameters fp = this.renderWithoutInitialConnector();
        return this.connector.map(fp::prependFragment).orElse(fp);
    }

    public FragmentAndParameters renderWithoutInitialConnector() {
        FragmentCollector fc = this.internalRender();
        String fragment = this.calculateFragment(fc);
        return FragmentAndParameters.withFragment(fragment).withParameters(fc.parameters()).build();
    }

    private FragmentCollector internalRender() {
        return this.initialCondition.map(this::renderConditionAndSubCriteria).orElseGet(this::renderSubCriteriaOnly);
    }

    private FragmentCollector renderSubCriteriaOnly() {
        FragmentAndParameters initial = this.subCriteria.get(0).renderWithoutInitialConnector();
        return this.subCriteria.stream().skip(1L).map(RenderedCriterion::renderWithInitialConnector).collect(FragmentCollector.collect(initial));
    }

    private FragmentCollector renderConditionAndSubCriteria(FragmentAndParameters initialCondition) {
        return this.subCriteria.stream().map(RenderedCriterion::renderWithInitialConnector).collect(FragmentCollector.collect(initialCondition));
    }

    private String calculateFragment(FragmentCollector collector) {
        if (collector.hasMultipleFragments()) {
            return collector.fragments().collect(Collectors.joining(" ", "(", ")"));
        }
        return collector.fragments().findFirst().orElse("");
    }

    public static class Builder {
        private Optional<String> connector = Optional.empty();
        private Optional<FragmentAndParameters> initialCondition = Optional.empty();
        private List<RenderedCriterion> subCriteria = new ArrayList<RenderedCriterion>();

        public Builder withConnector(Optional<String> connector) {
            this.connector = connector;
            return this;
        }

        public Builder withInitialCondition(Optional<FragmentAndParameters> initialCondition) {
            this.initialCondition = initialCondition;
            return this;
        }

        public Builder withSubCriteria(List<RenderedCriterion> subCriteria) {
            this.subCriteria.addAll(subCriteria);
            return this;
        }

        public Optional<RenderedCriterion> build() {
            if (!this.initialCondition.isPresent() && this.subCriteria.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new RenderedCriterion(this));
        }
    }
}

