/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.Collection;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsNotIn<T>
extends AbstractListValueCondition<T> {
    protected IsNotIn(Collection<T> values, UnaryOperator<Stream<T>> valueStreamTransformer) {
        super(values, valueStreamTransformer);
    }

    protected IsNotIn(Collection<T> values) {
        super(values);
    }

    @Override
    public String renderCondition(String columnName, Stream<String> placeholders) {
        return StringUtilities.spaceAfter(columnName) + placeholders.collect(Collectors.joining(",", "not in (", ")"));
    }

    public IsNotIn<T> then(UnaryOperator<Stream<T>> valueStreamTransformer) {
        return new IsNotIn<T>(this.values, valueStreamTransformer);
    }

    @Deprecated
    public IsNotIn<T> withValueStreamOperations(UnaryOperator<Stream<T>> valueStreamTransformer) {
        return this.then(valueStreamTransformer);
    }

    public static <T> IsNotIn<T> of(Collection<T> values) {
        return new IsNotIn<T>(values);
    }
}

