/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.Collection;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsInCaseInsensitive
extends AbstractListValueCondition<String> {
    protected IsInCaseInsensitive(Collection<String> values) {
        super(values, s -> s.map(StringUtilities::safelyUpperCase));
    }

    protected IsInCaseInsensitive(Collection<String> values, UnaryOperator<Stream<String>> valueStreamTransformer) {
        super(values, StringUtilities.upperCaseAfter(valueStreamTransformer));
    }

    @Override
    public String renderCondition(String columnName, Stream<String> placeholders) {
        return "upper(" + columnName + ") " + placeholders.collect(Collectors.joining(",", "in (", ")"));
    }

    public IsInCaseInsensitive then(UnaryOperator<Stream<String>> valueStreamTransformer) {
        return new IsInCaseInsensitive(this.values, valueStreamTransformer);
    }

    @Deprecated
    public IsInCaseInsensitive withValueStreamOperations(UnaryOperator<Stream<String>> valueStreamTransformer) {
        return this.then(valueStreamTransformer);
    }

    public static IsInCaseInsensitive of(Collection<String> values) {
        return new IsInCaseInsensitive(values);
    }
}

