/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.where.WhereModel;

public abstract class AbstractWhereDSL<T extends AbstractWhereDSL<T>> {
    private List<SqlCriterion<?>> criteria = new ArrayList();

    protected <S> AbstractWhereDSL() {
    }

    protected <S> AbstractWhereDSL(BindableColumn<S> column, VisitableCondition<S> condition) {
        SqlCriterion<S> criterion = SqlCriterion.withColumn(column).withCondition(condition).build();
        this.criteria.add(criterion);
    }

    protected <S> AbstractWhereDSL(BindableColumn<S> column, VisitableCondition<S> condition, SqlCriterion<?> ... subCriteria) {
        SqlCriterion<S> criterion = SqlCriterion.withColumn(column).withCondition(condition).withSubCriteria(Arrays.asList(subCriteria)).build();
        this.criteria.add(criterion);
    }

    public <S> T and(BindableColumn<S> column, VisitableCondition<S> condition) {
        this.addCriterion("and", column, condition);
        return this.getThis();
    }

    public <S> T and(BindableColumn<S> column, VisitableCondition<S> condition, SqlCriterion<?> ... subCriteria) {
        this.addCriterion("and", column, condition, subCriteria);
        return this.getThis();
    }

    public <S> T or(BindableColumn<S> column, VisitableCondition<S> condition) {
        this.addCriterion("or", column, condition);
        return this.getThis();
    }

    public <S> T or(BindableColumn<S> column, VisitableCondition<S> condition, SqlCriterion<?> ... subCriteria) {
        this.addCriterion("or", column, condition, subCriteria);
        return this.getThis();
    }

    private <S> void addCriterion(String connector, BindableColumn<S> column, VisitableCondition<S> condition) {
        SqlCriterion<S> criterion = SqlCriterion.withColumn(column).withConnector(connector).withCondition(condition).build();
        this.criteria.add(criterion);
    }

    private <S> void addCriterion(String connector, BindableColumn<S> column, VisitableCondition<S> condition, SqlCriterion<?> ... subCriteria) {
        SqlCriterion<S> criterion = SqlCriterion.withColumn(column).withConnector(connector).withCondition(condition).withSubCriteria(Arrays.asList(subCriteria)).build();
        this.criteria.add(criterion);
    }

    protected WhereModel buildWhereModel() {
        return WhereModel.of(this.criteria);
    }

    protected abstract T getThis();
}

