/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Optional;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.LimitAndOffsetPagingModel;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;

public class LimitAndOffsetPagingModelRenderer {
    private static final String LIMIT_PARAMETER = "_limit";
    private static final String OFFSET_PARAMETER = "_offset";
    private RenderingStrategy renderingStrategy;
    private LimitAndOffsetPagingModel pagingModel;

    public LimitAndOffsetPagingModelRenderer(RenderingStrategy renderingStrategy, LimitAndOffsetPagingModel pagingModel) {
        this.renderingStrategy = renderingStrategy;
        this.pagingModel = pagingModel;
    }

    public Optional<FragmentAndParameters> render() {
        return this.pagingModel.offset().map(this::renderLimitAndOffset).orElseGet(this::renderLimitOnly);
    }

    private Optional<FragmentAndParameters> renderLimitOnly() {
        return FragmentAndParameters.withFragment("limit " + this.renderPlaceholder(LIMIT_PARAMETER)).withParameter(LIMIT_PARAMETER, this.pagingModel.limit()).buildOptional();
    }

    private Optional<FragmentAndParameters> renderLimitAndOffset(Long offset) {
        return FragmentAndParameters.withFragment("limit " + this.renderPlaceholder(LIMIT_PARAMETER) + " offset " + this.renderPlaceholder(OFFSET_PARAMETER)).withParameter(LIMIT_PARAMETER, this.pagingModel.limit()).withParameter(OFFSET_PARAMETER, offset).buildOptional();
    }

    private String renderPlaceholder(String parameterName) {
        return this.renderingStrategy.getFormattedJdbcPlaceholder("parameters", parameterName);
    }
}

