/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.function;

import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.select.function.AbstractFunction;

public class Substring
extends AbstractFunction<String, Substring> {
    private int offset;
    private int length;

    private Substring(BindableColumn<String> column, int offset, int length) {
        super(column);
        this.offset = offset;
        this.length = length;
    }

    @Override
    public String renderWithTableAlias(TableAliasCalculator tableAliasCalculator) {
        return "substring(" + this.column.renderWithTableAlias(tableAliasCalculator) + ", " + this.offset + ", " + this.length + ")";
    }

    @Override
    protected Substring copy() {
        return new Substring(this.column, this.offset, this.length);
    }

    public static Substring of(BindableColumn<String> column, int offset, int length) {
        return new Substring(column, offset, length);
    }
}

