/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.select.FetchFirstPagingModel;
import org.mybatis.dynamic.sql.select.LimitAndOffsetPagingModel;
import org.mybatis.dynamic.sql.select.MyBatis3SelectModelAdapter;
import org.mybatis.dynamic.sql.select.OrderByModel;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.Buildable;

public class SelectDSL<R>
implements Buildable<R> {
    private Function<SelectModel, R> adapterFunction;
    private List<QueryExpressionModel> queryExpressions = new ArrayList<QueryExpressionModel>();
    private OrderByModel orderByModel;
    private PagingModel pagingModel;
    private Supplier<R> buildDelegateMethod;

    private SelectDSL(Function<SelectModel, R> adapterFunction) {
        this.adapterFunction = Objects.requireNonNull(adapterFunction);
        this.buildDelegateMethod = this::internalBuild;
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> select(BasicColumn ... selectList) {
        return SelectDSL.select(Function.identity(), selectList);
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> select(Function<SelectModel, R> adapterFunction, BasicColumn ... selectList) {
        SelectDSL<R> selectDSL = new SelectDSL<R>(adapterFunction);
        return QueryExpressionDSL.select(selectDSL, selectList);
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> selectDistinct(BasicColumn ... selectList) {
        return SelectDSL.selectDistinct(Function.identity(), selectList);
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> selectDistinct(Function<SelectModel, R> adapterFunction, BasicColumn ... selectList) {
        SelectDSL<R> selectDSL = new SelectDSL<R>(adapterFunction);
        return QueryExpressionDSL.selectDistinct(selectDSL, selectList);
    }

    public static <T> QueryExpressionDSL.FromGatherer<MyBatis3SelectModelAdapter<T>> selectWithMapper(Function<SelectStatementProvider, T> mapperMethod, BasicColumn ... selectList) {
        return SelectDSL.select((SelectModel selectModel) -> MyBatis3SelectModelAdapter.of(selectModel, mapperMethod), selectList);
    }

    public static <T> QueryExpressionDSL.FromGatherer<MyBatis3SelectModelAdapter<T>> selectDistinctWithMapper(Function<SelectStatementProvider, T> mapperMethod, BasicColumn ... selectList) {
        return SelectDSL.selectDistinct((SelectModel selectModel) -> MyBatis3SelectModelAdapter.of(selectModel, mapperMethod), selectList);
    }

    void addQueryExpression(QueryExpressionModel queryExpression) {
        this.queryExpressions.add(queryExpression);
    }

    void setOrderByModel(OrderByModel orderByModel) {
        this.orderByModel = orderByModel;
    }

    public LimitFinisher limit(long limit) {
        return new LimitFinisher(limit);
    }

    public OffsetFirstFinisher offset(long offset) {
        return new OffsetFirstFinisher(offset);
    }

    public FetchFirstFinisher fetchFirst(long fetchFirstRows) {
        return new FetchFirstFinisher(fetchFirstRows);
    }

    @Override
    public R build() {
        return this.buildDelegateMethod.get();
    }

    private R internalBuild() {
        SelectModel selectModel = SelectModel.withQueryExpressions(this.queryExpressions).withOrderByModel(this.orderByModel).withPagingModel(this.pagingModel).build();
        return this.adapterFunction.apply(selectModel);
    }

    public class RowsOnlyFinisher
    implements Buildable<R> {
        public RowsOnlyFinisher() {
            SelectDSL.this.buildDelegateMethod = this::internalBuild;
        }

        @Override
        public R build() {
            return SelectDSL.this.buildDelegateMethod.get();
        }

        private R internalBuild() {
            return SelectDSL.this.internalBuild();
        }
    }

    public class FetchFirstFinisher {
        public FetchFirstFinisher(long fetchFirstRows) {
            SelectDSL.this.pagingModel = new FetchFirstPagingModel.Builder().withFetchFirstRows(fetchFirstRows).build();
        }

        public FetchFirstFinisher(long offset, long fetchFirstRows) {
            SelectDSL.this.pagingModel = new FetchFirstPagingModel.Builder().withOffset(offset).withFetchFirstRows(fetchFirstRows).build();
        }

        public RowsOnlyFinisher rowsOnly() {
            return new RowsOnlyFinisher();
        }
    }

    public class OffsetFirstFinisher
    implements Buildable<R> {
        private long offset;

        public OffsetFirstFinisher(long offset) {
            this.offset = offset;
            SelectDSL.this.buildDelegateMethod = this::internalBuild;
        }

        public FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            return new FetchFirstFinisher(this.offset, fetchFirstRows);
        }

        @Override
        public R build() {
            return SelectDSL.this.buildDelegateMethod.get();
        }

        private R internalBuild() {
            SelectDSL.this.pagingModel = new FetchFirstPagingModel.Builder().withOffset(this.offset).build();
            return SelectDSL.this.internalBuild();
        }
    }

    public class OffsetFinisher
    implements Buildable<R> {
        public OffsetFinisher(long limit, long offset) {
            SelectDSL.this.buildDelegateMethod = this::internalBuild;
            SelectDSL.this.pagingModel = new LimitAndOffsetPagingModel.Builder().withLimit(limit).withOffset(offset).build();
        }

        @Override
        public R build() {
            return SelectDSL.this.buildDelegateMethod.get();
        }

        private R internalBuild() {
            return SelectDSL.this.internalBuild();
        }
    }

    public class LimitFinisher
    implements Buildable<R> {
        private long limit;

        public LimitFinisher(long limit) {
            this.limit = limit;
            SelectDSL.this.buildDelegateMethod = this::internalBuild;
        }

        public OffsetFinisher offset(long offset) {
            return new OffsetFinisher(this.limit, offset);
        }

        @Override
        public R build() {
            return SelectDSL.this.buildDelegateMethod.get();
        }

        private R internalBuild() {
            SelectDSL.this.pagingModel = new LimitAndOffsetPagingModel.Builder().withLimit(this.limit).build();
            return SelectDSL.this.internalBuild();
        }
    }
}

