/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.SqlCriterion;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.select.GroupByModel;
import org.mybatis.dynamic.sql.select.OrderByModel;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.SelectDSL;
import org.mybatis.dynamic.sql.select.join.JoinCondition;
import org.mybatis.dynamic.sql.select.join.JoinCriterion;
import org.mybatis.dynamic.sql.select.join.JoinModel;
import org.mybatis.dynamic.sql.select.join.JoinSpecification;
import org.mybatis.dynamic.sql.select.join.JoinType;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.where.AbstractWhereDSL;
import org.mybatis.dynamic.sql.where.WhereModel;

public class QueryExpressionDSL<R>
implements Buildable<R> {
    private String connector;
    private SelectDSL<R> selectDSL;
    private boolean isDistinct;
    private List<BasicColumn> selectList;
    private SqlTable table;
    private Map<SqlTable, String> tableAliases = new HashMap<SqlTable, String>();
    private WhereModel whereModel;
    private GroupByModel groupByModel;
    private JoinModel joinModel;
    private List<JoinSpecification> joinSpecifications = new ArrayList<JoinSpecification>();
    private Supplier<R> buildDelegateMethod;

    private QueryExpressionDSL(FromGatherer<R> fromGatherer) {
        this.connector = ((FromGatherer)fromGatherer).connector;
        this.selectList = Arrays.asList(((FromGatherer)fromGatherer).selectList);
        this.isDistinct = ((FromGatherer)fromGatherer).isDistinct;
        this.selectDSL = Objects.requireNonNull(((FromGatherer)fromGatherer).selectDSL);
        this.table = Objects.requireNonNull(((FromGatherer)fromGatherer).table);
        this.buildDelegateMethod = this::internalBuild;
    }

    private QueryExpressionDSL(FromGatherer<R> fromGatherer, String tableAlias) {
        this(fromGatherer);
        this.tableAliases.put(this.table, tableAlias);
    }

    public static <R> FromGatherer<R> select(SelectDSL<R> selectDSL, BasicColumn ... selectList) {
        return new FromGatherer.Builder().withSelectList(selectList).withSelectDSL(selectDSL).build();
    }

    public static <R> FromGatherer<R> selectDistinct(SelectDSL<R> selectDSL, BasicColumn ... selectList) {
        return new FromGatherer.Builder().withSelectList(selectList).withSelectDSL(selectDSL).isDistinct().build();
    }

    public QueryExpressionWhereBuilder where() {
        return new QueryExpressionWhereBuilder();
    }

    public <T> QueryExpressionWhereBuilder where(BindableColumn<T> column, VisitableCondition<T> condition) {
        return new QueryExpressionWhereBuilder((BindableColumn)column, (VisitableCondition)condition);
    }

    public <T> QueryExpressionWhereBuilder where(BindableColumn<T> column, VisitableCondition<T> condition, SqlCriterion<?> ... subCriteria) {
        return new QueryExpressionWhereBuilder((BindableColumn)column, (VisitableCondition)condition, (SqlCriterion[])subCriteria);
    }

    @Override
    public R build() {
        return this.buildDelegateMethod.get();
    }

    private R internalBuild() {
        this.selectDSL.addQueryExpression(this.buildModel());
        return this.selectDSL.build();
    }

    public JoinSpecificationStarter join(SqlTable joinTable) {
        return new JoinSpecificationStarter(joinTable, JoinType.INNER);
    }

    public JoinSpecificationStarter join(SqlTable joinTable, String tableAlias) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.join(joinTable);
    }

    public JoinSpecificationStarter leftJoin(SqlTable joinTable) {
        return new JoinSpecificationStarter(joinTable, JoinType.LEFT);
    }

    public JoinSpecificationStarter leftJoin(SqlTable joinTable, String tableAlias) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.leftJoin(joinTable);
    }

    public JoinSpecificationStarter rightJoin(SqlTable joinTable) {
        return new JoinSpecificationStarter(joinTable, JoinType.RIGHT);
    }

    public JoinSpecificationStarter rightJoin(SqlTable joinTable, String tableAlias) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.rightJoin(joinTable);
    }

    public JoinSpecificationStarter fullJoin(SqlTable joinTable) {
        return new JoinSpecificationStarter(joinTable, JoinType.FULL);
    }

    public JoinSpecificationStarter fullJoin(SqlTable joinTable, String tableAlias) {
        this.tableAliases.put(joinTable, tableAlias);
        return this.fullJoin(joinTable);
    }

    public GroupByFinisher groupBy(BasicColumn ... columns) {
        this.groupByModel = GroupByModel.of(columns);
        this.selectDSL.addQueryExpression(this.buildModel());
        return new GroupByFinisher();
    }

    public SelectDSL<R> orderBy(SortSpecification ... columns) {
        this.buildDelegateMethod = this.selectDSL::build;
        this.selectDSL.addQueryExpression(this.buildModel());
        this.selectDSL.setOrderByModel(OrderByModel.of(columns));
        return this.selectDSL;
    }

    public UnionBuilder union() {
        this.selectDSL.addQueryExpression(this.buildModel());
        return new UnionBuilder("union");
    }

    public UnionBuilder unionAll() {
        this.selectDSL.addQueryExpression(this.buildModel());
        return new UnionBuilder("union all");
    }

    protected QueryExpressionModel buildModel() {
        return QueryExpressionModel.withSelectList(this.selectList).withConnector(this.connector).withTable(this.table).isDistinct(this.isDistinct).withTableAliases(this.tableAliases).withWhereModel(this.whereModel).withJoinModel(this.joinModel).withGroupByModel(this.groupByModel).build();
    }

    public SelectDSL.LimitFinisher limit(long limit) {
        this.buildDelegateMethod = this.selectDSL::build;
        this.selectDSL.addQueryExpression(this.buildModel());
        return this.selectDSL.limit(limit);
    }

    public SelectDSL.OffsetFirstFinisher offset(long offset) {
        this.buildDelegateMethod = this.selectDSL::build;
        this.selectDSL.addQueryExpression(this.buildModel());
        return this.selectDSL.offset(offset);
    }

    public SelectDSL.FetchFirstFinisher fetchFirst(long fetchFirstRows) {
        this.buildDelegateMethod = this.selectDSL::build;
        this.selectDSL.addQueryExpression(this.buildModel());
        return this.selectDSL.fetchFirst(fetchFirstRows);
    }

    public class UnionBuilder {
        private String connector;

        public UnionBuilder(String connector) {
            this.connector = Objects.requireNonNull(connector);
        }

        public FromGatherer<R> select(BasicColumn ... selectList) {
            return new FromGatherer.Builder().withConnector(this.connector).withSelectList(selectList).withSelectDSL(QueryExpressionDSL.this.selectDSL).withPriorQuery(QueryExpressionDSL.this).build();
        }

        public FromGatherer<R> selectDistinct(BasicColumn ... selectList) {
            return new FromGatherer.Builder().withConnector(this.connector).withSelectList(selectList).withSelectDSL(QueryExpressionDSL.this.selectDSL).isDistinct().withPriorQuery(QueryExpressionDSL.this).build();
        }
    }

    public class GroupByFinisher
    implements Buildable<R> {
        public GroupByFinisher() {
            QueryExpressionDSL.this.buildDelegateMethod = this::internalBuild;
        }

        public SelectDSL<R> orderBy(SortSpecification ... columns) {
            QueryExpressionDSL.this.buildDelegateMethod = QueryExpressionDSL.this.selectDSL::build;
            QueryExpressionDSL.this.selectDSL.setOrderByModel(OrderByModel.of(columns));
            return QueryExpressionDSL.this.selectDSL;
        }

        @Override
        public R build() {
            return QueryExpressionDSL.this.buildDelegateMethod.get();
        }

        private R internalBuild() {
            return QueryExpressionDSL.this.selectDSL.build();
        }

        public SelectDSL.LimitFinisher limit(long limit) {
            QueryExpressionDSL.this.buildDelegateMethod = QueryExpressionDSL.this.selectDSL::build;
            return QueryExpressionDSL.this.selectDSL.limit(limit);
        }

        public SelectDSL.OffsetFirstFinisher offset(long offset) {
            QueryExpressionDSL.this.buildDelegateMethod = QueryExpressionDSL.this.selectDSL::build;
            return QueryExpressionDSL.this.selectDSL.offset(offset);
        }

        public SelectDSL.FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            QueryExpressionDSL.this.buildDelegateMethod = QueryExpressionDSL.this.selectDSL::build;
            return QueryExpressionDSL.this.selectDSL.fetchFirst(fetchFirstRows);
        }
    }

    public class JoinSpecificationFinisher
    implements Buildable<R> {
        private SqlTable joinTable;
        private List<JoinCriterion> joinCriteria = new ArrayList<JoinCriterion>();
        private JoinType joinType;

        public JoinSpecificationFinisher(SqlTable table, BasicColumn joinColumn, JoinCondition joinCondition, JoinType joinType) {
            this.joinTable = table;
            this.joinType = joinType;
            JoinCriterion joinCriterion = JoinCriterion.withJoinColumn(joinColumn).withJoinCondition(joinCondition).withConnector("on").build();
            this.joinCriteria.add(joinCriterion);
            QueryExpressionDSL.this.buildDelegateMethod = this::internalbuild;
        }

        public JoinSpecificationFinisher(SqlTable table, BasicColumn joinColumn, JoinCondition joinCondition, JoinType joinType, JoinCriterion ... joinCriteria) {
            this.joinTable = table;
            this.joinType = joinType;
            JoinCriterion joinCriterion = JoinCriterion.withJoinColumn(joinColumn).withJoinCondition(joinCondition).withConnector("on").build();
            this.joinCriteria.add(joinCriterion);
            this.joinCriteria.addAll(Arrays.asList(joinCriteria));
            QueryExpressionDSL.this.buildDelegateMethod = this::internalbuild;
        }

        protected JoinSpecification buildJoinSpecification() {
            return JoinSpecification.withJoinTable(this.joinTable).withJoinCriteria(this.joinCriteria).withJoinType(this.joinType).build();
        }

        protected JoinModel buildJoinModel() {
            QueryExpressionDSL.this.joinSpecifications.add(this.buildJoinSpecification());
            return JoinModel.of(QueryExpressionDSL.this.joinSpecifications);
        }

        @Override
        public R build() {
            return QueryExpressionDSL.this.buildDelegateMethod.get();
        }

        private R internalbuild() {
            QueryExpressionDSL.this.joinModel = this.buildJoinModel();
            QueryExpressionDSL.this.selectDSL.addQueryExpression(QueryExpressionDSL.this.buildModel());
            return QueryExpressionDSL.this.selectDSL.build();
        }

        public QueryExpressionWhereBuilder where() {
            QueryExpressionDSL.this.joinModel = this.buildJoinModel();
            return new QueryExpressionWhereBuilder();
        }

        public <T> QueryExpressionWhereBuilder where(BindableColumn<T> column, VisitableCondition<T> condition) {
            QueryExpressionDSL.this.joinModel = this.buildJoinModel();
            return new QueryExpressionWhereBuilder((BindableColumn)column, (VisitableCondition)condition);
        }

        public <T> QueryExpressionWhereBuilder where(BindableColumn<T> column, VisitableCondition<T> condition, SqlCriterion<?> ... subCriteria) {
            QueryExpressionDSL.this.joinModel = this.buildJoinModel();
            return new QueryExpressionWhereBuilder((BindableColumn)column, (VisitableCondition)condition, (SqlCriterion[])subCriteria);
        }

        public JoinSpecificationFinisher and(BasicColumn joinColumn, JoinCondition joinCondition) {
            JoinCriterion joinCriterion = JoinCriterion.withJoinColumn(joinColumn).withJoinCondition(joinCondition).withConnector("and").build();
            this.joinCriteria.add(joinCriterion);
            return this;
        }

        public JoinSpecificationStarter join(SqlTable joinTable) {
            QueryExpressionDSL.this.joinSpecifications.add(this.buildJoinSpecification());
            return new JoinSpecificationStarter(joinTable, JoinType.INNER);
        }

        public JoinSpecificationStarter join(SqlTable joinTable, String tableAlias) {
            QueryExpressionDSL.this.tableAliases.put(joinTable, tableAlias);
            return this.join(joinTable);
        }

        public JoinSpecificationStarter leftJoin(SqlTable joinTable) {
            QueryExpressionDSL.this.joinSpecifications.add(this.buildJoinSpecification());
            return new JoinSpecificationStarter(joinTable, JoinType.LEFT);
        }

        public JoinSpecificationStarter leftJoin(SqlTable joinTable, String tableAlias) {
            QueryExpressionDSL.this.tableAliases.put(joinTable, tableAlias);
            return this.leftJoin(joinTable);
        }

        public JoinSpecificationStarter rightJoin(SqlTable joinTable) {
            QueryExpressionDSL.this.joinSpecifications.add(this.buildJoinSpecification());
            return new JoinSpecificationStarter(joinTable, JoinType.RIGHT);
        }

        public JoinSpecificationStarter rightJoin(SqlTable joinTable, String tableAlias) {
            QueryExpressionDSL.this.tableAliases.put(joinTable, tableAlias);
            return this.rightJoin(joinTable);
        }

        public JoinSpecificationStarter fullJoin(SqlTable joinTable) {
            QueryExpressionDSL.this.joinSpecifications.add(this.buildJoinSpecification());
            return new JoinSpecificationStarter(joinTable, JoinType.FULL);
        }

        public JoinSpecificationStarter fullJoin(SqlTable joinTable, String tableAlias) {
            QueryExpressionDSL.this.tableAliases.put(joinTable, tableAlias);
            return this.fullJoin(joinTable);
        }

        public SelectDSL<R> orderBy(SortSpecification ... columns) {
            QueryExpressionDSL.this.buildDelegateMethod = QueryExpressionDSL.this.selectDSL::build;
            QueryExpressionDSL.this.joinModel = this.buildJoinModel();
            QueryExpressionDSL.this.selectDSL.addQueryExpression(QueryExpressionDSL.this.buildModel());
            QueryExpressionDSL.this.selectDSL.setOrderByModel(OrderByModel.of(columns));
            return QueryExpressionDSL.this.selectDSL;
        }

        public SelectDSL.LimitFinisher limit(long limit) {
            QueryExpressionDSL.this.buildDelegateMethod = QueryExpressionDSL.this.selectDSL::build;
            QueryExpressionDSL.this.joinModel = this.buildJoinModel();
            QueryExpressionDSL.this.selectDSL.addQueryExpression(QueryExpressionDSL.this.buildModel());
            return QueryExpressionDSL.this.selectDSL.limit(limit);
        }

        public SelectDSL.OffsetFirstFinisher offset(long offset) {
            QueryExpressionDSL.this.buildDelegateMethod = QueryExpressionDSL.this.selectDSL::build;
            QueryExpressionDSL.this.joinModel = this.buildJoinModel();
            QueryExpressionDSL.this.selectDSL.addQueryExpression(QueryExpressionDSL.this.buildModel());
            return QueryExpressionDSL.this.selectDSL.offset(offset);
        }

        public SelectDSL.FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            QueryExpressionDSL.this.buildDelegateMethod = QueryExpressionDSL.this.selectDSL::build;
            QueryExpressionDSL.this.joinModel = this.buildJoinModel();
            QueryExpressionDSL.this.selectDSL.addQueryExpression(QueryExpressionDSL.this.buildModel());
            return QueryExpressionDSL.this.selectDSL.fetchFirst(fetchFirstRows);
        }
    }

    public class JoinSpecificationStarter {
        private SqlTable joinTable;
        private JoinType joinType;

        public JoinSpecificationStarter(SqlTable joinTable, JoinType joinType) {
            this.joinTable = joinTable;
            this.joinType = joinType;
        }

        public JoinSpecificationFinisher on(BasicColumn joinColumn, JoinCondition joinCondition) {
            return new JoinSpecificationFinisher(this.joinTable, joinColumn, joinCondition, this.joinType);
        }

        public JoinSpecificationFinisher on(BasicColumn joinColumn, JoinCondition joinCondition, JoinCriterion ... joinCriteria) {
            return new JoinSpecificationFinisher(this.joinTable, joinColumn, joinCondition, this.joinType, joinCriteria);
        }
    }

    public class QueryExpressionWhereBuilder
    extends AbstractWhereDSL<QueryExpressionWhereBuilder>
    implements Buildable<R> {
        private <T> QueryExpressionWhereBuilder() {
            QueryExpressionDSL.this.buildDelegateMethod = this::internalBuild;
        }

        private <T> QueryExpressionWhereBuilder(BindableColumn<T> column, VisitableCondition<T> condition) {
            super(column, condition);
            QueryExpressionDSL.this.buildDelegateMethod = this::internalBuild;
        }

        private <T> QueryExpressionWhereBuilder(BindableColumn<T> column, VisitableCondition<T> condition, SqlCriterion<?> ... subCriteria) {
            super(column, condition, subCriteria);
            QueryExpressionDSL.this.buildDelegateMethod = this::internalBuild;
        }

        public UnionBuilder union() {
            QueryExpressionDSL.this.whereModel = this.buildWhereModel();
            QueryExpressionDSL.this.selectDSL.addQueryExpression(QueryExpressionDSL.this.buildModel());
            return new UnionBuilder("union");
        }

        public UnionBuilder unionAll() {
            QueryExpressionDSL.this.whereModel = this.buildWhereModel();
            QueryExpressionDSL.this.selectDSL.addQueryExpression(QueryExpressionDSL.this.buildModel());
            return new UnionBuilder("union all");
        }

        public SelectDSL<R> orderBy(SortSpecification ... columns) {
            QueryExpressionDSL.this.buildDelegateMethod = QueryExpressionDSL.this.selectDSL::build;
            QueryExpressionDSL.this.whereModel = this.buildWhereModel();
            QueryExpressionDSL.this.selectDSL.addQueryExpression(QueryExpressionDSL.this.buildModel());
            QueryExpressionDSL.this.selectDSL.setOrderByModel(OrderByModel.of(columns));
            return QueryExpressionDSL.this.selectDSL;
        }

        public GroupByFinisher groupBy(BasicColumn ... columns) {
            QueryExpressionDSL.this.groupByModel = GroupByModel.of(columns);
            QueryExpressionDSL.this.whereModel = this.buildWhereModel();
            QueryExpressionDSL.this.selectDSL.addQueryExpression(QueryExpressionDSL.this.buildModel());
            return new GroupByFinisher();
        }

        public SelectDSL.LimitFinisher limit(long limit) {
            QueryExpressionDSL.this.buildDelegateMethod = QueryExpressionDSL.this.selectDSL::build;
            QueryExpressionDSL.this.whereModel = this.buildWhereModel();
            QueryExpressionDSL.this.selectDSL.addQueryExpression(QueryExpressionDSL.this.buildModel());
            return QueryExpressionDSL.this.selectDSL.limit(limit);
        }

        public SelectDSL.OffsetFirstFinisher offset(long offset) {
            QueryExpressionDSL.this.buildDelegateMethod = QueryExpressionDSL.this.selectDSL::build;
            QueryExpressionDSL.this.whereModel = this.buildWhereModel();
            QueryExpressionDSL.this.selectDSL.addQueryExpression(QueryExpressionDSL.this.buildModel());
            return QueryExpressionDSL.this.selectDSL.offset(offset);
        }

        public SelectDSL.FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            QueryExpressionDSL.this.buildDelegateMethod = QueryExpressionDSL.this.selectDSL::build;
            QueryExpressionDSL.this.whereModel = this.buildWhereModel();
            QueryExpressionDSL.this.selectDSL.addQueryExpression(QueryExpressionDSL.this.buildModel());
            return QueryExpressionDSL.this.selectDSL.fetchFirst(fetchFirstRows);
        }

        @Override
        public R build() {
            return QueryExpressionDSL.this.buildDelegateMethod.get();
        }

        private R internalBuild() {
            QueryExpressionDSL.this.whereModel = this.buildWhereModel();
            QueryExpressionDSL.this.selectDSL.addQueryExpression(QueryExpressionDSL.this.buildModel());
            return QueryExpressionDSL.this.selectDSL.build();
        }

        @Override
        protected QueryExpressionWhereBuilder getThis() {
            return this;
        }
    }

    public static class FromGatherer<R> {
        private String connector;
        private BasicColumn[] selectList;
        private SelectDSL<R> selectDSL;
        private boolean isDistinct;
        private SqlTable table;
        private Optional<QueryExpressionDSL<R>> priorQuery;

        public FromGatherer(Builder<R> builder) {
            this.connector = ((Builder)builder).connector;
            this.selectList = Objects.requireNonNull(((Builder)builder).selectList);
            this.selectDSL = Objects.requireNonNull(((Builder)builder).selectDSL);
            this.isDistinct = ((Builder)builder).isDistinct;
            this.priorQuery = Optional.ofNullable(((Builder)builder).priorQuery);
        }

        public QueryExpressionDSL<R> from(SqlTable table) {
            this.table = table;
            return this.setPriorBuildDelegate(new QueryExpressionDSL(this));
        }

        public QueryExpressionDSL<R> from(SqlTable table, String tableAlias) {
            this.table = table;
            return this.setPriorBuildDelegate(new QueryExpressionDSL(this, tableAlias));
        }

        private QueryExpressionDSL<R> setPriorBuildDelegate(QueryExpressionDSL<R> newQuery) {
            this.priorQuery.ifPresent(pq -> ((QueryExpressionDSL)pq).buildDelegateMethod = newQuery::build);
            return newQuery;
        }

        public static class Builder<R> {
            private String connector;
            private BasicColumn[] selectList;
            private SelectDSL<R> selectDSL;
            private boolean isDistinct;
            private QueryExpressionDSL<R> priorQuery;

            public Builder<R> withConnector(String connector) {
                this.connector = connector;
                return this;
            }

            public Builder<R> withSelectList(BasicColumn[] selectList) {
                this.selectList = selectList;
                return this;
            }

            public Builder<R> withSelectDSL(SelectDSL<R> selectDSL) {
                this.selectDSL = selectDSL;
                return this;
            }

            public Builder<R> isDistinct() {
                this.isDistinct = true;
                return this;
            }

            public Builder<R> withPriorQuery(QueryExpressionDSL<R> priorQuery) {
                this.priorQuery = priorQuery;
                return this;
            }

            public FromGatherer<R> build() {
                return new FromGatherer(this);
            }
        }
    }
}

