/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.Objects;
import java.util.function.Function;
import org.mybatis.dynamic.sql.insert.BatchInsertModel;
import org.mybatis.dynamic.sql.insert.render.BatchInsert;
import org.mybatis.dynamic.sql.insert.render.FieldAndValue;
import org.mybatis.dynamic.sql.insert.render.FieldAndValueCollector;
import org.mybatis.dynamic.sql.insert.render.ValuePhraseVisitor;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.InsertMapping;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class BatchInsertRenderer<T> {
    private BatchInsertModel<T> model;
    private RenderingStrategy renderingStrategy;

    private BatchInsertRenderer(Builder<T> builder) {
        this.model = Objects.requireNonNull(((Builder)builder).model);
        this.renderingStrategy = Objects.requireNonNull(((Builder)builder).renderingStrategy);
    }

    public BatchInsert<T> render() {
        ValuePhraseVisitor visitor = new ValuePhraseVisitor(this.renderingStrategy);
        FieldAndValueCollector collector = this.model.mapColumnMappings(this.toFieldAndValue(visitor)).collect(FieldAndValueCollector.collect());
        return BatchInsert.withRecords(this.model.records()).withInsertStatement(this.calculateInsertStatement(collector)).build();
    }

    private Function<InsertMapping, FieldAndValue> toFieldAndValue(ValuePhraseVisitor visitor) {
        return insertMapping -> this.toFieldAndValue(visitor, (InsertMapping)insertMapping);
    }

    private FieldAndValue toFieldAndValue(ValuePhraseVisitor visitor, InsertMapping insertMapping) {
        return insertMapping.accept(visitor);
    }

    private String calculateInsertStatement(FieldAndValueCollector<T> collector) {
        return "insert into" + StringUtilities.spaceBefore(this.model.table().tableNameAtRuntime()) + StringUtilities.spaceBefore(collector.columnsPhrase()) + StringUtilities.spaceBefore(collector.valuesPhrase());
    }

    public static <T> Builder<T> withBatchInsertModel(BatchInsertModel<T> model) {
        return new Builder<T>().withBatchInsertModel(model);
    }

    public static class Builder<T> {
        private BatchInsertModel<T> model;
        private RenderingStrategy renderingStrategy;

        public Builder<T> withBatchInsertModel(BatchInsertModel<T> model) {
            this.model = model;
            return this;
        }

        public Builder<T> withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public BatchInsertRenderer<T> build() {
            return new BatchInsertRenderer(this);
        }
    }
}

