/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.delete.render;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DefaultDeleteStatementProvider;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.util.StringUtilities;
import org.mybatis.dynamic.sql.where.WhereModel;
import org.mybatis.dynamic.sql.where.render.WhereClauseProvider;
import org.mybatis.dynamic.sql.where.render.WhereRenderer;

public class DeleteRenderer {
    private DeleteModel deleteModel;
    private RenderingStrategy renderingStrategy;

    private DeleteRenderer(Builder builder) {
        this.deleteModel = Objects.requireNonNull(builder.deleteModel);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
    }

    public DeleteStatementProvider render() {
        Optional<WhereClauseProvider> whereClause = this.deleteModel.whereModel().flatMap(this::renderWhereClause);
        return DefaultDeleteStatementProvider.withDeleteStatement(this.calculateDeleteStatement(whereClause)).withParameters(this.calculateParameters(whereClause)).build();
    }

    private Optional<WhereClauseProvider> renderWhereClause(WhereModel whereModel) {
        return WhereRenderer.withWhereModel(whereModel).withRenderingStrategy(this.renderingStrategy).withSequence(new AtomicInteger(1)).withTableAliasCalculator(TableAliasCalculator.empty()).build().render();
    }

    private String calculateDeleteStatement(Optional<WhereClauseProvider> whereClause) {
        return "delete from" + StringUtilities.spaceBefore(this.deleteModel.table().tableNameAtRuntime()) + StringUtilities.spaceBefore(whereClause.map(WhereClauseProvider::getWhereClause));
    }

    private Map<String, Object> calculateParameters(Optional<WhereClauseProvider> whereClause) {
        return whereClause.map(WhereClauseProvider::getParameters).orElse(Collections.emptyMap());
    }

    public static Builder withDeleteModel(DeleteModel deleteModel) {
        return new Builder().withDeleteModel(deleteModel);
    }

    public static class Builder {
        private DeleteModel deleteModel;
        private RenderingStrategy renderingStrategy;

        public Builder withDeleteModel(DeleteModel deleteModel) {
            this.deleteModel = deleteModel;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public DeleteRenderer build() {
            return new DeleteRenderer(this);
        }
    }
}

