/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.sql.JDBCType;
import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;

public class SqlColumn<T>
implements BindableColumn<T>,
SortSpecification {
    protected String name;
    protected SqlTable table;
    protected JDBCType jdbcType;
    protected boolean isDescending = false;
    protected String alias;
    protected String typeHandler;

    private SqlColumn(Builder builder) {
        this.name = Objects.requireNonNull(builder.name);
        this.jdbcType = builder.jdbcType;
        this.table = Objects.requireNonNull(builder.table);
        this.typeHandler = builder.typeHandler;
    }

    protected SqlColumn(SqlColumn<?> sqlColumn) {
        this.name = sqlColumn.name;
        this.table = sqlColumn.table;
        this.jdbcType = sqlColumn.jdbcType;
        this.isDescending = sqlColumn.isDescending;
        this.alias = sqlColumn.alias;
        this.typeHandler = sqlColumn.typeHandler;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Optional<JDBCType> jdbcType() {
        return Optional.ofNullable(this.jdbcType);
    }

    @Override
    public Optional<String> alias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    public Optional<String> typeHandler() {
        return Optional.ofNullable(this.typeHandler);
    }

    @Override
    public SortSpecification descending() {
        SqlColumn<T> column = new SqlColumn<T>(this);
        column.isDescending = true;
        return column;
    }

    @Override
    public SqlColumn<T> as(String alias) {
        SqlColumn<T> column = new SqlColumn<T>(this);
        column.alias = alias;
        return column;
    }

    @Override
    public boolean isDescending() {
        return this.isDescending;
    }

    @Override
    public String aliasOrName() {
        return this.alias().orElse(this.name);
    }

    @Override
    public String renderWithTableAlias(TableAliasCalculator tableAliasCalculator) {
        return tableAliasCalculator.aliasForColumn(this.table).map(this::applyTableAlias).orElseGet(this::name);
    }

    public <S> SqlColumn<S> withTypeHandler(String typeHandler) {
        SqlColumn<T> column = new SqlColumn<T>(this);
        column.typeHandler = typeHandler;
        return column;
    }

    private String applyTableAlias(String tableAlias) {
        return tableAlias + "." + this.name();
    }

    public static <T> SqlColumn<T> of(String name, SqlTable table) {
        return SqlColumn.withName(name).withTable(table).build();
    }

    public static <T> SqlColumn<T> of(String name, SqlTable table, JDBCType jdbcType) {
        return SqlColumn.withName(name).withTable(table).withJdbcType(jdbcType).build();
    }

    public static Builder withName(String name) {
        return new Builder().withName(name);
    }

    public static class Builder {
        private SqlTable table;
        private String name;
        private JDBCType jdbcType;
        private String typeHandler;

        public Builder withTable(SqlTable table) {
            this.table = table;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withJdbcType(JDBCType jdbcType) {
            this.jdbcType = jdbcType;
            return this;
        }

        public Builder withTypeHandler(String typeHandler) {
            this.typeHandler = typeHandler;
            return this;
        }

        public <T> SqlColumn<T> build() {
            return new SqlColumn(this);
        }
    }
}

