/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.mybatis.dynamic.sql.ConditionVisitor;
import org.mybatis.dynamic.sql.VisitableCondition;

public abstract class AbstractTwoValueCondition<T>
implements VisitableCondition<T> {
    protected Supplier<T> valueSupplier1;
    protected Supplier<T> valueSupplier2;
    private BiPredicate<T, T> predicate;

    protected AbstractTwoValueCondition(Supplier<T> valueSupplier1, Supplier<T> valueSupplier2) {
        this.valueSupplier1 = Objects.requireNonNull(valueSupplier1);
        this.valueSupplier2 = Objects.requireNonNull(valueSupplier2);
        this.predicate = (v1, v2) -> true;
    }

    protected AbstractTwoValueCondition(Supplier<T> valueSupplier1, Supplier<T> valueSupplier2, BiPredicate<T, T> predicate) {
        this(valueSupplier1, valueSupplier2);
        this.predicate = Objects.requireNonNull(predicate);
    }

    public T value1() {
        return this.valueSupplier1.get();
    }

    public T value2() {
        return this.valueSupplier2.get();
    }

    @Override
    public boolean shouldRender() {
        return this.predicate.test(this.value1(), this.value2());
    }

    @Override
    public <R> R accept(ConditionVisitor<T, R> visitor) {
        return visitor.visit(this);
    }

    public abstract String renderCondition(String var1, String var2, String var3);
}

