/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.mybatis.dynamic.sql.ConditionVisitor;
import org.mybatis.dynamic.sql.VisitableCondition;

public abstract class AbstractSingleValueCondition<T>
implements VisitableCondition<T> {
    protected Supplier<T> valueSupplier;
    private Predicate<T> predicate;

    protected AbstractSingleValueCondition(Supplier<T> valueSupplier) {
        this.valueSupplier = Objects.requireNonNull(valueSupplier);
        this.predicate = v -> true;
    }

    protected AbstractSingleValueCondition(Supplier<T> valueSupplier, Predicate<T> predicate) {
        this.valueSupplier = Objects.requireNonNull(valueSupplier);
        this.predicate = Objects.requireNonNull(predicate);
    }

    public T value() {
        return this.valueSupplier.get();
    }

    @Override
    public boolean shouldRender() {
        return this.predicate.test(this.value());
    }

    @Override
    public <R> R accept(ConditionVisitor<T, R> visitor) {
        return visitor.visit(this);
    }

    public abstract String renderCondition(String var1, String var2);
}

