/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.util.ClassUtils;

public class XStreamFactory {
    public static final String XSTREAM_DOM_DRIVER = "com.thoughtworks.xstream.io.xml.DomDriver";
    public static final String XSTREAM_DOM4J_DRIVER = "com.thoughtworks.xstream.io.xml.Dom4JDriver";
    public static final String XSTREAM_JDOM_DRIVER = "com.thoughtworks.xstream.io.xml.JDomDriver";
    public static final String XSTREAM_STAX_DRIVER = "com.thoughtworks.xstream.io.xml.StaxDriver";
    public static final String XSTREAM_XPP_DRIVER = "com.thoughtworks.xstream.io.xml.XppDriver";
    private final XStream xstream;

    public XStreamFactory() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this(XSTREAM_XPP_DRIVER, null, null);
    }

    public XStreamFactory(String driverClassName, Map aliases, List converters) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Iterator iterator;
        Class driverClass = ClassUtils.loadClass((String)driverClassName, this.getClass());
        this.xstream = new XStream((HierarchicalStreamDriver)driverClass.newInstance());
        this.xstream.registerConverter((Converter)new ConcurrentHashMapConverter((Mapper)this.xstream.getClassMapper()), -1);
        if (aliases != null) {
            iterator = aliases.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Class aliasClass = ClassUtils.loadClass((String)entry.getValue().toString(), this.getClass());
                this.xstream.alias(entry.getKey().toString(), aliasClass);
            }
        }
        if (converters != null) {
            iterator = converters.iterator();
            while (iterator.hasNext()) {
                Class converterClazz = ClassUtils.loadClass((String)iterator.next().toString(), this.getClass());
                this.xstream.registerConverter((Converter)converterClazz.newInstance());
            }
        }
    }

    public final XStream getInstance() {
        return this.xstream;
    }

    private class ConcurrentHashMapConverter
    extends MapConverter {
        public ConcurrentHashMapConverter(Mapper mapper) throws ClassNotFoundException {
            super(mapper);
        }

        public boolean canConvert(Class aClass) {
            String className = aClass.getName();
            return className.equals("java.util.concurrent.ConcurrentHashMap") || className.equals("edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap");
        }
    }
}

