/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.stitch.server.services.mongodb.remote.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteCountOptions;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteDeleteResult;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteInsertManyResult;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteInsertOneResult;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteUpdateOptions;
import com.mongodb.stitch.core.services.mongodb.remote.RemoteUpdateResult;
import com.mongodb.stitch.core.services.mongodb.remote.internal.CoreRemoteMongoCollection;
import com.mongodb.stitch.server.services.mongodb.remote.RemoteAggregateIterable;
import com.mongodb.stitch.server.services.mongodb.remote.RemoteFindIterable;
import com.mongodb.stitch.server.services.mongodb.remote.RemoteMongoCollection;
import com.mongodb.stitch.server.services.mongodb.remote.internal.RemoteAggregateIterableImpl;
import com.mongodb.stitch.server.services.mongodb.remote.internal.RemoteFindIterableImpl;
import java.util.List;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class RemoteMongoCollectionImpl<DocumentT>
implements RemoteMongoCollection<DocumentT> {
    private final CoreRemoteMongoCollection<DocumentT> proxy;

    RemoteMongoCollectionImpl(CoreRemoteMongoCollection<DocumentT> coll) {
        this.proxy = coll;
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.proxy.getNamespace();
    }

    @Override
    public Class<DocumentT> getDocumentClass() {
        return this.proxy.getDocumentClass();
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.proxy.getCodecRegistry();
    }

    @Override
    public <NewDocumentT> RemoteMongoCollection<NewDocumentT> withDocumentClass(Class<NewDocumentT> clazz) {
        return new RemoteMongoCollectionImpl<DocumentT>(this.proxy.withDocumentClass(clazz));
    }

    @Override
    public RemoteMongoCollection<DocumentT> withCodecRegistry(CodecRegistry codecRegistry) {
        return new RemoteMongoCollectionImpl<DocumentT>(this.proxy.withCodecRegistry(codecRegistry));
    }

    @Override
    public long count() {
        return this.proxy.count();
    }

    @Override
    public long count(Bson filter) {
        return this.proxy.count(filter);
    }

    @Override
    public long count(Bson filter, RemoteCountOptions options) {
        return this.proxy.count(filter, options);
    }

    @Override
    public RemoteFindIterable<DocumentT> find() {
        return new RemoteFindIterableImpl(this.proxy.find());
    }

    @Override
    public <ResultT> RemoteFindIterable<ResultT> find(Class<ResultT> resultClass) {
        return new RemoteFindIterableImpl(this.proxy.find(resultClass));
    }

    @Override
    public RemoteFindIterable<DocumentT> find(Bson filter) {
        return new RemoteFindIterableImpl(this.proxy.find(filter));
    }

    @Override
    public <ResultT> RemoteFindIterable<ResultT> find(Bson filter, Class<ResultT> resultClass) {
        return new RemoteFindIterableImpl(this.proxy.find(filter, resultClass));
    }

    @Override
    public RemoteAggregateIterable<DocumentT> aggregate(List<? extends Bson> pipeline) {
        return new RemoteAggregateIterableImpl(this.proxy.aggregate(pipeline));
    }

    @Override
    public <ResultT> RemoteAggregateIterable<ResultT> aggregate(List<? extends Bson> pipeline, Class<ResultT> resultClass) {
        return new RemoteAggregateIterableImpl(this.proxy.aggregate(pipeline, resultClass));
    }

    @Override
    public RemoteInsertOneResult insertOne(DocumentT document) {
        return this.proxy.insertOne(document);
    }

    @Override
    public RemoteInsertManyResult insertMany(List<? extends DocumentT> documents) {
        return this.proxy.insertMany(documents);
    }

    @Override
    public RemoteDeleteResult deleteOne(Bson filter) {
        return this.proxy.deleteOne(filter);
    }

    @Override
    public RemoteDeleteResult deleteMany(Bson filter) {
        return this.proxy.deleteMany(filter);
    }

    @Override
    public RemoteUpdateResult updateOne(Bson filter, Bson update) {
        return this.proxy.updateOne(filter, update);
    }

    @Override
    public RemoteUpdateResult updateOne(Bson filter, Bson update, RemoteUpdateOptions updateOptions) {
        return this.proxy.updateOne(filter, update, updateOptions);
    }

    @Override
    public RemoteUpdateResult updateMany(Bson filter, Bson update) {
        return this.proxy.updateMany(filter, update);
    }

    @Override
    public RemoteUpdateResult updateMany(Bson filter, Bson update, RemoteUpdateOptions updateOptions) {
        return this.proxy.updateMany(filter, update, updateOptions);
    }
}

