/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClientException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteInsert;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptionDefaults;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.ValidationOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.CommandReadOperation;
import com.mongodb.internal.operation.CreateCollectionOperation;
import com.mongodb.internal.operation.CreateViewOperation;
import com.mongodb.internal.operation.DropDatabaseOperation;
import com.mongodb.internal.operation.IndexHelper;
import com.mongodb.internal.operation.Operations;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.internal.OperationExecutor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.UuidRepresentation;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.internal.CodecRegistryHelper;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public final class MongoOperationPublisher<T> {
    private final Operations<T> operations;
    private final UuidRepresentation uuidRepresentation;
    private final OperationExecutor executor;
    private static final Function<BulkWriteResult, InsertOneResult> INSERT_ONE_RESULT_MAPPER = result -> {
        if (result.wasAcknowledged()) {
            BsonValue insertedId = result.getInserts().isEmpty() ? null : ((BulkWriteInsert)result.getInserts().get(0)).getId();
            return InsertOneResult.acknowledged(insertedId);
        }
        return InsertOneResult.unacknowledged();
    };
    private static final Function<BulkWriteResult, InsertManyResult> INSERT_MANY_RESULT_MAPPER = result -> {
        if (result.wasAcknowledged()) {
            return InsertManyResult.acknowledged((Map)result.getInserts().stream().collect(HashMap::new, (m, v) -> m.put(v.getIndex(), v.getId()), HashMap::putAll));
        }
        return InsertManyResult.unacknowledged();
    };
    private static final Function<BulkWriteResult, DeleteResult> DELETE_RESULT_MAPPER = result -> {
        if (result.wasAcknowledged()) {
            return DeleteResult.acknowledged((long)result.getDeletedCount());
        }
        return DeleteResult.unacknowledged();
    };
    private static final Function<BulkWriteResult, UpdateResult> UPDATE_RESULT_MAPPER = result -> {
        if (result.wasAcknowledged()) {
            BsonValue upsertedId = result.getUpserts().isEmpty() ? null : ((BulkWriteUpsert)result.getUpserts().get(0)).getId();
            return UpdateResult.acknowledged((long)result.getMatchedCount(), (Long)Long.valueOf(result.getModifiedCount()), (BsonValue)upsertedId);
        }
        return UpdateResult.unacknowledged();
    };

    MongoOperationPublisher(Class<T> documentClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, UuidRepresentation uuidRepresentation, OperationExecutor executor) {
        this(new MongoNamespace("_ignored", "_ignored"), documentClass, codecRegistry, readPreference, readConcern, writeConcern, retryWrites, retryReads, uuidRepresentation, executor);
    }

    MongoOperationPublisher(MongoNamespace namespace, Class<T> documentClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, UuidRepresentation uuidRepresentation, OperationExecutor executor) {
        this.operations = new Operations(namespace, (Class)Assertions.notNull((String)"documentClass", documentClass), (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference), (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry), (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern), (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern), retryWrites, retryReads);
        this.uuidRepresentation = (UuidRepresentation)Assertions.notNull((String)"uuidRepresentation", (Object)uuidRepresentation);
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    MongoNamespace getNamespace() {
        return this.operations.getNamespace();
    }

    ReadPreference getReadPreference() {
        return this.operations.getReadPreference();
    }

    CodecRegistry getCodecRegistry() {
        return this.operations.getCodecRegistry();
    }

    ReadConcern getReadConcern() {
        return this.operations.getReadConcern();
    }

    WriteConcern getWriteConcern() {
        return this.operations.getWriteConcern();
    }

    public boolean getRetryWrites() {
        return this.operations.isRetryWrites();
    }

    public boolean getRetryReads() {
        return this.operations.isRetryReads();
    }

    Class<T> getDocumentClass() {
        return this.operations.getDocumentClass();
    }

    public Operations<T> getOperations() {
        return this.operations;
    }

    MongoOperationPublisher<T> withDatabase(String name) {
        return this.withDatabaseAndDocumentClass(name, this.getDocumentClass());
    }

    <D> MongoOperationPublisher<D> withDatabaseAndDocumentClass(String name, Class<D> documentClass) {
        return this.withNamespaceAndDocumentClass(new MongoNamespace((String)Assertions.notNull((String)"name", (Object)name), "ignored"), (Class)Assertions.notNull((String)"documentClass", documentClass));
    }

    MongoOperationPublisher<T> withNamespace(MongoNamespace namespace) {
        return this.withNamespaceAndDocumentClass(namespace, this.getDocumentClass());
    }

    <D> MongoOperationPublisher<D> withDocumentClass(Class<D> documentClass) {
        return this.withNamespaceAndDocumentClass(this.getNamespace(), documentClass);
    }

    <D> MongoOperationPublisher<D> withNamespaceAndDocumentClass(MongoNamespace namespace, Class<D> documentClass) {
        if (this.getNamespace().equals((Object)namespace) && this.getDocumentClass().equals(documentClass)) {
            return this;
        }
        return new MongoOperationPublisher<T>((MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace), (Class)Assertions.notNull((String)"documentClass", documentClass), this.getCodecRegistry(), this.getReadPreference(), this.getReadConcern(), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.executor);
    }

    MongoOperationPublisher<T> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), CodecRegistryHelper.createRegistry((CodecRegistry)((CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry)), (UuidRepresentation)this.uuidRepresentation), this.getReadPreference(), this.getReadConcern(), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.executor);
    }

    MongoOperationPublisher<T> withReadPreference(ReadPreference readPreference) {
        if (this.getReadPreference().equals(readPreference)) {
            return this;
        }
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), this.getCodecRegistry(), (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference), this.getReadConcern(), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.executor);
    }

    MongoOperationPublisher<T> withWriteConcern(WriteConcern writeConcern) {
        if (this.getWriteConcern().equals((Object)writeConcern)) {
            return this;
        }
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), this.getCodecRegistry(), this.getReadPreference(), this.getReadConcern(), (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.executor);
    }

    MongoOperationPublisher<T> withReadConcern(ReadConcern readConcern) {
        if (this.getReadConcern().equals((Object)readConcern)) {
            return this;
        }
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), this.getCodecRegistry(), this.getReadPreference(), (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.executor);
    }

    Publisher<Void> dropDatabase(@Nullable ClientSession clientSession) {
        return this.createWriteOperationMono(() -> new DropDatabaseOperation(this.getNamespace().getDatabaseName(), this.getWriteConcern()), clientSession);
    }

    Publisher<Void> createCollection(@Nullable ClientSession clientSession, MongoNamespace namespace, CreateCollectionOptions options) {
        return this.createWriteOperationMono(() -> {
            ValidationOptions validationOptions;
            Bson validator;
            CreateCollectionOperation operation = new CreateCollectionOperation(namespace.getDatabaseName(), namespace.getCollectionName(), this.getWriteConcern()).capped(options.isCapped()).sizeInBytes(options.getSizeInBytes()).maxDocuments(options.getMaxDocuments()).storageEngineOptions(this.toBsonDocument(options.getStorageEngineOptions())).collation(options.getCollation()).expireAfter(options.getExpireAfter(TimeUnit.SECONDS)).timeSeriesOptions(options.getTimeSeriesOptions());
            IndexOptionDefaults indexOptionDefaults = options.getIndexOptionDefaults();
            Bson storageEngine = indexOptionDefaults.getStorageEngine();
            if (storageEngine != null) {
                operation.indexOptionDefaults(new BsonDocument("storageEngine", (BsonValue)this.toBsonDocument(storageEngine)));
            }
            if ((validator = (validationOptions = options.getValidationOptions()).getValidator()) != null) {
                operation.validator(this.toBsonDocument(validator));
            }
            if (validationOptions.getValidationLevel() != null) {
                operation.validationLevel(validationOptions.getValidationLevel());
            }
            if (validationOptions.getValidationAction() != null) {
                operation.validationAction(validationOptions.getValidationAction());
            }
            return operation;
        }, clientSession);
    }

    Publisher<Void> createView(@Nullable ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions options) {
        List<BsonDocument> bsonDocumentPipeline = this.createBsonDocumentList((List)Assertions.notNull((String)"pipeline", pipeline));
        return this.createWriteOperationMono(() -> new CreateViewOperation(this.getNamespace().getDatabaseName(), (String)Assertions.notNull((String)"viewName", (Object)viewName), (String)Assertions.notNull((String)"viewOn", (Object)viewOn), bsonDocumentPipeline, this.getWriteConcern()).collation(((CreateViewOptions)Assertions.notNull((String)"options", (Object)options)).getCollation()), clientSession);
    }

    public <R> Publisher<R> runCommand(@Nullable ClientSession clientSession, Bson command, ReadPreference readPreference, Class<R> clazz) {
        if (clientSession != null && clientSession.hasActiveTransaction() && !readPreference.equals(ReadPreference.primary())) {
            return Mono.error((Throwable)new MongoClientException("Read preference in a transaction must be primary"));
        }
        return this.createReadOperationMono(() -> new CommandReadOperation(this.getNamespace().getDatabaseName(), this.toBsonDocument((Bson)Assertions.notNull((String)"command", (Object)command)), (Decoder)this.getCodecRegistry().get((Class)Assertions.notNull((String)"clazz", (Object)clazz))), clientSession, (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference));
    }

    Publisher<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return this.createReadOperationMono(() -> this.operations.estimatedDocumentCount((EstimatedDocumentCountOptions)Assertions.notNull((String)"options", (Object)options)), null);
    }

    Publisher<Long> countDocuments(@Nullable ClientSession clientSession, Bson filter, CountOptions options) {
        return this.createReadOperationMono(() -> this.operations.countDocuments((Bson)Assertions.notNull((String)"filter", (Object)filter), (CountOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<BulkWriteResult> bulkWrite(@Nullable ClientSession clientSession, List<? extends WriteModel<? extends T>> requests, BulkWriteOptions options) {
        return this.createWriteOperationMono(() -> this.operations.bulkWrite((List)Assertions.notNull((String)"requests", (Object)requests), (BulkWriteOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<InsertOneResult> insertOne(@Nullable ClientSession clientSession, T document, InsertOneOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.insertOne(Assertions.notNull((String)"document", (Object)document), (InsertOneOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.INSERT).map(INSERT_ONE_RESULT_MAPPER);
    }

    Publisher<InsertManyResult> insertMany(@Nullable ClientSession clientSession, List<? extends T> documents, InsertManyOptions options) {
        return this.createWriteOperationMono(() -> this.operations.insertMany((List)Assertions.notNull((String)"documents", (Object)documents), (InsertManyOptions)Assertions.notNull((String)"options", (Object)options)), clientSession).map(INSERT_MANY_RESULT_MAPPER);
    }

    Publisher<DeleteResult> deleteOne(@Nullable ClientSession clientSession, Bson filter, DeleteOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.deleteOne((Bson)Assertions.notNull((String)"filter", (Object)filter), (DeleteOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.DELETE).map(DELETE_RESULT_MAPPER);
    }

    Publisher<DeleteResult> deleteMany(@Nullable ClientSession clientSession, Bson filter, DeleteOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.deleteMany((Bson)Assertions.notNull((String)"filter", (Object)filter), (DeleteOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.DELETE).map(DELETE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> replaceOne(@Nullable ClientSession clientSession, Bson filter, T replacement, ReplaceOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.replaceOne((Bson)Assertions.notNull((String)"filter", (Object)filter), Assertions.notNull((String)"replacement", (Object)replacement), (ReplaceOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.REPLACE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateOne(@Nullable ClientSession clientSession, Bson filter, Bson update, UpdateOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateOne((Bson)Assertions.notNull((String)"filter", (Object)filter), (Bson)Assertions.notNull((String)"update", (Object)update), (UpdateOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateOne(@Nullable ClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateOne((Bson)Assertions.notNull((String)"filter", (Object)filter), (List)Assertions.notNull((String)"update", (Object)update), (UpdateOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateMany(@Nullable ClientSession clientSession, Bson filter, Bson update, UpdateOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateMany((Bson)Assertions.notNull((String)"filter", (Object)filter), (Bson)Assertions.notNull((String)"update", (Object)update), (UpdateOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateMany(@Nullable ClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateMany((Bson)Assertions.notNull((String)"filter", (Object)filter), (List)Assertions.notNull((String)"update", (Object)update), (UpdateOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<T> findOneAndDelete(@Nullable ClientSession clientSession, Bson filter, FindOneAndDeleteOptions options) {
        return this.createWriteOperationMono(() -> this.operations.findOneAndDelete((Bson)Assertions.notNull((String)"filter", (Object)filter), (FindOneAndDeleteOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<T> findOneAndReplace(@Nullable ClientSession clientSession, Bson filter, T replacement, FindOneAndReplaceOptions options) {
        return this.createWriteOperationMono(() -> this.operations.findOneAndReplace((Bson)Assertions.notNull((String)"filter", (Object)filter), Assertions.notNull((String)"replacement", (Object)replacement), (FindOneAndReplaceOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<T> findOneAndUpdate(@Nullable ClientSession clientSession, Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return this.createWriteOperationMono(() -> this.operations.findOneAndUpdate((Bson)Assertions.notNull((String)"filter", (Object)filter), (Bson)Assertions.notNull((String)"update", (Object)update), (FindOneAndUpdateOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<T> findOneAndUpdate(@Nullable ClientSession clientSession, Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return this.createWriteOperationMono(() -> this.operations.findOneAndUpdate((Bson)Assertions.notNull((String)"filter", (Object)filter), (List)Assertions.notNull((String)"update", (Object)update), (FindOneAndUpdateOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<Void> dropCollection(@Nullable ClientSession clientSession) {
        return this.createWriteOperationMono(() -> this.operations.dropCollection(), clientSession);
    }

    Publisher<String> createIndex(@Nullable ClientSession clientSession, Bson key, IndexOptions options) {
        return this.createIndexes(clientSession, Collections.singletonList(new IndexModel((Bson)Assertions.notNull((String)"key", (Object)key), options)), new CreateIndexOptions());
    }

    Publisher<String> createIndexes(@Nullable ClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions options) {
        return this.createWriteOperationMono(() -> this.operations.createIndexes((List)Assertions.notNull((String)"indexes", (Object)indexes), (CreateIndexOptions)Assertions.notNull((String)"options", (Object)options)), clientSession).thenMany((Publisher)Flux.fromIterable((Iterable)IndexHelper.getIndexNames(indexes, (CodecRegistry)this.getCodecRegistry())));
    }

    Publisher<Void> dropIndex(@Nullable ClientSession clientSession, String indexName, DropIndexOptions options) {
        return this.createWriteOperationMono(() -> this.operations.dropIndex((String)Assertions.notNull((String)"indexName", (Object)indexName), (DropIndexOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<Void> dropIndex(@Nullable ClientSession clientSession, Bson keys, DropIndexOptions options) {
        return this.createWriteOperationMono(() -> this.operations.dropIndex((Bson)Assertions.notNull((String)"keys", (Object)keys), (DropIndexOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<Void> dropIndexes(@Nullable ClientSession clientSession, DropIndexOptions options) {
        return this.dropIndex(clientSession, "*", options);
    }

    Publisher<Void> renameCollection(@Nullable ClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return this.createWriteOperationMono(() -> this.operations.renameCollection((MongoNamespace)Assertions.notNull((String)"newCollectionNamespace", (Object)newCollectionNamespace), (RenameCollectionOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    <R> Mono<R> createReadOperationMono(Supplier<AsyncReadOperation<R>> operation, @Nullable ClientSession clientSession) {
        return this.createReadOperationMono(operation, clientSession, this.getReadPreference());
    }

    <R> Mono<R> createReadOperationMono(Supplier<AsyncReadOperation<R>> operation, @Nullable ClientSession clientSession, ReadPreference readPreference) {
        AsyncReadOperation<R> readOperation = operation.get();
        return this.executor.execute(readOperation, readPreference, this.getReadConcern(), clientSession);
    }

    <R> Mono<R> createWriteOperationMono(Supplier<AsyncWriteOperation<R>> operation, @Nullable ClientSession clientSession) {
        AsyncWriteOperation<R> writeOperation = operation.get();
        return this.executor.execute(writeOperation, this.getReadConcern(), clientSession);
    }

    private Mono<BulkWriteResult> createSingleWriteRequestMono(Supplier<AsyncWriteOperation<BulkWriteResult>> operation, @Nullable ClientSession clientSession, WriteRequest.Type type) {
        return this.createWriteOperationMono(operation, clientSession).onErrorMap(MongoBulkWriteException.class, e -> {
            MongoWriteException exception;
            WriteConcernError writeConcernError = e.getWriteConcernError();
            if (e.getWriteErrors().isEmpty() && writeConcernError != null) {
                WriteConcernResult writeConcernResult = type == WriteRequest.Type.INSERT ? WriteConcernResult.acknowledged((int)e.getWriteResult().getInsertedCount(), (boolean)false, null) : (type == WriteRequest.Type.DELETE ? WriteConcernResult.acknowledged((int)e.getWriteResult().getDeletedCount(), (boolean)false, null) : WriteConcernResult.acknowledged((int)(e.getWriteResult().getMatchedCount() + e.getWriteResult().getUpserts().size()), (e.getWriteResult().getMatchedCount() > 0 ? 1 : 0) != 0, e.getWriteResult().getUpserts().isEmpty() ? null : ((BulkWriteUpsert)e.getWriteResult().getUpserts().get(0)).getId()));
                exception = new MongoWriteConcernException(writeConcernError, writeConcernResult, e.getServerAddress());
            } else {
                exception = !e.getWriteErrors().isEmpty() ? new MongoWriteException(new WriteError((WriteError)e.getWriteErrors().get(0)), e.getServerAddress()) : new MongoWriteException(new WriteError(-1, "Unknown write error", new BsonDocument()), e.getServerAddress());
            }
            for (String errorLabel : e.getErrorLabels()) {
                exception.addLabel(errorLabel);
            }
            return exception;
        });
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        if (pipeline.contains(null)) {
            throw new IllegalArgumentException("pipeline can not contain a null value");
        }
        return pipeline.stream().map(this::toBsonDocument).collect(Collectors.toList());
    }

    public static <T> SingleResultCallback<T> sinkToCallback(MonoSink<T> sink) {
        return (result, t) -> {
            if (t != null) {
                sink.error(t);
            } else if (result == null) {
                sink.success();
            } else {
                sink.success(result);
            }
        };
    }

    @Nullable
    private BsonDocument toBsonDocument(@Nullable Bson document) {
        return document == null ? null : document.toBsonDocument(BsonDocument.class, this.getCodecRegistry());
    }
}

