/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import com.mongodb.MongoInternalException;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsynchronousSocketChannelStreamFactoryFactory;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.connection.TlsChannelStreamFactoryFactory;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.DefaultClusterFactory;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.internal.MongoClientImpl;
import java.io.Closeable;
import java.util.List;
import org.bson.codecs.configuration.CodecRegistry;

public final class MongoClients {
    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, null);
    }

    public static MongoClient create(ConnectionString connectionString, MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(MongoClientSettings.builder().applyConnectionString(connectionString).build(), mongoDriverInformation);
    }

    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation) {
        if (settings.getStreamFactoryFactory() == null) {
            if (settings.getSslSettings().isEnabled()) {
                return MongoClients.createWithTlsChannel(settings, mongoDriverInformation);
            }
            return MongoClients.createWithAsynchronousSocketChannel(settings, mongoDriverInformation);
        }
        return MongoClients.createMongoClient(settings, mongoDriverInformation, MongoClients.getStreamFactory(settings, false), MongoClients.getStreamFactory(settings, true), null);
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        return MongoClientSettings.getDefaultCodecRegistry();
    }

    private static MongoClient createMongoClient(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, @Nullable Closeable externalResourceCloser) {
        return new MongoClientImpl(settings, MongoClients.createCluster(settings, MongoClients.wrapMongoDriverInformation(mongoDriverInformation), streamFactory, heartbeatStreamFactory), externalResourceCloser);
    }

    private static Cluster createCluster(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory) {
        Assertions.notNull((String)"settings", (Object)settings);
        return new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), streamFactory, heartbeatStreamFactory, settings.getCredential(), EventListenerHelper.getCommandListener((List)settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation, settings.getCompressorList());
    }

    private static MongoDriverInformation wrapMongoDriverInformation(MongoDriverInformation mongoDriverInformation) {
        return (mongoDriverInformation == null ? MongoDriverInformation.builder() : MongoDriverInformation.builder((MongoDriverInformation)mongoDriverInformation)).driverName("reactive-streams").build();
    }

    private static MongoClient createWithTlsChannel(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        TlsChannelStreamFactoryFactory streamFactoryFactory = new TlsChannelStreamFactoryFactory();
        StreamFactory streamFactory = streamFactoryFactory.create(settings.getSocketSettings(), settings.getSslSettings());
        StreamFactory heartbeatStreamFactory = streamFactoryFactory.create(settings.getHeartbeatSocketSettings(), settings.getSslSettings());
        return MongoClients.createMongoClient(settings, mongoDriverInformation, streamFactory, heartbeatStreamFactory, (Closeable)streamFactoryFactory);
    }

    private static MongoClient createWithAsynchronousSocketChannel(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        AsynchronousSocketChannelStreamFactoryFactory streamFactoryFactory = AsynchronousSocketChannelStreamFactoryFactory.builder().build();
        StreamFactory streamFactory = streamFactoryFactory.create(settings.getSocketSettings(), settings.getSslSettings());
        StreamFactory heartbeatStreamFactory = streamFactoryFactory.create(settings.getHeartbeatSocketSettings(), settings.getSslSettings());
        return MongoClients.createMongoClient(settings, mongoDriverInformation, streamFactory, heartbeatStreamFactory, null);
    }

    private static StreamFactory getStreamFactory(MongoClientSettings settings, boolean isHeartbeat) {
        StreamFactoryFactory streamFactoryFactory = settings.getStreamFactoryFactory();
        if (streamFactoryFactory == null) {
            throw new MongoInternalException("should not happen");
        }
        return streamFactoryFactory.create(isHeartbeat ? settings.getHeartbeatSocketSettings() : settings.getSocketSettings(), settings.getSslSettings());
    }

    private MongoClients() {
    }
}

