/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.Observables;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SingleResultObservableToPublisher<TResult>
implements Publisher<TResult> {
    private final ObservableToPublisher<TResult> observable;

    public SingleResultObservableToPublisher(Block<SingleResultCallback<TResult>> operation) {
        this.observable = new ObservableToPublisher(Observables.observe(operation));
    }

    public void subscribe(final Subscriber<? super TResult> subscriber) {
        this.observable.subscribe(new Subscriber<TResult>(){

            public void onSubscribe(Subscription s) {
                subscriber.onSubscribe(s);
            }

            public void onNext(TResult result) {
                subscriber.onNext(result);
            }

            public void onError(Throwable t) {
                if (t instanceof NullPointerException) {
                    this.onComplete();
                } else {
                    subscriber.onError(t);
                }
            }

            public void onComplete() {
                subscriber.onComplete();
            }
        });
    }
}

