/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.Observables;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.ListIndexesPublisher;
import com.mongodb.reactivestreams.client.MapReducePublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.Success;
import com.mongodb.reactivestreams.client.internal.AggregatePublisherImpl;
import com.mongodb.reactivestreams.client.internal.ChangeStreamPublisherImpl;
import com.mongodb.reactivestreams.client.internal.DistinctPublisherImpl;
import com.mongodb.reactivestreams.client.internal.FindPublisherImpl;
import com.mongodb.reactivestreams.client.internal.ListIndexesPublisherImpl;
import com.mongodb.reactivestreams.client.internal.MapReducePublisherImpl;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import com.mongodb.reactivestreams.client.internal.PublisherHelper;
import com.mongodb.reactivestreams.client.internal.SingleResultObservableToPublisher;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

final class MongoCollectionImpl<TDocument>
implements MongoCollection<TDocument> {
    private final com.mongodb.async.client.MongoCollection<TDocument> wrapped;

    MongoCollectionImpl(com.mongodb.async.client.MongoCollection<TDocument> wrapped) {
        this.wrapped = (com.mongodb.async.client.MongoCollection)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.wrapped.getNamespace();
    }

    @Override
    public Class<TDocument> getDocumentClass() {
        return this.wrapped.getDocumentClass();
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.wrapped.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.wrapped.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.wrapped.getReadConcern();
    }

    @Override
    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> clazz) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withDocumentClass(clazz));
    }

    @Override
    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withCodecRegistry(codecRegistry));
    }

    @Override
    public MongoCollection<TDocument> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withReadPreference(readPreference));
    }

    @Override
    public MongoCollection<TDocument> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withWriteConcern(writeConcern));
    }

    @Override
    public MongoCollection<TDocument> withReadConcern(ReadConcern readConcern) {
        return new MongoCollectionImpl<TDocument>(this.wrapped.withReadConcern(readConcern));
    }

    @Override
    @Deprecated
    public Publisher<Long> count() {
        return this.count((Bson)new BsonDocument(), new CountOptions());
    }

    @Override
    @Deprecated
    public Publisher<Long> count(Bson filter) {
        return this.count(filter, new CountOptions());
    }

    @Override
    @Deprecated
    public Publisher<Long> count(final Bson filter, final CountOptions options) {
        return new SingleResultObservableToPublisher<Long>(new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                MongoCollectionImpl.this.wrapped.count(filter, options, callback);
            }
        });
    }

    @Override
    @Deprecated
    public Publisher<Long> count(ClientSession clientSession) {
        return this.count(clientSession, (Bson)new BsonDocument(), new CountOptions());
    }

    @Override
    @Deprecated
    public Publisher<Long> count(ClientSession clientSession, Bson filter) {
        return this.count(clientSession, filter, new CountOptions());
    }

    @Override
    @Deprecated
    public Publisher<Long> count(final ClientSession clientSession, final Bson filter, final CountOptions options) {
        return new SingleResultObservableToPublisher<Long>(new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                MongoCollectionImpl.this.wrapped.count(clientSession.getWrapped(), filter, options, callback);
            }
        });
    }

    @Override
    public Publisher<Long> estimatedDocumentCount() {
        return this.estimatedDocumentCount(new EstimatedDocumentCountOptions());
    }

    @Override
    public Publisher<Long> estimatedDocumentCount(final EstimatedDocumentCountOptions options) {
        return new SingleResultObservableToPublisher<Long>(new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                MongoCollectionImpl.this.wrapped.estimatedDocumentCount(options, callback);
            }
        });
    }

    @Override
    public Publisher<Long> countDocuments() {
        return this.countDocuments((Bson)new BsonDocument());
    }

    @Override
    public Publisher<Long> countDocuments(Bson filter) {
        return this.countDocuments(filter, new CountOptions());
    }

    @Override
    public Publisher<Long> countDocuments(final Bson filter, final CountOptions options) {
        return new SingleResultObservableToPublisher<Long>(new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                MongoCollectionImpl.this.wrapped.countDocuments(filter, options, callback);
            }
        });
    }

    @Override
    public Publisher<Long> countDocuments(ClientSession clientSession) {
        return this.countDocuments(clientSession, (Bson)new BsonDocument());
    }

    @Override
    public Publisher<Long> countDocuments(ClientSession clientSession, Bson filter) {
        return this.countDocuments(clientSession, filter, new CountOptions());
    }

    @Override
    public Publisher<Long> countDocuments(final ClientSession clientSession, final Bson filter, final CountOptions options) {
        return new SingleResultObservableToPublisher<Long>(new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                MongoCollectionImpl.this.wrapped.countDocuments(clientSession.getWrapped(), filter, options, callback);
            }
        });
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        return this.distinct(fieldName, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(String fieldName, Bson filter, Class<TResult> resultClass) {
        return new DistinctPublisherImpl(this.wrapped.distinct(fieldName, resultClass)).filter(filter);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(ClientSession clientSession, String fieldName, Class<TResult> resultClass) {
        return this.distinct(clientSession, fieldName, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(ClientSession clientSession, String fieldName, Bson filter, Class<TResult> resultClass) {
        return new DistinctPublisherImpl(this.wrapped.distinct(clientSession.getWrapped(), fieldName, resultClass)).filter(filter);
    }

    @Override
    public FindPublisher<TDocument> find() {
        return this.find((Bson)new BsonDocument(), this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(Class<TResult> clazz) {
        return this.find((Bson)new BsonDocument(), clazz);
    }

    @Override
    public FindPublisher<TDocument> find(Bson filter) {
        return this.find(filter, this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(Bson filter, Class<TResult> clazz) {
        return new FindPublisherImpl(this.wrapped.find(filter, clazz));
    }

    @Override
    public FindPublisher<TDocument> find(ClientSession clientSession) {
        return this.find(clientSession, (Bson)new BsonDocument(), this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(ClientSession clientSession, Class<TResult> clazz) {
        return this.find(clientSession, (Bson)new BsonDocument(), clazz);
    }

    @Override
    public FindPublisher<TDocument> find(ClientSession clientSession, Bson filter) {
        return this.find(clientSession, filter, this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(ClientSession clientSession, Bson filter, Class<TResult> clazz) {
        return new FindPublisherImpl(this.wrapped.find(clientSession.getWrapped(), filter, clazz));
    }

    @Override
    public AggregatePublisher<Document> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, Document.class);
    }

    @Override
    public <TResult> AggregatePublisher<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> clazz) {
        return new AggregatePublisherImpl(this.wrapped.aggregate(pipeline, clazz));
    }

    @Override
    public AggregatePublisher<Document> aggregate(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.aggregate(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> AggregatePublisher<TResult> aggregate(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> clazz) {
        return new AggregatePublisherImpl(this.wrapped.aggregate(clientSession.getWrapped(), pipeline, clazz));
    }

    @Override
    public ChangeStreamPublisher<Document> watch() {
        return this.watch(Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamPublisherImpl(this.wrapped.watch(pipeline, resultClass));
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamPublisherImpl(this.wrapped.watch(clientSession.getWrapped(), pipeline, resultClass));
    }

    @Override
    public MapReducePublisher<Document> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, Document.class);
    }

    @Override
    public <TResult> MapReducePublisher<TResult> mapReduce(String mapFunction, String reduceFunction, Class<TResult> clazz) {
        return new MapReducePublisherImpl(this.wrapped.mapReduce(mapFunction, reduceFunction, clazz));
    }

    @Override
    public MapReducePublisher<Document> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction) {
        return this.mapReduce(clientSession, mapFunction, reduceFunction, Document.class);
    }

    @Override
    public <TResult> MapReducePublisher<TResult> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction, Class<TResult> clazz) {
        return new MapReducePublisherImpl(this.wrapped.mapReduce(clientSession.getWrapped(), mapFunction, reduceFunction, clazz));
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> requests) {
        return this.bulkWrite(requests, new BulkWriteOptions());
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(final List<? extends WriteModel<? extends TDocument>> requests, final BulkWriteOptions options) {
        return new SingleResultObservableToPublisher<BulkWriteResult>(new Block<SingleResultCallback<BulkWriteResult>>(){

            public void apply(SingleResultCallback<BulkWriteResult> callback) {
                MongoCollectionImpl.this.wrapped.bulkWrite(requests, options, callback);
            }
        });
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests) {
        return this.bulkWrite(clientSession, requests, new BulkWriteOptions());
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(final ClientSession clientSession, final List<? extends WriteModel<? extends TDocument>> requests, final BulkWriteOptions options) {
        return new SingleResultObservableToPublisher<BulkWriteResult>(new Block<SingleResultCallback<BulkWriteResult>>(){

            public void apply(SingleResultCallback<BulkWriteResult> callback) {
                MongoCollectionImpl.this.wrapped.bulkWrite(clientSession.getWrapped(), requests, options, callback);
            }
        });
    }

    @Override
    public Publisher<Success> insertOne(TDocument document) {
        return this.insertOne(document, new InsertOneOptions());
    }

    @Override
    public Publisher<Success> insertOne(final TDocument document, final InsertOneOptions options) {
        return new SingleResultObservableToPublisher<Success>(new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.insertOne(document, options, PublisherHelper.voidToSuccessCallback(callback));
            }
        });
    }

    @Override
    public Publisher<Success> insertOne(ClientSession clientSession, TDocument document) {
        return this.insertOne(clientSession, document, new InsertOneOptions());
    }

    @Override
    public Publisher<Success> insertOne(final ClientSession clientSession, final TDocument document, final InsertOneOptions options) {
        return new SingleResultObservableToPublisher<Success>(new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.insertOne(clientSession.getWrapped(), document, options, PublisherHelper.voidToSuccessCallback(callback));
            }
        });
    }

    @Override
    public Publisher<Success> insertMany(List<? extends TDocument> documents) {
        return this.insertMany(documents, new InsertManyOptions());
    }

    @Override
    public Publisher<Success> insertMany(final List<? extends TDocument> documents, final InsertManyOptions options) {
        return new SingleResultObservableToPublisher<Success>(new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.insertMany(documents, options, PublisherHelper.voidToSuccessCallback(callback));
            }
        });
    }

    @Override
    public Publisher<Success> insertMany(ClientSession clientSession, List<? extends TDocument> documents) {
        return this.insertMany(clientSession, documents, new InsertManyOptions());
    }

    @Override
    public Publisher<Success> insertMany(final ClientSession clientSession, final List<? extends TDocument> documents, final InsertManyOptions options) {
        return new SingleResultObservableToPublisher<Success>(new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.insertMany(clientSession.getWrapped(), documents, options, PublisherHelper.voidToSuccessCallback(callback));
            }
        });
    }

    @Override
    public Publisher<DeleteResult> deleteOne(Bson filter) {
        return this.deleteOne(filter, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteOne(final Bson filter, final DeleteOptions options) {
        return new SingleResultObservableToPublisher<DeleteResult>(new Block<SingleResultCallback<DeleteResult>>(){

            public void apply(SingleResultCallback<DeleteResult> callback) {
                MongoCollectionImpl.this.wrapped.deleteOne(filter, options, callback);
            }
        });
    }

    @Override
    public Publisher<DeleteResult> deleteOne(ClientSession clientSession, Bson filter) {
        return this.deleteOne(clientSession, filter, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteOne(final ClientSession clientSession, final Bson filter, final DeleteOptions options) {
        return new SingleResultObservableToPublisher<DeleteResult>(new Block<SingleResultCallback<DeleteResult>>(){

            public void apply(SingleResultCallback<DeleteResult> callback) {
                MongoCollectionImpl.this.wrapped.deleteOne(clientSession.getWrapped(), filter, options, callback);
            }
        });
    }

    @Override
    public Publisher<DeleteResult> deleteMany(Bson filter) {
        return this.deleteMany(filter, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteMany(final Bson filter, final DeleteOptions options) {
        return new SingleResultObservableToPublisher<DeleteResult>(new Block<SingleResultCallback<DeleteResult>>(){

            public void apply(SingleResultCallback<DeleteResult> callback) {
                MongoCollectionImpl.this.wrapped.deleteMany(filter, options, callback);
            }
        });
    }

    @Override
    public Publisher<DeleteResult> deleteMany(ClientSession clientSession, Bson filter) {
        return this.deleteMany(clientSession, filter, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteMany(final ClientSession clientSession, final Bson filter, final DeleteOptions options) {
        return new SingleResultObservableToPublisher<DeleteResult>(new Block<SingleResultCallback<DeleteResult>>(){

            public void apply(SingleResultCallback<DeleteResult> callback) {
                MongoCollectionImpl.this.wrapped.deleteMany(clientSession.getWrapped(), filter, options, callback);
            }
        });
    }

    @Override
    public Publisher<UpdateResult> replaceOne(Bson filter, TDocument replacement) {
        return this.replaceOne(filter, replacement, new ReplaceOptions());
    }

    @Override
    public Publisher<UpdateResult> replaceOne(final Bson filter, final TDocument replacement, final ReplaceOptions options) {
        return new SingleResultObservableToPublisher<UpdateResult>(new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.replaceOne(filter, replacement, options, callback);
            }
        });
    }

    @Override
    @Deprecated
    public Publisher<UpdateResult> replaceOne(final Bson filter, final TDocument replacement, final UpdateOptions options) {
        return new SingleResultObservableToPublisher<UpdateResult>(new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.replaceOne(filter, replacement, options, callback);
            }
        });
    }

    @Override
    public Publisher<UpdateResult> replaceOne(ClientSession clientSession, Bson filter, TDocument replacement) {
        return this.replaceOne(clientSession, filter, replacement, new ReplaceOptions());
    }

    @Override
    public Publisher<UpdateResult> replaceOne(final ClientSession clientSession, final Bson filter, final TDocument replacement, final ReplaceOptions options) {
        return new SingleResultObservableToPublisher<UpdateResult>(new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.replaceOne(clientSession.getWrapped(), filter, replacement, options, callback);
            }
        });
    }

    @Override
    @Deprecated
    public Publisher<UpdateResult> replaceOne(final ClientSession clientSession, final Bson filter, final TDocument replacement, final UpdateOptions options) {
        return new SingleResultObservableToPublisher<UpdateResult>(new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.replaceOne(clientSession.getWrapped(), filter, replacement, options, callback);
            }
        });
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter, Bson update) {
        return this.updateOne(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(final Bson filter, final Bson update, final UpdateOptions options) {
        return new SingleResultObservableToPublisher<UpdateResult>(new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.updateOne(filter, update, options, callback);
            }
        });
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter, Bson update) {
        return this.updateOne(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(final ClientSession clientSession, final Bson filter, final Bson update, final UpdateOptions options) {
        return new SingleResultObservableToPublisher<UpdateResult>(new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.updateOne(clientSession.getWrapped(), filter, update, options, callback);
            }
        });
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter, List<? extends Bson> update) {
        return this.updateOne(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(final Bson filter, final List<? extends Bson> update, final UpdateOptions options) {
        return new SingleResultObservableToPublisher<UpdateResult>(new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.updateOne(filter, update, options, callback);
            }
        });
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return this.updateOne(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(final ClientSession clientSession, final Bson filter, final List<? extends Bson> update, final UpdateOptions options) {
        return new SingleResultObservableToPublisher<UpdateResult>(new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.updateOne(clientSession.getWrapped(), filter, update, options, callback);
            }
        });
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter, Bson update) {
        return this.updateMany(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(final Bson filter, final Bson update, final UpdateOptions options) {
        return new SingleResultObservableToPublisher<UpdateResult>(new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.updateMany(filter, update, options, callback);
            }
        });
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter, Bson update) {
        return this.updateMany(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(final ClientSession clientSession, final Bson filter, final Bson update, final UpdateOptions options) {
        return new SingleResultObservableToPublisher<UpdateResult>(new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.updateMany(clientSession.getWrapped(), filter, update, options, callback);
            }
        });
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter, List<? extends Bson> update) {
        return this.updateMany(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(final Bson filter, final List<? extends Bson> update, final UpdateOptions options) {
        return new SingleResultObservableToPublisher<UpdateResult>(new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.updateMany(filter, update, options, callback);
            }
        });
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return this.updateMany(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(final ClientSession clientSession, final Bson filter, final List<? extends Bson> update, final UpdateOptions options) {
        return new SingleResultObservableToPublisher<UpdateResult>(new Block<SingleResultCallback<UpdateResult>>(){

            public void apply(SingleResultCallback<UpdateResult> callback) {
                MongoCollectionImpl.this.wrapped.updateMany(clientSession.getWrapped(), filter, update, options, callback);
            }
        });
    }

    @Override
    public Publisher<TDocument> findOneAndDelete(Bson filter) {
        return this.findOneAndDelete(filter, new FindOneAndDeleteOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndDelete(final Bson filter, final FindOneAndDeleteOptions options) {
        return new SingleResultObservableToPublisher(new Block<SingleResultCallback<TDocument>>(){

            public void apply(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndDelete(filter, options, callback);
            }
        });
    }

    @Override
    public Publisher<TDocument> findOneAndDelete(ClientSession clientSession, Bson filter) {
        return this.findOneAndDelete(clientSession, filter, new FindOneAndDeleteOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndDelete(final ClientSession clientSession, final Bson filter, final FindOneAndDeleteOptions options) {
        return new SingleResultObservableToPublisher(new Block<SingleResultCallback<TDocument>>(){

            public void apply(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndDelete(clientSession.getWrapped(), filter, options, callback);
            }
        });
    }

    @Override
    public Publisher<TDocument> findOneAndReplace(Bson filter, TDocument replacement) {
        return this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndReplace(final Bson filter, final TDocument replacement, final FindOneAndReplaceOptions options) {
        return new SingleResultObservableToPublisher(new Block<SingleResultCallback<TDocument>>(){

            public void apply(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndReplace(filter, replacement, options, callback);
            }
        });
    }

    @Override
    public Publisher<TDocument> findOneAndReplace(ClientSession clientSession, Bson filter, TDocument replacement) {
        return this.findOneAndReplace(clientSession, filter, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndReplace(final ClientSession clientSession, final Bson filter, final TDocument replacement, final FindOneAndReplaceOptions options) {
        return new SingleResultObservableToPublisher(new Block<SingleResultCallback<TDocument>>(){

            public void apply(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndReplace(clientSession.getWrapped(), filter, replacement, options, callback);
            }
        });
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(Bson filter, Bson update) {
        return this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(final Bson filter, final Bson update, final FindOneAndUpdateOptions options) {
        return new SingleResultObservableToPublisher(new Block<SingleResultCallback<TDocument>>(){

            public void apply(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndUpdate(filter, update, options, callback);
            }
        });
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(ClientSession clientSession, Bson filter, Bson update) {
        return this.findOneAndUpdate(clientSession, filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(final ClientSession clientSession, final Bson filter, final Bson update, final FindOneAndUpdateOptions options) {
        return new SingleResultObservableToPublisher(new Block<SingleResultCallback<TDocument>>(){

            public void apply(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndUpdate(clientSession.getWrapped(), filter, update, options, callback);
            }
        });
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(Bson filter, List<? extends Bson> update) {
        return this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(final Bson filter, final List<? extends Bson> update, final FindOneAndUpdateOptions options) {
        return new SingleResultObservableToPublisher(new Block<SingleResultCallback<TDocument>>(){

            public void apply(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndUpdate(filter, update, options, callback);
            }
        });
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return this.findOneAndUpdate(clientSession, filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<TDocument> findOneAndUpdate(final ClientSession clientSession, final Bson filter, final List<? extends Bson> update, final FindOneAndUpdateOptions options) {
        return new SingleResultObservableToPublisher(new Block<SingleResultCallback<TDocument>>(){

            public void apply(SingleResultCallback<TDocument> callback) {
                MongoCollectionImpl.this.wrapped.findOneAndUpdate(clientSession.getWrapped(), filter, update, options, callback);
            }
        });
    }

    @Override
    public Publisher<Success> drop() {
        return new SingleResultObservableToPublisher<Success>(new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.drop(PublisherHelper.voidToSuccessCallback(callback));
            }
        });
    }

    @Override
    public Publisher<Success> drop(final ClientSession clientSession) {
        return new SingleResultObservableToPublisher<Success>(new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.drop(clientSession.getWrapped(), PublisherHelper.voidToSuccessCallback(callback));
            }
        });
    }

    @Override
    public Publisher<String> createIndex(Bson key) {
        return this.createIndex(key, new IndexOptions());
    }

    @Override
    public Publisher<String> createIndex(final Bson key, final IndexOptions options) {
        return new SingleResultObservableToPublisher<String>(new Block<SingleResultCallback<String>>(){

            public void apply(SingleResultCallback<String> callback) {
                MongoCollectionImpl.this.wrapped.createIndex(key, options, callback);
            }
        });
    }

    @Override
    public Publisher<String> createIndex(ClientSession clientSession, Bson key) {
        return this.createIndex(clientSession, key, new IndexOptions());
    }

    @Override
    public Publisher<String> createIndex(final ClientSession clientSession, final Bson key, final IndexOptions options) {
        return new SingleResultObservableToPublisher<String>(new Block<SingleResultCallback<String>>(){

            public void apply(SingleResultCallback<String> callback) {
                MongoCollectionImpl.this.wrapped.createIndex(clientSession.getWrapped(), key, options, callback);
            }
        });
    }

    @Override
    public Publisher<String> createIndexes(List<IndexModel> indexes) {
        return this.createIndexes(indexes, new CreateIndexOptions());
    }

    @Override
    public Publisher<String> createIndexes(final List<IndexModel> indexes, final CreateIndexOptions createIndexOptions) {
        return new ObservableToPublisher<String>(Observables.observeAndFlatten((Block)new Block<SingleResultCallback<List<String>>>(){

            public void apply(SingleResultCallback<List<String>> callback) {
                MongoCollectionImpl.this.wrapped.createIndexes(indexes, createIndexOptions, callback);
            }
        }));
    }

    @Override
    public Publisher<String> createIndexes(ClientSession clientSession, List<IndexModel> indexes) {
        return this.createIndexes(clientSession, indexes, new CreateIndexOptions());
    }

    @Override
    public Publisher<String> createIndexes(final ClientSession clientSession, final List<IndexModel> indexes, final CreateIndexOptions createIndexOptions) {
        return new ObservableToPublisher<String>(Observables.observeAndFlatten((Block)new Block<SingleResultCallback<List<String>>>(){

            public void apply(SingleResultCallback<List<String>> callback) {
                MongoCollectionImpl.this.wrapped.createIndexes(clientSession.getWrapped(), indexes, createIndexOptions, callback);
            }
        }));
    }

    @Override
    public ListIndexesPublisher<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <TResult> ListIndexesPublisher<TResult> listIndexes(Class<TResult> clazz) {
        return new ListIndexesPublisherImpl(this.wrapped.listIndexes(clazz));
    }

    @Override
    public ListIndexesPublisher<Document> listIndexes(ClientSession clientSession) {
        return this.listIndexes(clientSession, Document.class);
    }

    @Override
    public <TResult> ListIndexesPublisher<TResult> listIndexes(ClientSession clientSession, Class<TResult> clazz) {
        return new ListIndexesPublisherImpl(this.wrapped.listIndexes(clientSession.getWrapped(), clazz));
    }

    @Override
    public Publisher<Success> dropIndex(String indexName) {
        return this.dropIndex(indexName, new DropIndexOptions());
    }

    @Override
    public Publisher<Success> dropIndex(Bson keys) {
        return this.dropIndex(keys, new DropIndexOptions());
    }

    @Override
    public Publisher<Success> dropIndex(final String indexName, final DropIndexOptions dropIndexOptions) {
        return new SingleResultObservableToPublisher<Success>(new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.dropIndex(indexName, dropIndexOptions, PublisherHelper.voidToSuccessCallback(callback));
            }
        });
    }

    @Override
    public Publisher<Success> dropIndex(final Bson keys, final DropIndexOptions dropIndexOptions) {
        return new SingleResultObservableToPublisher<Success>(new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.dropIndex(keys, dropIndexOptions, PublisherHelper.voidToSuccessCallback(callback));
            }
        });
    }

    @Override
    public Publisher<Success> dropIndex(ClientSession clientSession, String indexName) {
        return this.dropIndex(clientSession, indexName, new DropIndexOptions());
    }

    @Override
    public Publisher<Success> dropIndex(ClientSession clientSession, Bson keys) {
        return this.dropIndex(clientSession, keys, new DropIndexOptions());
    }

    @Override
    public Publisher<Success> dropIndex(final ClientSession clientSession, final String indexName, final DropIndexOptions dropIndexOptions) {
        return new SingleResultObservableToPublisher<Success>(new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.dropIndex(clientSession.getWrapped(), indexName, dropIndexOptions, PublisherHelper.voidToSuccessCallback(callback));
            }
        });
    }

    @Override
    public Publisher<Success> dropIndex(final ClientSession clientSession, final Bson keys, final DropIndexOptions dropIndexOptions) {
        return new SingleResultObservableToPublisher<Success>(new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.dropIndex(clientSession.getWrapped(), keys, dropIndexOptions, PublisherHelper.voidToSuccessCallback(callback));
            }
        });
    }

    @Override
    public Publisher<Success> dropIndexes() {
        return this.dropIndexes(new DropIndexOptions());
    }

    @Override
    public Publisher<Success> dropIndexes(DropIndexOptions dropIndexOptions) {
        return this.dropIndex("*", dropIndexOptions);
    }

    @Override
    public Publisher<Success> dropIndexes(ClientSession clientSession) {
        return this.dropIndexes(clientSession, new DropIndexOptions());
    }

    @Override
    public Publisher<Success> dropIndexes(ClientSession clientSession, DropIndexOptions dropIndexOptions) {
        return this.dropIndex(clientSession, "*", dropIndexOptions);
    }

    @Override
    public Publisher<Success> renameCollection(MongoNamespace newCollectionNamespace) {
        return this.renameCollection(newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public Publisher<Success> renameCollection(final MongoNamespace newCollectionNamespace, final RenameCollectionOptions options) {
        return new SingleResultObservableToPublisher<Success>(new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.renameCollection(newCollectionNamespace, options, PublisherHelper.voidToSuccessCallback(callback));
            }
        });
    }

    @Override
    public Publisher<Success> renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace) {
        return this.renameCollection(clientSession, newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public Publisher<Success> renameCollection(final ClientSession clientSession, final MongoNamespace newCollectionNamespace, final RenameCollectionOptions options) {
        return new SingleResultObservableToPublisher<Success>(new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoCollectionImpl.this.wrapped.renameCollection(clientSession.getWrapped(), newCollectionNamespace, options, PublisherHelper.voidToSuccessCallback(callback));
            }
        });
    }
}

