/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class QueryBuilder {
    private DBObject _query = new BasicDBObject();
    private String _currentKey;

    public static QueryBuilder start() {
        return new QueryBuilder();
    }

    public static QueryBuilder start(String key) {
        return new QueryBuilder().put(key);
    }

    public QueryBuilder put(String key) {
        this._currentKey = key;
        if (this._query.get(key) == null) {
            this._query.put(this._currentKey, new NullObject());
        }
        return this;
    }

    public QueryBuilder and(String key) {
        return this.put(key);
    }

    public QueryBuilder greaterThan(Object object) {
        this.addOperand("$gt", object);
        return this;
    }

    public QueryBuilder greaterThanEquals(Object object) {
        this.addOperand("$gte", object);
        return this;
    }

    public QueryBuilder lessThan(Object object) {
        this.addOperand("$lt", object);
        return this;
    }

    public QueryBuilder lessThanEquals(Object object) {
        this.addOperand("$lte", object);
        return this;
    }

    public QueryBuilder is(Object object) {
        this.addOperand(null, object);
        return this;
    }

    public QueryBuilder notEquals(Object object) {
        this.addOperand("$ne", object);
        return this;
    }

    public QueryBuilder in(Object object) {
        this.addOperand("$in", object);
        return this;
    }

    public QueryBuilder notIn(Object object) {
        this.addOperand("$nin", object);
        return this;
    }

    public QueryBuilder mod(Object object) {
        this.addOperand("$mod", object);
        return this;
    }

    public QueryBuilder all(Object object) {
        this.addOperand("$all", object);
        return this;
    }

    public QueryBuilder size(Object object) {
        this.addOperand("$size", object);
        return this;
    }

    public QueryBuilder exists(Object object) {
        this.addOperand("$exists", object);
        return this;
    }

    public QueryBuilder regex(Pattern regex) {
        this.addOperand(null, regex);
        return this;
    }

    public QueryBuilder withinCenter(double x, double y, double radius) {
        this.addOperand("$within", new BasicDBObject("$center", new Object[]{new Double[]{x, y}, radius}));
        return this;
    }

    public QueryBuilder near(double x, double y) {
        this.addOperand("$near", new Double[]{x, y});
        return this;
    }

    public QueryBuilder near(double x, double y, double maxDistance) {
        this.addOperand("$near", new Double[]{x, y, maxDistance});
        return this;
    }

    public QueryBuilder or(DBObject ... ors) {
        ArrayList<DBObject> l = (ArrayList<DBObject>)this._query.get("$or");
        if (l == null) {
            l = new ArrayList<DBObject>();
            this._query.put("$or", l);
        }
        for (DBObject o : ors) {
            l.add(o);
        }
        return this;
    }

    public DBObject get() {
        for (String key : this._query.keySet()) {
            if (!(this._query.get(key) instanceof NullObject)) continue;
            throw new QueryBuilderException("No operand for key:" + key);
        }
        return this._query;
    }

    private void addOperand(String op, Object value) {
        BasicDBObject operand;
        if (op == null) {
            this._query.put(this._currentKey, value);
            return;
        }
        Object storedValue = this._query.get(this._currentKey);
        if (!(storedValue instanceof DBObject)) {
            operand = new BasicDBObject();
            this._query.put(this._currentKey, operand);
        } else {
            operand = (BasicDBObject)this._query.get(this._currentKey);
        }
        operand.put(op, value);
    }

    private static class NullObject {
        private NullObject() {
        }
    }

    static class QueryBuilderException
    extends RuntimeException {
        QueryBuilderException(String message) {
            super(message);
        }
    }
}

