/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.character.Character;
import org.mockserver.dashboard.model.DashboardLogEntryDTO;

public class DashboardLogEntryDTOSerializer
extends StdSerializer<DashboardLogEntryDTO> {
    public DashboardLogEntryDTOSerializer() {
        super(DashboardLogEntryDTO.class);
    }

    public void serialize(DashboardLogEntryDTO logEntry, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeObjectField("key", (Object)logEntry.getId());
        jgen.writeObjectFieldStart("value");
        if (logEntry.getLogLevel() != null) {
            jgen.writeObjectField("logLevel", (Object)logEntry.getLogLevel());
        }
        if (logEntry.getTimestamp() != null) {
            jgen.writeObjectField("timestamp", (Object)logEntry.getTimestamp());
        }
        if (logEntry.getType() != null) {
            jgen.writeObjectField("type", (Object)logEntry.getType());
        }
        if (logEntry.getHttpRequests() != null) {
            jgen.writeObjectField("httpRequests", (Object)logEntry.getHttpRequests());
        }
        if (logEntry.getHttpResponse() != null) {
            jgen.writeObjectField("httpResponse", (Object)logEntry.getHttpResponse());
        }
        if (logEntry.getHttpError() != null) {
            jgen.writeObjectField("httpError", (Object)logEntry.getHttpError());
        }
        if (logEntry.getExpectation() != null) {
            jgen.writeObjectField("expectation", (Object)logEntry.getExpectation());
        }
        if (logEntry.getMessage() != null) {
            jgen.writeObjectField("message", (Object)logEntry.getMessage().replaceAll(" {2}", "   ").split(Character.NEW_LINE));
        }
        if (logEntry.getMessage() != null) {
            jgen.writeObjectField("messageFormat", (Object)logEntry.getMessageFormat());
        }
        if (logEntry.getMessage() != null) {
            jgen.writeObjectField("arguments", (Object)logEntry.getArguments());
        }
        if (logEntry.getThrowable() != null) {
            jgen.writeObjectField("throwable", (Object)logEntry.getThrowable());
        }
        jgen.writeEndObject();
        jgen.writeEndObject();
    }
}

