/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.smstpdu;

import org.mobicents.protocols.ss7.map.api.smstpdu.ConcatenatedShortMessagesIdentifier;

public class ConcatenatedShortMessagesIdentifierImpl
implements ConcatenatedShortMessagesIdentifier {
    private boolean referenceIs16bit;
    private int reference;
    private int mesageSegmentCount;
    private int mesageSegmentNumber;

    public ConcatenatedShortMessagesIdentifierImpl(boolean referenceIs16bit, int reference, int mesageSegmentCount, int mesageSegmentNumber) {
        this.referenceIs16bit = referenceIs16bit;
        this.reference = reference;
        this.mesageSegmentCount = mesageSegmentCount;
        this.mesageSegmentNumber = mesageSegmentNumber;
    }

    public ConcatenatedShortMessagesIdentifierImpl(byte[] encodedInformationElementData) {
        if (encodedInformationElementData == null || encodedInformationElementData.length < 3 || encodedInformationElementData.length > 4) {
            return;
        }
        if (encodedInformationElementData.length == 3) {
            this.referenceIs16bit = false;
            this.reference = encodedInformationElementData[0] & 0xFF;
            this.mesageSegmentCount = encodedInformationElementData[1] & 0xFF;
            this.mesageSegmentNumber = encodedInformationElementData[2] & 0xFF;
        } else {
            this.referenceIs16bit = true;
            this.reference = (encodedInformationElementData[0] & 0xFF) + ((encodedInformationElementData[1] & 0xFF) << 8);
            this.mesageSegmentCount = encodedInformationElementData[2] & 0xFF;
            this.mesageSegmentNumber = encodedInformationElementData[3] & 0xFF;
        }
    }

    public boolean getReferenceIs16bit() {
        return this.referenceIs16bit;
    }

    public int getReference() {
        return this.reference;
    }

    public int getMesageSegmentCount() {
        return this.mesageSegmentCount;
    }

    public int getMesageSegmentNumber() {
        return this.mesageSegmentNumber;
    }

    public int getEncodedInformationElementIdentifier() {
        if (this.getReferenceIs16bit()) {
            return 8;
        }
        return 0;
    }

    public byte[] getEncodedInformationElementData() {
        byte[] res = this.referenceIs16bit ? new byte[]{(byte)(this.reference & 0xFF), (byte)((this.reference & 0xFF00) >> 8), (byte)(this.mesageSegmentCount & 0xFF), (byte)(this.mesageSegmentNumber & 0xFF)} : new byte[]{(byte)(this.reference & 0xFF), (byte)(this.mesageSegmentCount & 0xFF), (byte)(this.mesageSegmentNumber & 0xFF)};
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConcatenatedShortMessagesIdentifier [");
        if (this.referenceIs16bit) {
            sb.append("Reference=16bit");
        } else {
            sb.append("Reference=8bit");
        }
        sb.append(", reference=");
        sb.append(this.reference);
        sb.append(", mesagePartsCount=");
        sb.append(this.mesageSegmentCount);
        sb.append(", mesagePartNumber=");
        sb.append(this.mesageSegmentNumber);
        sb.append("]");
        return sb.toString();
    }
}

