/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtSSStatus;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.MCSSInfo;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSCode;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtSSStatusImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSCodeImpl;

public class MCSSInfoImpl
extends SequenceBase
implements MCSSInfo {
    public static final int _TAG_ssCode = 0;
    public static final int _TAG_ssStatus = 1;
    public static final int _TAG_nbrSB = 2;
    public static final int _TAG_nbrUser = 3;
    public static final int _TAG_extensionContainer = 4;
    private SSCode ssCode;
    private ExtSSStatus ssStatus;
    private int nbrSB;
    private int nbrUser;
    private MAPExtensionContainer extensionContainer;

    public MCSSInfoImpl() {
        super("MCSSInfo");
    }

    public MCSSInfoImpl(SSCode ssCode, ExtSSStatus ssStatus, int nbrSB, int nbrUser, MAPExtensionContainer extensionContainer) {
        super("MCSSInfo");
        this.ssCode = ssCode;
        this.ssStatus = ssStatus;
        this.nbrSB = nbrSB;
        this.nbrUser = nbrUser;
        this.extensionContainer = extensionContainer;
    }

    public SSCode getSSCode() {
        return this.ssCode;
    }

    public ExtSSStatus getSSStatus() {
        return this.ssStatus;
    }

    public int getNbrSB() {
        return this.nbrSB;
    }

    public int getNbrUser() {
        return this.nbrUser;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ssCode = null;
        this.ssStatus = null;
        this.nbrSB = -1;
        this.nbrUser = -1;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (tag != 0 || ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ssCode: bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.ssCode = new SSCodeImpl();
                    ((SSCodeImpl)this.ssCode).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (tag != 1 || ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ssStatus: bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.ssStatus = new ExtSSStatusImpl();
                    ((ExtSSStatusImpl)this.ssStatus).decodeAll(ais);
                    break;
                }
                case 2: {
                    if (tag != 2 || ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".nbrSB: bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.nbrSB = (int)ais.readInteger();
                    break;
                }
                case 3: {
                    if (tag != 3 || ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".nbrUser: bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.nbrUser = (int)ais.readInteger();
                    break;
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 2: {
                            switch (tag) {
                                case 4: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break block0;
                        }
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (this.ssCode == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament ssCode is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.ssStatus == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament ssStatus is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.nbrSB == -1) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament nbrSB is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.nbrUser == -1) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament nbrUser is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.ssCode == null) {
            throw new MAPException("Error while encoding" + this._PrimitiveName + ": ssCode must not be null");
        }
        if (this.ssStatus == null) {
            throw new MAPException("Error while encoding" + this._PrimitiveName + ": ssStatus must not be null");
        }
        if (this.nbrSB < 2 || this.nbrSB > 7) {
            throw new MAPException("Error while encoding" + this._PrimitiveName + ": nbrSB value muct be between 2 and 7");
        }
        if (this.nbrUser < 1 || this.nbrUser > 7) {
            throw new MAPException("Error while encoding" + this._PrimitiveName + ": nbrUser value muct be between 1 and 7");
        }
        try {
            ((SSCodeImpl)this.ssCode).encodeAll(asnOs, 2, 0);
            ((ExtSSStatusImpl)this.ssStatus).encodeAll(asnOs, 2, 1);
            asnOs.writeInteger(2, 2, (long)this.nbrSB);
            asnOs.writeInteger(2, 3, (long)this.nbrUser);
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 4);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.ssCode != null) {
            sb.append("ssCode=");
            sb.append(this.ssCode.toString());
            sb.append(", ");
        }
        if (this.ssStatus != null) {
            sb.append("ssStatus=");
            sb.append(this.ssStatus.toString());
            sb.append(", ");
        }
        sb.append("nbrSB=");
        sb.append(this.nbrSB);
        sb.append(", ");
        sb.append("nbrUser=");
        sb.append(this.nbrUser);
        sb.append(", ");
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

