/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtForwFeature;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtForwInfo;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSCode;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtForwFeatureImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSCodeImpl;

public class ExtForwInfoImpl
extends SequenceBase
implements ExtForwInfo {
    private static final int _TAG_extensionContainer = 0;
    private SSCode ssCode = null;
    private ArrayList<ExtForwFeature> forwardingFeatureList = null;
    private MAPExtensionContainer extensionContainer = null;

    public ExtForwInfoImpl() {
        super("ExtForwInfo");
    }

    public ExtForwInfoImpl(SSCode ssCode, ArrayList<ExtForwFeature> forwardingFeatureList, MAPExtensionContainer extensionContainer) {
        super("ExtForwInfo");
        this.ssCode = ssCode;
        this.forwardingFeatureList = forwardingFeatureList;
        this.extensionContainer = extensionContainer;
    }

    public SSCode getSsCode() {
        return this.ssCode;
    }

    public ArrayList<ExtForwFeature> getForwardingFeatureList() {
        return this.forwardingFeatureList;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        ExtForwFeatureImpl featureItem = null;
        this.ssCode = null;
        this.forwardingFeatureList = null;
        this.extensionContainer = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || tag != 4 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ssCode: bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.ssCode = new SSCodeImpl();
                    ((SSCodeImpl)this.ssCode).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (ais.getTagClass() != 0 || tag != 16 || ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".forwardingFeatureList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    AsnInputStream ais2 = ais.readSequenceStream();
                    this.forwardingFeatureList = new ArrayList();
                    while (ais2.available() != 0) {
                        int tag2 = ais2.readTag();
                        if (tag2 != 16 || ais2.getTagClass() != 0 || ais2.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bad forwardingFeature tag or tagClass or is primitive ", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        featureItem = new ExtForwFeatureImpl();
                        featureItem.decodeAll(ais2);
                        this.forwardingFeatureList.add(featureItem);
                    }
                    if (this.forwardingFeatureList.size() >= 1 && this.forwardingFeatureList.size() <= 32) break;
                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter forwardingFeatureList size must be from 1 to 32, found: " + this.forwardingFeatureList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 2: {
                            switch (tag) {
                                case 0: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break block0;
                        }
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 2) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": ssCode, forwardingFeatureList are required but not found.", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.ssCode == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": ssCode required.");
        }
        if (this.forwardingFeatureList == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": forwardingFeatureList required.");
        }
        if (this.forwardingFeatureList.size() < 1 || this.forwardingFeatureList.size() > 32) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter forwardingFeatureList size must be from 1 to 32, found: " + this.forwardingFeatureList.size());
        }
        try {
            ((SSCodeImpl)this.ssCode).encodeAll(asnOs);
            asnOs.writeTag(0, false, 16);
            int pos = asnOs.StartContentDefiniteLength();
            for (ExtForwFeature featureItem : this.forwardingFeatureList) {
                ((ExtForwFeatureImpl)featureItem).encodeAll(asnOs);
            }
            asnOs.FinalizeContent(pos);
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 0);
            }
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.ssCode != null) {
            sb.append("ssCode=");
            sb.append(this.ssCode.toString());
            sb.append(", ");
        }
        if (this.forwardingFeatureList != null) {
            sb.append("forwardingFeatureList=[");
            boolean firstItem = true;
            for (ExtForwFeature be : this.forwardingFeatureList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("], ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

