/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.Time;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.APN;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.CSGId;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.CSGSubscriptionData;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.primitives.TimeImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.APNImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.CSGIdImpl;

public class CSGSubscriptionDataImpl
extends SequenceBase
implements CSGSubscriptionData {
    public static final int _TAG_LipaAllowedAPNList = 0;
    private CSGId csgId;
    private Time expirationDate;
    private MAPExtensionContainer extensionContainer;
    private ArrayList<APN> lipaAllowedAPNList;

    public CSGSubscriptionDataImpl() {
        super("CSGSubscriptionData");
    }

    public CSGSubscriptionDataImpl(CSGId csgId, Time expirationDate, MAPExtensionContainer extensionContainer, ArrayList<APN> lipaAllowedAPNList) {
        super("CSGSubscriptionData");
        this.csgId = csgId;
        this.expirationDate = expirationDate;
        this.extensionContainer = extensionContainer;
        this.lipaAllowedAPNList = lipaAllowedAPNList;
    }

    public CSGId getCsgId() {
        return this.csgId;
    }

    public Time getExpirationDate() {
        return this.expirationDate;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public ArrayList<APN> getLipaAllowedAPNList() {
        return this.lipaAllowedAPNList;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.csgId = null;
        this.expirationDate = null;
        this.extensionContainer = null;
        this.lipaAllowedAPNList = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (tag != 3 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".csgId : bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.csgId = new CSGIdImpl();
                    ((CSGIdImpl)this.csgId).decodeAll(ais);
                    break;
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 0: {
                            switch (tag) {
                                case 4: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".expirationDate: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.expirationDate = new TimeImpl();
                                    ((TimeImpl)this.expirationDate).decodeAll(ais);
                                    break block0;
                                }
                                case 16: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break block0;
                        }
                        case 2: {
                            switch (tag) {
                                case 0: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".lipaAllowedAPNList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.lipaAllowedAPNList = new ArrayList();
                                    AsnInputStream ais2 = ais.readSequenceStream();
                                    while (ais2.available() != 0) {
                                        int tag2 = ais2.readTag();
                                        if (tag2 != 4 || ais2.getTagClass() != 0 || !ais2.isTagPrimitive()) {
                                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bad tag or tagClass or is not primitive when decoding lipaAllowedAPNList", MAPParsingComponentExceptionReason.MistypedParameter);
                                        }
                                        APNImpl elem = new APNImpl();
                                        elem.decodeAll(ais2);
                                        this.lipaAllowedAPNList.add(elem);
                                        if (this.lipaAllowedAPNList.size() >= 1 && this.lipaAllowedAPNList.size() <= 50) continue;
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".lipaAllowedAPNList: elements count must be from 1 to 50, found: " + this.lipaAllowedAPNList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    break;
                                }
                                default: {
                                    ais.advanceElement();
                                    break;
                                }
                            }
                            break block0;
                        }
                        default: {
                            ais.advanceElement();
                        }
                    }
                }
            }
            ++num;
        }
        if (this.csgId == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament csgId is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.csgId == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter csgId is not defined");
        }
        if (this.lipaAllowedAPNList != null && (this.lipaAllowedAPNList.size() < 1 || this.lipaAllowedAPNList.size() > 50)) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter lipaAllowedAPNList size must be from 1 to 50, found: " + this.lipaAllowedAPNList.size());
        }
        try {
            if (this.csgId != null) {
                ((CSGIdImpl)this.csgId).encodeAll(asnOs);
            }
            if (this.expirationDate != null) {
                ((TimeImpl)this.expirationDate).encodeAll(asnOs);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
            if (this.lipaAllowedAPNList != null) {
                asnOs.writeTag(2, false, 0);
                int pos = asnOs.StartContentDefiniteLength();
                for (APN be : this.lipaAllowedAPNList) {
                    APNImpl bee = (APNImpl)be;
                    bee.encodeAll(asnOs);
                }
                asnOs.FinalizeContent(pos);
            }
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.csgId != null) {
            sb.append("csgId=");
            sb.append(this.csgId.toString());
            sb.append(", ");
        }
        if (this.expirationDate != null) {
            sb.append("expirationDate=");
            sb.append(this.expirationDate.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.lipaAllowedAPNList != null) {
            sb.append("lipaAllowedAPNList=[");
            boolean firstItem = true;
            for (APN be : this.lipaAllowedAPNList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("] ");
        }
        sb.append("]");
        return sb.toString();
    }
}

