/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.ClipData;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ExtSSStatus;
import org.mobicents.protocols.ss7.map.api.service.supplementary.OverrideCategory;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.ExtSSStatusImpl;

public class ClipDataImpl
extends SequenceBase
implements ClipData {
    private static final int _TAG_EXT_SS_STATUS = 1;
    private static final int _TAG_OVERRIDE_CATEGORY = 2;
    private static final int _TAG_NOTIFICATION_TO_CSE = 3;
    private ExtSSStatus ssStatus;
    private OverrideCategory overrideCategory;
    private boolean notificationToCSE;

    public ClipDataImpl() {
        super("ClipData");
    }

    public ClipDataImpl(ExtSSStatus ssStatus, OverrideCategory overrideCategory, boolean notificationToCSE) {
        super("ClipData");
        this.ssStatus = ssStatus;
        this.overrideCategory = overrideCategory;
        this.notificationToCSE = notificationToCSE;
    }

    public ExtSSStatus getSsStatus() {
        return this.ssStatus;
    }

    public OverrideCategory getOverrideCategory() {
        return this.overrideCategory;
    }

    public boolean getNotificationToCSE() {
        return this.notificationToCSE;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ssStatus = null;
        this.overrideCategory = null;
        this.notificationToCSE = false;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter ssStatus is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.ssStatus = new ExtSSStatusImpl();
                        ((ExtSSStatusImpl)this.ssStatus).decodeAll(ais);
                        break;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter overrideCategory is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int code = (int)ais.readInteger();
                        this.overrideCategory = OverrideCategory.getInstance((int)code);
                        break;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter notificationToCSE is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.notificationToCSE = Boolean.TRUE;
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.ssStatus == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + "ssStatus is mandatory but it is absent", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.overrideCategory == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + "overrideCategory is mandatory but it is absent", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.ssStatus == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter ssStatus is not defined");
        }
        if (this.overrideCategory == null) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + " the mandatory parameter overrideCategory is not defined");
        }
        ((ExtSSStatusImpl)this.ssStatus).encodeAll(asnOs, 2, 1);
        try {
            asnOs.writeInteger(2, 2, (long)this.overrideCategory.getCode());
            if (this.notificationToCSE) {
                asnOs.writeNull(2, 3);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.ssStatus != null) {
            sb.append("ssStatus=");
            sb.append(this.ssStatus);
        }
        if (this.overrideCategory != null) {
            sb.append(", overrideCategory=");
            sb.append(this.overrideCategory);
        }
        if (this.notificationToCSE) {
            sb.append(", notificationToCSE");
        }
        sb.append("]");
        return sb.toString();
    }
}

