/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.authentication;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AuthenticationTriplet;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class AuthenticationTripletImpl
implements AuthenticationTriplet,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "AuthenticationTriplet";
    private byte[] rand;
    private byte[] sres;
    private byte[] kc;

    public AuthenticationTripletImpl() {
    }

    public AuthenticationTripletImpl(byte[] rand, byte[] sres, byte[] kc) {
        this.rand = rand;
        this.sres = sres;
        this.kc = kc;
    }

    public byte[] getRand() {
        return this.rand;
    }

    public byte[] getSres() {
        return this.sres;
    }

    public byte[] getKc() {
        return this.kc;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AuthenticationTriplet: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AuthenticationTriplet: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AuthenticationTriplet: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AuthenticationTriplet: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.rand = null;
        this.sres = null;
        this.kc = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding AuthenticationTriplet.rand: Parameter 0 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.rand = ais.readOctetString();
                    if (this.rand.length == 16) break;
                    throw new MAPParsingComponentException("Error while decoding AuthenticationTriplet.rand: Bad field length: 16 is needed, found: " + this.rand.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                case 1: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding AuthenticationTriplet.sres: Parameter 1 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.sres = ais.readOctetString();
                    if (this.sres.length == 4) break;
                    throw new MAPParsingComponentException("Error while decoding AuthenticationTriplet.sres: Bad field length: 4 is needed, found: " + this.sres.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                case 2: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding AuthenticationTriplet.kc: Parameter 2 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.kc = ais.readOctetString();
                    if (this.kc.length == 8) break;
                    throw new MAPParsingComponentException("Error while decoding AuthenticationTriplet.kc: Bad field length: 8 is needed, found: " + this.kc.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
            }
            ++num;
        }
        if (num < 3) {
            throw new MAPParsingComponentException("Error while decoding AuthenticationTriplet: Needs at least 3 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AuthenticationTriplet: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.rand == null || this.sres == null || this.kc == null) {
            throw new MAPException("rand, sres and kc fields must not be null");
        }
        if (this.rand.length != 16) {
            throw new MAPException("Wrong rand field length: must be 16, found " + this.rand.length);
        }
        if (this.sres.length != 4) {
            throw new MAPException("Wrong sres field length: must be 4, found " + this.rand.length);
        }
        if (this.kc.length != 8) {
            throw new MAPException("Wrong kc field length: must be 8, found " + this.rand.length);
        }
        try {
            asnOs.writeOctetString(this.rand);
            asnOs.writeOctetString(this.sres);
            asnOs.writeOctetString(this.kc);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding AuthenticationTriplet: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AuthenticationTriplet: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AuthenticationTriplet [");
        if (this.rand != null) {
            sb.append("rand=[");
            sb.append(this.printDataArr(this.rand));
            sb.append("], ");
        }
        if (this.sres != null) {
            sb.append("sres=[");
            sb.append(this.printDataArr(this.sres));
            sb.append("], ");
        }
        if (this.kc != null) {
            sb.append("kc=[");
            sb.append(this.printDataArr(this.kc));
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }
}

