/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.callhandling;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.callhandling.CUGCheckInfo;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.CUGInterlock;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.CUGInterlockImpl;

public class CUGCheckInfoImpl
extends SequenceBase
implements CUGCheckInfo {
    private CUGInterlock cugInterlock;
    private boolean cugOutgoingAccess;
    private MAPExtensionContainer extensionContainer;

    public CUGCheckInfoImpl() {
        super("CUGCheckInfo");
    }

    public CUGCheckInfoImpl(CUGInterlock cugInterlock, boolean cugOutgoingAccess, MAPExtensionContainer extensionContainer) {
        super("CUGCheckInfo");
        this.cugInterlock = cugInterlock;
        this.cugOutgoingAccess = cugOutgoingAccess;
        this.extensionContainer = extensionContainer;
    }

    public CUGInterlock getCUGInterlock() {
        return this.cugInterlock;
    }

    public boolean getCUGOutgoingAccess() {
        return this.cugOutgoingAccess;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.cugInterlock = null;
        this.cugOutgoingAccess = false;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block11: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 0: {
                    switch (tag) {
                        case 4: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".cug-Interlock: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.cugInterlock = new CUGInterlockImpl();
                            ((CUGInterlockImpl)this.cugInterlock).decodeAll(ais);
                            continue block11;
                        }
                        case 5: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".cug-OutgoingAccess: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.cugOutgoingAccess = true;
                            ais.readNull();
                            continue block11;
                        }
                        case 16: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            continue block11;
                        }
                    }
                    ais.advanceElement();
                    continue block11;
                }
                case 2: {
                    switch (tag) {
                        default: 
                    }
                    ais.advanceElement();
                    continue block11;
                }
            }
            ais.advanceElement();
        }
        if (this.cugInterlock == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament cugInterlock is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.cugInterlock == null) {
                throw new MAPException("Error while encoding" + this._PrimitiveName + ": cugInterlock must not be null");
            }
            ((CUGInterlockImpl)this.cugInterlock).encodeAll(asnOs);
            if (this.cugOutgoingAccess) {
                asnOs.writeNull();
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.cugInterlock != null) {
            sb.append("cugInterlock=");
            sb.append(this.cugInterlock.toString());
        }
        if (this.cugOutgoingAccess) {
            sb.append(", cugOutgoingAccess");
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

