/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.errors;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.errors.AdditionalNetworkResource;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageSystemFailure;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.NetworkResource;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;

public class MAPErrorMessageSystemFailureImpl
extends MAPErrorMessageImpl
implements MAPErrorMessageSystemFailure {
    private static final String MAP_PROTOCOL_VERSION = "mapProtocolVersion";
    private static final String NETWORK_RESOURCE = "networkResource";
    private static final String ADDITIONAL_NETWORK_RESOURCE = "additionalNetworkResource";
    private static final String MAP_EXTENSION_CONTAINER = "mapExtensionContainer";
    public static final int additionalNetworkResource_TAG = 0;
    private long mapProtocolVersion;
    private NetworkResource networkResource;
    private AdditionalNetworkResource additionalNetworkResource;
    private MAPExtensionContainer extensionContainer;
    protected static final XMLFormat<MAPErrorMessageSystemFailureImpl> MAP_ERROR_MESSAGE_SYSTEM_FAILURE_XML = new XMLFormat<MAPErrorMessageSystemFailureImpl>(MAPErrorMessageSystemFailureImpl.class){

        public void read(XMLFormat.InputElement xml, MAPErrorMessageSystemFailureImpl errorMessage) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.read(xml, (Object)errorMessage);
            errorMessage.mapProtocolVersion = (Long)xml.get(MAPErrorMessageSystemFailureImpl.MAP_PROTOCOL_VERSION, Long.class);
            String str = (String)xml.get(MAPErrorMessageSystemFailureImpl.NETWORK_RESOURCE, String.class);
            if (str != null) {
                errorMessage.networkResource = Enum.valueOf(NetworkResource.class, str);
            }
            if ((str = (String)xml.get(MAPErrorMessageSystemFailureImpl.ADDITIONAL_NETWORK_RESOURCE, String.class)) != null) {
                errorMessage.additionalNetworkResource = Enum.valueOf(AdditionalNetworkResource.class, str);
            }
            errorMessage.extensionContainer = (MAPExtensionContainer)xml.get(MAPErrorMessageSystemFailureImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }

        public void write(MAPErrorMessageSystemFailureImpl errorMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.write((Object)errorMessage, xml);
            xml.add((Object)errorMessage.getMapProtocolVersion(), MAPErrorMessageSystemFailureImpl.MAP_PROTOCOL_VERSION, Long.class);
            if (errorMessage.getNetworkResource() != null) {
                xml.add((Object)errorMessage.getNetworkResource().toString(), MAPErrorMessageSystemFailureImpl.NETWORK_RESOURCE, String.class);
            }
            if (errorMessage.getAdditionalNetworkResource() != null) {
                xml.add((Object)errorMessage.getAdditionalNetworkResource().toString(), MAPErrorMessageSystemFailureImpl.ADDITIONAL_NETWORK_RESOURCE, String.class);
            }
            xml.add((Object)((MAPExtensionContainerImpl)errorMessage.extensionContainer), MAPErrorMessageSystemFailureImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }
    };

    public MAPErrorMessageSystemFailureImpl(long mapProtocolVersion, NetworkResource networkResource, AdditionalNetworkResource additionalNetworkResource, MAPExtensionContainer extensionContainer) {
        super(34L);
        this.mapProtocolVersion = mapProtocolVersion;
        this.networkResource = networkResource;
        this.additionalNetworkResource = additionalNetworkResource;
        this.extensionContainer = extensionContainer;
    }

    public MAPErrorMessageSystemFailureImpl() {
        super(34L);
    }

    @Override
    public boolean isEmSystemFailure() {
        return true;
    }

    @Override
    public MAPErrorMessageSystemFailure getEmSystemFailure() {
        return this;
    }

    public NetworkResource getNetworkResource() {
        return this.networkResource;
    }

    public AdditionalNetworkResource getAdditionalNetworkResource() {
        return this.additionalNetworkResource;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    public void setNetworkResource(NetworkResource networkResource) {
        this.networkResource = networkResource;
    }

    public void setAdditionalNetworkResource(AdditionalNetworkResource additionalNetworkResource) {
        this.additionalNetworkResource = additionalNetworkResource;
    }

    public void setExtensionContainer(MAPExtensionContainer extensionContainer) {
        this.extensionContainer = extensionContainer;
    }

    public void setMapProtocolVersion(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.mapProtocolVersion < 3L) {
            return 10;
        }
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return this.mapProtocolVersion < 3L;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MAPErrorMessageSystemFailure: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MAPErrorMessageSystemFailure: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MAPErrorMessageSystemFailure: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MAPErrorMessageSystemFailure: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream localAis, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.networkResource = null;
        this.additionalNetworkResource = null;
        this.extensionContainer = null;
        if (localAis.getTagClass() != 0) {
            throw new MAPParsingComponentException("Error decoding MAPErrorMessageSystemFailure: bad tag class", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (localAis.getTag()) {
            case 10: {
                if (!localAis.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageAbsentSubscriberSM: ENUMERATED tag but data is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                int code = (int)localAis.readIntegerData(length);
                this.networkResource = NetworkResource.getInstance((int)code);
                if (this.networkResource == null) {
                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageAbsentSubscriberSM.networkResource: bad code value", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                this.mapProtocolVersion = 2L;
                break;
            }
            case 16: {
                if (localAis.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageAbsentSubscriberSM: SEQUENCE tag but data is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                AsnInputStream ais = localAis.readSequenceStreamData(length);
                block15: while (ais.available() != 0) {
                    int tag = ais.readTag();
                    switch (ais.getTagClass()) {
                        case 0: {
                            int code;
                            switch (tag) {
                                case 10: {
                                    code = (int)ais.readInteger();
                                    this.networkResource = NetworkResource.getInstance((int)code);
                                    if (this.networkResource != null) continue block15;
                                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageAbsentSubscriberSM.networkResource: bad code value", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                case 16: {
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    continue block15;
                                }
                            }
                            ais.advanceElement();
                            continue block15;
                        }
                        case 2: {
                            int code;
                            switch (tag) {
                                case 0: {
                                    code = (int)ais.readInteger();
                                    this.additionalNetworkResource = AdditionalNetworkResource.getInstance((int)code);
                                    continue block15;
                                }
                            }
                            ais.advanceElement();
                            continue block15;
                        }
                    }
                    ais.advanceElement();
                }
                this.mapProtocolVersion = 3L;
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error decoding MAPErrorMessageSystemFailure: bad tag", MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        if (this.mapProtocolVersion < 3L) {
            this.encodeAll(asnOs, 0, 10);
        } else {
            this.encodeAll(asnOs, 0, 16);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            if (this.mapProtocolVersion < 3L) {
                asnOs.writeTag(tagClass, true, tag);
            } else {
                asnOs.writeTag(tagClass, false, tag);
            }
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MAPErrorMessageSystemFailure: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws MAPException {
        if (this.networkResource == null && this.additionalNetworkResource == null && this.extensionContainer == null) {
            return;
        }
        if (this.networkResource == null && this.mapProtocolVersion < 3L) {
            return;
        }
        try {
            if (this.mapProtocolVersion < 3L) {
                aos.writeIntegerData((long)this.networkResource.getCode());
            } else {
                if (this.networkResource != null) {
                    aos.writeInteger(0, 10, (long)this.networkResource.getCode());
                }
                if (this.extensionContainer != null) {
                    ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(aos);
                }
                if (this.additionalNetworkResource != null) {
                    aos.writeInteger(2, 0, (long)this.additionalNetworkResource.getCode());
                }
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding MAPErrorMessageSystemFailure: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MAPErrorMessageSystemFailure: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MAPErrorMessageSystemFailure [");
        if (this.networkResource != null) {
            sb.append("networkResource=" + this.networkResource.toString());
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=" + this.extensionContainer.toString());
        }
        if (this.additionalNetworkResource != null) {
            sb.append(", additionalNetworkResource=" + this.additionalNetworkResource.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

