/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.server.impl.app.rf;

import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.rf.events.RfAccountingRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Event
implements StateEvent {
    Type type;
    AppEvent data;

    Event(Type type) {
        this.type = type;
    }

    Event(RfAccountingRequest accountRequest) throws Exception {
        this.data = accountRequest;
        int type = accountRequest.getAccountingRecordType();
        switch (type) {
            case 1: {
                this.type = Type.RECEIVED_EVENT_RECORD;
                break;
            }
            case 2: {
                this.type = Type.RECEIVED_START_RECORD;
                break;
            }
            case 3: {
                this.type = Type.RECEIVED_INTERIM_RECORD;
                break;
            }
            case 4: {
                this.type = Type.RECEIVED_STOP_RECORD;
                break;
            }
            default: {
                throw new Exception("Unknown type " + type);
            }
        }
    }

    public <E> E encodeType(Class<E> eClass) {
        return (E)((Object)(eClass == Type.class ? this.type : null));
    }

    public Enum getType() {
        return this.type;
    }

    public void setData(Object o) {
        this.data = (AppEvent)o;
    }

    public Object getData() {
        return this.data;
    }

    public int compareTo(Object other) {
        return this.equals(other) ? 0 : -1;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        RECEIVED_EVENT_RECORD,
        RECEIVED_START_RECORD,
        RECEIVED_INTERIM_RECORD,
        RECEIVED_STOP_RECORD;

    }
}

