/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.jdiameter.common.api.statistic.IStatistic;
import org.jdiameter.common.api.statistic.IStatisticRecord;
import org.jdiameter.common.impl.concurrent.AbstractTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultCallable<L>
extends AbstractTask<Callable<L>>
implements Callable<L> {
    public DefaultCallable(Callable<L> task, IStatistic statistic, IStatisticRecord ... statisticRecords) {
        super(task, statistic, statisticRecords);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public L call() throws Exception {
        Object v;
        long time = 0L;
        if (this.statistic.isEnabled()) {
            this.getCounter(IStatisticRecord.Counters.WorkingThread).inc();
            time = System.nanoTime();
        }
        try {
            try {
                v = ((Callable)this.parentTask).call();
                Object var5_5 = null;
            }
            catch (CancellationException e) {
                if (!this.statistic.isEnabled()) throw e;
                this.getCounter(IStatisticRecord.Counters.CanceledTasks).inc();
                throw e;
            }
            catch (Exception e) {
                if (!this.statistic.isEnabled()) throw e;
                this.getCounter(IStatisticRecord.Counters.BrokenTasks).inc();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!this.statistic.isEnabled()) throw throwable;
            this.updateTimeStatistic(time, time - this.createdTime);
            this.getCounter(IStatisticRecord.Counters.WorkingThread).dec();
            throw throwable;
        }
        if (!this.statistic.isEnabled()) return (L)v;
        this.updateTimeStatistic(time, time - this.createdTime);
        this.getCounter(IStatisticRecord.Counters.WorkingThread).dec();
        return (L)v;
    }
}

