/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.sh;

import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.sh.ClientShSession;
import org.jdiameter.api.sh.ClientShSessionListener;
import org.jdiameter.api.sh.ServerShSession;
import org.jdiameter.api.sh.ServerShSessionListener;
import org.jdiameter.api.sh.events.ProfileUpdateAnswer;
import org.jdiameter.api.sh.events.ProfileUpdateRequest;
import org.jdiameter.api.sh.events.PushNotificationAnswer;
import org.jdiameter.api.sh.events.PushNotificationRequest;
import org.jdiameter.api.sh.events.SubscribeNotificationsAnswer;
import org.jdiameter.api.sh.events.SubscribeNotificationsRequest;
import org.jdiameter.api.sh.events.UserDataAnswer;
import org.jdiameter.api.sh.events.UserDataRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.sh.IShClientSessionData;
import org.jdiameter.client.impl.app.sh.ShClientSessionImpl;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.sh.IShMessageFactory;
import org.jdiameter.common.api.app.sh.IShSessionData;
import org.jdiameter.common.api.app.sh.IShSessionFactory;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.sh.ProfileUpdateAnswerImpl;
import org.jdiameter.common.impl.app.sh.ProfileUpdateRequestImpl;
import org.jdiameter.common.impl.app.sh.PushNotificationAnswerImpl;
import org.jdiameter.common.impl.app.sh.PushNotificationRequestImpl;
import org.jdiameter.common.impl.app.sh.ShLocalSessionDataFactory;
import org.jdiameter.common.impl.app.sh.ShSession;
import org.jdiameter.common.impl.app.sh.SubscribeNotificationsAnswerImpl;
import org.jdiameter.common.impl.app.sh.SubscribeNotificationsRequestImpl;
import org.jdiameter.common.impl.app.sh.UserDataAnswerImpl;
import org.jdiameter.common.impl.app.sh.UserDataRequestImpl;
import org.jdiameter.server.impl.app.sh.IShServerSessionData;
import org.jdiameter.server.impl.app.sh.ShServerSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShSessionFactoryImpl
implements IShSessionFactory,
StateChangeListener<AppSession>,
ClientShSessionListener,
ServerShSessionListener,
IShMessageFactory {
    protected Logger logger = LoggerFactory.getLogger(ShSessionFactoryImpl.class);
    protected ClientShSessionListener clientShSessionListener;
    protected ServerShSessionListener serverShSessionListener;
    protected IShMessageFactory messageFactory;
    protected StateChangeListener<AppSession> stateChangeListener;
    protected ISessionFactory sessionFactory;
    protected ISessionDatasource sessionDataSource;
    protected IAppSessionDataFactory<IShSessionData> sessionDataFactory;
    protected long messageTimeout = 10000L;
    protected static final long applicationId = 0x1000001L;

    public ShSessionFactoryImpl(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
        this.sessionDataSource = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        this.sessionDataFactory = this.sessionDataSource.getDataFactory(IShSessionData.class);
        if (this.sessionDataFactory == null) {
            this.logger.debug("No factory for Sh Application data, using default/local.");
            this.sessionDataFactory = new ShLocalSessionDataFactory();
        }
    }

    @Override
    public ClientShSessionListener getClientShSessionListener() {
        if (this.clientShSessionListener == null) {
            return this;
        }
        return this.clientShSessionListener;
    }

    @Override
    public void setClientShSessionListener(ClientShSessionListener clientShSessionListener) {
        this.clientShSessionListener = clientShSessionListener;
    }

    @Override
    public ServerShSessionListener getServerShSessionListener() {
        if (this.serverShSessionListener == null) {
            return this;
        }
        return this.serverShSessionListener;
    }

    @Override
    public void setServerShSessionListener(ServerShSessionListener serverShSessionListener) {
        this.serverShSessionListener = serverShSessionListener;
    }

    @Override
    public IShMessageFactory getMessageFactory() {
        if (this.messageFactory == null) {
            return this;
        }
        return this.messageFactory;
    }

    @Override
    public void setMessageFactory(IShMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public StateChangeListener<AppSession> getStateChangeListener() {
        return this.stateChangeListener;
    }

    @Override
    public void setStateChangeListener(StateChangeListener<AppSession> stateChangeListener) {
        this.stateChangeListener = stateChangeListener;
    }

    @Override
    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        try {
            if (aClass == ClientShSession.class) {
                ShClientSessionImpl clientSession = null;
                if (sessionId == null) {
                    if (args != null && args.length > 0 && args[0] instanceof Request) {
                        Request request = (Request)args[0];
                        sessionId = request.getSessionId();
                    } else {
                        sessionId = this.sessionFactory.getSessionId();
                    }
                }
                IShClientSessionData sessionData = (IShClientSessionData)this.sessionDataFactory.getAppSessionData(ClientShSession.class, sessionId);
                sessionData.setApplicationId(applicationId);
                clientSession = new ShClientSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientShSessionListener());
                this.sessionDataSource.addSession((BaseSession)clientSession);
                clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                return clientSession;
            }
            if (aClass == ServerShSession.class) {
                ShServerSessionImpl serverSession = null;
                if (sessionId == null) {
                    if (args != null && args.length > 0 && args[0] instanceof Request) {
                        Request request = (Request)args[0];
                        sessionId = request.getSessionId();
                    } else {
                        sessionId = this.sessionFactory.getSessionId();
                    }
                }
                IShServerSessionData sessionData = (IShServerSessionData)this.sessionDataFactory.getAppSessionData(ServerShSession.class, sessionId);
                sessionData.setApplicationId(applicationId);
                serverSession = new ShServerSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerShSessionListener());
                this.sessionDataSource.addSession((BaseSession)serverSession);
                serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                return serverSession;
            }
            throw new IllegalArgumentException("Wrong session class: [" + aClass + "]. Supported[" + ClientShSession.class + "]");
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            this.logger.error("Failure to obtain new Sh Session.", (Throwable)e);
            return null;
        }
    }

    @Override
    public AppSession getSession(String sessionId, Class<? extends AppSession> aClass) {
        ShSession appSession;
        block6: {
            if (sessionId == null) {
                throw new IllegalArgumentException("Session-Id must not be null");
            }
            if (!this.sessionDataSource.exists(sessionId)) {
                return null;
            }
            appSession = null;
            try {
                if (aClass == ServerShSession.class) {
                    IShServerSessionData sessionData = (IShServerSessionData)this.sessionDataFactory.getAppSessionData(ServerShSession.class, sessionId);
                    appSession = new ShServerSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerShSessionListener());
                    ((Session)appSession.getSessions().get(0)).setRequestListener((NetworkReqListener)appSession);
                    break block6;
                }
                if (aClass == ClientShSession.class) {
                    IShClientSessionData sessionData = (IShClientSessionData)this.sessionDataFactory.getAppSessionData(ClientShSession.class, sessionId);
                    appSession = new ShClientSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientShSessionListener());
                    ((Session)appSession.getSessions().get(0)).setRequestListener((NetworkReqListener)appSession);
                    break block6;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ServerShSession.class + "," + ClientShSession.class + "]");
            }
            catch (Exception e) {
                this.logger.error("Failure to obtain new Sh Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    public void stateChanged(Enum oldState, Enum newState) {
        this.logger.info("Diameter Sh SessionFactory :: stateChanged :: oldState[{}], newState[{}]", (Object)oldState, (Object)newState);
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.logger.info("Diameter Sh SessionFactory :: stateChanged :: source[{}], oldState[{}], newState[{}]", new Object[]{source, oldState, newState});
    }

    public void doOtherEvent(AppSession session, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
    }

    public void doProfileUpdateAnswerEvent(ClientShSession session, ProfileUpdateRequest request, ProfileUpdateAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
    }

    public void doPushNotificationRequestEvent(ClientShSession session, PushNotificationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
    }

    public void doSubscribeNotificationsAnswerEvent(ClientShSession session, SubscribeNotificationsRequest request, SubscribeNotificationsAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
    }

    public void doUserDataAnswerEvent(ClientShSession session, UserDataRequest request, UserDataAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
    }

    public void doProfileUpdateRequestEvent(ServerShSession session, ProfileUpdateRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
    }

    public void doPushNotificationAnswerEvent(ServerShSession session, PushNotificationRequest request, PushNotificationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
    }

    public void doSubscribeNotificationsRequestEvent(ServerShSession session, SubscribeNotificationsRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
    }

    public void doUserDataRequestEvent(ServerShSession session, UserDataRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
    }

    @Override
    public AppAnswerEvent createProfileUpdateAnswer(Answer answer) {
        return new ProfileUpdateAnswerImpl(answer);
    }

    @Override
    public AppRequestEvent createProfileUpdateRequest(Request request) {
        return new ProfileUpdateRequestImpl(request);
    }

    @Override
    public AppAnswerEvent createPushNotificationAnswer(Answer answer) {
        return new PushNotificationAnswerImpl(answer);
    }

    @Override
    public AppRequestEvent createPushNotificationRequest(Request request) {
        return new PushNotificationRequestImpl(request);
    }

    @Override
    public AppAnswerEvent createSubscribeNotificationsAnswer(Answer answer) {
        return new SubscribeNotificationsAnswerImpl(answer);
    }

    @Override
    public AppRequestEvent createSubscribeNotificationsRequest(Request request) {
        return new SubscribeNotificationsRequestImpl(request);
    }

    @Override
    public AppAnswerEvent createUserDataAnswer(Answer answer) {
        return new UserDataAnswerImpl(answer);
    }

    @Override
    public AppRequestEvent createUserDataRequest(Request request) {
        return new UserDataRequestImpl(request);
    }

    @Override
    public long getApplicationId() {
        return 0x1000001L;
    }

    @Override
    public long getMessageTimeout() {
        return this.messageTimeout;
    }
}

