/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.s6a;

import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.s6a.ClientS6aSession;
import org.jdiameter.api.s6a.ClientS6aSessionListener;
import org.jdiameter.api.s6a.ServerS6aSession;
import org.jdiameter.api.s6a.ServerS6aSessionListener;
import org.jdiameter.api.s6a.events.JAuthenticationInformationAnswer;
import org.jdiameter.api.s6a.events.JAuthenticationInformationRequest;
import org.jdiameter.api.s6a.events.JCancelLocationAnswer;
import org.jdiameter.api.s6a.events.JCancelLocationRequest;
import org.jdiameter.api.s6a.events.JDeleteSubscriberDataAnswer;
import org.jdiameter.api.s6a.events.JDeleteSubscriberDataRequest;
import org.jdiameter.api.s6a.events.JInsertSubscriberDataAnswer;
import org.jdiameter.api.s6a.events.JInsertSubscriberDataRequest;
import org.jdiameter.api.s6a.events.JNotifyAnswer;
import org.jdiameter.api.s6a.events.JNotifyRequest;
import org.jdiameter.api.s6a.events.JPurgeUEAnswer;
import org.jdiameter.api.s6a.events.JPurgeUERequest;
import org.jdiameter.api.s6a.events.JResetAnswer;
import org.jdiameter.api.s6a.events.JResetRequest;
import org.jdiameter.api.s6a.events.JUpdateLocationAnswer;
import org.jdiameter.api.s6a.events.JUpdateLocationRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.s6a.IClientS6aSessionData;
import org.jdiameter.client.impl.app.s6a.S6aClientSessionImpl;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.s6a.IS6aMessageFactory;
import org.jdiameter.common.api.app.s6a.IS6aSessionData;
import org.jdiameter.common.api.app.s6a.IS6aSessionFactory;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.s6a.JAuthenticationInformationAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JAuthenticationInformationRequestImpl;
import org.jdiameter.common.impl.app.s6a.JCancelLocationAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JCancelLocationRequestImpl;
import org.jdiameter.common.impl.app.s6a.JDeleteSubscriberDataAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JDeleteSubscriberDataRequestImpl;
import org.jdiameter.common.impl.app.s6a.JInsertSubscriberDataAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JInsertSubscriberDataRequestImpl;
import org.jdiameter.common.impl.app.s6a.JNotifyAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JNotifyRequestImpl;
import org.jdiameter.common.impl.app.s6a.JPurgeUEAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JPurgeUERequestImpl;
import org.jdiameter.common.impl.app.s6a.JResetAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JResetRequestImpl;
import org.jdiameter.common.impl.app.s6a.JUpdateLocationAnswerImpl;
import org.jdiameter.common.impl.app.s6a.JUpdateLocationRequestImpl;
import org.jdiameter.common.impl.app.s6a.S6aSession;
import org.jdiameter.server.impl.app.s6a.IServerS6aSessionData;
import org.jdiameter.server.impl.app.s6a.S6aServerSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S6aSessionFactoryImpl
implements IS6aSessionFactory,
ServerS6aSessionListener,
ClientS6aSessionListener,
IS6aMessageFactory,
StateChangeListener<AppSession> {
    private static final Logger logger = LoggerFactory.getLogger(S6aSessionFactoryImpl.class);
    protected ISessionFactory sessionFactory;
    protected ServerS6aSessionListener serverSessionListener;
    protected ClientS6aSessionListener clientSessionListener;
    protected IS6aMessageFactory messageFactory;
    protected StateChangeListener<AppSession> stateListener;
    protected ISessionDatasource iss;
    protected IAppSessionDataFactory<IS6aSessionData> sessionDataFactory;

    public S6aSessionFactoryImpl(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
        this.iss = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        this.sessionDataFactory = this.iss.getDataFactory(IS6aSessionData.class);
    }

    @Override
    public ServerS6aSessionListener getServerSessionListener() {
        return this.serverSessionListener != null ? this.serverSessionListener : this;
    }

    @Override
    public void setServerSessionListener(ServerS6aSessionListener serverSessionListener) {
        this.serverSessionListener = serverSessionListener;
    }

    @Override
    public ClientS6aSessionListener getClientSessionListener() {
        return this.clientSessionListener != null ? this.clientSessionListener : this;
    }

    @Override
    public void setClientSessionListener(ClientS6aSessionListener clientSessionListener) {
        this.clientSessionListener = clientSessionListener;
    }

    @Override
    public IS6aMessageFactory getMessageFactory() {
        return this.messageFactory != null ? this.messageFactory : this;
    }

    @Override
    public void setMessageFactory(IS6aMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public StateChangeListener<AppSession> getStateListener() {
        return this.stateListener != null ? this.stateListener : this;
    }

    @Override
    public void setStateListener(StateChangeListener<AppSession> stateListener) {
        this.stateListener = stateListener;
    }

    @Override
    public AppSession getSession(String sessionId, Class<? extends AppSession> aClass) {
        S6aSession appSession;
        block6: {
            if (sessionId == null) {
                throw new IllegalArgumentException("SessionId must not be null");
            }
            if (!this.iss.exists(sessionId)) {
                return null;
            }
            appSession = null;
            try {
                if (aClass == ServerS6aSession.class) {
                    IServerS6aSessionData sessionData = (IServerS6aSessionData)this.sessionDataFactory.getAppSessionData(ServerS6aSession.class, sessionId);
                    S6aServerSessionImpl serverSession = new S6aServerSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener());
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block6;
                }
                if (aClass == ClientS6aSession.class) {
                    IClientS6aSessionData sessionData = (IClientS6aSessionData)this.sessionDataFactory.getAppSessionData(ClientS6aSession.class, sessionId);
                    S6aClientSessionImpl clientSession = new S6aClientSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener());
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block6;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ServerS6aSession.class + "]");
            }
            catch (Exception e) {
                logger.error("Failure to obtain new S6a Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    @Override
    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        S6aSession appSession = null;
        if (aClass == ServerS6aSession.class) {
            if (sessionId == null) {
                if (args != null && args.length > 0 && args[0] instanceof Request) {
                    Request request = (Request)args[0];
                    sessionId = request.getSessionId();
                } else {
                    sessionId = this.sessionFactory.getSessionId();
                }
            }
            IServerS6aSessionData sessionData = (IServerS6aSessionData)this.sessionDataFactory.getAppSessionData(ServerS6aSession.class, sessionId);
            S6aServerSessionImpl serverSession = new S6aServerSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener());
            this.iss.addSession((BaseSession)serverSession);
            serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
            appSession = serverSession;
        } else if (aClass == ClientS6aSession.class) {
            if (sessionId == null) {
                if (args != null && args.length > 0 && args[0] instanceof Request) {
                    Request request = (Request)args[0];
                    sessionId = request.getSessionId();
                } else {
                    sessionId = this.sessionFactory.getSessionId();
                }
            }
            IClientS6aSessionData sessionData = (IClientS6aSessionData)this.sessionDataFactory.getAppSessionData(ClientS6aSession.class, sessionId);
            S6aClientSessionImpl clientSession = new S6aClientSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener());
            this.iss.addSession((BaseSession)clientSession);
            clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
            appSession = clientSession;
        } else {
            throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ServerS6aSession.class + "]");
        }
        return appSession;
    }

    public void stateChanged(Enum oldState, Enum newState) {
        logger.info("Diameter S6a Session Factory :: stateChanged :: oldState[{}], newState[{}]", (Object)oldState, (Object)newState);
    }

    @Override
    public long getApplicationId() {
        return 16777251L;
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        logger.info("Diameter S6a Session Factory :: stateChanged :: Session, [{}], oldState[{}], newState[{}]", new Object[]{source, oldState, newState});
    }

    @Override
    public JAuthenticationInformationAnswer createAuthenticationInformationAnswer(Answer answer) {
        return new JAuthenticationInformationAnswerImpl(answer);
    }

    @Override
    public JAuthenticationInformationRequest createAuthenticationInformationRequest(Request request) {
        return new JAuthenticationInformationRequestImpl((Message)request);
    }

    @Override
    public JUpdateLocationRequest createUpdateLocationRequest(Request request) {
        return new JUpdateLocationRequestImpl((Message)request);
    }

    @Override
    public JUpdateLocationAnswer createUpdateLocationAnswer(Answer answer) {
        return new JUpdateLocationAnswerImpl(answer);
    }

    @Override
    public JPurgeUERequest createPurgeUERequest(Request request) {
        return new JPurgeUERequestImpl((Message)request);
    }

    @Override
    public JPurgeUEAnswer createPurgeUEAnswer(Answer answer) {
        return new JPurgeUEAnswerImpl(answer);
    }

    @Override
    public JCancelLocationRequest createCancelLocationRequest(Request request) {
        return new JCancelLocationRequestImpl((Message)request);
    }

    @Override
    public JCancelLocationAnswer createCancelLocationAnswer(Answer answer) {
        return new JCancelLocationAnswerImpl(answer);
    }

    @Override
    public JInsertSubscriberDataRequest createInsertSubscriberDataRequest(Request request) {
        return new JInsertSubscriberDataRequestImpl((Message)request);
    }

    @Override
    public JInsertSubscriberDataAnswer createInsertSubscriberDataAnswer(Answer answer) {
        return new JInsertSubscriberDataAnswerImpl(answer);
    }

    @Override
    public JDeleteSubscriberDataRequest createDeleteSubscriberDataRequest(Request request) {
        return new JDeleteSubscriberDataRequestImpl((Message)request);
    }

    @Override
    public JDeleteSubscriberDataAnswer createDeleteSubscriberDataAnswer(Answer answer) {
        return new JDeleteSubscriberDataAnswerImpl(answer);
    }

    @Override
    public JResetRequest createResetRequest(Request request) {
        return new JResetRequestImpl((Message)request);
    }

    @Override
    public JResetAnswer createResetAnswer(Answer answer) {
        return new JResetAnswerImpl(answer);
    }

    @Override
    public JNotifyRequest createNotifyRequest(Request request) {
        return new JNotifyRequestImpl((Message)request);
    }

    @Override
    public JNotifyAnswer createNotifyAnswer(Answer answer) {
        return new JNotifyAnswerImpl(answer);
    }

    public void doAuthenticationInformationRequestEvent(ServerS6aSession appSession, JAuthenticationInformationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doAuthenticationInformationRequest :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doPurgeUERequestEvent(ServerS6aSession appSession, JPurgeUERequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doPurgeUERequest :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doUpdateLocationRequestEvent(ServerS6aSession appSession, JUpdateLocationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doUpdateLocationRequest :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doNotifyRequestEvent(ServerS6aSession appSession, JNotifyRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doNotifyRequest :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doCancelLocationAnswerEvent(ServerS6aSession appSession, JCancelLocationRequest request, JCancelLocationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doCancelLocationAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doInsertSubscriberDataAnswerEvent(ServerS6aSession appSession, JInsertSubscriberDataRequest request, JInsertSubscriberDataAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doInsertSubscriberDataAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doDeleteSubscriberDataAnswerEvent(ServerS6aSession appSession, JDeleteSubscriberDataRequest request, JDeleteSubscriberDataAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doDeleteSubscriberDataAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doResetAnswerEvent(ServerS6aSession appSession, JResetRequest request, JResetAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doResetAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doOtherEvent :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doCancelLocationRequestEvent(ClientS6aSession appSession, JCancelLocationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doCancelLocationRequest :: appSession[{}], Request[{}]", new Object[]{appSession, request});
    }

    public void doInsertSubscriberDataRequestEvent(ClientS6aSession appSession, JInsertSubscriberDataRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doInsertSubscriberDataRequest :: appSession[{}], Request[{}]", new Object[]{appSession, request});
    }

    public void doDeleteSubscriberDataRequestEvent(ClientS6aSession appSession, JDeleteSubscriberDataRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doDeleteSubscriberDataRequest :: appSession[{}], Request[{}]", new Object[]{appSession, request});
    }

    public void doResetRequestEvent(ClientS6aSession appSession, JResetRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doResetRequest :: appSession[{}], Request[{}]", new Object[]{appSession, request});
    }

    public void doAuthenticationInformationAnswerEvent(ClientS6aSession appSession, JAuthenticationInformationRequest request, JAuthenticationInformationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doAuthenticationInformationAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doPurgeUEAnswerEvent(ClientS6aSession appSession, JPurgeUERequest request, JPurgeUEAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doPurgeUEAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doUpdateLocationAnswerEvent(ClientS6aSession appSession, JUpdateLocationRequest request, JUpdateLocationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doUpdateLocationAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doNotifyAnswerEvent(ClientS6aSession appSession, JNotifyRequest request, JNotifyAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter S6a Session Factory :: doNotifyAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }
}

