/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.cxdx;

import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.acc.ClientAccSession;
import org.jdiameter.api.acc.ServerAccSession;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.cxdx.ClientCxDxSession;
import org.jdiameter.api.cxdx.ClientCxDxSessionListener;
import org.jdiameter.api.cxdx.ServerCxDxSession;
import org.jdiameter.api.cxdx.ServerCxDxSessionListener;
import org.jdiameter.api.cxdx.events.JLocationInfoAnswer;
import org.jdiameter.api.cxdx.events.JLocationInfoRequest;
import org.jdiameter.api.cxdx.events.JMultimediaAuthAnswer;
import org.jdiameter.api.cxdx.events.JMultimediaAuthRequest;
import org.jdiameter.api.cxdx.events.JPushProfileAnswer;
import org.jdiameter.api.cxdx.events.JPushProfileRequest;
import org.jdiameter.api.cxdx.events.JRegistrationTerminationAnswer;
import org.jdiameter.api.cxdx.events.JRegistrationTerminationRequest;
import org.jdiameter.api.cxdx.events.JServerAssignmentAnswer;
import org.jdiameter.api.cxdx.events.JServerAssignmentRequest;
import org.jdiameter.api.cxdx.events.JUserAuthorizationAnswer;
import org.jdiameter.api.cxdx.events.JUserAuthorizationRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.cxdx.CxDxClientSessionImpl;
import org.jdiameter.client.impl.app.cxdx.IClientCxDxSessionData;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.cxdx.ICxDxMessageFactory;
import org.jdiameter.common.api.app.cxdx.ICxDxSessionData;
import org.jdiameter.common.api.app.cxdx.ICxDxSessionFactory;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.app.cxdx.CxDxSession;
import org.jdiameter.common.impl.app.cxdx.JLocationInfoAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JLocationInfoRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JMultimediaAuthAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JMultimediaAuthRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JPushProfileAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JPushProfileRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JRegistrationTerminationAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JRegistrationTerminationRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JServerAssignmentAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JServerAssignmentRequestImpl;
import org.jdiameter.common.impl.app.cxdx.JUserAuthorizationAnswerImpl;
import org.jdiameter.common.impl.app.cxdx.JUserAuthorizationRequestImpl;
import org.jdiameter.server.impl.app.cxdx.CxDxServerSessionImpl;
import org.jdiameter.server.impl.app.cxdx.IServerCxDxSessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxDxSessionFactoryImpl
implements ICxDxSessionFactory,
ClientCxDxSessionListener,
ServerCxDxSessionListener,
ICxDxMessageFactory,
StateChangeListener<AppSession> {
    private static final Logger logger = LoggerFactory.getLogger(CxDxSessionFactoryImpl.class);
    protected ISessionFactory sessionFactory;
    protected ClientCxDxSessionListener clientSessionListener;
    protected ServerCxDxSessionListener serverSessionListener;
    protected ICxDxMessageFactory messageFactory;
    protected StateChangeListener<AppSession> stateListener;
    protected ISessionDatasource iss;
    protected IAppSessionDataFactory<ICxDxSessionData> sessionDataFactory;

    public CxDxSessionFactoryImpl(SessionFactory sessionFactory) {
        this.sessionFactory = (ISessionFactory)sessionFactory;
        this.iss = this.sessionFactory.getContainer().getAssemblerFacility().getComponentInstance(ISessionDatasource.class);
        this.sessionDataFactory = this.iss.getDataFactory(ICxDxSessionData.class);
    }

    @Override
    public ClientCxDxSessionListener getClientSessionListener() {
        if (this.clientSessionListener != null) {
            return this.clientSessionListener;
        }
        return this;
    }

    @Override
    public void setClientSessionListener(ClientCxDxSessionListener clientSessionListener) {
        this.clientSessionListener = clientSessionListener;
    }

    @Override
    public ServerCxDxSessionListener getServerSessionListener() {
        if (this.serverSessionListener != null) {
            return this.serverSessionListener;
        }
        return this;
    }

    @Override
    public void setServerSessionListener(ServerCxDxSessionListener serverSessionListener) {
        this.serverSessionListener = serverSessionListener;
    }

    @Override
    public ICxDxMessageFactory getMessageFactory() {
        if (this.messageFactory != null) {
            return this.messageFactory;
        }
        return this;
    }

    @Override
    public void setMessageFactory(ICxDxMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    @Override
    public StateChangeListener<AppSession> getStateListener() {
        if (this.stateListener != null) {
            return this.stateListener;
        }
        return this;
    }

    @Override
    public void setStateListener(StateChangeListener<AppSession> stateListener) {
        this.stateListener = stateListener;
    }

    @Override
    public AppSession getSession(String sessionId, Class<? extends AppSession> aClass) {
        CxDxSession appSession;
        block6: {
            if (sessionId == null) {
                throw new IllegalArgumentException("SessionId must not be null");
            }
            if (!this.iss.exists(sessionId)) {
                return null;
            }
            appSession = null;
            try {
                if (aClass == ClientCxDxSession.class) {
                    IClientCxDxSessionData sessionData = (IClientCxDxSessionData)this.sessionDataFactory.getAppSessionData(ClientCxDxSession.class, sessionId);
                    CxDxClientSessionImpl clientSession = new CxDxClientSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener());
                    clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
                    appSession = clientSession;
                    break block6;
                }
                if (aClass == ServerCxDxSession.class) {
                    IServerCxDxSessionData sessionData = (IServerCxDxSessionData)this.sessionDataFactory.getAppSessionData(ServerCxDxSession.class, sessionId);
                    CxDxServerSessionImpl serverSession = new CxDxServerSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener());
                    serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
                    appSession = serverSession;
                    break block6;
                }
                throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ClientAccSession.class + "," + ServerAccSession.class + "]");
            }
            catch (Exception e) {
                logger.error("Failure to obtain new Cx/Dx Session.", (Throwable)e);
            }
        }
        return appSession;
    }

    @Override
    public AppSession getNewSession(String sessionId, Class<? extends AppSession> aClass, ApplicationId applicationId, Object[] args) {
        CxDxSession appSession = null;
        if (aClass == ClientCxDxSession.class) {
            if (sessionId == null) {
                if (args != null && args.length > 0 && args[0] instanceof Request) {
                    Request request = (Request)args[0];
                    sessionId = request.getSessionId();
                } else {
                    sessionId = this.sessionFactory.getSessionId();
                }
            }
            IClientCxDxSessionData sessionData = (IClientCxDxSessionData)this.sessionDataFactory.getAppSessionData(ClientCxDxSession.class, sessionId);
            sessionData.setApplicationId(applicationId);
            CxDxClientSessionImpl clientSession = new CxDxClientSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getClientSessionListener());
            this.iss.addSession((BaseSession)clientSession);
            clientSession.getSessions().get(0).setRequestListener((NetworkReqListener)clientSession);
            appSession = clientSession;
        } else if (aClass == ServerCxDxSession.class) {
            if (sessionId == null) {
                if (args != null && args.length > 0 && args[0] instanceof Request) {
                    Request request = (Request)args[0];
                    sessionId = request.getSessionId();
                } else {
                    sessionId = this.sessionFactory.getSessionId();
                }
            }
            IServerCxDxSessionData sessionData = (IServerCxDxSessionData)this.sessionDataFactory.getAppSessionData(ServerCxDxSession.class, sessionId);
            sessionData.setApplicationId(applicationId);
            CxDxServerSessionImpl serverSession = new CxDxServerSessionImpl(sessionData, this.getMessageFactory(), this.sessionFactory, this.getServerSessionListener());
            this.iss.addSession((BaseSession)serverSession);
            serverSession.getSessions().get(0).setRequestListener((NetworkReqListener)serverSession);
            appSession = serverSession;
        } else {
            throw new IllegalArgumentException("Wrong session class: " + aClass + ". Supported[" + ServerCxDxSession.class + "," + ClientCxDxSession.class + "]");
        }
        return appSession;
    }

    @Override
    public JLocationInfoAnswer createLocationInfoAnswer(Answer answer) {
        return new JLocationInfoAnswerImpl(answer);
    }

    @Override
    public JLocationInfoRequest createLocationInfoRequest(Request request) {
        return new JLocationInfoRequestImpl((Message)request);
    }

    @Override
    public JMultimediaAuthAnswer createMultimediaAuthAnswer(Answer answer) {
        return new JMultimediaAuthAnswerImpl(answer);
    }

    @Override
    public JMultimediaAuthRequest createMultimediaAuthRequest(Request request) {
        return new JMultimediaAuthRequestImpl((Message)request);
    }

    @Override
    public JPushProfileAnswer createPushProfileAnswer(Answer answer) {
        return new JPushProfileAnswerImpl(answer);
    }

    @Override
    public JPushProfileRequest createPushProfileRequest(Request request) {
        return new JPushProfileRequestImpl((Message)request);
    }

    @Override
    public JRegistrationTerminationAnswer createRegistrationTerminationAnswer(Answer answer) {
        return new JRegistrationTerminationAnswerImpl(answer);
    }

    @Override
    public JRegistrationTerminationRequest createRegistrationTerminationRequest(Request request) {
        return new JRegistrationTerminationRequestImpl((Message)request);
    }

    @Override
    public JServerAssignmentAnswer createServerAssignmentAnswer(Answer answer) {
        return new JServerAssignmentAnswerImpl(answer);
    }

    @Override
    public JServerAssignmentRequest createServerAssignmentRequest(Request request) {
        return new JServerAssignmentRequestImpl((Message)request);
    }

    @Override
    public JUserAuthorizationAnswer createUserAuthorizationAnswer(Answer answer) {
        return new JUserAuthorizationAnswerImpl(answer);
    }

    @Override
    public JUserAuthorizationRequest createUserAuthorizationRequest(Request request) {
        return new JUserAuthorizationRequestImpl((Message)request);
    }

    @Override
    public long getApplicationId() {
        return 0x1000000L;
    }

    public void doLocationInformationRequest(ServerCxDxSession appSession, JLocationInfoRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Cx/Dx Session Factory :: doLocationInformationRequest :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doMultimediaAuthRequest(ServerCxDxSession appSession, JMultimediaAuthRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Cx/Dx Session Factory :: doMultimediaAuthRequest :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doOtherEvent(AppSession appSession, AppRequestEvent request, AppAnswerEvent answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Cx/Dx Session Factory :: doOtherEvent :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doPushProfileAnswer(ServerCxDxSession appSession, JPushProfileRequest request, JPushProfileAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Cx/Dx Session Factory :: doPushProfileAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doRegistrationTerminationAnswer(ServerCxDxSession appSession, JRegistrationTerminationRequest request, JRegistrationTerminationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Cx/Dx Session Factory :: doRegistrationTerminationAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doServerAssignmentRequest(ServerCxDxSession appSession, JServerAssignmentRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Cx/Dx Session Factory :: doServerAssignmentRequest :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doUserAuthorizationRequest(ServerCxDxSession appSession, JUserAuthorizationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Cx/Dx Session Factory :: doUserAuthorizationRequest :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doLocationInformationAnswer(ClientCxDxSession appSession, JLocationInfoRequest request, JLocationInfoAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Cx/Dx Session Factory :: doLocationInformationAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doMultimediaAuthAnswer(ClientCxDxSession appSession, JMultimediaAuthRequest request, JMultimediaAuthAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Cx/Dx Session Factory :: doMultimediaAuthAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doPushProfileRequest(ClientCxDxSession appSession, JPushProfileRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Cx/Dx Session Factory :: doPushProfileRequest :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doRegistrationTerminationRequest(ClientCxDxSession appSession, JRegistrationTerminationRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Cx/Dx Session Factory :: doRegistrationTerminationRequest :: appSession[{}], Request[{}]", (Object)appSession, (Object)request);
    }

    public void doServerAssignmentAnswer(ClientCxDxSession appSession, JServerAssignmentRequest request, JServerAssignmentAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Cx/Dx Session Factory :: doServerAssignmentAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void doUserAuthorizationAnswer(ClientCxDxSession appSession, JUserAuthorizationRequest request, JUserAuthorizationAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        logger.info("Diameter Cx/Dx Session Factory :: doUserAuthorizationAnswer :: appSession[{}], Request[{}], Answer[{}]", new Object[]{appSession, request, answer});
    }

    public void stateChanged(Enum oldState, Enum newState) {
        logger.info("Diameter Cx/Dx Session Factory :: stateChanged :: oldState[{}], newState[{}]", (Object)oldState, (Object)newState);
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        logger.info("Diameter Cx/Dx Session Factory :: stateChanged :: Session, [{}], oldState[{}], newState[{}]", new Object[]{source, oldState, newState});
    }
}

