/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.cca;

import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.cca.events.JCreditControlRequest;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCreditControlRequestImpl
extends AppRequestEventImpl
implements JCreditControlRequest {
    private static final long serialVersionUID = 1L;
    protected Logger logger = LoggerFactory.getLogger(JCreditControlRequestImpl.class);
    private static final int REQUESTED_ACTION_AVP_CODE = 436;
    private static final int CC_REQUEST_TYPE_AVP_CODE = 416;

    public JCreditControlRequestImpl(AppSession session, String destRealm, String destHost) {
        super((Message)((Session)session.getSessions().get(0)).createRequest(272, session.getSessionAppId(), destRealm, destHost));
    }

    public JCreditControlRequestImpl(Request request) {
        super((Message)request);
    }

    public boolean isRequestedActionAVPPresent() {
        return this.message.getAvps().getAvp(436) != null;
    }

    public int getRequestedActionAVPValue() {
        Avp requestedActionAvp = this.message.getAvps().getAvp(436);
        if (requestedActionAvp != null) {
            try {
                return requestedActionAvp.getInteger32();
            }
            catch (AvpDataException e) {
                this.logger.debug("Failure trying to obtain Requested-Action AVP value", (Throwable)e);
            }
        }
        return -1;
    }

    public boolean isRequestTypeAVPPresent() {
        return this.message.getAvps().getAvp(416) != null;
    }

    public int getRequestTypeAVPValue() {
        Avp requestTypeAvp = this.message.getAvps().getAvp(416);
        if (requestTypeAvp != null) {
            try {
                return requestTypeAvp.getInteger32();
            }
            catch (AvpDataException e) {
                this.logger.debug("Failure trying to obtain CC-Request-Type AVP value", (Throwable)e);
            }
        }
        return -1;
    }
}

