/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.common.impl.app.acc;

import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.acc.events.AccountRequest;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.common.impl.app.AppRequestEventImpl;

public class AccountRequestImpl
extends AppRequestEventImpl
implements AccountRequest {
    private static final long serialVersionUID = 1L;

    public AccountRequestImpl(AppSession session, int accountRecordType, int accReqNumber, String destRealm, String destHost) {
        super((Message)((Session)session.getSessions().get(0)).createRequest(271, session.getSessionAppId(), destRealm, destHost));
        try {
            this.getMessage().getAvps().addAvp(480, accountRecordType);
            this.getMessage().getAvps().addAvp(485, accReqNumber);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public AccountRequestImpl(Request request) {
        super((Message)request);
    }

    public int getAccountingRecordType() throws AvpDataException {
        Avp accRecordTypeAvp = this.message.getAvps().getAvp(480);
        if (accRecordTypeAvp != null) {
            return accRecordTypeAvp.getInteger32();
        }
        throw new AvpDataException("Avp ACC_RECORD_TYPE not found");
    }

    public long getAccountingRecordNumber() throws AvpDataException {
        Avp accRecordNumberAvp = this.message.getAvps().getAvp(485);
        if (accRecordNumberAvp != null) {
            return accRecordNumberAvp.getUnsigned32();
        }
        throw new AvpDataException("Avp ACC_RECORD_NUMBER not found");
    }

    public void setAccountingRecordType(int recordType) throws AvpDataException {
        this.message.getAvps().removeAvp(480);
        this.message.getAvps().addAvp(480, recordType);
    }

    public void setAccountingRecordNumber(long recordNum) throws AvpDataException {
        this.message.getAvps().removeAvp(485);
        this.message.getAvps().addAvp(485, 485L, true);
    }
}

