/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.sctp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.client.api.io.NotInitializedException;
import org.jdiameter.client.impl.transport.sctp.SCTPClientConnection;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.AssociationListener;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.api.PayloadData;
import org.mobicents.protocols.sctp.AssociationImpl;
import org.mobicents.protocols.sctp.ManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCTPTransportClient {
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int DELAY = 100;
    private ManagementImpl management = null;
    private AssociationImpl clientAssociation = null;
    private SCTPClientConnection parentConnection;
    private String clientAssociationName;
    protected InetSocketAddress destAddress;
    protected InetSocketAddress origAddress;
    private int payloadProtocolId = 0;
    private int streamNumber = 0;
    private static final Logger logger = LoggerFactory.getLogger(SCTPTransportClient.class);

    public SCTPTransportClient() {
    }

    SCTPTransportClient(SCTPClientConnection parenConnection) {
        this.parentConnection = parenConnection;
    }

    public void initialize() throws IOException, NotInitializedException {
        logger.debug("Initializing SCTPTransportClient. Origin address is [{}] and destination address is [{}]", (Object)this.origAddress, (Object)this.destAddress);
        if (this.destAddress == null) {
            throw new NotInitializedException("Destination address is not set");
        }
        logger.debug("Initializing SCTP client");
        this.clientAssociationName = this.origAddress.getAddress().getHostAddress() + "." + this.origAddress.getPort() + "_" + this.destAddress.getAddress().getHostAddress() + "." + this.destAddress.getPort();
        try {
            if (this.management == null) {
                this.management = new ManagementImpl(this.clientAssociationName);
                this.management.setSingleThread(true);
                this.management.start();
                this.management.setConnectDelay(1000);
                this.management.removeAllResourses();
                logger.debug("Management initialized.");
            } else {
                logger.debug("Management already initialized.");
            }
            if (this.clientAssociation == null) {
                logger.debug("Creating CLIENT ASSOCIATION '{}'. Origin Address [{}] <=> Dest Address [{}]", new Object[]{this.clientAssociationName, this.origAddress, this.destAddress});
                this.clientAssociation = this.management.addAssociation(this.origAddress.getAddress().getHostAddress(), this.origAddress.getPort(), this.destAddress.getAddress().getHostAddress(), this.destAddress.getPort(), this.clientAssociationName, IpChannelType.SCTP, null);
            } else {
                logger.debug("CLIENT ASSOCIATION '{}'. Origin Address [{}:{}] <=> Dest Address [{}:{}] already present. Re-using it.", new Object[]{this.clientAssociation.getName(), this.clientAssociation.getHostAddress(), this.clientAssociation.getHostPort(), this.clientAssociation.getPeerAddress(), this.clientAssociation.getPeerPort()});
            }
        }
        catch (Exception e) {
            logger.error("Failed to initialize client ", (Throwable)e);
        }
    }

    public SCTPClientConnection getParent() {
        return this.parentConnection;
    }

    public void start() throws NotInitializedException, IOException {
        logger.debug("Starting SCTP client");
        try {
            this.clientAssociation.setAssociationListener((AssociationListener)new ClientAssociationListener());
            this.management.startAssociation(this.clientAssociationName);
        }
        catch (Exception e) {
            logger.error("Failed to start client ", (Throwable)e);
        }
        if (this.getParent() == null) {
            throw new NotInitializedException("No parent connection is set");
        }
        logger.debug("Successfuly initialized SCTP Client Host [{}:{}] Peer [{}:{}]", new Object[]{this.clientAssociation.getHostAddress(), this.clientAssociation.getHostPort(), this.clientAssociation.getPeerAddress(), this.clientAssociation.getPeerPort()});
        logger.debug("Client Association Status: Started[{}] Connected[{}] Up[{}] ", new Object[]{this.clientAssociation.isStarted(), this.clientAssociation.isConnected(), this.clientAssociation.isUp()});
        logger.trace("Client Association [{}]", (Object)this.clientAssociation);
        this.defer();
    }

    private void defer() throws IOException {
        long endTStamp = System.currentTimeMillis() + 30000L;
        while (this.clientAssociation.isStarted() && !this.clientAssociation.isConnected() && !this.clientAssociation.isUp()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new IOException("Failed to establish SCTP connection, thread was interrupted waiting for connection.");
            }
            if (endTStamp >= System.currentTimeMillis()) continue;
            throw new IOException("Failed to establish SCTP connection!");
        }
        logger.debug("Client Association Status: Started[{}] Connected[{}] Up[{}] ", new Object[]{this.clientAssociation.isStarted(), this.clientAssociation.isConnected(), this.clientAssociation.isUp()});
        logger.trace("Client Association [{}]", (Object)this.clientAssociation);
    }

    public void stop() throws Exception {
        this.management.stopAssociation(this.clientAssociationName);
    }

    public void release() throws Exception {
        this.stop();
        this.management.removeAssociation(this.clientAssociationName);
        this.management.stop();
        this.clientAssociation = null;
    }

    public InetSocketAddress getDestAddress() {
        return this.destAddress;
    }

    public void setDestAddress(InetSocketAddress address) {
        this.destAddress = address;
        if (logger.isDebugEnabled()) {
            logger.debug("Destination address is set to [{}:{}]", (Object)this.destAddress.getHostName(), (Object)this.destAddress.getPort());
        }
    }

    public void setOrigAddress(InetSocketAddress address) {
        this.origAddress = address;
        if (logger.isDebugEnabled()) {
            logger.debug("Origin address is set to [{}:{}]", (Object)this.origAddress.getHostName(), (Object)this.origAddress.getPort());
        }
    }

    public InetSocketAddress getOrigAddress() {
        return this.origAddress;
    }

    public void sendMessage(ByteBuffer bytes) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("About to send a byte buffer of size [{}] over the SCTP", (Object)bytes.array().length);
        }
        PayloadData payloadData = new PayloadData(bytes.array().length, bytes.array(), true, false, this.payloadProtocolId, this.streamNumber);
        try {
            this.clientAssociation.send(payloadData);
        }
        catch (Exception e) {
            logger.error("Failed sending byte buffer over SCTP", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Sent a byte buffer of size [{}] over SCTP", (Object)bytes.array().length);
        }
    }

    boolean isConnected() {
        return this.clientAssociation != null && this.clientAssociation.isConnected();
    }

    private class ClientAssociationListener
    implements AssociationListener {
        private final Logger logger = LoggerFactory.getLogger(ClientAssociationListener.class);

        private ClientAssociationListener() {
        }

        public void onCommunicationUp(Association association, int maxInboundStreams, int maxOutboundStreams) {
            this.logger.debug("onCommunicationUp called for [{}]", (Object)this);
            SCTPTransportClient.this.getParent().onConnected();
        }

        public void onCommunicationShutdown(Association association) {
            this.logger.debug("onCommunicationShutdown called for [{}]", (Object)this);
            try {
                SCTPTransportClient.this.getParent().onDisconnect();
            }
            catch (Exception e) {
                this.logger.debug("Error", (Throwable)e);
            }
        }

        public void onCommunicationLost(Association association) {
            this.logger.debug("onCommunicationLost called for [{}]", (Object)this);
        }

        public void onCommunicationRestart(Association association) {
            this.logger.debug("onCommunicationRestart called for [{}]", (Object)this);
        }

        public void onPayload(Association association, PayloadData payloadData) {
            byte[] data = new byte[payloadData.getDataLength()];
            System.arraycopy(payloadData.getData(), 0, data, 0, payloadData.getDataLength());
            this.logger.debug("SCTP Client received data of length [{}]", (Object)data.length);
            try {
                SCTPTransportClient.this.getParent().onMessageReceived(ByteBuffer.wrap(data));
            }
            catch (AvpDataException e) {
                this.logger.debug("Garbage was received. Discarding.");
                SCTPTransportClient.this.getParent().onAvpDataException(e);
            }
        }

        public void inValidStreamId(PayloadData payloadData) {
        }
    }
}

