/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.helpers;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jdiameter.api.Configuration;
import org.jdiameter.client.impl.helpers.AppConfiguration;
import org.jdiameter.client.impl.helpers.EmptyConfiguration;
import org.jdiameter.client.impl.helpers.ExtensionPoint;
import org.jdiameter.client.impl.helpers.Ordinal;
import org.jdiameter.client.impl.helpers.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfiguration
extends EmptyConfiguration {
    public XMLConfiguration(InputStream in) throws Exception {
        this(in, null, null, false);
    }

    public XMLConfiguration(InputStream in, Hashtable<String, Object> attributes, Hashtable<String, Boolean> features) throws Exception {
        this(in, attributes, features, false);
    }

    public XMLConfiguration(String filename) throws Exception {
        this(filename, null, null, false);
    }

    public XMLConfiguration(String filename, Hashtable<String, Object> attributes, Hashtable<String, Boolean> features) throws Exception {
        this(filename, attributes, features, false);
    }

    protected XMLConfiguration(Object in, Hashtable<String, Object> attributes, Hashtable<String, Boolean> features, boolean nop) throws Exception {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                factory.setAttribute(key, attributes.get(key));
            }
        }
        if (features != null) {
            for (String key : features.keySet()) {
                factory.setFeature(key, features.get(key));
            }
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (in instanceof InputStream) {
            document = builder.parse((InputStream)in);
        } else if (in instanceof String) {
            document = builder.parse(new File((String)in));
        } else {
            throw new Exception("Unknown type of input data");
        }
        this.validate(document);
        this.processing(document);
    }

    protected void validate(Document document) throws Exception {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaFile = new StreamSource(this.getClass().getResourceAsStream("/META-INF/jdiameter-client.xsd"));
        Schema schema = factory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
    }

    protected void processing(Document document) {
        Element element = document.getDocumentElement();
        NodeList c = element.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (nodeName.equals("LocalPeer")) {
                this.addLocalPeer(c.item(i));
                continue;
            }
            if (nodeName.equals("Parameters")) {
                this.addParameters(c.item(i));
                continue;
            }
            if (nodeName.equals("Network")) {
                this.addNetwork(c.item(i));
                continue;
            }
            if (nodeName.equals("Security")) {
                this.addSecurity(c.item(i));
                continue;
            }
            if (!nodeName.equals("Extensions")) continue;
            this.addExtensions(c.item(i));
        }
    }

    protected void addLocalPeer(Node node) {
        NodeList c = node.getChildNodes();
        if (node.getAttributes().getNamedItem("security_ref") != null) {
            this.add((Ordinal)Parameters.SecurityRef, node.getAttributes().getNamedItem("security_ref").getNodeValue());
        }
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (nodeName.equals("URI")) {
                this.add((Ordinal)Parameters.OwnDiameterURI, this.getValue(c.item(i)));
            }
            this.addIPAddress(c.item(i));
            if (nodeName.equals("Realm")) {
                this.add((Ordinal)Parameters.OwnRealm, this.getValue(c.item(i)));
            }
            if (nodeName.equals("VendorID")) {
                this.add((Ordinal)Parameters.OwnVendorID, this.getLongValue(c.item(i)));
            }
            if (nodeName.equals("ProductName")) {
                this.add((Ordinal)Parameters.OwnProductName, this.getValue(c.item(i)));
            }
            if (nodeName.equals("FirmwareRevision")) {
                this.add((Ordinal)Parameters.OwnFirmwareRevision, this.getLongValue(c.item(i)));
            }
            if (!nodeName.equals("Applications")) continue;
            this.addApplications(c.item(i));
        }
    }

    protected void addIPAddress(Node node) {
        String nodeName = node.getNodeName();
        if (nodeName.equals("IPAddress")) {
            this.add((Ordinal)Parameters.OwnIPAddress, this.getValue(node));
        }
    }

    protected void addApplications(Node node) {
        NodeList c = node.getChildNodes();
        ArrayList<Configuration> items = new ArrayList<Configuration>();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (!nodeName.equals("ApplicationID")) continue;
            items.add(this.addApplication(c.item(i)));
        }
        this.add((Ordinal)Parameters.ApplicationId, items.toArray(this.EMPTY_ARRAY));
    }

    protected Configuration addApplication(Node node) {
        NodeList c = node.getChildNodes();
        AppConfiguration e = XMLConfiguration.getInstance();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (nodeName.equals("VendorId")) {
                e.add((Ordinal)Parameters.VendorId, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("AuthApplId")) {
                e.add((Ordinal)Parameters.AuthApplId, this.getLongValue(c.item(i)));
                continue;
            }
            if (!nodeName.equals("AcctApplId")) continue;
            e.add((Ordinal)Parameters.AcctApplId, this.getLongValue(c.item(i)));
        }
        return e;
    }

    protected void addParameters(Node node) {
        NodeList c = node.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (nodeName.equals("UseUriAsFqdn")) {
                this.add((Ordinal)Parameters.UseUriAsFqdn, Boolean.valueOf(this.getValue(c.item(i))));
                continue;
            }
            if (nodeName.equals("QueueSize")) {
                this.add((Ordinal)Parameters.QueueSize, this.getIntValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("MessageTimeOut")) {
                this.add((Ordinal)Parameters.MessageTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("StopTimeOut")) {
                this.add((Ordinal)Parameters.StopTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("CeaTimeOut")) {
                this.add((Ordinal)Parameters.CeaTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("IacTimeOut")) {
                this.add((Ordinal)Parameters.IacTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("DwaTimeOut")) {
                this.add((Ordinal)Parameters.DwaTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("DpaTimeOut")) {
                this.add((Ordinal)Parameters.DpaTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("RecTimeOut")) {
                this.add((Ordinal)Parameters.RecTimeOut, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("PeerFSMThreadCount")) {
                this.add((Ordinal)Parameters.PeerFSMThreadCount, this.getIntValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("Statistics")) {
                this.addStatisticLogger(Parameters.Statistics, c.item(i));
                continue;
            }
            if (nodeName.equals("Concurrent")) {
                this.addConcurrent(Parameters.Concurrent, c.item(i));
                continue;
            }
            if (nodeName.equals("Dictionary")) {
                this.addDictionary(Parameters.Dictionary, c.item(i));
                continue;
            }
            this.appendOtherParameter(c.item(i));
        }
    }

    protected void addConcurrent(Parameters name, Node node) {
        NodeList c = node.getChildNodes();
        ArrayList<Configuration> items = new ArrayList<Configuration>();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (!nodeName.equals("Entity")) continue;
            this.addConcurrentEntity(items, c.item(i));
        }
        this.add((Ordinal)name, items.toArray(new Configuration[items.size()]));
    }

    protected void addConcurrentEntity(List<Configuration> items, Node node) {
        AppConfiguration cfg = XMLConfiguration.getInstance();
        String name = node.getAttributes().getNamedItem("name").getNodeValue();
        cfg.add((Ordinal)Parameters.ConcurrentEntityName, name);
        if (node.getAttributes().getNamedItem("description") != null) {
            String descr = node.getAttributes().getNamedItem("description").getNodeValue();
            cfg.add((Ordinal)Parameters.ConcurrentEntityDescription, descr);
        }
        if (node.getAttributes().getNamedItem("size") != null) {
            String size = node.getAttributes().getNamedItem("size").getNodeValue();
            cfg.add((Ordinal)Parameters.ConcurrentEntityPoolSize, Integer.parseInt(size));
        }
        items.add(cfg);
    }

    protected void addStatisticLogger(Parameters name, Node node) {
        String pause = node.getAttributes().getNamedItem("pause").getNodeValue();
        String delay = node.getAttributes().getNamedItem("delay").getNodeValue();
        String enabled = node.getAttributes().getNamedItem("enabled").getNodeValue();
        String active_records = node.getAttributes().getNamedItem("active_records") != null ? node.getAttributes().getNamedItem("active_records").getNodeValue() : (String)Parameters.StatisticsActiveList.defValue();
        this.add((Ordinal)name, (Object)XMLConfiguration.getInstance().add((Ordinal)Parameters.StatisticsLoggerPause, Long.parseLong(pause)).add((Ordinal)Parameters.StatisticsLoggerDelay, Long.parseLong(delay)).add((Ordinal)Parameters.StatisticsEnabled, Boolean.parseBoolean(enabled)).add((Ordinal)Parameters.StatisticsActiveList, active_records));
    }

    protected void addDictionary(Parameters name, Node node) {
        AppConfiguration dicConfiguration = XMLConfiguration.getInstance();
        Node param = node.getAttributes().getNamedItem("class");
        if (param != null) {
            String clazz = param.getNodeValue();
            dicConfiguration.add((Ordinal)Parameters.DictionaryClass, clazz);
        }
        if ((param = node.getAttributes().getNamedItem("enabled")) != null) {
            String enabled = param.getNodeValue();
            dicConfiguration.add((Ordinal)Parameters.DictionaryEnabled, Boolean.valueOf(enabled));
        }
        if ((param = node.getAttributes().getNamedItem("sendLevel")) != null) {
            String sendLevel = param.getNodeValue();
            dicConfiguration.add((Ordinal)Parameters.DictionarySendLevel, sendLevel);
        }
        if ((param = node.getAttributes().getNamedItem("receiveLevel")) != null) {
            String receiveLevel = param.getNodeValue();
            dicConfiguration.add((Ordinal)Parameters.DictionaryReceiveLevel, receiveLevel);
        }
        this.add((Ordinal)name, (Object)dicConfiguration);
    }

    protected void appendOtherParameter(Node node) {
    }

    protected void addThreadPool(Node item) {
        AppConfiguration threadPoolConfiguration = EmptyConfiguration.getInstance();
        NamedNodeMap attributes = item.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            Node n = attributes.item(index);
            int v = Integer.parseInt(n.getNodeValue());
            if (n.getNodeName().equals("size")) {
                threadPoolConfiguration.add((Ordinal)Parameters.ThreadPoolSize, v);
                continue;
            }
            if (!n.getNodeName().equals("priority")) continue;
            threadPoolConfiguration.add((Ordinal)Parameters.ThreadPoolPriority, v);
        }
        if (!threadPoolConfiguration.isAttributeExist(Parameters.ThreadPoolSize.ordinal())) {
            threadPoolConfiguration.add((Ordinal)Parameters.ThreadPoolSize, Parameters.ThreadPoolSize.defValue());
        }
        if (!threadPoolConfiguration.isAttributeExist(Parameters.ThreadPoolPriority.ordinal())) {
            threadPoolConfiguration.add((Ordinal)Parameters.ThreadPoolPriority, Parameters.ThreadPoolPriority.defValue());
        }
        this.add((Ordinal)Parameters.ThreadPool, (Object)threadPoolConfiguration);
    }

    protected void addSecurity(Node node) {
        NodeList c = node.getChildNodes();
        ArrayList<Configuration> items = new ArrayList<Configuration>();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (!nodeName.equals("SecurityData")) continue;
            items.add(this.addSecurityData(c.item(i)));
        }
        this.add((Ordinal)Parameters.Security, items.toArray(this.EMPTY_ARRAY));
    }

    protected Configuration addSecurityData(Node node) {
        AppConfiguration sd = XMLConfiguration.getInstance().add((Ordinal)Parameters.SDName, node.getAttributes().getNamedItem("name").getNodeValue()).add((Ordinal)Parameters.SDProtocol, node.getAttributes().getNamedItem("protocol").getNodeValue()).add((Ordinal)Parameters.SDEnableSessionCreation, Boolean.valueOf(node.getAttributes().getNamedItem("enable_session_creation").getNodeValue())).add((Ordinal)Parameters.SDUseClientMode, Boolean.valueOf(node.getAttributes().getNamedItem("use_client_mode").getNodeValue()));
        NodeList c = node.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            Node cnode = c.item(i);
            String nodeName = cnode.getNodeName();
            if (nodeName.equals("CipherSuites")) {
                sd.add((Ordinal)Parameters.CipherSuites, cnode.getTextContent().trim());
            }
            if (nodeName.equals("KeyData")) {
                sd.add((Ordinal)Parameters.KeyData, (Object)XMLConfiguration.getInstance().add((Ordinal)Parameters.KDManager, cnode.getAttributes().getNamedItem("manager").getNodeValue()).add((Ordinal)Parameters.KDStore, cnode.getAttributes().getNamedItem("store").getNodeValue()).add((Ordinal)Parameters.KDFile, cnode.getAttributes().getNamedItem("file").getNodeValue()).add((Ordinal)Parameters.KDPwd, cnode.getAttributes().getNamedItem("pwd").getNodeValue()));
            }
            if (!nodeName.equals("TrustData")) continue;
            sd.add((Ordinal)Parameters.TrustData, (Object)XMLConfiguration.getInstance().add((Ordinal)Parameters.TDManager, cnode.getAttributes().getNamedItem("manager").getNodeValue()).add((Ordinal)Parameters.TDStore, cnode.getAttributes().getNamedItem("store").getNodeValue()).add((Ordinal)Parameters.TDFile, cnode.getAttributes().getNamedItem("file").getNodeValue()).add((Ordinal)Parameters.TDPwd, cnode.getAttributes().getNamedItem("pwd").getNodeValue()));
        }
        return sd;
    }

    protected void addNetwork(Node node) {
        NodeList c = node.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (nodeName.equals("Peers")) {
                this.addPeers(c.item(i));
                continue;
            }
            if (!nodeName.equals("Realms")) continue;
            this.addRealms(c.item(i));
        }
    }

    protected void addPeers(Node node) {
        NodeList c = node.getChildNodes();
        ArrayList<Configuration> items = new ArrayList<Configuration>();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (!nodeName.equals("Peer")) continue;
            items.add(this.addPeer(c.item(i)));
        }
        this.add((Ordinal)Parameters.PeerTable, items.toArray(this.EMPTY_ARRAY));
    }

    protected void addRealms(Node node) {
        NodeList c = node.getChildNodes();
        ArrayList<Configuration> items = new ArrayList<Configuration>();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (!nodeName.equals("Realm")) continue;
            items.add(this.addRealm(c.item(i)));
        }
        this.add((Ordinal)Parameters.RealmTable, items.toArray(this.EMPTY_ARRAY));
    }

    protected Configuration addPeer(Node node) {
        AppConfiguration peerConfig = XMLConfiguration.getInstance().add((Ordinal)Parameters.PeerRating, new Integer(node.getAttributes().getNamedItem("rating").getNodeValue())).add((Ordinal)Parameters.PeerName, node.getAttributes().getNamedItem("name").getNodeValue());
        if (node.getAttributes().getNamedItem("ip") != null) {
            peerConfig.add((Ordinal)Parameters.PeerIp, node.getAttributes().getNamedItem("ip").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("portRange") != null) {
            peerConfig.add((Ordinal)Parameters.PeerLocalPortRange, node.getAttributes().getNamedItem("portRange").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("security_ref") != null) {
            peerConfig.add((Ordinal)Parameters.SecurityRef, node.getAttributes().getNamedItem("security_ref").getNodeValue());
        }
        return peerConfig;
    }

    protected Configuration addRealm(Node node) {
        AppConfiguration realmEntry = XMLConfiguration.getInstance().add((Ordinal)Parameters.ApplicationId, this.addApplicationID(node.getChildNodes())).add((Ordinal)org.jdiameter.server.impl.helpers.Parameters.RealmName, this.getAttrValue(node, "name")).add((Ordinal)org.jdiameter.server.impl.helpers.Parameters.RealmHosts, this.getAttrValue(node, "peers")).add((Ordinal)org.jdiameter.server.impl.helpers.Parameters.RealmLocalAction, this.getAttrValue(node, "local_action")).add((Ordinal)org.jdiameter.server.impl.helpers.Parameters.RealmEntryIsDynamic, Boolean.valueOf(this.getAttrValue(node, "dynamic"))).add((Ordinal)org.jdiameter.server.impl.helpers.Parameters.RealmEntryExpTime, Long.valueOf(this.getAttrValue(node, "exp_time")));
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String nodeName = childNodes.item(i).getNodeName();
            if (!nodeName.equals("Agent")) continue;
            realmEntry.add((Ordinal)Parameters.Agent, (Object)this.addAgent(childNodes.item(i)));
        }
        return XMLConfiguration.getInstance().add((Ordinal)Parameters.RealmEntry, (Object)realmEntry);
    }

    protected Configuration addAgent(Node node) {
        AppConfiguration agentConf = XMLConfiguration.getInstance();
        NodeList agentChildren = node.getChildNodes();
        for (int index = 0; index < agentChildren.getLength(); ++index) {
            Node n = agentChildren.item(index);
            if (!n.getNodeName().equals("Properties")) continue;
            agentConf.add((Ordinal)Parameters.Properties, this.getProperties(n).toArray(this.EMPTY_ARRAY));
        }
        return agentConf;
    }

    protected List<Configuration> getProperties(Node node) {
        ArrayList<Configuration> props = new ArrayList<Configuration>();
        NodeList propertiesChildren = node.getChildNodes();
        for (int index = 0; index < propertiesChildren.getLength(); ++index) {
            Node n = propertiesChildren.item(index);
            if (!n.getNodeName().equals("Property")) continue;
            AppConfiguration property = XMLConfiguration.getInstance();
            property.add((Ordinal)Parameters.PropertyName, n.getAttributes().getNamedItem(Parameters.PropertyName.name()).getNodeValue());
            property.add((Ordinal)Parameters.PropertyValue, n.getAttributes().getNamedItem(Parameters.PropertyValue.name()).getNodeValue());
            props.add(property);
        }
        return props;
    }

    protected Configuration addApplicationID(NodeList node) {
        for (int i = 0; i < node.getLength(); ++i) {
            String nodeName = node.item(i).getNodeName();
            if (!nodeName.equals("ApplicationID")) continue;
            return this.addApplicationID(node.item(i));
        }
        return null;
    }

    protected Configuration addApplicationID(Node node) {
        NodeList c = node.getChildNodes();
        AppConfiguration e = XMLConfiguration.getInstance();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (nodeName.equals("VendorId")) {
                e.add((Ordinal)Parameters.VendorId, this.getLongValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("AuthApplId")) {
                e.add((Ordinal)Parameters.AuthApplId, this.getLongValue(c.item(i)));
                continue;
            }
            if (!nodeName.equals("AcctApplId")) continue;
            e.add((Ordinal)Parameters.AcctApplId, this.getLongValue(c.item(i)));
        }
        return e;
    }

    protected void addExtensions(Node node) {
        NodeList c = node.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            String nodeName = c.item(i).getNodeName();
            if (nodeName.equals("MetaData")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalMetaData, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("MessageParser")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalMessageParser, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("ElementParser")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalElementParser, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("RouterEngine")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalRouterEngine, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("PeerController")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalPeerController, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("RealmController")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalRealmController, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("SessionFactory")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalSessionFactory, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("TransportFactory")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalTransportFactory, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("Connection")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalConnectionClass, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("PeerFsmFactory")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalPeerFsmFactory, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("StatisticFactory")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalStatisticFactory, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("ConcurrentFactory")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalConcurrentFactory, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("ConcurrentEntityFactory")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalConcurrentEntityFactory, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("SessionDatasource")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalSessionDatasource, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("TimerFacility")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalTimerFacility, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("AgentRedirect")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalAgentRedirect, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("AgentConfiguration")) {
                this.add((Ordinal)org.jdiameter.server.impl.helpers.ExtensionPoint.InternalAgentConfiguration, this.getValue(c.item(i)));
                continue;
            }
            if (nodeName.equals("StatisticProcessor")) {
                this.addInternalExtension(org.jdiameter.server.impl.helpers.ExtensionPoint.InternalStatisticProcessor, this.getValue(c.item(i)));
                continue;
            }
            this.appendOtherExtension(c.item(i));
        }
    }

    protected void addInternalExtension(Ordinal ep, String value) {
        Configuration[] extensionConfs = this.getChildren(org.jdiameter.server.impl.helpers.Parameters.Extensions.ordinal());
        AppConfiguration internalExtensions = (AppConfiguration)extensionConfs[ExtensionPoint.Internal.id()];
        internalExtensions.add(ep, value);
    }

    private void appendOtherExtension(Node item) {
    }

    protected Long getLongValue(Node node) {
        return new Long(this.getValue(node));
    }

    protected Integer getIntValue(Node node) {
        return new Integer(this.getValue(node));
    }

    protected String getValue(Node node) {
        return node.getAttributes().getNamedItem("value").getNodeValue();
    }

    protected String getAttrValue(Node node, String name) {
        return node.getAttributes().getNamedItem(name).getNodeValue();
    }
}

