/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.rf;

import java.io.Serializable;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.rf.ClientRfSession;
import org.jdiameter.api.rf.ClientRfSessionListener;
import org.jdiameter.api.rf.events.RfAccountingRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.rf.Event;
import org.jdiameter.client.impl.app.rf.IClientRfSessionData;
import org.jdiameter.common.api.app.IAppSessionState;
import org.jdiameter.common.api.app.rf.ClientRfSessionState;
import org.jdiameter.common.api.app.rf.IClientRfActionContext;
import org.jdiameter.common.impl.app.rf.AppRfSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRfSessionImpl
extends AppRfSessionImpl
implements EventListener<Request, Answer>,
ClientRfSession {
    private static final Logger logger = LoggerFactory.getLogger(ClientRfSessionImpl.class);
    public static final int DELIVER_AND_GRANT = 1;
    public static final int GRANT_AND_LOSE = 3;
    protected transient IClientRfActionContext context;
    protected transient ClientRfSessionListener listener;
    protected static final String TIMER_NAME_INTERIM = "CLIENT_INTERIM";
    protected IClientRfSessionData sessionData;

    public ClientRfSessionImpl(IClientRfSessionData sessionData, ISessionFactory sessionFactory, ClientRfSessionListener clientAccSessionListener, IClientRfActionContext iClientRfActionContext, StateChangeListener<AppSession> stateChangeListener, ApplicationId applicationId) {
        super(sessionFactory, sessionData);
        this.appId = applicationId;
        this.listener = clientAccSessionListener;
        this.context = iClientRfActionContext;
        this.sessionData = sessionData;
        super.addStateChangeNotification(stateChangeListener);
    }

    public void sendAccountRequest(RfAccountingRequest accountRequest) throws InternalException, IllegalStateException, RouteException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            this.handleEvent(new Event(accountRequest));
            try {
                this.session.send(accountRequest.getMessage(), (EventListener)this);
                this.sessionData.setDestinationRealm(accountRequest.getMessage().getAvps().getAvp(283).getDiameterIdentity());
                Avp destHostAvp = accountRequest.getMessage().getAvps().getAvp(293);
                if (destHostAvp != null) {
                    this.sessionData.setDestinationHost(destHostAvp.getDiameterIdentity());
                }
            }
            catch (Throwable t) {
                logger.debug("Failed to send ACR.", t);
                this.handleEvent(new Event(Event.Type.FAILED_SEND_RECORD, accountRequest));
            }
        }
        catch (Exception exc) {
            throw new InternalException((Throwable)exc);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    protected synchronized void storeToBuffer(Request accountRequest) {
        this.sessionData.setBuffer(accountRequest);
    }

    protected synchronized boolean checkBufferSpace() {
        return this.sessionData.getBuffer() == null;
    }

    protected void setState(IAppSessionState newState) {
        ClientRfSessionState oldState = this.sessionData.getClientRfSessionState();
        this.sessionData.setClientRfSessionState((ClientRfSessionState)newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)((Object)newState));
        }
    }

    public boolean isStateless() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        ClientRfSessionState state;
        ClientRfSessionState oldState = state = this.sessionData.getClientRfSessionState();
        try {
            ClientRfSessionImpl data;
            block93: {
                block16 : switch (state) {
                    case IDLE: {
                        switch ((Event.Type)event.getType()) {
                            case SEND_START_RECORD: {
                                this.setState(ClientRfSessionState.PENDING_START);
                                break block16;
                            }
                            case SEND_EVENT_RECORD: {
                                this.setState(ClientRfSessionState.PENDING_EVENT);
                                break block16;
                            }
                        }
                        throw new IllegalStateException("Current state " + state + " action " + event.getType());
                    }
                    case PENDING_START: {
                        RfAccountingRequest answer;
                        Request str;
                        Avp accRtReq;
                        RfAccountingRequest request;
                        switch ((Event.Type)event.getType()) {
                            case FAILED_SEND_RECORD: {
                                request = (RfAccountingRequest)event.getData();
                                accRtReq = request.getMessage().getAvps().getAvp(483);
                                if (this.checkBufferSpace() && accRtReq != null && accRtReq.getInteger32() != 1) {
                                    this.storeToBuffer((Request)request.getMessage());
                                    this.setState(ClientRfSessionState.OPEN);
                                    break;
                                }
                                if (!this.checkBufferSpace() && accRtReq != null && accRtReq.getInteger32() == 3) {
                                    this.setState(ClientRfSessionState.OPEN);
                                    break;
                                }
                                try {
                                    if (this.context == null) break block16;
                                    str = this.createSessionTermRequest();
                                    this.context.disconnectUserOrDev(this, str);
                                    this.session.send((Message)str, (EventListener)this);
                                    break block16;
                                }
                                finally {
                                    this.setState(ClientRfSessionState.IDLE);
                                }
                            }
                            case RECEIVED_RECORD: {
                                this.processInterimIntervalAvp(event);
                                this.setState(ClientRfSessionState.OPEN);
                                break;
                            }
                            case FAILED_RECEIVE_RECORD: {
                                try {
                                    answer = (RfAccountingRequest)event.getData();
                                    accRtReq = answer.getMessage().getAvps().getAvp(483);
                                    if (accRtReq != null && accRtReq.getInteger32() == 3) {
                                        this.setState(ClientRfSessionState.OPEN);
                                        break;
                                    }
                                    if (accRtReq == null || accRtReq.getInteger32() == 3) break block16;
                                    try {
                                        if (this.context == null) break block16;
                                        Request str2 = this.createSessionTermRequest();
                                        this.context.disconnectUserOrDev(this, str2);
                                        this.session.send((Message)str2, (EventListener)this);
                                        break block16;
                                    }
                                    finally {
                                        this.setState(ClientRfSessionState.IDLE);
                                    }
                                }
                                catch (Exception e) {
                                    logger.debug("Can not process answer", (Throwable)e);
                                    this.setState(ClientRfSessionState.IDLE);
                                    break;
                                }
                            }
                            case SEND_STOP_RECORD: {
                                if (this.context != null) {
                                    str = this.createSessionTermRequest();
                                    this.context.disconnectUserOrDev(this, str);
                                    this.storeToBuffer(str);
                                } else {
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case OPEN: {
                        switch ((Event.Type)event.getType()) {
                            case SEND_STOP_RECORD: {
                                this.setState(ClientRfSessionState.PENDING_CLOSE);
                                break;
                            }
                            case SEND_INTERIM_RECORD: {
                                this.setState(ClientRfSessionState.PENDING_INTERIM);
                                break;
                            }
                            case RECEIVED_RECORD: {
                                this.processInterimIntervalAvp(event);
                            }
                        }
                        break;
                    }
                    case PENDING_INTERIM: {
                        RfAccountingRequest answer;
                        Request str;
                        Avp accRtReq;
                        RfAccountingRequest request;
                        switch ((Event.Type)event.getType()) {
                            case RECEIVED_RECORD: {
                                this.processInterimIntervalAvp(event);
                                this.setState(ClientRfSessionState.OPEN);
                                break;
                            }
                            case FAILED_SEND_RECORD: {
                                request = (RfAccountingRequest)event.getData();
                                accRtReq = request.getMessage().getAvps().getAvp(483);
                                if (this.checkBufferSpace() && accRtReq != null && accRtReq.getInteger32() != 1) {
                                    this.storeToBuffer((Request)request.getMessage());
                                    this.setState(ClientRfSessionState.OPEN);
                                    break;
                                }
                                if (!this.checkBufferSpace() && accRtReq != null && accRtReq.getInteger32() == 3) {
                                    this.setState(ClientRfSessionState.OPEN);
                                    break;
                                }
                                if (!this.checkBufferSpace() && accRtReq != null && accRtReq.getInteger32() != 3) {
                                    try {
                                        if (this.context == null) break block16;
                                        str = this.createSessionTermRequest();
                                        this.context.disconnectUserOrDev(this, str);
                                        this.session.send((Message)str, (EventListener)this);
                                        break block16;
                                    }
                                    finally {
                                        this.setState(ClientRfSessionState.IDLE);
                                    }
                                }
                                break block93;
                            }
                            case FAILED_RECEIVE_RECORD: {
                                try {
                                    answer = (RfAccountingRequest)event.getData();
                                    accRtReq = answer.getMessage().getAvps().getAvp(483);
                                    if (accRtReq != null && accRtReq.getInteger32() == 3) {
                                        this.setState(ClientRfSessionState.OPEN);
                                        break;
                                    }
                                    if (accRtReq == null || accRtReq.getInteger32() == 3) break block16;
                                    try {
                                        if (this.context == null) break block16;
                                        Request str3 = this.createSessionTermRequest();
                                        this.context.disconnectUserOrDev(this, str3);
                                        this.session.send((Message)str3, (EventListener)this);
                                        break block16;
                                    }
                                    finally {
                                        this.setState(ClientRfSessionState.IDLE);
                                    }
                                }
                                catch (Exception e) {
                                    logger.debug("Can not process received request", (Throwable)e);
                                    this.setState(ClientRfSessionState.IDLE);
                                    break;
                                }
                            }
                            case SEND_STOP_RECORD: {
                                if (this.context != null) {
                                    str = this.createSessionTermRequest();
                                    this.context.disconnectUserOrDev(this, str);
                                    this.storeToBuffer(str);
                                } else {
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case PENDING_EVENT: {
                        switch ((Event.Type)event.getType()) {
                            case RECEIVED_RECORD: {
                                this.setState(ClientRfSessionState.IDLE);
                                break;
                            }
                            case FAILED_SEND_RECORD: {
                                if (this.checkBufferSpace()) {
                                    data = (RfAccountingRequest)event.getData();
                                    this.storeToBuffer((Request)data.getMessage());
                                }
                                this.setState(ClientRfSessionState.IDLE);
                                break;
                            }
                            case FAILED_RECEIVE_RECORD: {
                                this.setState(ClientRfSessionState.IDLE);
                            }
                        }
                        break;
                    }
                    case PENDING_BUFFERED: {
                        switch ((Event.Type)event.getType()) {
                            case RECEIVED_RECORD: {
                                data = this;
                                synchronized (data) {
                                    this.storeToBuffer(null);
                                }
                                this.setState(ClientRfSessionState.IDLE);
                                break;
                            }
                            case FAILED_SEND_RECORD: {
                                this.setState(ClientRfSessionState.IDLE);
                                break;
                            }
                            case FAILED_RECEIVE_RECORD: {
                                data = this;
                                synchronized (data) {
                                    this.storeToBuffer(null);
                                }
                                this.setState(ClientRfSessionState.IDLE);
                            }
                        }
                        break;
                    }
                    case PENDING_CLOSE: {
                        switch ((Event.Type)event.getType()) {
                            case RECEIVED_RECORD: {
                                this.setState(ClientRfSessionState.IDLE);
                                break block16;
                            }
                            case FAILED_SEND_RECORD: {
                                if (this.checkBufferSpace()) {
                                    data = (RfAccountingRequest)event.getData();
                                    this.storeToBuffer((Request)data.getMessage());
                                }
                                this.setState(ClientRfSessionState.IDLE);
                                break block16;
                            }
                            case FAILED_RECEIVE_RECORD: {
                                this.setState(ClientRfSessionState.IDLE);
                            }
                        }
                    }
                }
            }
            if (oldState == state) return true;
            switch (state) {
                case IDLE: {
                    try {
                        data = this;
                        synchronized (data) {
                            if (this.sessionData.getBuffer() == null) return true;
                            this.session.send((Message)this.sessionData.getBuffer(), (EventListener)this);
                            this.setState(ClientRfSessionState.PENDING_BUFFERED);
                            return true;
                        }
                    }
                    catch (Exception e) {
                        logger.debug("can not send buffered message", (Throwable)e);
                        ClientRfSessionImpl clientRfSessionImpl = this;
                        synchronized (clientRfSessionImpl) {
                            Request buffer = this.sessionData.getBuffer();
                            if (this.context == null || buffer == null || this.context.failedSendRecord(this, buffer)) return true;
                            this.storeToBuffer(null);
                            return true;
                        }
                    }
                }
            }
            return true;
        }
        catch (Throwable t) {
            throw new InternalException(t);
        }
    }

    protected void processInterimIntervalAvp(StateEvent event) throws InternalException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTimer(String timerName) {
        if (timerName.equals(TIMER_NAME_INTERIM) && this.context != null) {
            try {
                Request interimRecord = this.createInterimRecord();
                this.context.interimIntervalElapses(this, interimRecord);
                this.sendAndStateLock.lock();
                this.session.send((Message)interimRecord, (EventListener)this);
                this.setState(ClientRfSessionState.PENDING_INTERIM);
                this.sessionData.setTsTimerId(null);
            }
            catch (Exception e) {
                logger.debug("Can not process Interim Interval AVP", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInterimTimer(long v) {
        try {
            this.sendAndStateLock.lock();
            this.sessionData.setTsTimerId(this.timerFacility.schedule(this.getSessionId(), TIMER_NAME_INTERIM, v));
            return;
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelInterimTimer() {
        try {
            this.sendAndStateLock.lock();
            Serializable timerId = this.sessionData.getTsTimerId();
            if (timerId != null) {
                this.timerFacility.cancel(timerId);
                this.sessionData.setTsTimerId(null);
            }
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public <E> E getState(Class<E> eClass) {
        return (E)(eClass == ClientRfSessionState.class ? this.sessionData.getTsTimerId() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedSuccessMessage(Request request, Answer answer) {
        if (request.getCommandCode() == 271) {
            try {
                this.sendAndStateLock.lock();
                this.handleEvent(new Event(this.createAccountAnswer(answer)));
            }
            catch (Exception e) {
                logger.debug("Can not process received request", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
            try {
                this.listener.doRfAccountingAnswerEvent((ClientRfSession)this, this.createAccountRequest(request), this.createAccountAnswer(answer));
            }
            catch (Exception e) {
                logger.debug("Unable to deliver message to listener.", (Throwable)e);
            }
        } else {
            try {
                this.listener.doOtherEvent((AppSession)this, (AppRequestEvent)this.createAccountRequest(request), (AppAnswerEvent)this.createAccountAnswer(answer));
            }
            catch (Exception e) {
                logger.debug("Can not process received request", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeoutExpired(Request request) {
        try {
            this.sendAndStateLock.lock();
            this.handleEvent(new Event(Event.Type.FAILED_RECEIVE_RECORD, this.createAccountRequest(request)));
        }
        catch (Exception e) {
            logger.debug("Can not handle timeout event", (Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public Answer processRequest(Request request) {
        if (request.getCommandCode() == 271) {
            try {
                this.listener.doRfAccountingAnswerEvent((ClientRfSession)this, this.createAccountRequest(request), null);
            }
            catch (Exception e) {
                logger.debug("Can not process received request", (Throwable)e);
            }
        } else {
            try {
                this.listener.doOtherEvent((AppSession)this, (AppRequestEvent)this.createAccountRequest(request), null);
            }
            catch (Exception e) {
                logger.debug("Can not process received request", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    protected Request createInterimRecord() {
        Request interimRecord = this.session.createRequest(271, this.appId, this.sessionData.getDestinationRealm(), this.sessionData.getDestinationHost());
        interimRecord.getAvps().addAvp(480, 3);
        return interimRecord;
    }

    protected Request createSessionTermRequest() {
        return this.session.createRequest(275, this.appId, this.sessionData.getDestinationRealm(), this.sessionData.getDestinationHost());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientRfSessionImpl other = (ClientRfSessionImpl)obj;
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
            }
            catch (Exception e) {
                logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }
}

