/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.cca;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.auth.events.ReAuthAnswer;
import org.jdiameter.api.auth.events.ReAuthRequest;
import org.jdiameter.api.cca.ClientCCASession;
import org.jdiameter.api.cca.ClientCCASessionListener;
import org.jdiameter.api.cca.events.JCreditControlAnswer;
import org.jdiameter.api.cca.events.JCreditControlRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.cca.Event;
import org.jdiameter.client.impl.app.cca.IClientCCASessionData;
import org.jdiameter.common.api.app.cca.ClientCCASessionState;
import org.jdiameter.common.api.app.cca.ICCAMessageFactory;
import org.jdiameter.common.api.app.cca.IClientCCASessionContext;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.cca.AppCCASessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCCASessionImpl
extends AppCCASessionImpl
implements ClientCCASession,
NetworkReqListener,
EventListener<Request, Answer> {
    private static final Logger logger = LoggerFactory.getLogger(ClientCCASessionImpl.class);
    protected IClientCCASessionData sessionData;
    protected Lock sendAndStateLock = new ReentrantLock();
    protected ArrayList<Event> eventQueue = new ArrayList();
    protected ICCAMessageFactory factory;
    protected ClientCCASessionListener listener;
    protected IClientCCASessionContext context;
    protected static final String TX_TIMER_NAME = "CCA_CLIENT_TX_TIMER";
    protected static final long TX_TIMER_DEFAULT_VALUE = 1800000L;
    protected long[] authAppIds = new long[]{4L};
    protected static final int CCFH_TERMINATE = 0;
    protected static final int CCFH_CONTINUE = 1;
    protected static final int CCFH_RETRY_AND_TERMINATE = 2;
    private static final int DDFH_TERMINATE_OR_BUFFER = 0;
    private static final int DDFH_CONTINUE = 1;
    private static final int DIRECT_DEBITING = 0;
    private static final int REFUND_ACCOUNT = 1;
    private static final int CHECK_BALANCE = 2;
    private static final int PRICE_ENQUIRY = 3;
    private static final int EVENT_REQUEST = 4;
    private static final long END_USER_SERVICE_DENIED = 4010L;
    private static final long CREDIT_CONTROL_NOT_APPLICABLE = 4011L;
    private static final long USER_UNKNOWN = 5030L;
    private static final long DIAMETER_UNABLE_TO_DELIVER = 3002L;
    private static final long DIAMETER_TOO_BUSY = 3004L;
    private static final long DIAMETER_LOOP_DETECTED = 3005L;
    protected static final Set<Long> temporaryErrorCodes;

    public ClientCCASessionImpl(IClientCCASessionData data, ICCAMessageFactory fct, ISessionFactory sf, ClientCCASessionListener lst, IClientCCASessionContext ctx, StateChangeListener<AppSession> stLst) {
        super(sf, data);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (data == null) {
            throw new IllegalArgumentException("SessionData can not be null");
        }
        if (fct.getApplicationIds() == null) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.sessionData = data;
        this.context = ctx;
        this.authAppIds = fct.getApplicationIds();
        this.listener = lst;
        this.factory = fct;
        super.addStateChangeNotification(stLst);
    }

    protected int getLocalCCFH() {
        return this.sessionData.getGatheredCCFH() >= 0 ? this.sessionData.getGatheredCCFH() : this.context.getDefaultCCFHValue();
    }

    protected int getLocalDDFH() {
        return this.sessionData.getGatheredDDFH() >= 0 ? this.sessionData.getGatheredDDFH() : this.context.getDefaultDDFHValue();
    }

    public void sendCreditControlRequest(JCreditControlRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.extractFHAVPs(request, null);
        this.handleEvent(new Event(true, request, null));
    }

    public void sendReAuthAnswer(ReAuthAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.handleEvent(new Event(Event.Type.SEND_RAA, null, (AppAnswerEvent)answer));
    }

    public boolean isStateless() {
        return false;
    }

    public boolean isEventBased() {
        return this.sessionData.isEventBased();
    }

    public <E> E getState(Class<E> stateType) {
        return (E)(stateType == ClientCCASessionState.class ? this.sessionData.getClientCCASessionState() : null);
    }

    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        return this.isEventBased() ? this.handleEventForEventBased(event) : this.handleEventForSessionBased(event);
    }

    protected boolean handleEventForEventBased(StateEvent event) throws InternalException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            Event localEvent = (Event)event;
            Event.Type eventType = (Event.Type)localEvent.getType();
            ClientCCASessionState state = this.sessionData.getClientCCASessionState();
            block4 : switch (state) {
                case IDLE: {
                    switch (eventType) {
                        case SEND_EVENT_REQUEST: {
                            this.startTx((JCreditControlRequest)localEvent.getRequest());
                            this.setState(ClientCCASessionState.PENDING_EVENT);
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {
                                logger.debug("Failure handling send event request", (Throwable)e);
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block4;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case PENDING_EVENT: {
                    switch (eventType) {
                        case RECEIVE_EVENT_ANSWER: {
                            AppAnswerEvent answer = (AppAnswerEvent)localEvent.getAnswer();
                            try {
                                long resultCode = answer.getResultCodeAvp().getUnsigned32();
                                if (this.isSuccess(resultCode)) {
                                    this.setState(ClientCCASessionState.IDLE, false);
                                }
                                if (this.isProvisional(resultCode) || this.isFailure(resultCode)) {
                                    this.handleFailureMessage((JCreditControlAnswer)answer, (JCreditControlRequest)localEvent.getRequest(), eventType);
                                }
                                this.deliverCCAnswer((JCreditControlRequest)localEvent.getRequest(), (JCreditControlAnswer)localEvent.getAnswer());
                            }
                            catch (AvpDataException e) {
                                logger.debug("Failure handling received answer event", (Throwable)e);
                                this.setState(ClientCCASessionState.IDLE, false);
                            }
                            break block4;
                        }
                        case Tx_TIMER_FIRED: {
                            this.handleTxExpires(localEvent.getRequest().getMessage());
                            break block4;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case PENDING_BUFFERED: {
                    switch (eventType) {
                        case RECEIVE_EVENT_ANSWER: {
                            this.setState(ClientCCASessionState.IDLE, false);
                            this.sessionData.setBuffer(null);
                            this.deliverCCAnswer((JCreditControlRequest)localEvent.getRequest(), (JCreditControlAnswer)localEvent.getAnswer());
                            break block4;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                default: {
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                }
            }
            this.dispatch();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    protected boolean handleEventForSessionBased(StateEvent event) throws InternalException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            Event localEvent = (Event)event;
            Event.Type eventType = (Event.Type)localEvent.getType();
            ClientCCASessionState state = this.sessionData.getClientCCASessionState();
            block8 : switch (state) {
                case IDLE: {
                    switch (eventType) {
                        case SEND_INITIAL_REQUEST: {
                            this.startTx((JCreditControlRequest)localEvent.getRequest());
                            this.setState(ClientCCASessionState.PENDING_INITIAL);
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block8;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case PENDING_INITIAL: {
                    AppAnswerEvent answer = (AppAnswerEvent)localEvent.getAnswer();
                    switch (eventType) {
                        case RECEIVED_INITIAL_ANSWER: {
                            long resultCode = answer.getResultCodeAvp().getUnsigned32();
                            if (this.isSuccess(resultCode)) {
                                this.stopTx();
                                this.setState(ClientCCASessionState.OPEN);
                            } else if (this.isProvisional(resultCode) || this.isFailure(resultCode)) {
                                this.handleFailureMessage((JCreditControlAnswer)answer, (JCreditControlRequest)localEvent.getRequest(), eventType);
                            }
                            this.deliverCCAnswer((JCreditControlRequest)localEvent.getRequest(), (JCreditControlAnswer)localEvent.getAnswer());
                            break block8;
                        }
                        case Tx_TIMER_FIRED: {
                            this.handleTxExpires(localEvent.getRequest().getMessage());
                            break block8;
                        }
                        case SEND_UPDATE_REQUEST: 
                        case SEND_TERMINATE_REQUEST: {
                            this.eventQueue.add(localEvent);
                            break block8;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case OPEN: {
                    switch (eventType) {
                        case SEND_UPDATE_REQUEST: {
                            this.startTx((JCreditControlRequest)localEvent.getRequest());
                            this.setState(ClientCCASessionState.PENDING_UPDATE);
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block8;
                        }
                        case SEND_TERMINATE_REQUEST: {
                            this.setState(ClientCCASessionState.PENDING_TERMINATION);
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block8;
                        }
                        case RECEIVED_RAR: {
                            this.deliverRAR((ReAuthRequest)localEvent.getRequest());
                            break block8;
                        }
                        case SEND_RAA: {
                            try {
                                this.dispatchEvent(localEvent.getAnswer());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block8;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case PENDING_UPDATE: {
                    AppAnswerEvent answer = (AppAnswerEvent)localEvent.getAnswer();
                    switch (eventType) {
                        case RECEIVED_UPDATE_ANSWER: {
                            long resultCode = answer.getResultCodeAvp().getUnsigned32();
                            if (this.isSuccess(resultCode)) {
                                this.stopTx();
                                this.setState(ClientCCASessionState.OPEN);
                            } else if (this.isProvisional(resultCode) || this.isFailure(resultCode)) {
                                this.handleFailureMessage((JCreditControlAnswer)answer, (JCreditControlRequest)localEvent.getRequest(), eventType);
                            }
                            this.deliverCCAnswer((JCreditControlRequest)localEvent.getRequest(), (JCreditControlAnswer)localEvent.getAnswer());
                            break;
                        }
                        case Tx_TIMER_FIRED: {
                            this.handleTxExpires(localEvent.getRequest().getMessage());
                            break;
                        }
                        case SEND_UPDATE_REQUEST: 
                        case SEND_TERMINATE_REQUEST: {
                            this.eventQueue.add(localEvent);
                            break;
                        }
                        case RECEIVED_RAR: {
                            this.deliverRAR((ReAuthRequest)localEvent.getRequest());
                            break;
                        }
                        case SEND_RAA: {
                            try {
                                this.dispatchEvent(localEvent.getAnswer());
                                break;
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                        }
                    }
                    break;
                }
                case PENDING_TERMINATION: {
                    switch (eventType) {
                        case SEND_UPDATE_REQUEST: {
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {}
                            break block8;
                        }
                        case RECEIVED_TERMINATED_ANSWER: {
                            this.deliverCCAnswer((JCreditControlRequest)localEvent.getRequest(), (JCreditControlAnswer)localEvent.getAnswer());
                            this.setState(ClientCCASessionState.IDLE, true);
                            break block8;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                default: {
                    this.setState(ClientCCASessionState.IDLE, true);
                }
            }
            this.dispatch();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery ad = new AnswerDelivery();
        ad.session = this;
        ad.request = request;
        ad.answer = answer;
        this.scheduler.execute(ad);
    }

    public void timeoutExpired(Request request) {
        if (request.getCommandCode() == 272) {
            try {
                this.handleSendFailure(null, null, (Message)request);
            }
            catch (Exception e) {
                logger.debug("Failure processing timeout message for request", (Throwable)e);
            }
        }
    }

    protected void startTx(JCreditControlRequest request) {
        long txTimerValue = this.context.getDefaultTxTimerValue();
        if (txTimerValue < 0L) {
            txTimerValue = 1800000L;
        }
        this.stopTx();
        logger.debug("Scheduling TX Timer {}", (Object)txTimerValue);
        try {
            this.sessionData.setTxTimerRequest((Request)((AppEventImpl)request).getMessage());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to store request.", e);
        }
        this.sessionData.setTxTimerId(this.timerFacility.schedule(this.getSessionId(), TX_TIMER_NAME, 1800000L));
    }

    protected void stopTx() {
        Serializable txTimerId = this.sessionData.getTxTimerId();
        if (txTimerId != null) {
            this.sessionData.setTxTimerRequest(null);
            this.timerFacility.cancel(txTimerId);
            this.sessionData.setTxTimerId(null);
        }
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals(TX_TIMER_NAME)) {
            new TxTimerTask(this, this.sessionData.getTxTimerRequest()).run();
        }
    }

    protected void setState(ClientCCASessionState newState) {
        this.setState(newState, true);
    }

    protected void setState(ClientCCASessionState newState, boolean release) {
        block5: {
            try {
                ClientCCASessionState oldState = this.sessionData.getClientCCASessionState();
                this.sessionData.setClientCCASessionState(newState);
                for (StateChangeListener i : this.stateListeners) {
                    i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
                }
                if (newState == ClientCCASessionState.IDLE) {
                    if (release) {
                        this.release();
                    }
                    this.stopTx();
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("Failure switching to state " + this.sessionData.getClientCCASessionState() + " (release=" + release + ")", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                this.sendAndStateLock.lock();
                super.release();
            }
            catch (Exception e) {
                logger.debug("Failed to release session", (Throwable)e);
            }
            finally {
                this.sendAndStateLock.unlock();
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSendFailure(Exception e, Event.Type eventType, Message request) throws Exception {
        logger.debug("Failed to send message, type: {} message: {}, failure: {}", new Object[]{eventType, request, e != null ? e.getLocalizedMessage() : ""});
        try {
            this.sendAndStateLock.lock();
            ClientCCASessionState state = this.sessionData.getClientCCASessionState();
            if (this.isEventBased()) {
                int gatheredRequestedAction = this.sessionData.getGatheredRequestedAction();
                block1 : switch (state) {
                    case PENDING_EVENT: {
                        if (gatheredRequestedAction == 2 || gatheredRequestedAction == 3) {
                            this.setState(ClientCCASessionState.IDLE);
                            this.context.indicateServiceError(this);
                            break;
                        }
                        if (gatheredRequestedAction == 0) {
                            switch (this.getLocalDDFH()) {
                                case 0: {
                                    request.setReTransmitted(true);
                                    this.sessionData.setBuffer((Request)request);
                                    this.setState(ClientCCASessionState.IDLE, false);
                                    break block1;
                                }
                                case 1: {
                                    this.context.grantAccessOnDeliverFailure(this, request);
                                    break block1;
                                }
                            }
                            logger.warn("Invalid Direct-Debiting-Failure-Handling AVP value {}", (Object)this.getLocalDDFH());
                            break;
                        }
                        if (gatheredRequestedAction == 1) {
                            this.setState(ClientCCASessionState.IDLE, false);
                            request.setReTransmitted(true);
                            this.sessionData.setBuffer((Request)request);
                            break;
                        }
                        logger.warn("Invalid Requested-Action AVP value {}", (Object)gatheredRequestedAction);
                        break;
                    }
                    case PENDING_BUFFERED: {
                        this.setState(ClientCCASessionState.IDLE, false);
                        this.sessionData.setBuffer(null);
                        break;
                    }
                    default: {
                        logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                        break;
                    }
                }
            } else {
                switch (this.getLocalCCFH()) {
                    case 1: {
                        this.setState(ClientCCASessionState.IDLE, false);
                        this.context.grantAccessOnDeliverFailure(this, request);
                        break;
                    }
                    default: {
                        this.context.denyAccessOnDeliverFailure(this, request);
                        this.setState(ClientCCASessionState.IDLE, true);
                    }
                }
            }
            this.dispatch();
        }
        finally {
            this.sendAndStateLock.unlock();
        }
    }

    protected void handleFailureMessage(JCreditControlAnswer answer, JCreditControlRequest request, Event.Type eventType) {
        block38: {
            try {
                long resultCode = answer.getResultCodeAvp().getUnsigned32();
                ClientCCASessionState state = this.sessionData.getClientCCASessionState();
                Serializable txTimerId = this.sessionData.getTxTimerId();
                if (this.isEventBased()) {
                    int gatheredRequestedAction = this.sessionData.getGatheredRequestedAction();
                    switch (state) {
                        case PENDING_EVENT: {
                            if (resultCode == 4010L || resultCode == 5030L) {
                                if (txTimerId != null) {
                                    this.context.denyAccessOnFailureMessage(this);
                                    this.deliverCCAnswer(request, answer);
                                    this.setState(ClientCCASessionState.IDLE);
                                    break;
                                }
                                if (gatheredRequestedAction == 0 && txTimerId == null) {
                                    this.setState(ClientCCASessionState.IDLE);
                                    break;
                                }
                                break block38;
                            }
                            if (resultCode == 4011L && gatheredRequestedAction == 0) {
                                this.context.grantAccessOnFailureMessage(this);
                                this.deliverCCAnswer(request, answer);
                                this.setState(ClientCCASessionState.IDLE);
                                break;
                            }
                            if (temporaryErrorCodes.contains(resultCode)) {
                                if (gatheredRequestedAction == 2 || gatheredRequestedAction == 3) {
                                    this.context.indicateServiceError(this);
                                    this.deliverCCAnswer(request, answer);
                                    this.setState(ClientCCASessionState.IDLE);
                                    break;
                                }
                                if (gatheredRequestedAction == 0) {
                                    if (this.getLocalDDFH() == 1) {
                                        this.context.grantAccessOnFailureMessage(this);
                                        this.deliverCCAnswer(request, answer);
                                        this.setState(ClientCCASessionState.IDLE);
                                        break;
                                    }
                                    if (this.getLocalDDFH() == 0 && txTimerId != null) {
                                        this.context.denyAccessOnFailureMessage(this);
                                        this.deliverCCAnswer(request, answer);
                                        this.setState(ClientCCASessionState.IDLE);
                                        break;
                                    }
                                    break block38;
                                }
                                if (gatheredRequestedAction == 1) {
                                    this.sessionData.setBuffer((Request)request.getMessage());
                                    this.setState(ClientCCASessionState.IDLE, false);
                                    break;
                                }
                                logger.warn("Invalid combination for CCA Client FSM: State {}, Result-Code {}, Requested-Action {}, DDFH {}, Tx {}", new Object[]{state, resultCode, gatheredRequestedAction, this.getLocalDDFH(), txTimerId});
                                break;
                            }
                            if (gatheredRequestedAction == 2 || gatheredRequestedAction == 3) {
                                this.context.indicateServiceError(this);
                                this.deliverCCAnswer(request, answer);
                                this.setState(ClientCCASessionState.IDLE);
                                break;
                            }
                            if (gatheredRequestedAction == 0) {
                                if (this.getLocalDDFH() == 1) {
                                    this.context.grantAccessOnFailureMessage(this);
                                    this.deliverCCAnswer(request, answer);
                                    this.setState(ClientCCASessionState.IDLE);
                                    break;
                                }
                                if (this.getLocalDDFH() == 0 && txTimerId != null) {
                                    this.context.denyAccessOnFailureMessage(this);
                                    this.deliverCCAnswer(request, answer);
                                    this.setState(ClientCCASessionState.IDLE);
                                    break;
                                }
                                break block38;
                            }
                            if (gatheredRequestedAction == 1) {
                                this.sessionData.setBuffer(null);
                                this.context.indicateServiceError(this);
                                this.deliverCCAnswer(request, answer);
                                this.setState(ClientCCASessionState.IDLE);
                                break;
                            }
                            logger.warn("Invalid combination for CCA Client FSM: State {}, Result-Code {}, Requested-Action {}, DDFH {}, Tx {}", new Object[]{state, resultCode, gatheredRequestedAction, this.getLocalDDFH(), txTimerId});
                            break;
                        }
                        case PENDING_BUFFERED: {
                            this.sessionData.setBuffer(null);
                            this.setState(ClientCCASessionState.IDLE, false);
                            break;
                        }
                        default: {
                            logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                            break;
                        }
                    }
                    break block38;
                }
                block5 : switch (state) {
                    case PENDING_INITIAL: {
                        if (resultCode == 4011L) {
                            this.context.grantAccessOnFailureMessage(this);
                            this.setState(ClientCCASessionState.IDLE, false);
                            break;
                        }
                        if (resultCode == 4010L || resultCode == 5030L) {
                            this.context.denyAccessOnFailureMessage(this);
                            this.setState(ClientCCASessionState.IDLE, false);
                            break;
                        }
                        switch (this.getLocalCCFH()) {
                            case 1: {
                                this.context.grantAccessOnFailureMessage(this);
                                this.setState(ClientCCASessionState.IDLE, false);
                                break block5;
                            }
                            case 0: 
                            case 2: {
                                this.context.denyAccessOnFailureMessage(this);
                                this.setState(ClientCCASessionState.IDLE, false);
                                break block5;
                            }
                        }
                        logger.warn("Invalid value for CCFH: {}", (Object)this.getLocalCCFH());
                        break;
                    }
                    case PENDING_UPDATE: {
                        if (resultCode == 4011L) {
                            this.context.grantAccessOnFailureMessage(this);
                            this.setState(ClientCCASessionState.IDLE, false);
                            break;
                        }
                        if (resultCode == 4010L) {
                            this.context.denyAccessOnFailureMessage(this);
                            this.setState(ClientCCASessionState.IDLE, false);
                            break;
                        }
                        switch (this.getLocalCCFH()) {
                            case 1: {
                                this.context.grantAccessOnFailureMessage(this);
                                this.setState(ClientCCASessionState.IDLE, false);
                                break block5;
                            }
                            case 0: 
                            case 2: {
                                this.context.denyAccessOnFailureMessage(this);
                                this.setState(ClientCCASessionState.IDLE, false);
                                break block5;
                            }
                        }
                        logger.warn("Invalid value for CCFH: " + this.getLocalCCFH());
                        break;
                    }
                    default: {
                        logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block38;
                logger.debug("Failure handling failure message for Event " + answer + " (" + (Object)((Object)eventType) + ") and Request " + request, (Throwable)e);
            }
        }
    }

    protected void handleTxExpires(Message message) {
        ClientCCASessionState state = this.sessionData.getClientCCASessionState();
        Serializable txTimerId = this.sessionData.getTxTimerId();
        if (this.isEventBased()) {
            int gatheredRequestedAction = this.sessionData.getGatheredRequestedAction();
            if (gatheredRequestedAction == 2 || gatheredRequestedAction == 3) {
                this.context.indicateServiceError(this);
                this.setState(ClientCCASessionState.IDLE);
            } else if (gatheredRequestedAction == 0) {
                int gatheredDDFH = this.sessionData.getGatheredDDFH();
                if (gatheredDDFH == 0) {
                    this.sessionData.setBuffer((Request)message);
                    this.setState(ClientCCASessionState.IDLE, false);
                } else {
                    this.context.grantAccessOnTxExpire(this);
                    this.setState(ClientCCASessionState.PENDING_EVENT);
                }
            } else if (gatheredRequestedAction == 1) {
                message.setReTransmitted(true);
                this.sessionData.setBuffer((Request)message);
                this.setState(ClientCCASessionState.IDLE, false);
            }
        } else {
            block0 : switch (state) {
                case PENDING_INITIAL: {
                    switch (this.getLocalCCFH()) {
                        case 1: 
                        case 2: {
                            this.context.grantAccessOnTxExpire(this);
                            break block0;
                        }
                        case 0: {
                            this.context.denyAccessOnTxExpire(this);
                            this.setState(ClientCCASessionState.IDLE, true);
                            break block0;
                        }
                    }
                    logger.warn("Invalid value for CCFH: " + this.getLocalCCFH());
                    break;
                }
                case PENDING_UPDATE: {
                    switch (this.getLocalCCFH()) {
                        case 1: 
                        case 2: {
                            this.context.grantAccessOnTxExpire(this);
                            break block0;
                        }
                        case 0: {
                            this.context.denyAccessOnTxExpire(this);
                            this.setState(ClientCCASessionState.IDLE, true);
                            break block0;
                        }
                    }
                    logger.error("Bad value of CCFH: " + this.getLocalCCFH());
                    break;
                }
                default: {
                    logger.error("Unknown state (" + state + ") on txExpire");
                }
            }
        }
    }

    protected void dispatch() {
        if (this.isEventBased()) {
            Request buffer = this.sessionData.getBuffer();
            if (buffer != null) {
                this.setState(ClientCCASessionState.PENDING_BUFFERED);
                try {
                    this.dispatchEvent(new AppRequestEventImpl((Message)buffer));
                }
                catch (Exception e) {
                    try {
                        this.handleSendFailure(e, Event.Type.SEND_EVENT_REQUEST, (Message)buffer);
                    }
                    catch (Exception e1) {
                        logger.error("Failure handling buffer send failure", (Throwable)e1);
                    }
                }
            }
        } else if (this.sessionData.getClientCCASessionState() == ClientCCASessionState.OPEN && this.eventQueue.size() > 0) {
            try {
                this.handleEvent(this.eventQueue.remove(0));
            }
            catch (Exception e) {
                logger.error("Failure handling queued event", (Throwable)e);
            }
        }
    }

    protected void deliverCCAnswer(JCreditControlRequest request, JCreditControlAnswer answer) {
        try {
            this.listener.doCreditControlAnswer((ClientCCASession)this, request, answer);
        }
        catch (Exception e) {
            logger.warn("Failure delivering CCA Answer", (Throwable)e);
        }
    }

    protected void extractFHAVPs(JCreditControlRequest request, JCreditControlAnswer answer) {
        if (answer != null) {
            try {
                if (answer.isCreditControlFailureHandlingAVPPresent()) {
                    this.sessionData.setGatheredCCFH(answer.getCredidControlFailureHandlingAVPValue());
                }
            }
            catch (Exception e) {
                logger.debug("Failure trying to obtain Credit-Control-Failure-Handling AVP value", (Throwable)e);
            }
            try {
                if (answer.isDirectDebitingFailureHandlingAVPPresent()) {
                    this.sessionData.setGatheredDDFH(answer.getDirectDebitingFailureHandlingAVPValue());
                }
            }
            catch (Exception e) {
                logger.debug("Failure trying to obtain Direct-Debit-Failure-Handling AVP value", (Throwable)e);
            }
            if (!this.sessionData.isRequestTypeSet()) {
                this.sessionData.setRequestTypeSet(true);
                this.sessionData.setEventBased(answer.getRequestTypeAVPValue() == 4);
            }
        } else if (request != null) {
            try {
                if (request.isRequestedActionAVPPresent()) {
                    this.sessionData.setGatheredRequestedAction(request.getRequestedActionAVPValue());
                }
            }
            catch (Exception e) {
                logger.debug("Failure trying to obtain Request-Action AVP value", (Throwable)e);
            }
            if (!this.sessionData.isRequestTypeSet()) {
                this.sessionData.setRequestTypeSet(true);
                this.sessionData.setEventBased(request.getRequestTypeAVPValue() == 4);
            }
        }
    }

    protected void deliverRAR(ReAuthRequest request) {
        try {
            this.listener.doReAuthRequest((ClientCCASession)this, request);
        }
        catch (Exception e) {
            logger.debug("Failure delivering RAR", (Throwable)e);
        }
    }

    protected void dispatchEvent(AppEvent event) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.session.send(event.getMessage(), (EventListener)this);
    }

    protected boolean isProvisional(long resultCode) {
        return resultCode >= 1000L && resultCode < 2000L;
    }

    protected boolean isSuccess(long resultCode) {
        return resultCode >= 2000L && resultCode < 3000L;
    }

    protected boolean isFailure(long code) {
        return !this.isProvisional(code) && !this.isSuccess(code) && code >= 3000L && code < 6000L && !temporaryErrorCodes.contains(code);
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientCCASessionImpl other = (ClientCCASessionImpl)obj;
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }

    static {
        HashSet<Long> tmp = new HashSet<Long>();
        tmp.add(3002L);
        tmp.add(3004L);
        tmp.add(3005L);
        temporaryErrorCodes = Collections.unmodifiableSet(tmp);
    }

    private class AnswerDelivery
    implements Runnable {
        ClientCCASession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 272: {
                        JCreditControlRequest _request = ClientCCASessionImpl.this.factory.createCreditControlRequest(this.request);
                        JCreditControlAnswer _answer = ClientCCASessionImpl.this.factory.createCreditControlAnswer(this.answer);
                        ClientCCASessionImpl.this.extractFHAVPs(null, _answer);
                        ClientCCASessionImpl.this.handleEvent(new Event(false, _request, _answer));
                        break;
                    }
                    default: {
                        ClientCCASessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failure processing success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ClientCCASession session;
        Request request;

        private RequestDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 258: {
                        ClientCCASessionImpl.this.handleEvent(new Event(Event.Type.RECEIVED_RAR, (AppRequestEvent)ClientCCASessionImpl.this.factory.createReAuthRequest(this.request), null));
                        break;
                    }
                    default: {
                        ClientCCASessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failure processing request", (Throwable)e);
            }
        }
    }

    private class TxTimerTask
    implements Runnable {
        private ClientCCASession session = null;
        private Request request = null;

        private TxTimerTask(ClientCCASession session, Request request) {
            this.session = session;
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ClientCCASessionImpl.this.sendAndStateLock.lock();
                logger.debug("Fired TX Timer");
                ClientCCASessionImpl.this.sessionData.setTxTimerId(null);
                try {
                    ClientCCASessionImpl.this.context.txTimerExpired(this.session);
                }
                catch (Exception e) {
                    logger.debug("Failure handling TX Timer Expired", (Throwable)e);
                }
                JCreditControlRequest req = ClientCCASessionImpl.this.factory.createCreditControlRequest(this.request);
                ClientCCASessionImpl.this.handleEvent(new Event(Event.Type.Tx_TIMER_FIRED, (AppRequestEvent)req, null));
            }
            catch (InternalException e) {
                logger.error("Internal Exception", (Throwable)e);
            }
            catch (OverloadException e) {
                logger.error("Overload Exception", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("Exception", (Throwable)e);
            }
            finally {
                ClientCCASessionImpl.this.sendAndStateLock.unlock();
            }
        }
    }
}

