/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jdiameter.common.api.app.ro;

import org.jdiameter.common.api.app.IAppSessionState;

/**
 * 
 * @author <a href="mailto:baranowb@gmail.com"> Bartosz Baranowski </a> 
 * @author <a href="mailto:brainslog@gmail.com"> Alexandre Mendonca </a> 
 * @author Erick Svenson
 */
public enum ClientRoSessionState implements IAppSessionState<ClientRoSessionState>{

	IDLE(0),
  PENDING_EVENT(1),
	PENDING_INITIAL(2),
	PENDING_UPDATE(3),
	PENDING_TERMINATION(4),
	PENDING_BUFFERED(5),
  OPEN(6);
	
	private int stateValue = -1;

	ClientRoSessionState(int stateV)
	{
		this.stateValue=stateV;
	}
	
	public  ClientRoSessionState fromInt(int v) throws IllegalArgumentException
	{
		switch(v)
		{
		case 0:
			return IDLE;
    case 1:
      return PENDING_EVENT;
		case 2:
			return PENDING_INITIAL;
		case 3:
			return PENDING_UPDATE;
		case 4:
			return PENDING_TERMINATION;
		case 5:
			return PENDING_BUFFERED;
    case 6:
      return OPEN;
		default:
			throw new IllegalArgumentException("Illegal value of int representation!!!!");
		}
	}

	public int getValue()
  {
		return stateValue;
	}
}
